"use strict";Object.defineProperty(exports,"__esModule",{value:!0}),exports.parseTargetGroupFullName=exports.parseLoadBalancerFullName=exports.mapTagMapToCxschema=exports.validateNetworkProtocol=exports.ifUndefined=exports.determineProtocolAndPort=exports.defaultProtocolForPort=exports.defaultPortForProtocol=exports.renderAttributes=void 0;const enums_1=require("./enums"),core_1=require("../../../core");function renderAttributes(attributes){const ret=[];for(const[key,value]of Object.entries(attributes))value!==void 0&&ret.push({key,value});return ret}exports.renderAttributes=renderAttributes;function defaultPortForProtocol(proto){switch(proto){case enums_1.ApplicationProtocol.HTTP:return 80;case enums_1.ApplicationProtocol.HTTPS:return 443;default:throw new Error(`Unrecognized protocol: ${proto}`)}}exports.defaultPortForProtocol=defaultPortForProtocol;function defaultProtocolForPort(port){switch(port){case 80:case 8e3:case 8008:case 8080:return enums_1.ApplicationProtocol.HTTP;case 443:case 8443:return enums_1.ApplicationProtocol.HTTPS;default:throw new Error(`Don't know default protocol for port: ${port}; please supply a protocol`)}}exports.defaultProtocolForPort=defaultProtocolForPort;function determineProtocolAndPort(protocol,port){return protocol===void 0&&port===void 0?[void 0,void 0]:(protocol===void 0&&(protocol=defaultProtocolForPort(port)),port===void 0&&(port=defaultPortForProtocol(protocol)),[protocol,port])}exports.determineProtocolAndPort=determineProtocolAndPort;function ifUndefined(x,def){return x??def}exports.ifUndefined=ifUndefined;function validateNetworkProtocol(protocol){const NLB_PROTOCOLS=[enums_1.Protocol.TCP,enums_1.Protocol.TLS,enums_1.Protocol.UDP,enums_1.Protocol.TCP_UDP];if(NLB_PROTOCOLS.indexOf(protocol)===-1)throw new Error(`The protocol must be one of ${NLB_PROTOCOLS.join(", ")}. Found ${protocol}`)}exports.validateNetworkProtocol=validateNetworkProtocol;function mapTagMapToCxschema(tagMap){return Object.entries(tagMap).map(([key,value])=>({key,value}))}exports.mapTagMapToCxschema=mapTagMapToCxschema;function parseLoadBalancerFullName(arn){if(core_1.Token.isUnresolved(arn)){const arnParts=core_1.Fn.split("/",arn);return`${core_1.Fn.select(1,arnParts)}/${core_1.Fn.select(2,arnParts)}/${core_1.Fn.select(3,arnParts)}`}else{const resourceName=core_1.Arn.split(arn,core_1.ArnFormat.SLASH_RESOURCE_NAME).resourceName;if(!resourceName)throw new Error(`Provided ARN does not belong to a load balancer: ${arn}`);return resourceName}}exports.parseLoadBalancerFullName=parseLoadBalancerFullName;function parseTargetGroupFullName(arn){const resource=core_1.Arn.split(arn,core_1.ArnFormat.NO_RESOURCE_NAME).resource;if(!resource)throw new Error(`Provided ARN does not belong to a target group: ${arn}`);return resource}exports.parseTargetGroupFullName=parseTargetGroupFullName;
