"use strict";Object.defineProperty(exports,"__esModule",{value:!0}),exports.addToDeadLetterQueueResourcePolicy=exports.addLambdaPermission=exports.singletonEventRole=exports.bindBaseTargetConfig=void 0;const constructs_1=require("constructs"),iam=require("../../aws-iam"),core_1=require("../../core");function bindBaseTargetConfig(props){let{deadLetterQueue,retryAttempts,maxEventAge}=props;return{deadLetterConfig:deadLetterQueue?{arn:deadLetterQueue?.queueArn}:void 0,retryPolicy:retryAttempts!==void 0&&retryAttempts>=0||maxEventAge?{maximumRetryAttempts:retryAttempts,maximumEventAgeInSeconds:maxEventAge?.toSeconds({integral:!0})}:void 0}}exports.bindBaseTargetConfig=bindBaseTargetConfig;function singletonEventRole(scope){const id="EventsRole",existing=scope.node.tryFindChild(id);return existing||new iam.Role(scope,id,{roleName:core_1.PhysicalName.GENERATE_IF_NEEDED,assumedBy:new iam.ServicePrincipal("events.amazonaws.com")})}exports.singletonEventRole=singletonEventRole;function addLambdaPermission(rule,handler){let scope,node=handler.permissionsNode,permissionId=`AllowEventRule${core_1.Names.nodeUniqueId(rule.node)}`;rule instanceof constructs_1.Construct&&(scope=rule,node=rule.node,permissionId=`AllowEventRule${core_1.Names.nodeUniqueId(handler.node)}`),node.tryFindChild(permissionId)||handler.addPermission(permissionId,{scope,action:"lambda:InvokeFunction",principal:new iam.ServicePrincipal("events.amazonaws.com"),sourceArn:rule.ruleArn})}exports.addLambdaPermission=addLambdaPermission;function addToDeadLetterQueueResourcePolicy(rule,queue){if(!sameEnvDimension(rule.env.region,queue.env.region))throw new Error(`Cannot assign Dead Letter Queue in region ${queue.env.region} to the rule ${core_1.Names.nodeUniqueId(rule.node)} in region ${rule.env.region}. Both the queue and the rule must be in the same region.`);if(sameEnvDimension(rule.env.account,queue.env.account)){const policyStatementId=`AllowEventRule${core_1.Names.nodeUniqueId(rule.node)}`;queue.addToResourcePolicy(new iam.PolicyStatement({sid:policyStatementId,principals:[new iam.ServicePrincipal("events.amazonaws.com")],effect:iam.Effect.ALLOW,actions:["sqs:SendMessage"],resources:[queue.queueArn],conditions:{ArnEquals:{"aws:SourceArn":rule.ruleArn}}}))}else core_1.Annotations.of(rule).addWarning(`Cannot add a resource policy to your dead letter queue associated with rule ${rule.ruleName} because the queue is in a different account. You must add the resource policy manually to the dead letter queue in account ${queue.env.account}.`)}exports.addToDeadLetterQueueResourcePolicy=addToDeadLetterQueueResourcePolicy;function sameEnvDimension(dim1,dim2){return[core_1.TokenComparison.SAME,core_1.TokenComparison.BOTH_UNRESOLVED].includes(core_1.Token.compareStrings(dim1,dim2))}
