"use strict";var _a;Object.defineProperty(exports,"__esModule",{value:!0}),exports.CfnEnvironment=void 0;const jsiiDeprecationWarnings=require("../../.warnings.jsii.js"),JSII_RTTI_SYMBOL_1=Symbol.for("jsii.rtti"),cdk=require("../../core"),cfn_parse=require("../../core/lib/helpers-internal");function CfnEnvironmentPropsValidator(properties){if(!cdk.canInspect(properties))return cdk.VALIDATION_SUCCESS;const errors=new cdk.ValidationResults;return typeof properties!="object"&&errors.collect(new cdk.ValidationResult("Expected an object, but received: "+JSON.stringify(properties))),errors.collect(cdk.propertyValidator("description",cdk.validateString)(properties.description)),errors.collect(cdk.propertyValidator("federationMode",cdk.validateString)(properties.federationMode)),errors.collect(cdk.propertyValidator("federationParameters",CfnEnvironment_FederationParametersPropertyValidator)(properties.federationParameters)),errors.collect(cdk.propertyValidator("kmsKeyId",cdk.validateString)(properties.kmsKeyId)),errors.collect(cdk.propertyValidator("name",cdk.requiredValidator)(properties.name)),errors.collect(cdk.propertyValidator("name",cdk.validateString)(properties.name)),errors.collect(cdk.propertyValidator("superuserParameters",CfnEnvironment_SuperuserParametersPropertyValidator)(properties.superuserParameters)),errors.collect(cdk.propertyValidator("tags",cdk.listValidator(cdk.validateCfnTag))(properties.tags)),errors.wrap('supplied properties not correct for "CfnEnvironmentProps"')}function cfnEnvironmentPropsToCloudFormation(properties){return cdk.canInspect(properties)?(CfnEnvironmentPropsValidator(properties).assertSuccess(),{Name:cdk.stringToCloudFormation(properties.name),Description:cdk.stringToCloudFormation(properties.description),FederationMode:cdk.stringToCloudFormation(properties.federationMode),FederationParameters:cfnEnvironmentFederationParametersPropertyToCloudFormation(properties.federationParameters),KmsKeyId:cdk.stringToCloudFormation(properties.kmsKeyId),SuperuserParameters:cfnEnvironmentSuperuserParametersPropertyToCloudFormation(properties.superuserParameters),Tags:cdk.listMapper(cdk.cfnTagToCloudFormation)(properties.tags)}):properties}function CfnEnvironmentPropsFromCloudFormation(properties){if(properties=properties??{},typeof properties!="object")return new cfn_parse.FromCloudFormationResult(properties);const ret=new cfn_parse.FromCloudFormationPropertyObject;return ret.addPropertyResult("name","Name",cfn_parse.FromCloudFormation.getString(properties.Name)),ret.addPropertyResult("description","Description",properties.Description!=null?cfn_parse.FromCloudFormation.getString(properties.Description):void 0),ret.addPropertyResult("federationMode","FederationMode",properties.FederationMode!=null?cfn_parse.FromCloudFormation.getString(properties.FederationMode):void 0),ret.addPropertyResult("federationParameters","FederationParameters",properties.FederationParameters!=null?CfnEnvironmentFederationParametersPropertyFromCloudFormation(properties.FederationParameters):void 0),ret.addPropertyResult("kmsKeyId","KmsKeyId",properties.KmsKeyId!=null?cfn_parse.FromCloudFormation.getString(properties.KmsKeyId):void 0),ret.addPropertyResult("superuserParameters","SuperuserParameters",properties.SuperuserParameters!=null?CfnEnvironmentSuperuserParametersPropertyFromCloudFormation(properties.SuperuserParameters):void 0),ret.addPropertyResult("tags","Tags",properties.Tags!=null?cfn_parse.FromCloudFormation.getArray(cfn_parse.FromCloudFormation.getCfnTag)(properties.Tags):void 0),ret.addUnrecognizedPropertiesAsExtra(properties),ret}class CfnEnvironment extends cdk.CfnResource{static _fromCloudFormation(scope,id,resourceAttributes,options){resourceAttributes=resourceAttributes||{};const resourceProperties=options.parser.parseValue(resourceAttributes.Properties),propsResult=CfnEnvironmentPropsFromCloudFormation(resourceProperties),ret=new CfnEnvironment(scope,id,propsResult.value);for(const[propKey,propVal]of Object.entries(propsResult.extraProperties))ret.addPropertyOverride(propKey,propVal);return options.parser.handleAttributes(ret,resourceAttributes,id),ret}constructor(scope,id,props){super(scope,id,{type:CfnEnvironment.CFN_RESOURCE_TYPE_NAME,properties:props});try{jsiiDeprecationWarnings.aws_cdk_lib_aws_finspace_CfnEnvironmentProps(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,CfnEnvironment),error}cdk.requireProperty(props,"name",this),this.attrAwsAccountId=cdk.Token.asString(this.getAtt("AwsAccountId",cdk.ResolutionTypeHint.STRING)),this.attrDedicatedServiceAccountId=cdk.Token.asString(this.getAtt("DedicatedServiceAccountId",cdk.ResolutionTypeHint.STRING)),this.attrEnvironmentArn=cdk.Token.asString(this.getAtt("EnvironmentArn",cdk.ResolutionTypeHint.STRING)),this.attrEnvironmentId=cdk.Token.asString(this.getAtt("EnvironmentId",cdk.ResolutionTypeHint.STRING)),this.attrEnvironmentUrl=cdk.Token.asString(this.getAtt("EnvironmentUrl",cdk.ResolutionTypeHint.STRING)),this.attrSageMakerStudioDomainUrl=cdk.Token.asString(this.getAtt("SageMakerStudioDomainUrl",cdk.ResolutionTypeHint.STRING)),this.attrStatus=cdk.Token.asString(this.getAtt("Status",cdk.ResolutionTypeHint.STRING)),this.name=props.name,this.description=props.description,this.federationMode=props.federationMode,this.federationParameters=props.federationParameters,this.kmsKeyId=props.kmsKeyId,this.superuserParameters=props.superuserParameters,this.tags=new cdk.TagManager(cdk.TagType.STANDARD,"AWS::FinSpace::Environment",props.tags,{tagPropertyName:"tags"})}inspect(inspector){try{jsiiDeprecationWarnings.aws_cdk_lib_TreeInspector(inspector)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.inspect),error}inspector.addAttribute("aws:cdk:cloudformation:type",CfnEnvironment.CFN_RESOURCE_TYPE_NAME),inspector.addAttribute("aws:cdk:cloudformation:props",this.cfnProperties)}get cfnProperties(){return{name:this.name,description:this.description,federationMode:this.federationMode,federationParameters:this.federationParameters,kmsKeyId:this.kmsKeyId,superuserParameters:this.superuserParameters,tags:this.tags.renderTags()}}renderProperties(props){return cfnEnvironmentPropsToCloudFormation(props)}}_a=JSII_RTTI_SYMBOL_1,CfnEnvironment[_a]={fqn:"aws-cdk-lib.aws_finspace.CfnEnvironment",version:"2.87.0"},CfnEnvironment.CFN_RESOURCE_TYPE_NAME="AWS::FinSpace::Environment",exports.CfnEnvironment=CfnEnvironment;function CfnEnvironment_AttributeMapItemsPropertyValidator(properties){if(!cdk.canInspect(properties))return cdk.VALIDATION_SUCCESS;const errors=new cdk.ValidationResults;return typeof properties!="object"&&errors.collect(new cdk.ValidationResult("Expected an object, but received: "+JSON.stringify(properties))),errors.collect(cdk.propertyValidator("key",cdk.validateString)(properties.key)),errors.collect(cdk.propertyValidator("value",cdk.validateString)(properties.value)),errors.wrap('supplied properties not correct for "AttributeMapItemsProperty"')}function cfnEnvironmentAttributeMapItemsPropertyToCloudFormation(properties){return cdk.canInspect(properties)?(CfnEnvironment_AttributeMapItemsPropertyValidator(properties).assertSuccess(),{Key:cdk.stringToCloudFormation(properties.key),Value:cdk.stringToCloudFormation(properties.value)}):properties}function CfnEnvironmentAttributeMapItemsPropertyFromCloudFormation(properties){if(cdk.isResolvableObject(properties))return new cfn_parse.FromCloudFormationResult(properties);if(properties=properties??{},typeof properties!="object")return new cfn_parse.FromCloudFormationResult(properties);const ret=new cfn_parse.FromCloudFormationPropertyObject;return ret.addPropertyResult("key","Key",properties.Key!=null?cfn_parse.FromCloudFormation.getString(properties.Key):void 0),ret.addPropertyResult("value","Value",properties.Value!=null?cfn_parse.FromCloudFormation.getString(properties.Value):void 0),ret.addUnrecognizedPropertiesAsExtra(properties),ret}function CfnEnvironment_FederationParametersPropertyValidator(properties){if(!cdk.canInspect(properties))return cdk.VALIDATION_SUCCESS;const errors=new cdk.ValidationResults;return typeof properties!="object"&&errors.collect(new cdk.ValidationResult("Expected an object, but received: "+JSON.stringify(properties))),errors.collect(cdk.propertyValidator("applicationCallBackUrl",cdk.validateString)(properties.applicationCallBackUrl)),errors.collect(cdk.propertyValidator("attributeMap",cdk.listValidator(CfnEnvironment_AttributeMapItemsPropertyValidator))(properties.attributeMap)),errors.collect(cdk.propertyValidator("federationProviderName",cdk.validateString)(properties.federationProviderName)),errors.collect(cdk.propertyValidator("federationUrn",cdk.validateString)(properties.federationUrn)),errors.collect(cdk.propertyValidator("samlMetadataDocument",cdk.validateString)(properties.samlMetadataDocument)),errors.collect(cdk.propertyValidator("samlMetadataUrl",cdk.validateString)(properties.samlMetadataUrl)),errors.wrap('supplied properties not correct for "FederationParametersProperty"')}function cfnEnvironmentFederationParametersPropertyToCloudFormation(properties){return cdk.canInspect(properties)?(CfnEnvironment_FederationParametersPropertyValidator(properties).assertSuccess(),{ApplicationCallBackURL:cdk.stringToCloudFormation(properties.applicationCallBackUrl),AttributeMap:cdk.listMapper(cfnEnvironmentAttributeMapItemsPropertyToCloudFormation)(properties.attributeMap),FederationProviderName:cdk.stringToCloudFormation(properties.federationProviderName),FederationURN:cdk.stringToCloudFormation(properties.federationUrn),SamlMetadataDocument:cdk.stringToCloudFormation(properties.samlMetadataDocument),SamlMetadataURL:cdk.stringToCloudFormation(properties.samlMetadataUrl)}):properties}function CfnEnvironmentFederationParametersPropertyFromCloudFormation(properties){if(cdk.isResolvableObject(properties))return new cfn_parse.FromCloudFormationResult(properties);if(properties=properties??{},typeof properties!="object")return new cfn_parse.FromCloudFormationResult(properties);const ret=new cfn_parse.FromCloudFormationPropertyObject;return ret.addPropertyResult("applicationCallBackUrl","ApplicationCallBackURL",properties.ApplicationCallBackURL!=null?cfn_parse.FromCloudFormation.getString(properties.ApplicationCallBackURL):void 0),ret.addPropertyResult("attributeMap","AttributeMap",properties.AttributeMap!=null?cfn_parse.FromCloudFormation.getArray(CfnEnvironmentAttributeMapItemsPropertyFromCloudFormation)(properties.AttributeMap):void 0),ret.addPropertyResult("federationProviderName","FederationProviderName",properties.FederationProviderName!=null?cfn_parse.FromCloudFormation.getString(properties.FederationProviderName):void 0),ret.addPropertyResult("federationUrn","FederationURN",properties.FederationURN!=null?cfn_parse.FromCloudFormation.getString(properties.FederationURN):void 0),ret.addPropertyResult("samlMetadataDocument","SamlMetadataDocument",properties.SamlMetadataDocument!=null?cfn_parse.FromCloudFormation.getString(properties.SamlMetadataDocument):void 0),ret.addPropertyResult("samlMetadataUrl","SamlMetadataURL",properties.SamlMetadataURL!=null?cfn_parse.FromCloudFormation.getString(properties.SamlMetadataURL):void 0),ret.addUnrecognizedPropertiesAsExtra(properties),ret}function CfnEnvironment_SuperuserParametersPropertyValidator(properties){if(!cdk.canInspect(properties))return cdk.VALIDATION_SUCCESS;const errors=new cdk.ValidationResults;return typeof properties!="object"&&errors.collect(new cdk.ValidationResult("Expected an object, but received: "+JSON.stringify(properties))),errors.collect(cdk.propertyValidator("emailAddress",cdk.validateString)(properties.emailAddress)),errors.collect(cdk.propertyValidator("firstName",cdk.validateString)(properties.firstName)),errors.collect(cdk.propertyValidator("lastName",cdk.validateString)(properties.lastName)),errors.wrap('supplied properties not correct for "SuperuserParametersProperty"')}function cfnEnvironmentSuperuserParametersPropertyToCloudFormation(properties){return cdk.canInspect(properties)?(CfnEnvironment_SuperuserParametersPropertyValidator(properties).assertSuccess(),{EmailAddress:cdk.stringToCloudFormation(properties.emailAddress),FirstName:cdk.stringToCloudFormation(properties.firstName),LastName:cdk.stringToCloudFormation(properties.lastName)}):properties}function CfnEnvironmentSuperuserParametersPropertyFromCloudFormation(properties){if(cdk.isResolvableObject(properties))return new cfn_parse.FromCloudFormationResult(properties);if(properties=properties??{},typeof properties!="object")return new cfn_parse.FromCloudFormationResult(properties);const ret=new cfn_parse.FromCloudFormationPropertyObject;return ret.addPropertyResult("emailAddress","EmailAddress",properties.EmailAddress!=null?cfn_parse.FromCloudFormation.getString(properties.EmailAddress):void 0),ret.addPropertyResult("firstName","FirstName",properties.FirstName!=null?cfn_parse.FromCloudFormation.getString(properties.FirstName):void 0),ret.addPropertyResult("lastName","LastName",properties.LastName!=null?cfn_parse.FromCloudFormation.getString(properties.LastName):void 0),ret.addUnrecognizedPropertiesAsExtra(properties),ret}
