"use strict";var _a;Object.defineProperty(exports,"__esModule",{value:!0}),exports.ManagedPolicy=void 0;const jsiiDeprecationWarnings=require("../../.warnings.jsii.js"),JSII_RTTI_SYMBOL_1=Symbol.for("jsii.rtti"),iam_generated_1=require("./iam.generated"),policy_document_1=require("./policy-document"),util_1=require("./private/util"),core_1=require("../../core"),helpers_internal_1=require("../../core/lib/helpers-internal");class ManagedPolicy extends core_1.Resource{static fromManagedPolicyName(scope,id,managedPolicyName){class Import extends core_1.Resource{constructor(){super(...arguments),this.managedPolicyArn=core_1.Stack.of(scope).formatArn({service:"iam",region:"",account:core_1.Stack.of(scope).account,resource:"policy",resourceName:managedPolicyName})}}return new Import(scope,id)}static fromManagedPolicyArn(scope,id,managedPolicyArn){class Import extends core_1.Resource{constructor(){super(...arguments),this.managedPolicyArn=managedPolicyArn}}return new Import(scope,id)}static fromAwsManagedPolicyName(managedPolicyName){class AwsManagedPolicy{constructor(){this.managedPolicyArn=core_1.Arn.format({partition:core_1.Aws.PARTITION,service:"iam",region:"",account:"aws",resource:"policy",resourceName:managedPolicyName})}}return new AwsManagedPolicy}constructor(scope,id,props={}){super(scope,id,{physicalName:props.managedPolicyName}),this.document=new policy_document_1.PolicyDocument,this.roles=new Array,this.users=new Array,this.groups=new Array;try{jsiiDeprecationWarnings.aws_cdk_lib_aws_iam_ManagedPolicyProps(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,ManagedPolicy),error}this.description=props.description||"",this.path=props.path||"/",props.document&&(this.document=props.document);const config=(0,helpers_internal_1.getCustomizeRolesConfig)(this),_precreatedPolicy=ManagedPolicy.fromManagedPolicyName(this,"Imported"+id,id);if(this.managedPolicyName=id,this.managedPolicyArn=_precreatedPolicy.managedPolicyArn,config.enabled&&(this._precreatedPolicy=_precreatedPolicy),!config.preventSynthesis){const resource=new iam_generated_1.CfnManagedPolicy(this,"Resource",{policyDocument:this.document,managedPolicyName:this.physicalName,description:this.description,path:this.path,roles:(0,util_1.undefinedIfEmpty)(()=>this.roles.map(r=>r.roleName)),users:(0,util_1.undefinedIfEmpty)(()=>this.users.map(u=>u.userName)),groups:(0,util_1.undefinedIfEmpty)(()=>this.groups.map(g=>g.groupName))});this.managedPolicyName=this.getResourceNameAttribute(core_1.Stack.of(this).splitArn(resource.ref,core_1.ArnFormat.SLASH_RESOURCE_NAME).resourceName),this.managedPolicyArn=this.getResourceArnAttribute(resource.ref,{region:"",service:"iam",resource:"policy",resourceName:this.physicalName})}props.users&&props.users.forEach(u=>this.attachToUser(u)),props.groups&&props.groups.forEach(g=>this.attachToGroup(g)),props.roles&&props.roles.forEach(r=>this.attachToRole(r)),props.statements&&props.statements.forEach(p=>this.addStatements(p)),this.grantPrincipal=new ManagedPolicyGrantPrincipal(this),this.node.addValidation({validate:()=>this.validateManagedPolicy()})}addStatements(...statement){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_iam_PolicyStatement(statement)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.addStatements),error}this.document.addStatements(...statement)}attachToUser(user){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_iam_IUser(user)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.attachToUser),error}this.users.find(u=>u===user)||this.users.push(user)}attachToRole(role){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_iam_IRole(role)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.attachToRole),error}this.roles.find(r=>r===role)||this.roles.push(role)}attachToGroup(group){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_iam_IGroup(group)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.attachToGroup),error}this.groups.find(g=>g===group)||this.groups.push(group)}validateManagedPolicy(){const result=new Array;return this.document.isEmpty&&result.push("Managed Policy is empty. You must add statements to the policy"),result.push(...this.document.validateForIdentityPolicy()),result.length===0&&this._precreatedPolicy&&helpers_internal_1.PolicySynthesizer.getOrCreate(this).addManagedPolicy(this.node.path,{policyStatements:this.document.toJSON()?.Statement,roles:this.roles.map(role=>role.node.path)}),result}}_a=JSII_RTTI_SYMBOL_1,ManagedPolicy[_a]={fqn:"aws-cdk-lib.aws_iam.ManagedPolicy",version:"2.87.0"},exports.ManagedPolicy=ManagedPolicy;class ManagedPolicyGrantPrincipal{constructor(_managedPolicy){this._managedPolicy=_managedPolicy,this.assumeRoleAction="sts:AssumeRole",this.grantPrincipal=this,this.principalAccount=_managedPolicy.env.account}get policyFragment(){throw new Error(`Cannot use a ManagedPolicy '${this._managedPolicy.node.path}' as the 'Principal' or 'NotPrincipal' in an IAM Policy`)}addToPolicy(statement){return this.addToPrincipalPolicy(statement).statementAdded}addToPrincipalPolicy(statement){return this._managedPolicy.addStatements(statement),{statementAdded:!0,policyDependable:this._managedPolicy}}}
