"use strict";Object.defineProperty(exports,"__esModule",{value:!0}),exports.external=void 0;const tls=require("tls"),url=require("url"),aws=require("aws-sdk");let client;function iam(){return client||(client=new aws.IAM),client}function defaultLogger(fmt,...args){console.log(fmt,...args)}async function downloadThumbprint(issuerUrl){return new Promise((ok,ko)=>{const purl=url.parse(issuerUrl),port=purl.port?parseInt(purl.port,10):443;if(!purl.host)return ko(new Error(`unable to determine host from issuer url ${issuerUrl}`));exports.external.log(`Fetching x509 certificate chain from issuer ${issuerUrl}`);const socket=tls.connect(port,purl.host,{rejectUnauthorized:!1,servername:purl.host});socket.once("error",ko),socket.once("secureConnect",()=>{let cert=socket.getPeerX509Certificate();if(!cert)throw new Error(`Unable to retrieve X509 certificate from host ${purl.host}`);for(;cert.issuerCertificate;)printCertificate(cert),cert=cert.issuerCertificate;const validTo=new Date(cert.validTo),certificateValidity=getCertificateValidity(validTo);if(certificateValidity<0)return ko(new Error(`The certificate has already expired on: ${validTo.toUTCString()}`));certificateValidity<180&&console.warn(`The root certificate obtained would expire in ${certificateValidity} days!`),socket.end();const thumbprint=extractThumbprint(cert);exports.external.log(`Certificate Authority thumbprint for ${issuerUrl} is ${thumbprint}`),ok(thumbprint)})})}function extractThumbprint(cert){return cert.fingerprint.split(":").join("")}function printCertificate(cert){exports.external.log("-------------BEGIN CERT----------------"),exports.external.log(`Thumbprint: ${extractThumbprint(cert)}`),exports.external.log(`Valid To: ${cert.validTo}`),cert.issuerCertificate&&exports.external.log(`Issuer Thumbprint: ${extractThumbprint(cert.issuerCertificate)}`),exports.external.log(`Issuer: ${cert.issuer}`),exports.external.log(`Subject: ${cert.subject}`),exports.external.log("-------------END CERT------------------")}function getCertificateValidity(certDate){const currentDate=new Date;return Math.round((certDate.getTime()-currentDate.getTime())/864e5)}exports.external={downloadThumbprint,log:defaultLogger,createOpenIDConnectProvider:req=>iam().createOpenIDConnectProvider(req).promise(),deleteOpenIDConnectProvider:req=>iam().deleteOpenIDConnectProvider(req).promise(),updateOpenIDConnectProviderThumbprint:req=>iam().updateOpenIDConnectProviderThumbprint(req).promise(),addClientIDToOpenIDConnectProvider:req=>iam().addClientIDToOpenIDConnectProvider(req).promise(),removeClientIDFromOpenIDConnectProvider:req=>iam().removeClientIDFromOpenIDConnectProvider(req).promise()};
