"use strict";var _a,_b,_c,_d;Object.defineProperty(exports,"__esModule",{value:!0}),exports.CfnApplicationReferenceDataSource=exports.CfnApplicationOutput=exports.CfnApplicationCloudWatchLoggingOption=exports.CfnApplication=void 0;const jsiiDeprecationWarnings=require("../../.warnings.jsii.js"),JSII_RTTI_SYMBOL_1=Symbol.for("jsii.rtti"),cdk=require("../../core"),cfn_parse=require("../../core/lib/helpers-internal");function CfnApplicationPropsValidator(properties){if(!cdk.canInspect(properties))return cdk.VALIDATION_SUCCESS;const errors=new cdk.ValidationResults;return typeof properties!="object"&&errors.collect(new cdk.ValidationResult("Expected an object, but received: "+JSON.stringify(properties))),errors.collect(cdk.propertyValidator("applicationConfiguration",CfnApplication_ApplicationConfigurationPropertyValidator)(properties.applicationConfiguration)),errors.collect(cdk.propertyValidator("applicationDescription",cdk.validateString)(properties.applicationDescription)),errors.collect(cdk.propertyValidator("applicationMaintenanceConfiguration",CfnApplication_ApplicationMaintenanceConfigurationPropertyValidator)(properties.applicationMaintenanceConfiguration)),errors.collect(cdk.propertyValidator("applicationMode",cdk.validateString)(properties.applicationMode)),errors.collect(cdk.propertyValidator("applicationName",cdk.validateString)(properties.applicationName)),errors.collect(cdk.propertyValidator("runConfiguration",CfnApplication_RunConfigurationPropertyValidator)(properties.runConfiguration)),errors.collect(cdk.propertyValidator("runtimeEnvironment",cdk.requiredValidator)(properties.runtimeEnvironment)),errors.collect(cdk.propertyValidator("runtimeEnvironment",cdk.validateString)(properties.runtimeEnvironment)),errors.collect(cdk.propertyValidator("serviceExecutionRole",cdk.requiredValidator)(properties.serviceExecutionRole)),errors.collect(cdk.propertyValidator("serviceExecutionRole",cdk.validateString)(properties.serviceExecutionRole)),errors.collect(cdk.propertyValidator("tags",cdk.listValidator(cdk.validateCfnTag))(properties.tags)),errors.wrap('supplied properties not correct for "CfnApplicationProps"')}function cfnApplicationPropsToCloudFormation(properties){return cdk.canInspect(properties)?(CfnApplicationPropsValidator(properties).assertSuccess(),{RuntimeEnvironment:cdk.stringToCloudFormation(properties.runtimeEnvironment),ServiceExecutionRole:cdk.stringToCloudFormation(properties.serviceExecutionRole),ApplicationConfiguration:cfnApplicationApplicationConfigurationPropertyToCloudFormation(properties.applicationConfiguration),ApplicationDescription:cdk.stringToCloudFormation(properties.applicationDescription),ApplicationMaintenanceConfiguration:cfnApplicationApplicationMaintenanceConfigurationPropertyToCloudFormation(properties.applicationMaintenanceConfiguration),ApplicationMode:cdk.stringToCloudFormation(properties.applicationMode),ApplicationName:cdk.stringToCloudFormation(properties.applicationName),RunConfiguration:cfnApplicationRunConfigurationPropertyToCloudFormation(properties.runConfiguration),Tags:cdk.listMapper(cdk.cfnTagToCloudFormation)(properties.tags)}):properties}function CfnApplicationPropsFromCloudFormation(properties){if(properties=properties??{},typeof properties!="object")return new cfn_parse.FromCloudFormationResult(properties);const ret=new cfn_parse.FromCloudFormationPropertyObject;return ret.addPropertyResult("runtimeEnvironment","RuntimeEnvironment",cfn_parse.FromCloudFormation.getString(properties.RuntimeEnvironment)),ret.addPropertyResult("serviceExecutionRole","ServiceExecutionRole",cfn_parse.FromCloudFormation.getString(properties.ServiceExecutionRole)),ret.addPropertyResult("applicationConfiguration","ApplicationConfiguration",properties.ApplicationConfiguration!=null?CfnApplicationApplicationConfigurationPropertyFromCloudFormation(properties.ApplicationConfiguration):void 0),ret.addPropertyResult("applicationDescription","ApplicationDescription",properties.ApplicationDescription!=null?cfn_parse.FromCloudFormation.getString(properties.ApplicationDescription):void 0),ret.addPropertyResult("applicationMaintenanceConfiguration","ApplicationMaintenanceConfiguration",properties.ApplicationMaintenanceConfiguration!=null?CfnApplicationApplicationMaintenanceConfigurationPropertyFromCloudFormation(properties.ApplicationMaintenanceConfiguration):void 0),ret.addPropertyResult("applicationMode","ApplicationMode",properties.ApplicationMode!=null?cfn_parse.FromCloudFormation.getString(properties.ApplicationMode):void 0),ret.addPropertyResult("applicationName","ApplicationName",properties.ApplicationName!=null?cfn_parse.FromCloudFormation.getString(properties.ApplicationName):void 0),ret.addPropertyResult("runConfiguration","RunConfiguration",properties.RunConfiguration!=null?CfnApplicationRunConfigurationPropertyFromCloudFormation(properties.RunConfiguration):void 0),ret.addPropertyResult("tags","Tags",properties.Tags!=null?cfn_parse.FromCloudFormation.getArray(cfn_parse.FromCloudFormation.getCfnTag)(properties.Tags):void 0),ret.addUnrecognizedPropertiesAsExtra(properties),ret}class CfnApplication extends cdk.CfnResource{static _fromCloudFormation(scope,id,resourceAttributes,options){resourceAttributes=resourceAttributes||{};const resourceProperties=options.parser.parseValue(resourceAttributes.Properties),propsResult=CfnApplicationPropsFromCloudFormation(resourceProperties),ret=new CfnApplication(scope,id,propsResult.value);for(const[propKey,propVal]of Object.entries(propsResult.extraProperties))ret.addPropertyOverride(propKey,propVal);return options.parser.handleAttributes(ret,resourceAttributes,id),ret}constructor(scope,id,props){super(scope,id,{type:CfnApplication.CFN_RESOURCE_TYPE_NAME,properties:props});try{jsiiDeprecationWarnings.aws_cdk_lib_aws_kinesisanalyticsv2_CfnApplicationProps(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,CfnApplication),error}cdk.requireProperty(props,"runtimeEnvironment",this),cdk.requireProperty(props,"serviceExecutionRole",this),this.runtimeEnvironment=props.runtimeEnvironment,this.serviceExecutionRole=props.serviceExecutionRole,this.applicationConfiguration=props.applicationConfiguration,this.applicationDescription=props.applicationDescription,this.applicationMaintenanceConfiguration=props.applicationMaintenanceConfiguration,this.applicationMode=props.applicationMode,this.applicationName=props.applicationName,this.runConfiguration=props.runConfiguration,this.tags=new cdk.TagManager(cdk.TagType.STANDARD,"AWS::KinesisAnalyticsV2::Application",props.tags,{tagPropertyName:"tags"})}inspect(inspector){try{jsiiDeprecationWarnings.aws_cdk_lib_TreeInspector(inspector)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.inspect),error}inspector.addAttribute("aws:cdk:cloudformation:type",CfnApplication.CFN_RESOURCE_TYPE_NAME),inspector.addAttribute("aws:cdk:cloudformation:props",this.cfnProperties)}get cfnProperties(){return{runtimeEnvironment:this.runtimeEnvironment,serviceExecutionRole:this.serviceExecutionRole,applicationConfiguration:this.applicationConfiguration,applicationDescription:this.applicationDescription,applicationMaintenanceConfiguration:this.applicationMaintenanceConfiguration,applicationMode:this.applicationMode,applicationName:this.applicationName,runConfiguration:this.runConfiguration,tags:this.tags.renderTags()}}renderProperties(props){return cfnApplicationPropsToCloudFormation(props)}}_a=JSII_RTTI_SYMBOL_1,CfnApplication[_a]={fqn:"aws-cdk-lib.aws_kinesisanalyticsv2.CfnApplication",version:"2.87.0"},CfnApplication.CFN_RESOURCE_TYPE_NAME="AWS::KinesisAnalyticsV2::Application",exports.CfnApplication=CfnApplication;function CfnApplication_ApplicationCodeConfigurationPropertyValidator(properties){if(!cdk.canInspect(properties))return cdk.VALIDATION_SUCCESS;const errors=new cdk.ValidationResults;return typeof properties!="object"&&errors.collect(new cdk.ValidationResult("Expected an object, but received: "+JSON.stringify(properties))),errors.collect(cdk.propertyValidator("codeContent",cdk.requiredValidator)(properties.codeContent)),errors.collect(cdk.propertyValidator("codeContent",CfnApplication_CodeContentPropertyValidator)(properties.codeContent)),errors.collect(cdk.propertyValidator("codeContentType",cdk.requiredValidator)(properties.codeContentType)),errors.collect(cdk.propertyValidator("codeContentType",cdk.validateString)(properties.codeContentType)),errors.wrap('supplied properties not correct for "ApplicationCodeConfigurationProperty"')}function cfnApplicationApplicationCodeConfigurationPropertyToCloudFormation(properties){return cdk.canInspect(properties)?(CfnApplication_ApplicationCodeConfigurationPropertyValidator(properties).assertSuccess(),{CodeContent:cfnApplicationCodeContentPropertyToCloudFormation(properties.codeContent),CodeContentType:cdk.stringToCloudFormation(properties.codeContentType)}):properties}function CfnApplicationApplicationCodeConfigurationPropertyFromCloudFormation(properties){if(cdk.isResolvableObject(properties))return new cfn_parse.FromCloudFormationResult(properties);if(properties=properties??{},typeof properties!="object")return new cfn_parse.FromCloudFormationResult(properties);const ret=new cfn_parse.FromCloudFormationPropertyObject;return ret.addPropertyResult("codeContent","CodeContent",CfnApplicationCodeContentPropertyFromCloudFormation(properties.CodeContent)),ret.addPropertyResult("codeContentType","CodeContentType",cfn_parse.FromCloudFormation.getString(properties.CodeContentType)),ret.addUnrecognizedPropertiesAsExtra(properties),ret}function CfnApplication_ApplicationConfigurationPropertyValidator(properties){if(!cdk.canInspect(properties))return cdk.VALIDATION_SUCCESS;const errors=new cdk.ValidationResults;return typeof properties!="object"&&errors.collect(new cdk.ValidationResult("Expected an object, but received: "+JSON.stringify(properties))),errors.collect(cdk.propertyValidator("applicationCodeConfiguration",CfnApplication_ApplicationCodeConfigurationPropertyValidator)(properties.applicationCodeConfiguration)),errors.collect(cdk.propertyValidator("applicationSnapshotConfiguration",CfnApplication_ApplicationSnapshotConfigurationPropertyValidator)(properties.applicationSnapshotConfiguration)),errors.collect(cdk.propertyValidator("environmentProperties",CfnApplication_EnvironmentPropertiesPropertyValidator)(properties.environmentProperties)),errors.collect(cdk.propertyValidator("flinkApplicationConfiguration",CfnApplication_FlinkApplicationConfigurationPropertyValidator)(properties.flinkApplicationConfiguration)),errors.collect(cdk.propertyValidator("sqlApplicationConfiguration",CfnApplication_SqlApplicationConfigurationPropertyValidator)(properties.sqlApplicationConfiguration)),errors.collect(cdk.propertyValidator("vpcConfigurations",cdk.listValidator(CfnApplication_VpcConfigurationPropertyValidator))(properties.vpcConfigurations)),errors.collect(cdk.propertyValidator("zeppelinApplicationConfiguration",CfnApplication_ZeppelinApplicationConfigurationPropertyValidator)(properties.zeppelinApplicationConfiguration)),errors.wrap('supplied properties not correct for "ApplicationConfigurationProperty"')}function cfnApplicationApplicationConfigurationPropertyToCloudFormation(properties){return cdk.canInspect(properties)?(CfnApplication_ApplicationConfigurationPropertyValidator(properties).assertSuccess(),{ApplicationCodeConfiguration:cfnApplicationApplicationCodeConfigurationPropertyToCloudFormation(properties.applicationCodeConfiguration),ApplicationSnapshotConfiguration:cfnApplicationApplicationSnapshotConfigurationPropertyToCloudFormation(properties.applicationSnapshotConfiguration),EnvironmentProperties:cfnApplicationEnvironmentPropertiesPropertyToCloudFormation(properties.environmentProperties),FlinkApplicationConfiguration:cfnApplicationFlinkApplicationConfigurationPropertyToCloudFormation(properties.flinkApplicationConfiguration),SqlApplicationConfiguration:cfnApplicationSqlApplicationConfigurationPropertyToCloudFormation(properties.sqlApplicationConfiguration),VpcConfigurations:cdk.listMapper(cfnApplicationVpcConfigurationPropertyToCloudFormation)(properties.vpcConfigurations),ZeppelinApplicationConfiguration:cfnApplicationZeppelinApplicationConfigurationPropertyToCloudFormation(properties.zeppelinApplicationConfiguration)}):properties}function CfnApplicationApplicationConfigurationPropertyFromCloudFormation(properties){if(cdk.isResolvableObject(properties))return new cfn_parse.FromCloudFormationResult(properties);if(properties=properties??{},typeof properties!="object")return new cfn_parse.FromCloudFormationResult(properties);const ret=new cfn_parse.FromCloudFormationPropertyObject;return ret.addPropertyResult("applicationCodeConfiguration","ApplicationCodeConfiguration",properties.ApplicationCodeConfiguration!=null?CfnApplicationApplicationCodeConfigurationPropertyFromCloudFormation(properties.ApplicationCodeConfiguration):void 0),ret.addPropertyResult("applicationSnapshotConfiguration","ApplicationSnapshotConfiguration",properties.ApplicationSnapshotConfiguration!=null?CfnApplicationApplicationSnapshotConfigurationPropertyFromCloudFormation(properties.ApplicationSnapshotConfiguration):void 0),ret.addPropertyResult("environmentProperties","EnvironmentProperties",properties.EnvironmentProperties!=null?CfnApplicationEnvironmentPropertiesPropertyFromCloudFormation(properties.EnvironmentProperties):void 0),ret.addPropertyResult("flinkApplicationConfiguration","FlinkApplicationConfiguration",properties.FlinkApplicationConfiguration!=null?CfnApplicationFlinkApplicationConfigurationPropertyFromCloudFormation(properties.FlinkApplicationConfiguration):void 0),ret.addPropertyResult("sqlApplicationConfiguration","SqlApplicationConfiguration",properties.SqlApplicationConfiguration!=null?CfnApplicationSqlApplicationConfigurationPropertyFromCloudFormation(properties.SqlApplicationConfiguration):void 0),ret.addPropertyResult("vpcConfigurations","VpcConfigurations",properties.VpcConfigurations!=null?cfn_parse.FromCloudFormation.getArray(CfnApplicationVpcConfigurationPropertyFromCloudFormation)(properties.VpcConfigurations):void 0),ret.addPropertyResult("zeppelinApplicationConfiguration","ZeppelinApplicationConfiguration",properties.ZeppelinApplicationConfiguration!=null?CfnApplicationZeppelinApplicationConfigurationPropertyFromCloudFormation(properties.ZeppelinApplicationConfiguration):void 0),ret.addUnrecognizedPropertiesAsExtra(properties),ret}function CfnApplication_ApplicationMaintenanceConfigurationPropertyValidator(properties){if(!cdk.canInspect(properties))return cdk.VALIDATION_SUCCESS;const errors=new cdk.ValidationResults;return typeof properties!="object"&&errors.collect(new cdk.ValidationResult("Expected an object, but received: "+JSON.stringify(properties))),errors.collect(cdk.propertyValidator("applicationMaintenanceWindowStartTime",cdk.requiredValidator)(properties.applicationMaintenanceWindowStartTime)),errors.collect(cdk.propertyValidator("applicationMaintenanceWindowStartTime",cdk.validateString)(properties.applicationMaintenanceWindowStartTime)),errors.wrap('supplied properties not correct for "ApplicationMaintenanceConfigurationProperty"')}function cfnApplicationApplicationMaintenanceConfigurationPropertyToCloudFormation(properties){return cdk.canInspect(properties)?(CfnApplication_ApplicationMaintenanceConfigurationPropertyValidator(properties).assertSuccess(),{ApplicationMaintenanceWindowStartTime:cdk.stringToCloudFormation(properties.applicationMaintenanceWindowStartTime)}):properties}function CfnApplicationApplicationMaintenanceConfigurationPropertyFromCloudFormation(properties){if(cdk.isResolvableObject(properties))return new cfn_parse.FromCloudFormationResult(properties);if(properties=properties??{},typeof properties!="object")return new cfn_parse.FromCloudFormationResult(properties);const ret=new cfn_parse.FromCloudFormationPropertyObject;return ret.addPropertyResult("applicationMaintenanceWindowStartTime","ApplicationMaintenanceWindowStartTime",cfn_parse.FromCloudFormation.getString(properties.ApplicationMaintenanceWindowStartTime)),ret.addUnrecognizedPropertiesAsExtra(properties),ret}function CfnApplication_ApplicationRestoreConfigurationPropertyValidator(properties){if(!cdk.canInspect(properties))return cdk.VALIDATION_SUCCESS;const errors=new cdk.ValidationResults;return typeof properties!="object"&&errors.collect(new cdk.ValidationResult("Expected an object, but received: "+JSON.stringify(properties))),errors.collect(cdk.propertyValidator("applicationRestoreType",cdk.requiredValidator)(properties.applicationRestoreType)),errors.collect(cdk.propertyValidator("applicationRestoreType",cdk.validateString)(properties.applicationRestoreType)),errors.collect(cdk.propertyValidator("snapshotName",cdk.validateString)(properties.snapshotName)),errors.wrap('supplied properties not correct for "ApplicationRestoreConfigurationProperty"')}function cfnApplicationApplicationRestoreConfigurationPropertyToCloudFormation(properties){return cdk.canInspect(properties)?(CfnApplication_ApplicationRestoreConfigurationPropertyValidator(properties).assertSuccess(),{ApplicationRestoreType:cdk.stringToCloudFormation(properties.applicationRestoreType),SnapshotName:cdk.stringToCloudFormation(properties.snapshotName)}):properties}function CfnApplicationApplicationRestoreConfigurationPropertyFromCloudFormation(properties){if(cdk.isResolvableObject(properties))return new cfn_parse.FromCloudFormationResult(properties);if(properties=properties??{},typeof properties!="object")return new cfn_parse.FromCloudFormationResult(properties);const ret=new cfn_parse.FromCloudFormationPropertyObject;return ret.addPropertyResult("applicationRestoreType","ApplicationRestoreType",cfn_parse.FromCloudFormation.getString(properties.ApplicationRestoreType)),ret.addPropertyResult("snapshotName","SnapshotName",properties.SnapshotName!=null?cfn_parse.FromCloudFormation.getString(properties.SnapshotName):void 0),ret.addUnrecognizedPropertiesAsExtra(properties),ret}function CfnApplication_ApplicationSnapshotConfigurationPropertyValidator(properties){if(!cdk.canInspect(properties))return cdk.VALIDATION_SUCCESS;const errors=new cdk.ValidationResults;return typeof properties!="object"&&errors.collect(new cdk.ValidationResult("Expected an object, but received: "+JSON.stringify(properties))),errors.collect(cdk.propertyValidator("snapshotsEnabled",cdk.requiredValidator)(properties.snapshotsEnabled)),errors.collect(cdk.propertyValidator("snapshotsEnabled",cdk.validateBoolean)(properties.snapshotsEnabled)),errors.wrap('supplied properties not correct for "ApplicationSnapshotConfigurationProperty"')}function cfnApplicationApplicationSnapshotConfigurationPropertyToCloudFormation(properties){return cdk.canInspect(properties)?(CfnApplication_ApplicationSnapshotConfigurationPropertyValidator(properties).assertSuccess(),{SnapshotsEnabled:cdk.booleanToCloudFormation(properties.snapshotsEnabled)}):properties}function CfnApplicationApplicationSnapshotConfigurationPropertyFromCloudFormation(properties){if(cdk.isResolvableObject(properties))return new cfn_parse.FromCloudFormationResult(properties);if(properties=properties??{},typeof properties!="object")return new cfn_parse.FromCloudFormationResult(properties);const ret=new cfn_parse.FromCloudFormationPropertyObject;return ret.addPropertyResult("snapshotsEnabled","SnapshotsEnabled",cfn_parse.FromCloudFormation.getBoolean(properties.SnapshotsEnabled)),ret.addUnrecognizedPropertiesAsExtra(properties),ret}function CfnApplication_CSVMappingParametersPropertyValidator(properties){if(!cdk.canInspect(properties))return cdk.VALIDATION_SUCCESS;const errors=new cdk.ValidationResults;return typeof properties!="object"&&errors.collect(new cdk.ValidationResult("Expected an object, but received: "+JSON.stringify(properties))),errors.collect(cdk.propertyValidator("recordColumnDelimiter",cdk.requiredValidator)(properties.recordColumnDelimiter)),errors.collect(cdk.propertyValidator("recordColumnDelimiter",cdk.validateString)(properties.recordColumnDelimiter)),errors.collect(cdk.propertyValidator("recordRowDelimiter",cdk.requiredValidator)(properties.recordRowDelimiter)),errors.collect(cdk.propertyValidator("recordRowDelimiter",cdk.validateString)(properties.recordRowDelimiter)),errors.wrap('supplied properties not correct for "CSVMappingParametersProperty"')}function cfnApplicationCSVMappingParametersPropertyToCloudFormation(properties){return cdk.canInspect(properties)?(CfnApplication_CSVMappingParametersPropertyValidator(properties).assertSuccess(),{RecordColumnDelimiter:cdk.stringToCloudFormation(properties.recordColumnDelimiter),RecordRowDelimiter:cdk.stringToCloudFormation(properties.recordRowDelimiter)}):properties}function CfnApplicationCSVMappingParametersPropertyFromCloudFormation(properties){if(cdk.isResolvableObject(properties))return new cfn_parse.FromCloudFormationResult(properties);if(properties=properties??{},typeof properties!="object")return new cfn_parse.FromCloudFormationResult(properties);const ret=new cfn_parse.FromCloudFormationPropertyObject;return ret.addPropertyResult("recordColumnDelimiter","RecordColumnDelimiter",cfn_parse.FromCloudFormation.getString(properties.RecordColumnDelimiter)),ret.addPropertyResult("recordRowDelimiter","RecordRowDelimiter",cfn_parse.FromCloudFormation.getString(properties.RecordRowDelimiter)),ret.addUnrecognizedPropertiesAsExtra(properties),ret}function CfnApplication_CatalogConfigurationPropertyValidator(properties){if(!cdk.canInspect(properties))return cdk.VALIDATION_SUCCESS;const errors=new cdk.ValidationResults;return typeof properties!="object"&&errors.collect(new cdk.ValidationResult("Expected an object, but received: "+JSON.stringify(properties))),errors.collect(cdk.propertyValidator("glueDataCatalogConfiguration",CfnApplication_GlueDataCatalogConfigurationPropertyValidator)(properties.glueDataCatalogConfiguration)),errors.wrap('supplied properties not correct for "CatalogConfigurationProperty"')}function cfnApplicationCatalogConfigurationPropertyToCloudFormation(properties){return cdk.canInspect(properties)?(CfnApplication_CatalogConfigurationPropertyValidator(properties).assertSuccess(),{GlueDataCatalogConfiguration:cfnApplicationGlueDataCatalogConfigurationPropertyToCloudFormation(properties.glueDataCatalogConfiguration)}):properties}function CfnApplicationCatalogConfigurationPropertyFromCloudFormation(properties){if(cdk.isResolvableObject(properties))return new cfn_parse.FromCloudFormationResult(properties);if(properties=properties??{},typeof properties!="object")return new cfn_parse.FromCloudFormationResult(properties);const ret=new cfn_parse.FromCloudFormationPropertyObject;return ret.addPropertyResult("glueDataCatalogConfiguration","GlueDataCatalogConfiguration",properties.GlueDataCatalogConfiguration!=null?CfnApplicationGlueDataCatalogConfigurationPropertyFromCloudFormation(properties.GlueDataCatalogConfiguration):void 0),ret.addUnrecognizedPropertiesAsExtra(properties),ret}function CfnApplication_CheckpointConfigurationPropertyValidator(properties){if(!cdk.canInspect(properties))return cdk.VALIDATION_SUCCESS;const errors=new cdk.ValidationResults;return typeof properties!="object"&&errors.collect(new cdk.ValidationResult("Expected an object, but received: "+JSON.stringify(properties))),errors.collect(cdk.propertyValidator("checkpointInterval",cdk.validateNumber)(properties.checkpointInterval)),errors.collect(cdk.propertyValidator("checkpointingEnabled",cdk.validateBoolean)(properties.checkpointingEnabled)),errors.collect(cdk.propertyValidator("configurationType",cdk.requiredValidator)(properties.configurationType)),errors.collect(cdk.propertyValidator("configurationType",cdk.validateString)(properties.configurationType)),errors.collect(cdk.propertyValidator("minPauseBetweenCheckpoints",cdk.validateNumber)(properties.minPauseBetweenCheckpoints)),errors.wrap('supplied properties not correct for "CheckpointConfigurationProperty"')}function cfnApplicationCheckpointConfigurationPropertyToCloudFormation(properties){return cdk.canInspect(properties)?(CfnApplication_CheckpointConfigurationPropertyValidator(properties).assertSuccess(),{CheckpointInterval:cdk.numberToCloudFormation(properties.checkpointInterval),CheckpointingEnabled:cdk.booleanToCloudFormation(properties.checkpointingEnabled),ConfigurationType:cdk.stringToCloudFormation(properties.configurationType),MinPauseBetweenCheckpoints:cdk.numberToCloudFormation(properties.minPauseBetweenCheckpoints)}):properties}function CfnApplicationCheckpointConfigurationPropertyFromCloudFormation(properties){if(cdk.isResolvableObject(properties))return new cfn_parse.FromCloudFormationResult(properties);if(properties=properties??{},typeof properties!="object")return new cfn_parse.FromCloudFormationResult(properties);const ret=new cfn_parse.FromCloudFormationPropertyObject;return ret.addPropertyResult("checkpointInterval","CheckpointInterval",properties.CheckpointInterval!=null?cfn_parse.FromCloudFormation.getNumber(properties.CheckpointInterval):void 0),ret.addPropertyResult("checkpointingEnabled","CheckpointingEnabled",properties.CheckpointingEnabled!=null?cfn_parse.FromCloudFormation.getBoolean(properties.CheckpointingEnabled):void 0),ret.addPropertyResult("configurationType","ConfigurationType",cfn_parse.FromCloudFormation.getString(properties.ConfigurationType)),ret.addPropertyResult("minPauseBetweenCheckpoints","MinPauseBetweenCheckpoints",properties.MinPauseBetweenCheckpoints!=null?cfn_parse.FromCloudFormation.getNumber(properties.MinPauseBetweenCheckpoints):void 0),ret.addUnrecognizedPropertiesAsExtra(properties),ret}function CfnApplication_CodeContentPropertyValidator(properties){if(!cdk.canInspect(properties))return cdk.VALIDATION_SUCCESS;const errors=new cdk.ValidationResults;return typeof properties!="object"&&errors.collect(new cdk.ValidationResult("Expected an object, but received: "+JSON.stringify(properties))),errors.collect(cdk.propertyValidator("s3ContentLocation",CfnApplication_S3ContentLocationPropertyValidator)(properties.s3ContentLocation)),errors.collect(cdk.propertyValidator("textContent",cdk.validateString)(properties.textContent)),errors.collect(cdk.propertyValidator("zipFileContent",cdk.validateString)(properties.zipFileContent)),errors.wrap('supplied properties not correct for "CodeContentProperty"')}function cfnApplicationCodeContentPropertyToCloudFormation(properties){return cdk.canInspect(properties)?(CfnApplication_CodeContentPropertyValidator(properties).assertSuccess(),{S3ContentLocation:cfnApplicationS3ContentLocationPropertyToCloudFormation(properties.s3ContentLocation),TextContent:cdk.stringToCloudFormation(properties.textContent),ZipFileContent:cdk.stringToCloudFormation(properties.zipFileContent)}):properties}function CfnApplicationCodeContentPropertyFromCloudFormation(properties){if(cdk.isResolvableObject(properties))return new cfn_parse.FromCloudFormationResult(properties);if(properties=properties??{},typeof properties!="object")return new cfn_parse.FromCloudFormationResult(properties);const ret=new cfn_parse.FromCloudFormationPropertyObject;return ret.addPropertyResult("s3ContentLocation","S3ContentLocation",properties.S3ContentLocation!=null?CfnApplicationS3ContentLocationPropertyFromCloudFormation(properties.S3ContentLocation):void 0),ret.addPropertyResult("textContent","TextContent",properties.TextContent!=null?cfn_parse.FromCloudFormation.getString(properties.TextContent):void 0),ret.addPropertyResult("zipFileContent","ZipFileContent",properties.ZipFileContent!=null?cfn_parse.FromCloudFormation.getString(properties.ZipFileContent):void 0),ret.addUnrecognizedPropertiesAsExtra(properties),ret}function CfnApplication_CustomArtifactConfigurationPropertyValidator(properties){if(!cdk.canInspect(properties))return cdk.VALIDATION_SUCCESS;const errors=new cdk.ValidationResults;return typeof properties!="object"&&errors.collect(new cdk.ValidationResult("Expected an object, but received: "+JSON.stringify(properties))),errors.collect(cdk.propertyValidator("artifactType",cdk.requiredValidator)(properties.artifactType)),errors.collect(cdk.propertyValidator("artifactType",cdk.validateString)(properties.artifactType)),errors.collect(cdk.propertyValidator("mavenReference",CfnApplication_MavenReferencePropertyValidator)(properties.mavenReference)),errors.collect(cdk.propertyValidator("s3ContentLocation",CfnApplication_S3ContentLocationPropertyValidator)(properties.s3ContentLocation)),errors.wrap('supplied properties not correct for "CustomArtifactConfigurationProperty"')}function cfnApplicationCustomArtifactConfigurationPropertyToCloudFormation(properties){return cdk.canInspect(properties)?(CfnApplication_CustomArtifactConfigurationPropertyValidator(properties).assertSuccess(),{ArtifactType:cdk.stringToCloudFormation(properties.artifactType),MavenReference:cfnApplicationMavenReferencePropertyToCloudFormation(properties.mavenReference),S3ContentLocation:cfnApplicationS3ContentLocationPropertyToCloudFormation(properties.s3ContentLocation)}):properties}function CfnApplicationCustomArtifactConfigurationPropertyFromCloudFormation(properties){if(cdk.isResolvableObject(properties))return new cfn_parse.FromCloudFormationResult(properties);if(properties=properties??{},typeof properties!="object")return new cfn_parse.FromCloudFormationResult(properties);const ret=new cfn_parse.FromCloudFormationPropertyObject;return ret.addPropertyResult("artifactType","ArtifactType",cfn_parse.FromCloudFormation.getString(properties.ArtifactType)),ret.addPropertyResult("mavenReference","MavenReference",properties.MavenReference!=null?CfnApplicationMavenReferencePropertyFromCloudFormation(properties.MavenReference):void 0),ret.addPropertyResult("s3ContentLocation","S3ContentLocation",properties.S3ContentLocation!=null?CfnApplicationS3ContentLocationPropertyFromCloudFormation(properties.S3ContentLocation):void 0),ret.addUnrecognizedPropertiesAsExtra(properties),ret}function CfnApplication_DeployAsApplicationConfigurationPropertyValidator(properties){if(!cdk.canInspect(properties))return cdk.VALIDATION_SUCCESS;const errors=new cdk.ValidationResults;return typeof properties!="object"&&errors.collect(new cdk.ValidationResult("Expected an object, but received: "+JSON.stringify(properties))),errors.collect(cdk.propertyValidator("s3ContentLocation",cdk.requiredValidator)(properties.s3ContentLocation)),errors.collect(cdk.propertyValidator("s3ContentLocation",CfnApplication_S3ContentBaseLocationPropertyValidator)(properties.s3ContentLocation)),errors.wrap('supplied properties not correct for "DeployAsApplicationConfigurationProperty"')}function cfnApplicationDeployAsApplicationConfigurationPropertyToCloudFormation(properties){return cdk.canInspect(properties)?(CfnApplication_DeployAsApplicationConfigurationPropertyValidator(properties).assertSuccess(),{S3ContentLocation:cfnApplicationS3ContentBaseLocationPropertyToCloudFormation(properties.s3ContentLocation)}):properties}function CfnApplicationDeployAsApplicationConfigurationPropertyFromCloudFormation(properties){if(cdk.isResolvableObject(properties))return new cfn_parse.FromCloudFormationResult(properties);if(properties=properties??{},typeof properties!="object")return new cfn_parse.FromCloudFormationResult(properties);const ret=new cfn_parse.FromCloudFormationPropertyObject;return ret.addPropertyResult("s3ContentLocation","S3ContentLocation",CfnApplicationS3ContentBaseLocationPropertyFromCloudFormation(properties.S3ContentLocation)),ret.addUnrecognizedPropertiesAsExtra(properties),ret}function CfnApplication_EnvironmentPropertiesPropertyValidator(properties){if(!cdk.canInspect(properties))return cdk.VALIDATION_SUCCESS;const errors=new cdk.ValidationResults;return typeof properties!="object"&&errors.collect(new cdk.ValidationResult("Expected an object, but received: "+JSON.stringify(properties))),errors.collect(cdk.propertyValidator("propertyGroups",cdk.listValidator(CfnApplication_PropertyGroupPropertyValidator))(properties.propertyGroups)),errors.wrap('supplied properties not correct for "EnvironmentPropertiesProperty"')}function cfnApplicationEnvironmentPropertiesPropertyToCloudFormation(properties){return cdk.canInspect(properties)?(CfnApplication_EnvironmentPropertiesPropertyValidator(properties).assertSuccess(),{PropertyGroups:cdk.listMapper(cfnApplicationPropertyGroupPropertyToCloudFormation)(properties.propertyGroups)}):properties}function CfnApplicationEnvironmentPropertiesPropertyFromCloudFormation(properties){if(cdk.isResolvableObject(properties))return new cfn_parse.FromCloudFormationResult(properties);if(properties=properties??{},typeof properties!="object")return new cfn_parse.FromCloudFormationResult(properties);const ret=new cfn_parse.FromCloudFormationPropertyObject;return ret.addPropertyResult("propertyGroups","PropertyGroups",properties.PropertyGroups!=null?cfn_parse.FromCloudFormation.getArray(CfnApplicationPropertyGroupPropertyFromCloudFormation)(properties.PropertyGroups):void 0),ret.addUnrecognizedPropertiesAsExtra(properties),ret}function CfnApplication_FlinkApplicationConfigurationPropertyValidator(properties){if(!cdk.canInspect(properties))return cdk.VALIDATION_SUCCESS;const errors=new cdk.ValidationResults;return typeof properties!="object"&&errors.collect(new cdk.ValidationResult("Expected an object, but received: "+JSON.stringify(properties))),errors.collect(cdk.propertyValidator("checkpointConfiguration",CfnApplication_CheckpointConfigurationPropertyValidator)(properties.checkpointConfiguration)),errors.collect(cdk.propertyValidator("monitoringConfiguration",CfnApplication_MonitoringConfigurationPropertyValidator)(properties.monitoringConfiguration)),errors.collect(cdk.propertyValidator("parallelismConfiguration",CfnApplication_ParallelismConfigurationPropertyValidator)(properties.parallelismConfiguration)),errors.wrap('supplied properties not correct for "FlinkApplicationConfigurationProperty"')}function cfnApplicationFlinkApplicationConfigurationPropertyToCloudFormation(properties){return cdk.canInspect(properties)?(CfnApplication_FlinkApplicationConfigurationPropertyValidator(properties).assertSuccess(),{CheckpointConfiguration:cfnApplicationCheckpointConfigurationPropertyToCloudFormation(properties.checkpointConfiguration),MonitoringConfiguration:cfnApplicationMonitoringConfigurationPropertyToCloudFormation(properties.monitoringConfiguration),ParallelismConfiguration:cfnApplicationParallelismConfigurationPropertyToCloudFormation(properties.parallelismConfiguration)}):properties}function CfnApplicationFlinkApplicationConfigurationPropertyFromCloudFormation(properties){if(cdk.isResolvableObject(properties))return new cfn_parse.FromCloudFormationResult(properties);if(properties=properties??{},typeof properties!="object")return new cfn_parse.FromCloudFormationResult(properties);const ret=new cfn_parse.FromCloudFormationPropertyObject;return ret.addPropertyResult("checkpointConfiguration","CheckpointConfiguration",properties.CheckpointConfiguration!=null?CfnApplicationCheckpointConfigurationPropertyFromCloudFormation(properties.CheckpointConfiguration):void 0),ret.addPropertyResult("monitoringConfiguration","MonitoringConfiguration",properties.MonitoringConfiguration!=null?CfnApplicationMonitoringConfigurationPropertyFromCloudFormation(properties.MonitoringConfiguration):void 0),ret.addPropertyResult("parallelismConfiguration","ParallelismConfiguration",properties.ParallelismConfiguration!=null?CfnApplicationParallelismConfigurationPropertyFromCloudFormation(properties.ParallelismConfiguration):void 0),ret.addUnrecognizedPropertiesAsExtra(properties),ret}function CfnApplication_FlinkRunConfigurationPropertyValidator(properties){if(!cdk.canInspect(properties))return cdk.VALIDATION_SUCCESS;const errors=new cdk.ValidationResults;return typeof properties!="object"&&errors.collect(new cdk.ValidationResult("Expected an object, but received: "+JSON.stringify(properties))),errors.collect(cdk.propertyValidator("allowNonRestoredState",cdk.validateBoolean)(properties.allowNonRestoredState)),errors.wrap('supplied properties not correct for "FlinkRunConfigurationProperty"')}function cfnApplicationFlinkRunConfigurationPropertyToCloudFormation(properties){return cdk.canInspect(properties)?(CfnApplication_FlinkRunConfigurationPropertyValidator(properties).assertSuccess(),{AllowNonRestoredState:cdk.booleanToCloudFormation(properties.allowNonRestoredState)}):properties}function CfnApplicationFlinkRunConfigurationPropertyFromCloudFormation(properties){if(cdk.isResolvableObject(properties))return new cfn_parse.FromCloudFormationResult(properties);if(properties=properties??{},typeof properties!="object")return new cfn_parse.FromCloudFormationResult(properties);const ret=new cfn_parse.FromCloudFormationPropertyObject;return ret.addPropertyResult("allowNonRestoredState","AllowNonRestoredState",properties.AllowNonRestoredState!=null?cfn_parse.FromCloudFormation.getBoolean(properties.AllowNonRestoredState):void 0),ret.addUnrecognizedPropertiesAsExtra(properties),ret}function CfnApplication_GlueDataCatalogConfigurationPropertyValidator(properties){if(!cdk.canInspect(properties))return cdk.VALIDATION_SUCCESS;const errors=new cdk.ValidationResults;return typeof properties!="object"&&errors.collect(new cdk.ValidationResult("Expected an object, but received: "+JSON.stringify(properties))),errors.collect(cdk.propertyValidator("databaseArn",cdk.validateString)(properties.databaseArn)),errors.wrap('supplied properties not correct for "GlueDataCatalogConfigurationProperty"')}function cfnApplicationGlueDataCatalogConfigurationPropertyToCloudFormation(properties){return cdk.canInspect(properties)?(CfnApplication_GlueDataCatalogConfigurationPropertyValidator(properties).assertSuccess(),{DatabaseARN:cdk.stringToCloudFormation(properties.databaseArn)}):properties}function CfnApplicationGlueDataCatalogConfigurationPropertyFromCloudFormation(properties){if(cdk.isResolvableObject(properties))return new cfn_parse.FromCloudFormationResult(properties);if(properties=properties??{},typeof properties!="object")return new cfn_parse.FromCloudFormationResult(properties);const ret=new cfn_parse.FromCloudFormationPropertyObject;return ret.addPropertyResult("databaseArn","DatabaseARN",properties.DatabaseARN!=null?cfn_parse.FromCloudFormation.getString(properties.DatabaseARN):void 0),ret.addUnrecognizedPropertiesAsExtra(properties),ret}function CfnApplication_InputPropertyValidator(properties){if(!cdk.canInspect(properties))return cdk.VALIDATION_SUCCESS;const errors=new cdk.ValidationResults;return typeof properties!="object"&&errors.collect(new cdk.ValidationResult("Expected an object, but received: "+JSON.stringify(properties))),errors.collect(cdk.propertyValidator("inputParallelism",CfnApplication_InputParallelismPropertyValidator)(properties.inputParallelism)),errors.collect(cdk.propertyValidator("inputProcessingConfiguration",CfnApplication_InputProcessingConfigurationPropertyValidator)(properties.inputProcessingConfiguration)),errors.collect(cdk.propertyValidator("inputSchema",cdk.requiredValidator)(properties.inputSchema)),errors.collect(cdk.propertyValidator("inputSchema",CfnApplication_InputSchemaPropertyValidator)(properties.inputSchema)),errors.collect(cdk.propertyValidator("kinesisFirehoseInput",CfnApplication_KinesisFirehoseInputPropertyValidator)(properties.kinesisFirehoseInput)),errors.collect(cdk.propertyValidator("kinesisStreamsInput",CfnApplication_KinesisStreamsInputPropertyValidator)(properties.kinesisStreamsInput)),errors.collect(cdk.propertyValidator("namePrefix",cdk.requiredValidator)(properties.namePrefix)),errors.collect(cdk.propertyValidator("namePrefix",cdk.validateString)(properties.namePrefix)),errors.wrap('supplied properties not correct for "InputProperty"')}function cfnApplicationInputPropertyToCloudFormation(properties){return cdk.canInspect(properties)?(CfnApplication_InputPropertyValidator(properties).assertSuccess(),{InputParallelism:cfnApplicationInputParallelismPropertyToCloudFormation(properties.inputParallelism),InputProcessingConfiguration:cfnApplicationInputProcessingConfigurationPropertyToCloudFormation(properties.inputProcessingConfiguration),InputSchema:cfnApplicationInputSchemaPropertyToCloudFormation(properties.inputSchema),KinesisFirehoseInput:cfnApplicationKinesisFirehoseInputPropertyToCloudFormation(properties.kinesisFirehoseInput),KinesisStreamsInput:cfnApplicationKinesisStreamsInputPropertyToCloudFormation(properties.kinesisStreamsInput),NamePrefix:cdk.stringToCloudFormation(properties.namePrefix)}):properties}function CfnApplicationInputPropertyFromCloudFormation(properties){if(cdk.isResolvableObject(properties))return new cfn_parse.FromCloudFormationResult(properties);if(properties=properties??{},typeof properties!="object")return new cfn_parse.FromCloudFormationResult(properties);const ret=new cfn_parse.FromCloudFormationPropertyObject;return ret.addPropertyResult("inputParallelism","InputParallelism",properties.InputParallelism!=null?CfnApplicationInputParallelismPropertyFromCloudFormation(properties.InputParallelism):void 0),ret.addPropertyResult("inputProcessingConfiguration","InputProcessingConfiguration",properties.InputProcessingConfiguration!=null?CfnApplicationInputProcessingConfigurationPropertyFromCloudFormation(properties.InputProcessingConfiguration):void 0),ret.addPropertyResult("inputSchema","InputSchema",CfnApplicationInputSchemaPropertyFromCloudFormation(properties.InputSchema)),ret.addPropertyResult("kinesisFirehoseInput","KinesisFirehoseInput",properties.KinesisFirehoseInput!=null?CfnApplicationKinesisFirehoseInputPropertyFromCloudFormation(properties.KinesisFirehoseInput):void 0),ret.addPropertyResult("kinesisStreamsInput","KinesisStreamsInput",properties.KinesisStreamsInput!=null?CfnApplicationKinesisStreamsInputPropertyFromCloudFormation(properties.KinesisStreamsInput):void 0),ret.addPropertyResult("namePrefix","NamePrefix",cfn_parse.FromCloudFormation.getString(properties.NamePrefix)),ret.addUnrecognizedPropertiesAsExtra(properties),ret}function CfnApplication_InputLambdaProcessorPropertyValidator(properties){if(!cdk.canInspect(properties))return cdk.VALIDATION_SUCCESS;const errors=new cdk.ValidationResults;return typeof properties!="object"&&errors.collect(new cdk.ValidationResult("Expected an object, but received: "+JSON.stringify(properties))),errors.collect(cdk.propertyValidator("resourceArn",cdk.requiredValidator)(properties.resourceArn)),errors.collect(cdk.propertyValidator("resourceArn",cdk.validateString)(properties.resourceArn)),errors.wrap('supplied properties not correct for "InputLambdaProcessorProperty"')}function cfnApplicationInputLambdaProcessorPropertyToCloudFormation(properties){return cdk.canInspect(properties)?(CfnApplication_InputLambdaProcessorPropertyValidator(properties).assertSuccess(),{ResourceARN:cdk.stringToCloudFormation(properties.resourceArn)}):properties}function CfnApplicationInputLambdaProcessorPropertyFromCloudFormation(properties){if(cdk.isResolvableObject(properties))return new cfn_parse.FromCloudFormationResult(properties);if(properties=properties??{},typeof properties!="object")return new cfn_parse.FromCloudFormationResult(properties);const ret=new cfn_parse.FromCloudFormationPropertyObject;return ret.addPropertyResult("resourceArn","ResourceARN",cfn_parse.FromCloudFormation.getString(properties.ResourceARN)),ret.addUnrecognizedPropertiesAsExtra(properties),ret}function CfnApplication_InputParallelismPropertyValidator(properties){if(!cdk.canInspect(properties))return cdk.VALIDATION_SUCCESS;const errors=new cdk.ValidationResults;return typeof properties!="object"&&errors.collect(new cdk.ValidationResult("Expected an object, but received: "+JSON.stringify(properties))),errors.collect(cdk.propertyValidator("count",cdk.validateNumber)(properties.count)),errors.wrap('supplied properties not correct for "InputParallelismProperty"')}function cfnApplicationInputParallelismPropertyToCloudFormation(properties){return cdk.canInspect(properties)?(CfnApplication_InputParallelismPropertyValidator(properties).assertSuccess(),{Count:cdk.numberToCloudFormation(properties.count)}):properties}function CfnApplicationInputParallelismPropertyFromCloudFormation(properties){if(cdk.isResolvableObject(properties))return new cfn_parse.FromCloudFormationResult(properties);if(properties=properties??{},typeof properties!="object")return new cfn_parse.FromCloudFormationResult(properties);const ret=new cfn_parse.FromCloudFormationPropertyObject;return ret.addPropertyResult("count","Count",properties.Count!=null?cfn_parse.FromCloudFormation.getNumber(properties.Count):void 0),ret.addUnrecognizedPropertiesAsExtra(properties),ret}function CfnApplication_InputProcessingConfigurationPropertyValidator(properties){if(!cdk.canInspect(properties))return cdk.VALIDATION_SUCCESS;const errors=new cdk.ValidationResults;return typeof properties!="object"&&errors.collect(new cdk.ValidationResult("Expected an object, but received: "+JSON.stringify(properties))),errors.collect(cdk.propertyValidator("inputLambdaProcessor",CfnApplication_InputLambdaProcessorPropertyValidator)(properties.inputLambdaProcessor)),errors.wrap('supplied properties not correct for "InputProcessingConfigurationProperty"')}function cfnApplicationInputProcessingConfigurationPropertyToCloudFormation(properties){return cdk.canInspect(properties)?(CfnApplication_InputProcessingConfigurationPropertyValidator(properties).assertSuccess(),{InputLambdaProcessor:cfnApplicationInputLambdaProcessorPropertyToCloudFormation(properties.inputLambdaProcessor)}):properties}function CfnApplicationInputProcessingConfigurationPropertyFromCloudFormation(properties){if(cdk.isResolvableObject(properties))return new cfn_parse.FromCloudFormationResult(properties);if(properties=properties??{},typeof properties!="object")return new cfn_parse.FromCloudFormationResult(properties);const ret=new cfn_parse.FromCloudFormationPropertyObject;return ret.addPropertyResult("inputLambdaProcessor","InputLambdaProcessor",properties.InputLambdaProcessor!=null?CfnApplicationInputLambdaProcessorPropertyFromCloudFormation(properties.InputLambdaProcessor):void 0),ret.addUnrecognizedPropertiesAsExtra(properties),ret}function CfnApplication_InputSchemaPropertyValidator(properties){if(!cdk.canInspect(properties))return cdk.VALIDATION_SUCCESS;const errors=new cdk.ValidationResults;return typeof properties!="object"&&errors.collect(new cdk.ValidationResult("Expected an object, but received: "+JSON.stringify(properties))),errors.collect(cdk.propertyValidator("recordColumns",cdk.requiredValidator)(properties.recordColumns)),errors.collect(cdk.propertyValidator("recordColumns",cdk.listValidator(CfnApplication_RecordColumnPropertyValidator))(properties.recordColumns)),errors.collect(cdk.propertyValidator("recordEncoding",cdk.validateString)(properties.recordEncoding)),errors.collect(cdk.propertyValidator("recordFormat",cdk.requiredValidator)(properties.recordFormat)),errors.collect(cdk.propertyValidator("recordFormat",CfnApplication_RecordFormatPropertyValidator)(properties.recordFormat)),errors.wrap('supplied properties not correct for "InputSchemaProperty"')}function cfnApplicationInputSchemaPropertyToCloudFormation(properties){return cdk.canInspect(properties)?(CfnApplication_InputSchemaPropertyValidator(properties).assertSuccess(),{RecordColumns:cdk.listMapper(cfnApplicationRecordColumnPropertyToCloudFormation)(properties.recordColumns),RecordEncoding:cdk.stringToCloudFormation(properties.recordEncoding),RecordFormat:cfnApplicationRecordFormatPropertyToCloudFormation(properties.recordFormat)}):properties}function CfnApplicationInputSchemaPropertyFromCloudFormation(properties){if(cdk.isResolvableObject(properties))return new cfn_parse.FromCloudFormationResult(properties);if(properties=properties??{},typeof properties!="object")return new cfn_parse.FromCloudFormationResult(properties);const ret=new cfn_parse.FromCloudFormationPropertyObject;return ret.addPropertyResult("recordColumns","RecordColumns",cfn_parse.FromCloudFormation.getArray(CfnApplicationRecordColumnPropertyFromCloudFormation)(properties.RecordColumns)),ret.addPropertyResult("recordEncoding","RecordEncoding",properties.RecordEncoding!=null?cfn_parse.FromCloudFormation.getString(properties.RecordEncoding):void 0),ret.addPropertyResult("recordFormat","RecordFormat",CfnApplicationRecordFormatPropertyFromCloudFormation(properties.RecordFormat)),ret.addUnrecognizedPropertiesAsExtra(properties),ret}function CfnApplication_JSONMappingParametersPropertyValidator(properties){if(!cdk.canInspect(properties))return cdk.VALIDATION_SUCCESS;const errors=new cdk.ValidationResults;return typeof properties!="object"&&errors.collect(new cdk.ValidationResult("Expected an object, but received: "+JSON.stringify(properties))),errors.collect(cdk.propertyValidator("recordRowPath",cdk.requiredValidator)(properties.recordRowPath)),errors.collect(cdk.propertyValidator("recordRowPath",cdk.validateString)(properties.recordRowPath)),errors.wrap('supplied properties not correct for "JSONMappingParametersProperty"')}function cfnApplicationJSONMappingParametersPropertyToCloudFormation(properties){return cdk.canInspect(properties)?(CfnApplication_JSONMappingParametersPropertyValidator(properties).assertSuccess(),{RecordRowPath:cdk.stringToCloudFormation(properties.recordRowPath)}):properties}function CfnApplicationJSONMappingParametersPropertyFromCloudFormation(properties){if(cdk.isResolvableObject(properties))return new cfn_parse.FromCloudFormationResult(properties);if(properties=properties??{},typeof properties!="object")return new cfn_parse.FromCloudFormationResult(properties);const ret=new cfn_parse.FromCloudFormationPropertyObject;return ret.addPropertyResult("recordRowPath","RecordRowPath",cfn_parse.FromCloudFormation.getString(properties.RecordRowPath)),ret.addUnrecognizedPropertiesAsExtra(properties),ret}function CfnApplication_KinesisFirehoseInputPropertyValidator(properties){if(!cdk.canInspect(properties))return cdk.VALIDATION_SUCCESS;const errors=new cdk.ValidationResults;return typeof properties!="object"&&errors.collect(new cdk.ValidationResult("Expected an object, but received: "+JSON.stringify(properties))),errors.collect(cdk.propertyValidator("resourceArn",cdk.requiredValidator)(properties.resourceArn)),errors.collect(cdk.propertyValidator("resourceArn",cdk.validateString)(properties.resourceArn)),errors.wrap('supplied properties not correct for "KinesisFirehoseInputProperty"')}function cfnApplicationKinesisFirehoseInputPropertyToCloudFormation(properties){return cdk.canInspect(properties)?(CfnApplication_KinesisFirehoseInputPropertyValidator(properties).assertSuccess(),{ResourceARN:cdk.stringToCloudFormation(properties.resourceArn)}):properties}function CfnApplicationKinesisFirehoseInputPropertyFromCloudFormation(properties){if(cdk.isResolvableObject(properties))return new cfn_parse.FromCloudFormationResult(properties);if(properties=properties??{},typeof properties!="object")return new cfn_parse.FromCloudFormationResult(properties);const ret=new cfn_parse.FromCloudFormationPropertyObject;return ret.addPropertyResult("resourceArn","ResourceARN",cfn_parse.FromCloudFormation.getString(properties.ResourceARN)),ret.addUnrecognizedPropertiesAsExtra(properties),ret}function CfnApplication_KinesisStreamsInputPropertyValidator(properties){if(!cdk.canInspect(properties))return cdk.VALIDATION_SUCCESS;const errors=new cdk.ValidationResults;return typeof properties!="object"&&errors.collect(new cdk.ValidationResult("Expected an object, but received: "+JSON.stringify(properties))),errors.collect(cdk.propertyValidator("resourceArn",cdk.requiredValidator)(properties.resourceArn)),errors.collect(cdk.propertyValidator("resourceArn",cdk.validateString)(properties.resourceArn)),errors.wrap('supplied properties not correct for "KinesisStreamsInputProperty"')}function cfnApplicationKinesisStreamsInputPropertyToCloudFormation(properties){return cdk.canInspect(properties)?(CfnApplication_KinesisStreamsInputPropertyValidator(properties).assertSuccess(),{ResourceARN:cdk.stringToCloudFormation(properties.resourceArn)}):properties}function CfnApplicationKinesisStreamsInputPropertyFromCloudFormation(properties){if(cdk.isResolvableObject(properties))return new cfn_parse.FromCloudFormationResult(properties);if(properties=properties??{},typeof properties!="object")return new cfn_parse.FromCloudFormationResult(properties);const ret=new cfn_parse.FromCloudFormationPropertyObject;return ret.addPropertyResult("resourceArn","ResourceARN",cfn_parse.FromCloudFormation.getString(properties.ResourceARN)),ret.addUnrecognizedPropertiesAsExtra(properties),ret}function CfnApplication_MappingParametersPropertyValidator(properties){if(!cdk.canInspect(properties))return cdk.VALIDATION_SUCCESS;const errors=new cdk.ValidationResults;return typeof properties!="object"&&errors.collect(new cdk.ValidationResult("Expected an object, but received: "+JSON.stringify(properties))),errors.collect(cdk.propertyValidator("csvMappingParameters",CfnApplication_CSVMappingParametersPropertyValidator)(properties.csvMappingParameters)),errors.collect(cdk.propertyValidator("jsonMappingParameters",CfnApplication_JSONMappingParametersPropertyValidator)(properties.jsonMappingParameters)),errors.wrap('supplied properties not correct for "MappingParametersProperty"')}function cfnApplicationMappingParametersPropertyToCloudFormation(properties){return cdk.canInspect(properties)?(CfnApplication_MappingParametersPropertyValidator(properties).assertSuccess(),{CSVMappingParameters:cfnApplicationCSVMappingParametersPropertyToCloudFormation(properties.csvMappingParameters),JSONMappingParameters:cfnApplicationJSONMappingParametersPropertyToCloudFormation(properties.jsonMappingParameters)}):properties}function CfnApplicationMappingParametersPropertyFromCloudFormation(properties){if(cdk.isResolvableObject(properties))return new cfn_parse.FromCloudFormationResult(properties);if(properties=properties??{},typeof properties!="object")return new cfn_parse.FromCloudFormationResult(properties);const ret=new cfn_parse.FromCloudFormationPropertyObject;return ret.addPropertyResult("csvMappingParameters","CSVMappingParameters",properties.CSVMappingParameters!=null?CfnApplicationCSVMappingParametersPropertyFromCloudFormation(properties.CSVMappingParameters):void 0),ret.addPropertyResult("jsonMappingParameters","JSONMappingParameters",properties.JSONMappingParameters!=null?CfnApplicationJSONMappingParametersPropertyFromCloudFormation(properties.JSONMappingParameters):void 0),ret.addUnrecognizedPropertiesAsExtra(properties),ret}function CfnApplication_MavenReferencePropertyValidator(properties){if(!cdk.canInspect(properties))return cdk.VALIDATION_SUCCESS;const errors=new cdk.ValidationResults;return typeof properties!="object"&&errors.collect(new cdk.ValidationResult("Expected an object, but received: "+JSON.stringify(properties))),errors.collect(cdk.propertyValidator("artifactId",cdk.requiredValidator)(properties.artifactId)),errors.collect(cdk.propertyValidator("artifactId",cdk.validateString)(properties.artifactId)),errors.collect(cdk.propertyValidator("groupId",cdk.requiredValidator)(properties.groupId)),errors.collect(cdk.propertyValidator("groupId",cdk.validateString)(properties.groupId)),errors.collect(cdk.propertyValidator("version",cdk.requiredValidator)(properties.version)),errors.collect(cdk.propertyValidator("version",cdk.validateString)(properties.version)),errors.wrap('supplied properties not correct for "MavenReferenceProperty"')}function cfnApplicationMavenReferencePropertyToCloudFormation(properties){return cdk.canInspect(properties)?(CfnApplication_MavenReferencePropertyValidator(properties).assertSuccess(),{ArtifactId:cdk.stringToCloudFormation(properties.artifactId),GroupId:cdk.stringToCloudFormation(properties.groupId),Version:cdk.stringToCloudFormation(properties.version)}):properties}function CfnApplicationMavenReferencePropertyFromCloudFormation(properties){if(cdk.isResolvableObject(properties))return new cfn_parse.FromCloudFormationResult(properties);if(properties=properties??{},typeof properties!="object")return new cfn_parse.FromCloudFormationResult(properties);const ret=new cfn_parse.FromCloudFormationPropertyObject;return ret.addPropertyResult("artifactId","ArtifactId",cfn_parse.FromCloudFormation.getString(properties.ArtifactId)),ret.addPropertyResult("groupId","GroupId",cfn_parse.FromCloudFormation.getString(properties.GroupId)),ret.addPropertyResult("version","Version",cfn_parse.FromCloudFormation.getString(properties.Version)),ret.addUnrecognizedPropertiesAsExtra(properties),ret}function CfnApplication_MonitoringConfigurationPropertyValidator(properties){if(!cdk.canInspect(properties))return cdk.VALIDATION_SUCCESS;const errors=new cdk.ValidationResults;return typeof properties!="object"&&errors.collect(new cdk.ValidationResult("Expected an object, but received: "+JSON.stringify(properties))),errors.collect(cdk.propertyValidator("configurationType",cdk.requiredValidator)(properties.configurationType)),errors.collect(cdk.propertyValidator("configurationType",cdk.validateString)(properties.configurationType)),errors.collect(cdk.propertyValidator("logLevel",cdk.validateString)(properties.logLevel)),errors.collect(cdk.propertyValidator("metricsLevel",cdk.validateString)(properties.metricsLevel)),errors.wrap('supplied properties not correct for "MonitoringConfigurationProperty"')}function cfnApplicationMonitoringConfigurationPropertyToCloudFormation(properties){return cdk.canInspect(properties)?(CfnApplication_MonitoringConfigurationPropertyValidator(properties).assertSuccess(),{ConfigurationType:cdk.stringToCloudFormation(properties.configurationType),LogLevel:cdk.stringToCloudFormation(properties.logLevel),MetricsLevel:cdk.stringToCloudFormation(properties.metricsLevel)}):properties}function CfnApplicationMonitoringConfigurationPropertyFromCloudFormation(properties){if(cdk.isResolvableObject(properties))return new cfn_parse.FromCloudFormationResult(properties);if(properties=properties??{},typeof properties!="object")return new cfn_parse.FromCloudFormationResult(properties);const ret=new cfn_parse.FromCloudFormationPropertyObject;return ret.addPropertyResult("configurationType","ConfigurationType",cfn_parse.FromCloudFormation.getString(properties.ConfigurationType)),ret.addPropertyResult("logLevel","LogLevel",properties.LogLevel!=null?cfn_parse.FromCloudFormation.getString(properties.LogLevel):void 0),ret.addPropertyResult("metricsLevel","MetricsLevel",properties.MetricsLevel!=null?cfn_parse.FromCloudFormation.getString(properties.MetricsLevel):void 0),ret.addUnrecognizedPropertiesAsExtra(properties),ret}function CfnApplication_ParallelismConfigurationPropertyValidator(properties){if(!cdk.canInspect(properties))return cdk.VALIDATION_SUCCESS;const errors=new cdk.ValidationResults;return typeof properties!="object"&&errors.collect(new cdk.ValidationResult("Expected an object, but received: "+JSON.stringify(properties))),errors.collect(cdk.propertyValidator("autoScalingEnabled",cdk.validateBoolean)(properties.autoScalingEnabled)),errors.collect(cdk.propertyValidator("configurationType",cdk.requiredValidator)(properties.configurationType)),errors.collect(cdk.propertyValidator("configurationType",cdk.validateString)(properties.configurationType)),errors.collect(cdk.propertyValidator("parallelism",cdk.validateNumber)(properties.parallelism)),errors.collect(cdk.propertyValidator("parallelismPerKpu",cdk.validateNumber)(properties.parallelismPerKpu)),errors.wrap('supplied properties not correct for "ParallelismConfigurationProperty"')}function cfnApplicationParallelismConfigurationPropertyToCloudFormation(properties){return cdk.canInspect(properties)?(CfnApplication_ParallelismConfigurationPropertyValidator(properties).assertSuccess(),{AutoScalingEnabled:cdk.booleanToCloudFormation(properties.autoScalingEnabled),ConfigurationType:cdk.stringToCloudFormation(properties.configurationType),Parallelism:cdk.numberToCloudFormation(properties.parallelism),ParallelismPerKPU:cdk.numberToCloudFormation(properties.parallelismPerKpu)}):properties}function CfnApplicationParallelismConfigurationPropertyFromCloudFormation(properties){if(cdk.isResolvableObject(properties))return new cfn_parse.FromCloudFormationResult(properties);if(properties=properties??{},typeof properties!="object")return new cfn_parse.FromCloudFormationResult(properties);const ret=new cfn_parse.FromCloudFormationPropertyObject;return ret.addPropertyResult("autoScalingEnabled","AutoScalingEnabled",properties.AutoScalingEnabled!=null?cfn_parse.FromCloudFormation.getBoolean(properties.AutoScalingEnabled):void 0),ret.addPropertyResult("configurationType","ConfigurationType",cfn_parse.FromCloudFormation.getString(properties.ConfigurationType)),ret.addPropertyResult("parallelism","Parallelism",properties.Parallelism!=null?cfn_parse.FromCloudFormation.getNumber(properties.Parallelism):void 0),ret.addPropertyResult("parallelismPerKpu","ParallelismPerKPU",properties.ParallelismPerKPU!=null?cfn_parse.FromCloudFormation.getNumber(properties.ParallelismPerKPU):void 0),ret.addUnrecognizedPropertiesAsExtra(properties),ret}function CfnApplication_PropertyGroupPropertyValidator(properties){if(!cdk.canInspect(properties))return cdk.VALIDATION_SUCCESS;const errors=new cdk.ValidationResults;return typeof properties!="object"&&errors.collect(new cdk.ValidationResult("Expected an object, but received: "+JSON.stringify(properties))),errors.collect(cdk.propertyValidator("propertyGroupId",cdk.validateString)(properties.propertyGroupId)),errors.collect(cdk.propertyValidator("propertyMap",cdk.hashValidator(cdk.validateString))(properties.propertyMap)),errors.wrap('supplied properties not correct for "PropertyGroupProperty"')}function cfnApplicationPropertyGroupPropertyToCloudFormation(properties){return cdk.canInspect(properties)?(CfnApplication_PropertyGroupPropertyValidator(properties).assertSuccess(),{PropertyGroupId:cdk.stringToCloudFormation(properties.propertyGroupId),PropertyMap:cdk.hashMapper(cdk.stringToCloudFormation)(properties.propertyMap)}):properties}function CfnApplicationPropertyGroupPropertyFromCloudFormation(properties){if(cdk.isResolvableObject(properties))return new cfn_parse.FromCloudFormationResult(properties);if(properties=properties??{},typeof properties!="object")return new cfn_parse.FromCloudFormationResult(properties);const ret=new cfn_parse.FromCloudFormationPropertyObject;return ret.addPropertyResult("propertyGroupId","PropertyGroupId",properties.PropertyGroupId!=null?cfn_parse.FromCloudFormation.getString(properties.PropertyGroupId):void 0),ret.addPropertyResult("propertyMap","PropertyMap",properties.PropertyMap!=null?cfn_parse.FromCloudFormation.getMap(cfn_parse.FromCloudFormation.getString)(properties.PropertyMap):void 0),ret.addUnrecognizedPropertiesAsExtra(properties),ret}function CfnApplication_RecordColumnPropertyValidator(properties){if(!cdk.canInspect(properties))return cdk.VALIDATION_SUCCESS;const errors=new cdk.ValidationResults;return typeof properties!="object"&&errors.collect(new cdk.ValidationResult("Expected an object, but received: "+JSON.stringify(properties))),errors.collect(cdk.propertyValidator("mapping",cdk.validateString)(properties.mapping)),errors.collect(cdk.propertyValidator("name",cdk.requiredValidator)(properties.name)),errors.collect(cdk.propertyValidator("name",cdk.validateString)(properties.name)),errors.collect(cdk.propertyValidator("sqlType",cdk.requiredValidator)(properties.sqlType)),errors.collect(cdk.propertyValidator("sqlType",cdk.validateString)(properties.sqlType)),errors.wrap('supplied properties not correct for "RecordColumnProperty"')}function cfnApplicationRecordColumnPropertyToCloudFormation(properties){return cdk.canInspect(properties)?(CfnApplication_RecordColumnPropertyValidator(properties).assertSuccess(),{Mapping:cdk.stringToCloudFormation(properties.mapping),Name:cdk.stringToCloudFormation(properties.name),SqlType:cdk.stringToCloudFormation(properties.sqlType)}):properties}function CfnApplicationRecordColumnPropertyFromCloudFormation(properties){if(cdk.isResolvableObject(properties))return new cfn_parse.FromCloudFormationResult(properties);if(properties=properties??{},typeof properties!="object")return new cfn_parse.FromCloudFormationResult(properties);const ret=new cfn_parse.FromCloudFormationPropertyObject;return ret.addPropertyResult("mapping","Mapping",properties.Mapping!=null?cfn_parse.FromCloudFormation.getString(properties.Mapping):void 0),ret.addPropertyResult("name","Name",cfn_parse.FromCloudFormation.getString(properties.Name)),ret.addPropertyResult("sqlType","SqlType",cfn_parse.FromCloudFormation.getString(properties.SqlType)),ret.addUnrecognizedPropertiesAsExtra(properties),ret}function CfnApplication_RecordFormatPropertyValidator(properties){if(!cdk.canInspect(properties))return cdk.VALIDATION_SUCCESS;const errors=new cdk.ValidationResults;return typeof properties!="object"&&errors.collect(new cdk.ValidationResult("Expected an object, but received: "+JSON.stringify(properties))),errors.collect(cdk.propertyValidator("mappingParameters",CfnApplication_MappingParametersPropertyValidator)(properties.mappingParameters)),errors.collect(cdk.propertyValidator("recordFormatType",cdk.requiredValidator)(properties.recordFormatType)),errors.collect(cdk.propertyValidator("recordFormatType",cdk.validateString)(properties.recordFormatType)),errors.wrap('supplied properties not correct for "RecordFormatProperty"')}function cfnApplicationRecordFormatPropertyToCloudFormation(properties){return cdk.canInspect(properties)?(CfnApplication_RecordFormatPropertyValidator(properties).assertSuccess(),{MappingParameters:cfnApplicationMappingParametersPropertyToCloudFormation(properties.mappingParameters),RecordFormatType:cdk.stringToCloudFormation(properties.recordFormatType)}):properties}function CfnApplicationRecordFormatPropertyFromCloudFormation(properties){if(cdk.isResolvableObject(properties))return new cfn_parse.FromCloudFormationResult(properties);if(properties=properties??{},typeof properties!="object")return new cfn_parse.FromCloudFormationResult(properties);const ret=new cfn_parse.FromCloudFormationPropertyObject;return ret.addPropertyResult("mappingParameters","MappingParameters",properties.MappingParameters!=null?CfnApplicationMappingParametersPropertyFromCloudFormation(properties.MappingParameters):void 0),ret.addPropertyResult("recordFormatType","RecordFormatType",cfn_parse.FromCloudFormation.getString(properties.RecordFormatType)),ret.addUnrecognizedPropertiesAsExtra(properties),ret}function CfnApplication_RunConfigurationPropertyValidator(properties){if(!cdk.canInspect(properties))return cdk.VALIDATION_SUCCESS;const errors=new cdk.ValidationResults;return typeof properties!="object"&&errors.collect(new cdk.ValidationResult("Expected an object, but received: "+JSON.stringify(properties))),errors.collect(cdk.propertyValidator("applicationRestoreConfiguration",CfnApplication_ApplicationRestoreConfigurationPropertyValidator)(properties.applicationRestoreConfiguration)),errors.collect(cdk.propertyValidator("flinkRunConfiguration",CfnApplication_FlinkRunConfigurationPropertyValidator)(properties.flinkRunConfiguration)),errors.wrap('supplied properties not correct for "RunConfigurationProperty"')}function cfnApplicationRunConfigurationPropertyToCloudFormation(properties){return cdk.canInspect(properties)?(CfnApplication_RunConfigurationPropertyValidator(properties).assertSuccess(),{ApplicationRestoreConfiguration:cfnApplicationApplicationRestoreConfigurationPropertyToCloudFormation(properties.applicationRestoreConfiguration),FlinkRunConfiguration:cfnApplicationFlinkRunConfigurationPropertyToCloudFormation(properties.flinkRunConfiguration)}):properties}function CfnApplicationRunConfigurationPropertyFromCloudFormation(properties){if(cdk.isResolvableObject(properties))return new cfn_parse.FromCloudFormationResult(properties);if(properties=properties??{},typeof properties!="object")return new cfn_parse.FromCloudFormationResult(properties);const ret=new cfn_parse.FromCloudFormationPropertyObject;return ret.addPropertyResult("applicationRestoreConfiguration","ApplicationRestoreConfiguration",properties.ApplicationRestoreConfiguration!=null?CfnApplicationApplicationRestoreConfigurationPropertyFromCloudFormation(properties.ApplicationRestoreConfiguration):void 0),ret.addPropertyResult("flinkRunConfiguration","FlinkRunConfiguration",properties.FlinkRunConfiguration!=null?CfnApplicationFlinkRunConfigurationPropertyFromCloudFormation(properties.FlinkRunConfiguration):void 0),ret.addUnrecognizedPropertiesAsExtra(properties),ret}function CfnApplication_S3ContentBaseLocationPropertyValidator(properties){if(!cdk.canInspect(properties))return cdk.VALIDATION_SUCCESS;const errors=new cdk.ValidationResults;return typeof properties!="object"&&errors.collect(new cdk.ValidationResult("Expected an object, but received: "+JSON.stringify(properties))),errors.collect(cdk.propertyValidator("basePath",cdk.validateString)(properties.basePath)),errors.collect(cdk.propertyValidator("bucketArn",cdk.requiredValidator)(properties.bucketArn)),errors.collect(cdk.propertyValidator("bucketArn",cdk.validateString)(properties.bucketArn)),errors.wrap('supplied properties not correct for "S3ContentBaseLocationProperty"')}function cfnApplicationS3ContentBaseLocationPropertyToCloudFormation(properties){return cdk.canInspect(properties)?(CfnApplication_S3ContentBaseLocationPropertyValidator(properties).assertSuccess(),{BasePath:cdk.stringToCloudFormation(properties.basePath),BucketARN:cdk.stringToCloudFormation(properties.bucketArn)}):properties}function CfnApplicationS3ContentBaseLocationPropertyFromCloudFormation(properties){if(cdk.isResolvableObject(properties))return new cfn_parse.FromCloudFormationResult(properties);if(properties=properties??{},typeof properties!="object")return new cfn_parse.FromCloudFormationResult(properties);const ret=new cfn_parse.FromCloudFormationPropertyObject;return ret.addPropertyResult("basePath","BasePath",properties.BasePath!=null?cfn_parse.FromCloudFormation.getString(properties.BasePath):void 0),ret.addPropertyResult("bucketArn","BucketARN",cfn_parse.FromCloudFormation.getString(properties.BucketARN)),ret.addUnrecognizedPropertiesAsExtra(properties),ret}function CfnApplication_S3ContentLocationPropertyValidator(properties){if(!cdk.canInspect(properties))return cdk.VALIDATION_SUCCESS;const errors=new cdk.ValidationResults;return typeof properties!="object"&&errors.collect(new cdk.ValidationResult("Expected an object, but received: "+JSON.stringify(properties))),errors.collect(cdk.propertyValidator("bucketArn",cdk.requiredValidator)(properties.bucketArn)),errors.collect(cdk.propertyValidator("bucketArn",cdk.validateString)(properties.bucketArn)),errors.collect(cdk.propertyValidator("fileKey",cdk.requiredValidator)(properties.fileKey)),errors.collect(cdk.propertyValidator("fileKey",cdk.validateString)(properties.fileKey)),errors.collect(cdk.propertyValidator("objectVersion",cdk.validateString)(properties.objectVersion)),errors.wrap('supplied properties not correct for "S3ContentLocationProperty"')}function cfnApplicationS3ContentLocationPropertyToCloudFormation(properties){return cdk.canInspect(properties)?(CfnApplication_S3ContentLocationPropertyValidator(properties).assertSuccess(),{BucketARN:cdk.stringToCloudFormation(properties.bucketArn),FileKey:cdk.stringToCloudFormation(properties.fileKey),ObjectVersion:cdk.stringToCloudFormation(properties.objectVersion)}):properties}function CfnApplicationS3ContentLocationPropertyFromCloudFormation(properties){if(cdk.isResolvableObject(properties))return new cfn_parse.FromCloudFormationResult(properties);if(properties=properties??{},typeof properties!="object")return new cfn_parse.FromCloudFormationResult(properties);const ret=new cfn_parse.FromCloudFormationPropertyObject;return ret.addPropertyResult("bucketArn","BucketARN",cfn_parse.FromCloudFormation.getString(properties.BucketARN)),ret.addPropertyResult("fileKey","FileKey",cfn_parse.FromCloudFormation.getString(properties.FileKey)),ret.addPropertyResult("objectVersion","ObjectVersion",properties.ObjectVersion!=null?cfn_parse.FromCloudFormation.getString(properties.ObjectVersion):void 0),ret.addUnrecognizedPropertiesAsExtra(properties),ret}function CfnApplication_SqlApplicationConfigurationPropertyValidator(properties){if(!cdk.canInspect(properties))return cdk.VALIDATION_SUCCESS;const errors=new cdk.ValidationResults;return typeof properties!="object"&&errors.collect(new cdk.ValidationResult("Expected an object, but received: "+JSON.stringify(properties))),errors.collect(cdk.propertyValidator("inputs",cdk.listValidator(CfnApplication_InputPropertyValidator))(properties.inputs)),errors.wrap('supplied properties not correct for "SqlApplicationConfigurationProperty"')}function cfnApplicationSqlApplicationConfigurationPropertyToCloudFormation(properties){return cdk.canInspect(properties)?(CfnApplication_SqlApplicationConfigurationPropertyValidator(properties).assertSuccess(),{Inputs:cdk.listMapper(cfnApplicationInputPropertyToCloudFormation)(properties.inputs)}):properties}function CfnApplicationSqlApplicationConfigurationPropertyFromCloudFormation(properties){if(cdk.isResolvableObject(properties))return new cfn_parse.FromCloudFormationResult(properties);if(properties=properties??{},typeof properties!="object")return new cfn_parse.FromCloudFormationResult(properties);const ret=new cfn_parse.FromCloudFormationPropertyObject;return ret.addPropertyResult("inputs","Inputs",properties.Inputs!=null?cfn_parse.FromCloudFormation.getArray(CfnApplicationInputPropertyFromCloudFormation)(properties.Inputs):void 0),ret.addUnrecognizedPropertiesAsExtra(properties),ret}function CfnApplication_VpcConfigurationPropertyValidator(properties){if(!cdk.canInspect(properties))return cdk.VALIDATION_SUCCESS;const errors=new cdk.ValidationResults;return typeof properties!="object"&&errors.collect(new cdk.ValidationResult("Expected an object, but received: "+JSON.stringify(properties))),errors.collect(cdk.propertyValidator("securityGroupIds",cdk.requiredValidator)(properties.securityGroupIds)),errors.collect(cdk.propertyValidator("securityGroupIds",cdk.listValidator(cdk.validateString))(properties.securityGroupIds)),errors.collect(cdk.propertyValidator("subnetIds",cdk.requiredValidator)(properties.subnetIds)),errors.collect(cdk.propertyValidator("subnetIds",cdk.listValidator(cdk.validateString))(properties.subnetIds)),errors.wrap('supplied properties not correct for "VpcConfigurationProperty"')}function cfnApplicationVpcConfigurationPropertyToCloudFormation(properties){return cdk.canInspect(properties)?(CfnApplication_VpcConfigurationPropertyValidator(properties).assertSuccess(),{SecurityGroupIds:cdk.listMapper(cdk.stringToCloudFormation)(properties.securityGroupIds),SubnetIds:cdk.listMapper(cdk.stringToCloudFormation)(properties.subnetIds)}):properties}function CfnApplicationVpcConfigurationPropertyFromCloudFormation(properties){if(cdk.isResolvableObject(properties))return new cfn_parse.FromCloudFormationResult(properties);if(properties=properties??{},typeof properties!="object")return new cfn_parse.FromCloudFormationResult(properties);const ret=new cfn_parse.FromCloudFormationPropertyObject;return ret.addPropertyResult("securityGroupIds","SecurityGroupIds",cfn_parse.FromCloudFormation.getStringArray(properties.SecurityGroupIds)),ret.addPropertyResult("subnetIds","SubnetIds",cfn_parse.FromCloudFormation.getStringArray(properties.SubnetIds)),ret.addUnrecognizedPropertiesAsExtra(properties),ret}function CfnApplication_ZeppelinApplicationConfigurationPropertyValidator(properties){if(!cdk.canInspect(properties))return cdk.VALIDATION_SUCCESS;const errors=new cdk.ValidationResults;return typeof properties!="object"&&errors.collect(new cdk.ValidationResult("Expected an object, but received: "+JSON.stringify(properties))),errors.collect(cdk.propertyValidator("catalogConfiguration",CfnApplication_CatalogConfigurationPropertyValidator)(properties.catalogConfiguration)),errors.collect(cdk.propertyValidator("customArtifactsConfiguration",cdk.listValidator(CfnApplication_CustomArtifactConfigurationPropertyValidator))(properties.customArtifactsConfiguration)),errors.collect(cdk.propertyValidator("deployAsApplicationConfiguration",CfnApplication_DeployAsApplicationConfigurationPropertyValidator)(properties.deployAsApplicationConfiguration)),errors.collect(cdk.propertyValidator("monitoringConfiguration",CfnApplication_ZeppelinMonitoringConfigurationPropertyValidator)(properties.monitoringConfiguration)),errors.wrap('supplied properties not correct for "ZeppelinApplicationConfigurationProperty"')}function cfnApplicationZeppelinApplicationConfigurationPropertyToCloudFormation(properties){return cdk.canInspect(properties)?(CfnApplication_ZeppelinApplicationConfigurationPropertyValidator(properties).assertSuccess(),{CatalogConfiguration:cfnApplicationCatalogConfigurationPropertyToCloudFormation(properties.catalogConfiguration),CustomArtifactsConfiguration:cdk.listMapper(cfnApplicationCustomArtifactConfigurationPropertyToCloudFormation)(properties.customArtifactsConfiguration),DeployAsApplicationConfiguration:cfnApplicationDeployAsApplicationConfigurationPropertyToCloudFormation(properties.deployAsApplicationConfiguration),MonitoringConfiguration:cfnApplicationZeppelinMonitoringConfigurationPropertyToCloudFormation(properties.monitoringConfiguration)}):properties}function CfnApplicationZeppelinApplicationConfigurationPropertyFromCloudFormation(properties){if(cdk.isResolvableObject(properties))return new cfn_parse.FromCloudFormationResult(properties);if(properties=properties??{},typeof properties!="object")return new cfn_parse.FromCloudFormationResult(properties);const ret=new cfn_parse.FromCloudFormationPropertyObject;return ret.addPropertyResult("catalogConfiguration","CatalogConfiguration",properties.CatalogConfiguration!=null?CfnApplicationCatalogConfigurationPropertyFromCloudFormation(properties.CatalogConfiguration):void 0),ret.addPropertyResult("customArtifactsConfiguration","CustomArtifactsConfiguration",properties.CustomArtifactsConfiguration!=null?cfn_parse.FromCloudFormation.getArray(CfnApplicationCustomArtifactConfigurationPropertyFromCloudFormation)(properties.CustomArtifactsConfiguration):void 0),ret.addPropertyResult("deployAsApplicationConfiguration","DeployAsApplicationConfiguration",properties.DeployAsApplicationConfiguration!=null?CfnApplicationDeployAsApplicationConfigurationPropertyFromCloudFormation(properties.DeployAsApplicationConfiguration):void 0),ret.addPropertyResult("monitoringConfiguration","MonitoringConfiguration",properties.MonitoringConfiguration!=null?CfnApplicationZeppelinMonitoringConfigurationPropertyFromCloudFormation(properties.MonitoringConfiguration):void 0),ret.addUnrecognizedPropertiesAsExtra(properties),ret}function CfnApplication_ZeppelinMonitoringConfigurationPropertyValidator(properties){if(!cdk.canInspect(properties))return cdk.VALIDATION_SUCCESS;const errors=new cdk.ValidationResults;return typeof properties!="object"&&errors.collect(new cdk.ValidationResult("Expected an object, but received: "+JSON.stringify(properties))),errors.collect(cdk.propertyValidator("logLevel",cdk.validateString)(properties.logLevel)),errors.wrap('supplied properties not correct for "ZeppelinMonitoringConfigurationProperty"')}function cfnApplicationZeppelinMonitoringConfigurationPropertyToCloudFormation(properties){return cdk.canInspect(properties)?(CfnApplication_ZeppelinMonitoringConfigurationPropertyValidator(properties).assertSuccess(),{LogLevel:cdk.stringToCloudFormation(properties.logLevel)}):properties}function CfnApplicationZeppelinMonitoringConfigurationPropertyFromCloudFormation(properties){if(cdk.isResolvableObject(properties))return new cfn_parse.FromCloudFormationResult(properties);if(properties=properties??{},typeof properties!="object")return new cfn_parse.FromCloudFormationResult(properties);const ret=new cfn_parse.FromCloudFormationPropertyObject;return ret.addPropertyResult("logLevel","LogLevel",properties.LogLevel!=null?cfn_parse.FromCloudFormation.getString(properties.LogLevel):void 0),ret.addUnrecognizedPropertiesAsExtra(properties),ret}function CfnApplicationCloudWatchLoggingOptionPropsValidator(properties){if(!cdk.canInspect(properties))return cdk.VALIDATION_SUCCESS;const errors=new cdk.ValidationResults;return typeof properties!="object"&&errors.collect(new cdk.ValidationResult("Expected an object, but received: "+JSON.stringify(properties))),errors.collect(cdk.propertyValidator("applicationName",cdk.requiredValidator)(properties.applicationName)),errors.collect(cdk.propertyValidator("applicationName",cdk.validateString)(properties.applicationName)),errors.collect(cdk.propertyValidator("cloudWatchLoggingOption",cdk.requiredValidator)(properties.cloudWatchLoggingOption)),errors.collect(cdk.propertyValidator("cloudWatchLoggingOption",CfnApplicationCloudWatchLoggingOption_CloudWatchLoggingOptionPropertyValidator)(properties.cloudWatchLoggingOption)),errors.wrap('supplied properties not correct for "CfnApplicationCloudWatchLoggingOptionProps"')}function cfnApplicationCloudWatchLoggingOptionPropsToCloudFormation(properties){return cdk.canInspect(properties)?(CfnApplicationCloudWatchLoggingOptionPropsValidator(properties).assertSuccess(),{ApplicationName:cdk.stringToCloudFormation(properties.applicationName),CloudWatchLoggingOption:cfnApplicationCloudWatchLoggingOptionCloudWatchLoggingOptionPropertyToCloudFormation(properties.cloudWatchLoggingOption)}):properties}function CfnApplicationCloudWatchLoggingOptionPropsFromCloudFormation(properties){if(properties=properties??{},typeof properties!="object")return new cfn_parse.FromCloudFormationResult(properties);const ret=new cfn_parse.FromCloudFormationPropertyObject;return ret.addPropertyResult("applicationName","ApplicationName",cfn_parse.FromCloudFormation.getString(properties.ApplicationName)),ret.addPropertyResult("cloudWatchLoggingOption","CloudWatchLoggingOption",CfnApplicationCloudWatchLoggingOptionCloudWatchLoggingOptionPropertyFromCloudFormation(properties.CloudWatchLoggingOption)),ret.addUnrecognizedPropertiesAsExtra(properties),ret}class CfnApplicationCloudWatchLoggingOption extends cdk.CfnResource{static _fromCloudFormation(scope,id,resourceAttributes,options){resourceAttributes=resourceAttributes||{};const resourceProperties=options.parser.parseValue(resourceAttributes.Properties),propsResult=CfnApplicationCloudWatchLoggingOptionPropsFromCloudFormation(resourceProperties),ret=new CfnApplicationCloudWatchLoggingOption(scope,id,propsResult.value);for(const[propKey,propVal]of Object.entries(propsResult.extraProperties))ret.addPropertyOverride(propKey,propVal);return options.parser.handleAttributes(ret,resourceAttributes,id),ret}constructor(scope,id,props){super(scope,id,{type:CfnApplicationCloudWatchLoggingOption.CFN_RESOURCE_TYPE_NAME,properties:props});try{jsiiDeprecationWarnings.aws_cdk_lib_aws_kinesisanalyticsv2_CfnApplicationCloudWatchLoggingOptionProps(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,CfnApplicationCloudWatchLoggingOption),error}cdk.requireProperty(props,"applicationName",this),cdk.requireProperty(props,"cloudWatchLoggingOption",this),this.applicationName=props.applicationName,this.cloudWatchLoggingOption=props.cloudWatchLoggingOption}inspect(inspector){try{jsiiDeprecationWarnings.aws_cdk_lib_TreeInspector(inspector)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.inspect),error}inspector.addAttribute("aws:cdk:cloudformation:type",CfnApplicationCloudWatchLoggingOption.CFN_RESOURCE_TYPE_NAME),inspector.addAttribute("aws:cdk:cloudformation:props",this.cfnProperties)}get cfnProperties(){return{applicationName:this.applicationName,cloudWatchLoggingOption:this.cloudWatchLoggingOption}}renderProperties(props){return cfnApplicationCloudWatchLoggingOptionPropsToCloudFormation(props)}}_b=JSII_RTTI_SYMBOL_1,CfnApplicationCloudWatchLoggingOption[_b]={fqn:"aws-cdk-lib.aws_kinesisanalyticsv2.CfnApplicationCloudWatchLoggingOption",version:"2.87.0"},CfnApplicationCloudWatchLoggingOption.CFN_RESOURCE_TYPE_NAME="AWS::KinesisAnalyticsV2::ApplicationCloudWatchLoggingOption",exports.CfnApplicationCloudWatchLoggingOption=CfnApplicationCloudWatchLoggingOption;function CfnApplicationCloudWatchLoggingOption_CloudWatchLoggingOptionPropertyValidator(properties){if(!cdk.canInspect(properties))return cdk.VALIDATION_SUCCESS;const errors=new cdk.ValidationResults;return typeof properties!="object"&&errors.collect(new cdk.ValidationResult("Expected an object, but received: "+JSON.stringify(properties))),errors.collect(cdk.propertyValidator("logStreamArn",cdk.requiredValidator)(properties.logStreamArn)),errors.collect(cdk.propertyValidator("logStreamArn",cdk.validateString)(properties.logStreamArn)),errors.wrap('supplied properties not correct for "CloudWatchLoggingOptionProperty"')}function cfnApplicationCloudWatchLoggingOptionCloudWatchLoggingOptionPropertyToCloudFormation(properties){return cdk.canInspect(properties)?(CfnApplicationCloudWatchLoggingOption_CloudWatchLoggingOptionPropertyValidator(properties).assertSuccess(),{LogStreamARN:cdk.stringToCloudFormation(properties.logStreamArn)}):properties}function CfnApplicationCloudWatchLoggingOptionCloudWatchLoggingOptionPropertyFromCloudFormation(properties){if(cdk.isResolvableObject(properties))return new cfn_parse.FromCloudFormationResult(properties);if(properties=properties??{},typeof properties!="object")return new cfn_parse.FromCloudFormationResult(properties);const ret=new cfn_parse.FromCloudFormationPropertyObject;return ret.addPropertyResult("logStreamArn","LogStreamARN",cfn_parse.FromCloudFormation.getString(properties.LogStreamARN)),ret.addUnrecognizedPropertiesAsExtra(properties),ret}function CfnApplicationOutputPropsValidator(properties){if(!cdk.canInspect(properties))return cdk.VALIDATION_SUCCESS;const errors=new cdk.ValidationResults;return typeof properties!="object"&&errors.collect(new cdk.ValidationResult("Expected an object, but received: "+JSON.stringify(properties))),errors.collect(cdk.propertyValidator("applicationName",cdk.requiredValidator)(properties.applicationName)),errors.collect(cdk.propertyValidator("applicationName",cdk.validateString)(properties.applicationName)),errors.collect(cdk.propertyValidator("output",cdk.requiredValidator)(properties.output)),errors.collect(cdk.propertyValidator("output",CfnApplicationOutput_OutputPropertyValidator)(properties.output)),errors.wrap('supplied properties not correct for "CfnApplicationOutputProps"')}function cfnApplicationOutputPropsToCloudFormation(properties){return cdk.canInspect(properties)?(CfnApplicationOutputPropsValidator(properties).assertSuccess(),{ApplicationName:cdk.stringToCloudFormation(properties.applicationName),Output:cfnApplicationOutputOutputPropertyToCloudFormation(properties.output)}):properties}function CfnApplicationOutputPropsFromCloudFormation(properties){if(properties=properties??{},typeof properties!="object")return new cfn_parse.FromCloudFormationResult(properties);const ret=new cfn_parse.FromCloudFormationPropertyObject;return ret.addPropertyResult("applicationName","ApplicationName",cfn_parse.FromCloudFormation.getString(properties.ApplicationName)),ret.addPropertyResult("output","Output",CfnApplicationOutputOutputPropertyFromCloudFormation(properties.Output)),ret.addUnrecognizedPropertiesAsExtra(properties),ret}class CfnApplicationOutput extends cdk.CfnResource{static _fromCloudFormation(scope,id,resourceAttributes,options){resourceAttributes=resourceAttributes||{};const resourceProperties=options.parser.parseValue(resourceAttributes.Properties),propsResult=CfnApplicationOutputPropsFromCloudFormation(resourceProperties),ret=new CfnApplicationOutput(scope,id,propsResult.value);for(const[propKey,propVal]of Object.entries(propsResult.extraProperties))ret.addPropertyOverride(propKey,propVal);return options.parser.handleAttributes(ret,resourceAttributes,id),ret}constructor(scope,id,props){super(scope,id,{type:CfnApplicationOutput.CFN_RESOURCE_TYPE_NAME,properties:props});try{jsiiDeprecationWarnings.aws_cdk_lib_aws_kinesisanalyticsv2_CfnApplicationOutputProps(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,CfnApplicationOutput),error}cdk.requireProperty(props,"applicationName",this),cdk.requireProperty(props,"output",this),this.applicationName=props.applicationName,this.output=props.output}inspect(inspector){try{jsiiDeprecationWarnings.aws_cdk_lib_TreeInspector(inspector)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.inspect),error}inspector.addAttribute("aws:cdk:cloudformation:type",CfnApplicationOutput.CFN_RESOURCE_TYPE_NAME),inspector.addAttribute("aws:cdk:cloudformation:props",this.cfnProperties)}get cfnProperties(){return{applicationName:this.applicationName,output:this.output}}renderProperties(props){return cfnApplicationOutputPropsToCloudFormation(props)}}_c=JSII_RTTI_SYMBOL_1,CfnApplicationOutput[_c]={fqn:"aws-cdk-lib.aws_kinesisanalyticsv2.CfnApplicationOutput",version:"2.87.0"},CfnApplicationOutput.CFN_RESOURCE_TYPE_NAME="AWS::KinesisAnalyticsV2::ApplicationOutput",exports.CfnApplicationOutput=CfnApplicationOutput;function CfnApplicationOutput_DestinationSchemaPropertyValidator(properties){if(!cdk.canInspect(properties))return cdk.VALIDATION_SUCCESS;const errors=new cdk.ValidationResults;return typeof properties!="object"&&errors.collect(new cdk.ValidationResult("Expected an object, but received: "+JSON.stringify(properties))),errors.collect(cdk.propertyValidator("recordFormatType",cdk.validateString)(properties.recordFormatType)),errors.wrap('supplied properties not correct for "DestinationSchemaProperty"')}function cfnApplicationOutputDestinationSchemaPropertyToCloudFormation(properties){return cdk.canInspect(properties)?(CfnApplicationOutput_DestinationSchemaPropertyValidator(properties).assertSuccess(),{RecordFormatType:cdk.stringToCloudFormation(properties.recordFormatType)}):properties}function CfnApplicationOutputDestinationSchemaPropertyFromCloudFormation(properties){if(cdk.isResolvableObject(properties))return new cfn_parse.FromCloudFormationResult(properties);if(properties=properties??{},typeof properties!="object")return new cfn_parse.FromCloudFormationResult(properties);const ret=new cfn_parse.FromCloudFormationPropertyObject;return ret.addPropertyResult("recordFormatType","RecordFormatType",properties.RecordFormatType!=null?cfn_parse.FromCloudFormation.getString(properties.RecordFormatType):void 0),ret.addUnrecognizedPropertiesAsExtra(properties),ret}function CfnApplicationOutput_KinesisFirehoseOutputPropertyValidator(properties){if(!cdk.canInspect(properties))return cdk.VALIDATION_SUCCESS;const errors=new cdk.ValidationResults;return typeof properties!="object"&&errors.collect(new cdk.ValidationResult("Expected an object, but received: "+JSON.stringify(properties))),errors.collect(cdk.propertyValidator("resourceArn",cdk.requiredValidator)(properties.resourceArn)),errors.collect(cdk.propertyValidator("resourceArn",cdk.validateString)(properties.resourceArn)),errors.wrap('supplied properties not correct for "KinesisFirehoseOutputProperty"')}function cfnApplicationOutputKinesisFirehoseOutputPropertyToCloudFormation(properties){return cdk.canInspect(properties)?(CfnApplicationOutput_KinesisFirehoseOutputPropertyValidator(properties).assertSuccess(),{ResourceARN:cdk.stringToCloudFormation(properties.resourceArn)}):properties}function CfnApplicationOutputKinesisFirehoseOutputPropertyFromCloudFormation(properties){if(cdk.isResolvableObject(properties))return new cfn_parse.FromCloudFormationResult(properties);if(properties=properties??{},typeof properties!="object")return new cfn_parse.FromCloudFormationResult(properties);const ret=new cfn_parse.FromCloudFormationPropertyObject;return ret.addPropertyResult("resourceArn","ResourceARN",cfn_parse.FromCloudFormation.getString(properties.ResourceARN)),ret.addUnrecognizedPropertiesAsExtra(properties),ret}function CfnApplicationOutput_KinesisStreamsOutputPropertyValidator(properties){if(!cdk.canInspect(properties))return cdk.VALIDATION_SUCCESS;const errors=new cdk.ValidationResults;return typeof properties!="object"&&errors.collect(new cdk.ValidationResult("Expected an object, but received: "+JSON.stringify(properties))),errors.collect(cdk.propertyValidator("resourceArn",cdk.requiredValidator)(properties.resourceArn)),errors.collect(cdk.propertyValidator("resourceArn",cdk.validateString)(properties.resourceArn)),errors.wrap('supplied properties not correct for "KinesisStreamsOutputProperty"')}function cfnApplicationOutputKinesisStreamsOutputPropertyToCloudFormation(properties){return cdk.canInspect(properties)?(CfnApplicationOutput_KinesisStreamsOutputPropertyValidator(properties).assertSuccess(),{ResourceARN:cdk.stringToCloudFormation(properties.resourceArn)}):properties}function CfnApplicationOutputKinesisStreamsOutputPropertyFromCloudFormation(properties){if(cdk.isResolvableObject(properties))return new cfn_parse.FromCloudFormationResult(properties);if(properties=properties??{},typeof properties!="object")return new cfn_parse.FromCloudFormationResult(properties);const ret=new cfn_parse.FromCloudFormationPropertyObject;return ret.addPropertyResult("resourceArn","ResourceARN",cfn_parse.FromCloudFormation.getString(properties.ResourceARN)),ret.addUnrecognizedPropertiesAsExtra(properties),ret}function CfnApplicationOutput_LambdaOutputPropertyValidator(properties){if(!cdk.canInspect(properties))return cdk.VALIDATION_SUCCESS;const errors=new cdk.ValidationResults;return typeof properties!="object"&&errors.collect(new cdk.ValidationResult("Expected an object, but received: "+JSON.stringify(properties))),errors.collect(cdk.propertyValidator("resourceArn",cdk.requiredValidator)(properties.resourceArn)),errors.collect(cdk.propertyValidator("resourceArn",cdk.validateString)(properties.resourceArn)),errors.wrap('supplied properties not correct for "LambdaOutputProperty"')}function cfnApplicationOutputLambdaOutputPropertyToCloudFormation(properties){return cdk.canInspect(properties)?(CfnApplicationOutput_LambdaOutputPropertyValidator(properties).assertSuccess(),{ResourceARN:cdk.stringToCloudFormation(properties.resourceArn)}):properties}function CfnApplicationOutputLambdaOutputPropertyFromCloudFormation(properties){if(cdk.isResolvableObject(properties))return new cfn_parse.FromCloudFormationResult(properties);if(properties=properties??{},typeof properties!="object")return new cfn_parse.FromCloudFormationResult(properties);const ret=new cfn_parse.FromCloudFormationPropertyObject;return ret.addPropertyResult("resourceArn","ResourceARN",cfn_parse.FromCloudFormation.getString(properties.ResourceARN)),ret.addUnrecognizedPropertiesAsExtra(properties),ret}function CfnApplicationOutput_OutputPropertyValidator(properties){if(!cdk.canInspect(properties))return cdk.VALIDATION_SUCCESS;const errors=new cdk.ValidationResults;return typeof properties!="object"&&errors.collect(new cdk.ValidationResult("Expected an object, but received: "+JSON.stringify(properties))),errors.collect(cdk.propertyValidator("destinationSchema",cdk.requiredValidator)(properties.destinationSchema)),errors.collect(cdk.propertyValidator("destinationSchema",CfnApplicationOutput_DestinationSchemaPropertyValidator)(properties.destinationSchema)),errors.collect(cdk.propertyValidator("kinesisFirehoseOutput",CfnApplicationOutput_KinesisFirehoseOutputPropertyValidator)(properties.kinesisFirehoseOutput)),errors.collect(cdk.propertyValidator("kinesisStreamsOutput",CfnApplicationOutput_KinesisStreamsOutputPropertyValidator)(properties.kinesisStreamsOutput)),errors.collect(cdk.propertyValidator("lambdaOutput",CfnApplicationOutput_LambdaOutputPropertyValidator)(properties.lambdaOutput)),errors.collect(cdk.propertyValidator("name",cdk.validateString)(properties.name)),errors.wrap('supplied properties not correct for "OutputProperty"')}function cfnApplicationOutputOutputPropertyToCloudFormation(properties){return cdk.canInspect(properties)?(CfnApplicationOutput_OutputPropertyValidator(properties).assertSuccess(),{DestinationSchema:cfnApplicationOutputDestinationSchemaPropertyToCloudFormation(properties.destinationSchema),KinesisFirehoseOutput:cfnApplicationOutputKinesisFirehoseOutputPropertyToCloudFormation(properties.kinesisFirehoseOutput),KinesisStreamsOutput:cfnApplicationOutputKinesisStreamsOutputPropertyToCloudFormation(properties.kinesisStreamsOutput),LambdaOutput:cfnApplicationOutputLambdaOutputPropertyToCloudFormation(properties.lambdaOutput),Name:cdk.stringToCloudFormation(properties.name)}):properties}function CfnApplicationOutputOutputPropertyFromCloudFormation(properties){if(cdk.isResolvableObject(properties))return new cfn_parse.FromCloudFormationResult(properties);if(properties=properties??{},typeof properties!="object")return new cfn_parse.FromCloudFormationResult(properties);const ret=new cfn_parse.FromCloudFormationPropertyObject;return ret.addPropertyResult("destinationSchema","DestinationSchema",CfnApplicationOutputDestinationSchemaPropertyFromCloudFormation(properties.DestinationSchema)),ret.addPropertyResult("kinesisFirehoseOutput","KinesisFirehoseOutput",properties.KinesisFirehoseOutput!=null?CfnApplicationOutputKinesisFirehoseOutputPropertyFromCloudFormation(properties.KinesisFirehoseOutput):void 0),ret.addPropertyResult("kinesisStreamsOutput","KinesisStreamsOutput",properties.KinesisStreamsOutput!=null?CfnApplicationOutputKinesisStreamsOutputPropertyFromCloudFormation(properties.KinesisStreamsOutput):void 0),ret.addPropertyResult("lambdaOutput","LambdaOutput",properties.LambdaOutput!=null?CfnApplicationOutputLambdaOutputPropertyFromCloudFormation(properties.LambdaOutput):void 0),ret.addPropertyResult("name","Name",properties.Name!=null?cfn_parse.FromCloudFormation.getString(properties.Name):void 0),ret.addUnrecognizedPropertiesAsExtra(properties),ret}function CfnApplicationReferenceDataSourcePropsValidator(properties){if(!cdk.canInspect(properties))return cdk.VALIDATION_SUCCESS;const errors=new cdk.ValidationResults;return typeof properties!="object"&&errors.collect(new cdk.ValidationResult("Expected an object, but received: "+JSON.stringify(properties))),errors.collect(cdk.propertyValidator("applicationName",cdk.requiredValidator)(properties.applicationName)),errors.collect(cdk.propertyValidator("applicationName",cdk.validateString)(properties.applicationName)),errors.collect(cdk.propertyValidator("referenceDataSource",cdk.requiredValidator)(properties.referenceDataSource)),errors.collect(cdk.propertyValidator("referenceDataSource",CfnApplicationReferenceDataSource_ReferenceDataSourcePropertyValidator)(properties.referenceDataSource)),errors.wrap('supplied properties not correct for "CfnApplicationReferenceDataSourceProps"')}function cfnApplicationReferenceDataSourcePropsToCloudFormation(properties){return cdk.canInspect(properties)?(CfnApplicationReferenceDataSourcePropsValidator(properties).assertSuccess(),{ApplicationName:cdk.stringToCloudFormation(properties.applicationName),ReferenceDataSource:cfnApplicationReferenceDataSourceReferenceDataSourcePropertyToCloudFormation(properties.referenceDataSource)}):properties}function CfnApplicationReferenceDataSourcePropsFromCloudFormation(properties){if(properties=properties??{},typeof properties!="object")return new cfn_parse.FromCloudFormationResult(properties);const ret=new cfn_parse.FromCloudFormationPropertyObject;return ret.addPropertyResult("applicationName","ApplicationName",cfn_parse.FromCloudFormation.getString(properties.ApplicationName)),ret.addPropertyResult("referenceDataSource","ReferenceDataSource",CfnApplicationReferenceDataSourceReferenceDataSourcePropertyFromCloudFormation(properties.ReferenceDataSource)),ret.addUnrecognizedPropertiesAsExtra(properties),ret}class CfnApplicationReferenceDataSource extends cdk.CfnResource{static _fromCloudFormation(scope,id,resourceAttributes,options){resourceAttributes=resourceAttributes||{};const resourceProperties=options.parser.parseValue(resourceAttributes.Properties),propsResult=CfnApplicationReferenceDataSourcePropsFromCloudFormation(resourceProperties),ret=new CfnApplicationReferenceDataSource(scope,id,propsResult.value);for(const[propKey,propVal]of Object.entries(propsResult.extraProperties))ret.addPropertyOverride(propKey,propVal);return options.parser.handleAttributes(ret,resourceAttributes,id),ret}constructor(scope,id,props){super(scope,id,{type:CfnApplicationReferenceDataSource.CFN_RESOURCE_TYPE_NAME,properties:props});try{jsiiDeprecationWarnings.aws_cdk_lib_aws_kinesisanalyticsv2_CfnApplicationReferenceDataSourceProps(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,CfnApplicationReferenceDataSource),error}cdk.requireProperty(props,"applicationName",this),cdk.requireProperty(props,"referenceDataSource",this),this.applicationName=props.applicationName,this.referenceDataSource=props.referenceDataSource}inspect(inspector){try{jsiiDeprecationWarnings.aws_cdk_lib_TreeInspector(inspector)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.inspect),error}inspector.addAttribute("aws:cdk:cloudformation:type",CfnApplicationReferenceDataSource.CFN_RESOURCE_TYPE_NAME),inspector.addAttribute("aws:cdk:cloudformation:props",this.cfnProperties)}get cfnProperties(){return{applicationName:this.applicationName,referenceDataSource:this.referenceDataSource}}renderProperties(props){return cfnApplicationReferenceDataSourcePropsToCloudFormation(props)}}_d=JSII_RTTI_SYMBOL_1,CfnApplicationReferenceDataSource[_d]={fqn:"aws-cdk-lib.aws_kinesisanalyticsv2.CfnApplicationReferenceDataSource",version:"2.87.0"},CfnApplicationReferenceDataSource.CFN_RESOURCE_TYPE_NAME="AWS::KinesisAnalyticsV2::ApplicationReferenceDataSource",exports.CfnApplicationReferenceDataSource=CfnApplicationReferenceDataSource;function CfnApplicationReferenceDataSource_CSVMappingParametersPropertyValidator(properties){if(!cdk.canInspect(properties))return cdk.VALIDATION_SUCCESS;const errors=new cdk.ValidationResults;return typeof properties!="object"&&errors.collect(new cdk.ValidationResult("Expected an object, but received: "+JSON.stringify(properties))),errors.collect(cdk.propertyValidator("recordColumnDelimiter",cdk.requiredValidator)(properties.recordColumnDelimiter)),errors.collect(cdk.propertyValidator("recordColumnDelimiter",cdk.validateString)(properties.recordColumnDelimiter)),errors.collect(cdk.propertyValidator("recordRowDelimiter",cdk.requiredValidator)(properties.recordRowDelimiter)),errors.collect(cdk.propertyValidator("recordRowDelimiter",cdk.validateString)(properties.recordRowDelimiter)),errors.wrap('supplied properties not correct for "CSVMappingParametersProperty"')}function cfnApplicationReferenceDataSourceCSVMappingParametersPropertyToCloudFormation(properties){return cdk.canInspect(properties)?(CfnApplicationReferenceDataSource_CSVMappingParametersPropertyValidator(properties).assertSuccess(),{RecordColumnDelimiter:cdk.stringToCloudFormation(properties.recordColumnDelimiter),RecordRowDelimiter:cdk.stringToCloudFormation(properties.recordRowDelimiter)}):properties}function CfnApplicationReferenceDataSourceCSVMappingParametersPropertyFromCloudFormation(properties){if(cdk.isResolvableObject(properties))return new cfn_parse.FromCloudFormationResult(properties);if(properties=properties??{},typeof properties!="object")return new cfn_parse.FromCloudFormationResult(properties);const ret=new cfn_parse.FromCloudFormationPropertyObject;return ret.addPropertyResult("recordColumnDelimiter","RecordColumnDelimiter",cfn_parse.FromCloudFormation.getString(properties.RecordColumnDelimiter)),ret.addPropertyResult("recordRowDelimiter","RecordRowDelimiter",cfn_parse.FromCloudFormation.getString(properties.RecordRowDelimiter)),ret.addUnrecognizedPropertiesAsExtra(properties),ret}function CfnApplicationReferenceDataSource_JSONMappingParametersPropertyValidator(properties){if(!cdk.canInspect(properties))return cdk.VALIDATION_SUCCESS;const errors=new cdk.ValidationResults;return typeof properties!="object"&&errors.collect(new cdk.ValidationResult("Expected an object, but received: "+JSON.stringify(properties))),errors.collect(cdk.propertyValidator("recordRowPath",cdk.requiredValidator)(properties.recordRowPath)),errors.collect(cdk.propertyValidator("recordRowPath",cdk.validateString)(properties.recordRowPath)),errors.wrap('supplied properties not correct for "JSONMappingParametersProperty"')}function cfnApplicationReferenceDataSourceJSONMappingParametersPropertyToCloudFormation(properties){return cdk.canInspect(properties)?(CfnApplicationReferenceDataSource_JSONMappingParametersPropertyValidator(properties).assertSuccess(),{RecordRowPath:cdk.stringToCloudFormation(properties.recordRowPath)}):properties}function CfnApplicationReferenceDataSourceJSONMappingParametersPropertyFromCloudFormation(properties){if(cdk.isResolvableObject(properties))return new cfn_parse.FromCloudFormationResult(properties);if(properties=properties??{},typeof properties!="object")return new cfn_parse.FromCloudFormationResult(properties);const ret=new cfn_parse.FromCloudFormationPropertyObject;return ret.addPropertyResult("recordRowPath","RecordRowPath",cfn_parse.FromCloudFormation.getString(properties.RecordRowPath)),ret.addUnrecognizedPropertiesAsExtra(properties),ret}function CfnApplicationReferenceDataSource_MappingParametersPropertyValidator(properties){if(!cdk.canInspect(properties))return cdk.VALIDATION_SUCCESS;const errors=new cdk.ValidationResults;return typeof properties!="object"&&errors.collect(new cdk.ValidationResult("Expected an object, but received: "+JSON.stringify(properties))),errors.collect(cdk.propertyValidator("csvMappingParameters",CfnApplicationReferenceDataSource_CSVMappingParametersPropertyValidator)(properties.csvMappingParameters)),errors.collect(cdk.propertyValidator("jsonMappingParameters",CfnApplicationReferenceDataSource_JSONMappingParametersPropertyValidator)(properties.jsonMappingParameters)),errors.wrap('supplied properties not correct for "MappingParametersProperty"')}function cfnApplicationReferenceDataSourceMappingParametersPropertyToCloudFormation(properties){return cdk.canInspect(properties)?(CfnApplicationReferenceDataSource_MappingParametersPropertyValidator(properties).assertSuccess(),{CSVMappingParameters:cfnApplicationReferenceDataSourceCSVMappingParametersPropertyToCloudFormation(properties.csvMappingParameters),JSONMappingParameters:cfnApplicationReferenceDataSourceJSONMappingParametersPropertyToCloudFormation(properties.jsonMappingParameters)}):properties}function CfnApplicationReferenceDataSourceMappingParametersPropertyFromCloudFormation(properties){if(cdk.isResolvableObject(properties))return new cfn_parse.FromCloudFormationResult(properties);if(properties=properties??{},typeof properties!="object")return new cfn_parse.FromCloudFormationResult(properties);const ret=new cfn_parse.FromCloudFormationPropertyObject;return ret.addPropertyResult("csvMappingParameters","CSVMappingParameters",properties.CSVMappingParameters!=null?CfnApplicationReferenceDataSourceCSVMappingParametersPropertyFromCloudFormation(properties.CSVMappingParameters):void 0),ret.addPropertyResult("jsonMappingParameters","JSONMappingParameters",properties.JSONMappingParameters!=null?CfnApplicationReferenceDataSourceJSONMappingParametersPropertyFromCloudFormation(properties.JSONMappingParameters):void 0),ret.addUnrecognizedPropertiesAsExtra(properties),ret}function CfnApplicationReferenceDataSource_RecordColumnPropertyValidator(properties){if(!cdk.canInspect(properties))return cdk.VALIDATION_SUCCESS;const errors=new cdk.ValidationResults;return typeof properties!="object"&&errors.collect(new cdk.ValidationResult("Expected an object, but received: "+JSON.stringify(properties))),errors.collect(cdk.propertyValidator("mapping",cdk.validateString)(properties.mapping)),errors.collect(cdk.propertyValidator("name",cdk.requiredValidator)(properties.name)),errors.collect(cdk.propertyValidator("name",cdk.validateString)(properties.name)),errors.collect(cdk.propertyValidator("sqlType",cdk.requiredValidator)(properties.sqlType)),errors.collect(cdk.propertyValidator("sqlType",cdk.validateString)(properties.sqlType)),errors.wrap('supplied properties not correct for "RecordColumnProperty"')}function cfnApplicationReferenceDataSourceRecordColumnPropertyToCloudFormation(properties){return cdk.canInspect(properties)?(CfnApplicationReferenceDataSource_RecordColumnPropertyValidator(properties).assertSuccess(),{Mapping:cdk.stringToCloudFormation(properties.mapping),Name:cdk.stringToCloudFormation(properties.name),SqlType:cdk.stringToCloudFormation(properties.sqlType)}):properties}function CfnApplicationReferenceDataSourceRecordColumnPropertyFromCloudFormation(properties){if(cdk.isResolvableObject(properties))return new cfn_parse.FromCloudFormationResult(properties);if(properties=properties??{},typeof properties!="object")return new cfn_parse.FromCloudFormationResult(properties);const ret=new cfn_parse.FromCloudFormationPropertyObject;return ret.addPropertyResult("mapping","Mapping",properties.Mapping!=null?cfn_parse.FromCloudFormation.getString(properties.Mapping):void 0),ret.addPropertyResult("name","Name",cfn_parse.FromCloudFormation.getString(properties.Name)),ret.addPropertyResult("sqlType","SqlType",cfn_parse.FromCloudFormation.getString(properties.SqlType)),ret.addUnrecognizedPropertiesAsExtra(properties),ret}function CfnApplicationReferenceDataSource_RecordFormatPropertyValidator(properties){if(!cdk.canInspect(properties))return cdk.VALIDATION_SUCCESS;const errors=new cdk.ValidationResults;return typeof properties!="object"&&errors.collect(new cdk.ValidationResult("Expected an object, but received: "+JSON.stringify(properties))),errors.collect(cdk.propertyValidator("mappingParameters",CfnApplicationReferenceDataSource_MappingParametersPropertyValidator)(properties.mappingParameters)),errors.collect(cdk.propertyValidator("recordFormatType",cdk.requiredValidator)(properties.recordFormatType)),errors.collect(cdk.propertyValidator("recordFormatType",cdk.validateString)(properties.recordFormatType)),errors.wrap('supplied properties not correct for "RecordFormatProperty"')}function cfnApplicationReferenceDataSourceRecordFormatPropertyToCloudFormation(properties){return cdk.canInspect(properties)?(CfnApplicationReferenceDataSource_RecordFormatPropertyValidator(properties).assertSuccess(),{MappingParameters:cfnApplicationReferenceDataSourceMappingParametersPropertyToCloudFormation(properties.mappingParameters),RecordFormatType:cdk.stringToCloudFormation(properties.recordFormatType)}):properties}function CfnApplicationReferenceDataSourceRecordFormatPropertyFromCloudFormation(properties){if(cdk.isResolvableObject(properties))return new cfn_parse.FromCloudFormationResult(properties);if(properties=properties??{},typeof properties!="object")return new cfn_parse.FromCloudFormationResult(properties);const ret=new cfn_parse.FromCloudFormationPropertyObject;return ret.addPropertyResult("mappingParameters","MappingParameters",properties.MappingParameters!=null?CfnApplicationReferenceDataSourceMappingParametersPropertyFromCloudFormation(properties.MappingParameters):void 0),ret.addPropertyResult("recordFormatType","RecordFormatType",cfn_parse.FromCloudFormation.getString(properties.RecordFormatType)),ret.addUnrecognizedPropertiesAsExtra(properties),ret}function CfnApplicationReferenceDataSource_ReferenceDataSourcePropertyValidator(properties){if(!cdk.canInspect(properties))return cdk.VALIDATION_SUCCESS;const errors=new cdk.ValidationResults;return typeof properties!="object"&&errors.collect(new cdk.ValidationResult("Expected an object, but received: "+JSON.stringify(properties))),errors.collect(cdk.propertyValidator("referenceSchema",cdk.requiredValidator)(properties.referenceSchema)),errors.collect(cdk.propertyValidator("referenceSchema",CfnApplicationReferenceDataSource_ReferenceSchemaPropertyValidator)(properties.referenceSchema)),errors.collect(cdk.propertyValidator("s3ReferenceDataSource",CfnApplicationReferenceDataSource_S3ReferenceDataSourcePropertyValidator)(properties.s3ReferenceDataSource)),errors.collect(cdk.propertyValidator("tableName",cdk.validateString)(properties.tableName)),errors.wrap('supplied properties not correct for "ReferenceDataSourceProperty"')}function cfnApplicationReferenceDataSourceReferenceDataSourcePropertyToCloudFormation(properties){return cdk.canInspect(properties)?(CfnApplicationReferenceDataSource_ReferenceDataSourcePropertyValidator(properties).assertSuccess(),{ReferenceSchema:cfnApplicationReferenceDataSourceReferenceSchemaPropertyToCloudFormation(properties.referenceSchema),S3ReferenceDataSource:cfnApplicationReferenceDataSourceS3ReferenceDataSourcePropertyToCloudFormation(properties.s3ReferenceDataSource),TableName:cdk.stringToCloudFormation(properties.tableName)}):properties}function CfnApplicationReferenceDataSourceReferenceDataSourcePropertyFromCloudFormation(properties){if(cdk.isResolvableObject(properties))return new cfn_parse.FromCloudFormationResult(properties);if(properties=properties??{},typeof properties!="object")return new cfn_parse.FromCloudFormationResult(properties);const ret=new cfn_parse.FromCloudFormationPropertyObject;return ret.addPropertyResult("referenceSchema","ReferenceSchema",CfnApplicationReferenceDataSourceReferenceSchemaPropertyFromCloudFormation(properties.ReferenceSchema)),ret.addPropertyResult("s3ReferenceDataSource","S3ReferenceDataSource",properties.S3ReferenceDataSource!=null?CfnApplicationReferenceDataSourceS3ReferenceDataSourcePropertyFromCloudFormation(properties.S3ReferenceDataSource):void 0),ret.addPropertyResult("tableName","TableName",properties.TableName!=null?cfn_parse.FromCloudFormation.getString(properties.TableName):void 0),ret.addUnrecognizedPropertiesAsExtra(properties),ret}function CfnApplicationReferenceDataSource_ReferenceSchemaPropertyValidator(properties){if(!cdk.canInspect(properties))return cdk.VALIDATION_SUCCESS;const errors=new cdk.ValidationResults;return typeof properties!="object"&&errors.collect(new cdk.ValidationResult("Expected an object, but received: "+JSON.stringify(properties))),errors.collect(cdk.propertyValidator("recordColumns",cdk.requiredValidator)(properties.recordColumns)),errors.collect(cdk.propertyValidator("recordColumns",cdk.listValidator(CfnApplicationReferenceDataSource_RecordColumnPropertyValidator))(properties.recordColumns)),errors.collect(cdk.propertyValidator("recordEncoding",cdk.validateString)(properties.recordEncoding)),errors.collect(cdk.propertyValidator("recordFormat",cdk.requiredValidator)(properties.recordFormat)),errors.collect(cdk.propertyValidator("recordFormat",CfnApplicationReferenceDataSource_RecordFormatPropertyValidator)(properties.recordFormat)),errors.wrap('supplied properties not correct for "ReferenceSchemaProperty"')}function cfnApplicationReferenceDataSourceReferenceSchemaPropertyToCloudFormation(properties){return cdk.canInspect(properties)?(CfnApplicationReferenceDataSource_ReferenceSchemaPropertyValidator(properties).assertSuccess(),{RecordColumns:cdk.listMapper(cfnApplicationReferenceDataSourceRecordColumnPropertyToCloudFormation)(properties.recordColumns),RecordEncoding:cdk.stringToCloudFormation(properties.recordEncoding),RecordFormat:cfnApplicationReferenceDataSourceRecordFormatPropertyToCloudFormation(properties.recordFormat)}):properties}function CfnApplicationReferenceDataSourceReferenceSchemaPropertyFromCloudFormation(properties){if(cdk.isResolvableObject(properties))return new cfn_parse.FromCloudFormationResult(properties);if(properties=properties??{},typeof properties!="object")return new cfn_parse.FromCloudFormationResult(properties);const ret=new cfn_parse.FromCloudFormationPropertyObject;return ret.addPropertyResult("recordColumns","RecordColumns",cfn_parse.FromCloudFormation.getArray(CfnApplicationReferenceDataSourceRecordColumnPropertyFromCloudFormation)(properties.RecordColumns)),ret.addPropertyResult("recordEncoding","RecordEncoding",properties.RecordEncoding!=null?cfn_parse.FromCloudFormation.getString(properties.RecordEncoding):void 0),ret.addPropertyResult("recordFormat","RecordFormat",CfnApplicationReferenceDataSourceRecordFormatPropertyFromCloudFormation(properties.RecordFormat)),ret.addUnrecognizedPropertiesAsExtra(properties),ret}function CfnApplicationReferenceDataSource_S3ReferenceDataSourcePropertyValidator(properties){if(!cdk.canInspect(properties))return cdk.VALIDATION_SUCCESS;const errors=new cdk.ValidationResults;return typeof properties!="object"&&errors.collect(new cdk.ValidationResult("Expected an object, but received: "+JSON.stringify(properties))),errors.collect(cdk.propertyValidator("bucketArn",cdk.requiredValidator)(properties.bucketArn)),errors.collect(cdk.propertyValidator("bucketArn",cdk.validateString)(properties.bucketArn)),errors.collect(cdk.propertyValidator("fileKey",cdk.requiredValidator)(properties.fileKey)),errors.collect(cdk.propertyValidator("fileKey",cdk.validateString)(properties.fileKey)),errors.wrap('supplied properties not correct for "S3ReferenceDataSourceProperty"')}function cfnApplicationReferenceDataSourceS3ReferenceDataSourcePropertyToCloudFormation(properties){return cdk.canInspect(properties)?(CfnApplicationReferenceDataSource_S3ReferenceDataSourcePropertyValidator(properties).assertSuccess(),{BucketARN:cdk.stringToCloudFormation(properties.bucketArn),FileKey:cdk.stringToCloudFormation(properties.fileKey)}):properties}function CfnApplicationReferenceDataSourceS3ReferenceDataSourcePropertyFromCloudFormation(properties){if(cdk.isResolvableObject(properties))return new cfn_parse.FromCloudFormationResult(properties);if(properties=properties??{},typeof properties!="object")return new cfn_parse.FromCloudFormationResult(properties);const ret=new cfn_parse.FromCloudFormationPropertyObject;return ret.addPropertyResult("bucketArn","BucketARN",cfn_parse.FromCloudFormation.getString(properties.BucketARN)),ret.addPropertyResult("fileKey","FileKey",cfn_parse.FromCloudFormation.getString(properties.FileKey)),ret.addUnrecognizedPropertiesAsExtra(properties),ret}
