"use strict";var _a;Object.defineProperty(exports,"__esModule",{value:!0}),exports.Key=exports.KeyUsage=exports.KeySpec=void 0;const jsiiDeprecationWarnings=require("../../.warnings.jsii.js"),JSII_RTTI_SYMBOL_1=Symbol.for("jsii.rtti"),alias_1=require("./alias"),kms_generated_1=require("./kms.generated"),perms=require("./private/perms"),iam=require("../../aws-iam"),cxschema=require("../../cloud-assembly-schema"),core_1=require("../../core"),cxapi=require("../../cx-api");class KeyBase extends core_1.Resource{constructor(scope,id,props={}){super(scope,id,props),this.aliases=[],this.node.addValidation({validate:()=>this.policy?.validateForResourcePolicy()??[]})}addAlias(aliasName){const aliasId=this.aliases.length>0?`Alias${aliasName}`:"Alias",alias=new alias_1.Alias(this,aliasId,{aliasName,targetKey:this});return this.aliases.push(alias),alias}addToResourcePolicy(statement,allowNoOp=!0){const stack=core_1.Stack.of(this);if(!this.policy){if(allowNoOp)return{statementAdded:!1};throw new Error(`Unable to add statement to IAM resource policy for KMS key: ${JSON.stringify(stack.resolve(this.keyArn))}`)}return this.policy.addStatements(statement),{statementAdded:!0,policyDependable:this.policy}}grant(grantee,...actions){const granteeStackDependsOnKeyStack=this.granteeStackDependsOnKeyStack(grantee),principal=granteeStackDependsOnKeyStack?new iam.AccountPrincipal(granteeStackDependsOnKeyStack):grantee.grantPrincipal,crossAccountAccess=this.isGranteeFromAnotherAccount(grantee),crossRegionAccess=this.isGranteeFromAnotherRegion(grantee),crossEnvironment=crossAccountAccess||crossRegionAccess,grantOptions={grantee,actions,resource:this,resourceArns:[this.keyArn],resourceSelfArns:crossEnvironment?void 0:["*"]};return this.trustAccountIdentities&&!crossEnvironment?iam.Grant.addToPrincipalOrResource(grantOptions):iam.Grant.addToPrincipalAndResource({...grantOptions,resourceArns:crossEnvironment?["*"]:[this.keyArn],resourcePolicyPrincipal:principal})}grantDecrypt(grantee){return this.grant(grantee,...perms.DECRYPT_ACTIONS)}grantEncrypt(grantee){return this.grant(grantee,...perms.ENCRYPT_ACTIONS)}grantEncryptDecrypt(grantee){return this.grant(grantee,...perms.DECRYPT_ACTIONS,...perms.ENCRYPT_ACTIONS)}grantGenerateMac(grantee){return this.grant(grantee,...perms.GENERATE_HMAC_ACTIONS)}grantVerifyMac(grantee){return this.grant(grantee,...perms.VERIFY_HMAC_ACTIONS)}granteeStackDependsOnKeyStack(grantee){const grantPrincipal=grantee.grantPrincipal;if(!iam.principalIsOwnedResource(grantPrincipal))return;const keyStack=core_1.Stack.of(this),granteeStack=core_1.Stack.of(grantPrincipal);if(keyStack!==granteeStack)return granteeStack.dependencies.includes(keyStack)?granteeStack.account:void 0}isGranteeFromAnotherRegion(grantee){if(!iam.principalIsOwnedResource(grantee.grantPrincipal))return!1;const bucketStack=core_1.Stack.of(this),identityStack=core_1.Stack.of(grantee.grantPrincipal);return bucketStack.region!==identityStack.region}isGranteeFromAnotherAccount(grantee){if(!iam.principalIsOwnedResource(grantee.grantPrincipal))return!1;const bucketStack=core_1.Stack.of(this),identityStack=core_1.Stack.of(grantee.grantPrincipal);return bucketStack.account!==identityStack.account}}var KeySpec;(function(KeySpec2){KeySpec2.SYMMETRIC_DEFAULT="SYMMETRIC_DEFAULT",KeySpec2.RSA_2048="RSA_2048",KeySpec2.RSA_3072="RSA_3072",KeySpec2.RSA_4096="RSA_4096",KeySpec2.ECC_NIST_P256="ECC_NIST_P256",KeySpec2.ECC_NIST_P384="ECC_NIST_P384",KeySpec2.ECC_NIST_P521="ECC_NIST_P521",KeySpec2.ECC_SECG_P256K1="ECC_SECG_P256K1",KeySpec2.HMAC_224="HMAC_224",KeySpec2.HMAC_256="HMAC_256",KeySpec2.HMAC_384="HMAC_384",KeySpec2.HMAC_512="HMAC_512",KeySpec2.SM2="SM2"})(KeySpec=exports.KeySpec||(exports.KeySpec={}));var KeyUsage;(function(KeyUsage2){KeyUsage2.ENCRYPT_DECRYPT="ENCRYPT_DECRYPT",KeyUsage2.SIGN_VERIFY="SIGN_VERIFY",KeyUsage2.GENERATE_VERIFY_MAC="GENERATE_VERIFY_MAC"})(KeyUsage=exports.KeyUsage||(exports.KeyUsage={}));class Key extends KeyBase{static fromKeyArn(scope,id,keyArn){class Import extends KeyBase{constructor(keyId,props={}){super(scope,id,props),this.keyArn=keyArn,this.policy=void 0,this.trustAccountIdentities=!0,this.keyId=keyId}}const keyResourceName=core_1.Stack.of(scope).splitArn(keyArn,core_1.ArnFormat.SLASH_RESOURCE_NAME).resourceName;if(!keyResourceName)throw new Error(`KMS key ARN must be in the format 'arn:<partition>:kms:<region>:<account>:key/<keyId>', got: '${keyArn}'`);return new Import(keyResourceName,{environmentFromArn:keyArn})}static fromCfnKey(cfnKey){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_kms_CfnKey(cfnKey)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.fromCfnKey),error}const id="@FromCfnKey",existing=cfnKey.node.tryFindChild(id);if(existing)return existing;let keyPolicy;try{keyPolicy=iam.PolicyDocument.fromJson(cfnKey.keyPolicy)}catch{throw new Error("Could not parse the PolicyDocument of the passed AWS::KMS::Key resource because it contains CloudFormation functions. This makes it impossible to create a mutable IKey from that Policy. You have to use fromKeyArn instead, passing it the ARN attribute property of the low-level CfnKey")}return cfnKey.keyPolicy=core_1.Lazy.any({produce:()=>keyPolicy.toJSON()}),new class extends KeyBase{constructor(){super(...arguments),this.keyArn=cfnKey.attrArn,this.keyId=cfnKey.ref,this.policy=keyPolicy,this.trustAccountIdentities=!1}}(cfnKey,id)}static fromLookup(scope,id,options){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_kms_KeyLookupOptions(options)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.fromLookup),error}class Import extends KeyBase{constructor(keyId,keyArn){super(scope,id),this.policy=void 0,this.trustAccountIdentities=!0,this.keyId=keyId,this.keyArn=keyArn}}if(core_1.Token.isUnresolved(options.aliasName))throw new Error("All arguments to Key.fromLookup() must be concrete (no Tokens)");const attributes=core_1.ContextProvider.getValue(scope,{provider:cxschema.ContextProvider.KEY_PROVIDER,props:{aliasName:options.aliasName},dummyValue:{keyId:"1234abcd-12ab-34cd-56ef-1234567890ab"}}).value;return new Import(attributes.keyId,core_1.Arn.format({resource:"key",service:"kms",resourceName:attributes.keyId},core_1.Stack.of(scope)))}constructor(scope,id,props={}){super(scope,id);try{jsiiDeprecationWarnings.aws_cdk_lib_aws_kms_KeyProps(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,Key),error}const denyLists={[KeyUsage.ENCRYPT_DECRYPT]:[KeySpec.ECC_NIST_P256,KeySpec.ECC_NIST_P384,KeySpec.ECC_NIST_P521,KeySpec.ECC_SECG_P256K1,KeySpec.HMAC_224,KeySpec.HMAC_256,KeySpec.HMAC_384,KeySpec.HMAC_512],[KeyUsage.SIGN_VERIFY]:[KeySpec.SYMMETRIC_DEFAULT,KeySpec.HMAC_224,KeySpec.HMAC_256,KeySpec.HMAC_384,KeySpec.HMAC_512],[KeyUsage.GENERATE_VERIFY_MAC]:[KeySpec.RSA_2048,KeySpec.RSA_3072,KeySpec.RSA_4096,KeySpec.ECC_NIST_P256,KeySpec.ECC_NIST_P384,KeySpec.ECC_NIST_P521,KeySpec.ECC_SECG_P256K1,KeySpec.SYMMETRIC_DEFAULT,KeySpec.SM2]},keySpec=props.keySpec??KeySpec.SYMMETRIC_DEFAULT,keyUsage=props.keyUsage??KeyUsage.ENCRYPT_DECRYPT;if(denyLists[keyUsage].includes(keySpec))throw new Error(`key spec '${keySpec}' is not valid with usage '${keyUsage}'`);if(keySpec.startsWith("HMAC")&&props.enableKeyRotation)throw new Error("key rotation cannot be enabled on HMAC keys");if(keySpec!==KeySpec.SYMMETRIC_DEFAULT&&props.enableKeyRotation)throw new Error("key rotation cannot be enabled on asymmetric keys");const defaultKeyPoliciesFeatureEnabled=core_1.FeatureFlags.of(this).isEnabled(cxapi.KMS_DEFAULT_KEY_POLICIES);if(this.policy=props.policy??new iam.PolicyDocument,defaultKeyPoliciesFeatureEnabled){if(props.trustAccountIdentities===!1)throw new Error("`trustAccountIdentities` cannot be false if the @aws-cdk/aws-kms:defaultKeyPolicies feature flag is set");this.trustAccountIdentities=!0,props.policy||this.addDefaultAdminPolicy()}else this.trustAccountIdentities=props.trustAccountIdentities??!1,this.trustAccountIdentities?this.addDefaultAdminPolicy():this.addLegacyAdminPolicy();let pendingWindowInDays;if(props.pendingWindow&&(pendingWindowInDays=props.pendingWindow.toDays(),pendingWindowInDays<7||pendingWindowInDays>30))throw new Error(`'pendingWindow' value must between 7 and 30 days. Received: ${pendingWindowInDays}`);const resource=new kms_generated_1.CfnKey(this,"Resource",{description:props.description,enableKeyRotation:props.enableKeyRotation,enabled:props.enabled,keySpec:props.keySpec,keyUsage:props.keyUsage,keyPolicy:this.policy,pendingWindowInDays});this.keyArn=resource.attrArn,this.keyId=resource.ref,resource.applyRemovalPolicy(props.removalPolicy),(props.admins??[]).forEach(p=>this.grantAdmin(p)),props.alias!==void 0&&this.addAlias(props.alias)}grantAdmin(grantee){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_iam_IGrantable(grantee)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.grantAdmin),error}return this.grant(grantee,...perms.ADMIN_ACTIONS)}addDefaultAdminPolicy(){this.addToResourcePolicy(new iam.PolicyStatement({resources:["*"],actions:["kms:*"],principals:[new iam.AccountRootPrincipal]}))}addLegacyAdminPolicy(){const actions=["kms:Create*","kms:Describe*","kms:Enable*","kms:List*","kms:Put*","kms:Update*","kms:Revoke*","kms:Disable*","kms:Get*","kms:Delete*","kms:ScheduleKeyDeletion","kms:CancelKeyDeletion","kms:GenerateDataKey","kms:TagResource","kms:UntagResource"];this.addToResourcePolicy(new iam.PolicyStatement({resources:["*"],actions,principals:[new iam.AccountRootPrincipal]}))}}_a=JSII_RTTI_SYMBOL_1,Key[_a]={fqn:"aws-cdk-lib.aws_kms.Key",version:"2.87.0"},exports.Key=Key;
