"use strict";var _a,_b;Object.defineProperty(exports,"__esModule",{value:!0}),exports.SelfManagedKafkaEventSource=exports.ManagedKafkaEventSource=exports.AuthenticationMethod=void 0;const jsiiDeprecationWarnings=require("../../.warnings.jsii.js"),JSII_RTTI_SYMBOL_1=Symbol.for("jsii.rtti"),constructs_1=require("constructs"),stream_1=require("./stream"),iam=require("../../aws-iam"),lambda=require("../../aws-lambda"),core_1=require("../../core"),helpers_internal_1=require("../../core/lib/helpers-internal");var AuthenticationMethod;(function(AuthenticationMethod2){AuthenticationMethod2.SASL_SCRAM_512_AUTH="SASL_SCRAM_512_AUTH",AuthenticationMethod2.SASL_SCRAM_256_AUTH="SASL_SCRAM_256_AUTH",AuthenticationMethod2.BASIC_AUTH="BASIC_AUTH",AuthenticationMethod2.CLIENT_CERTIFICATE_TLS_AUTH="CLIENT_CERTIFICATE_TLS_AUTH"})(AuthenticationMethod=exports.AuthenticationMethod||(exports.AuthenticationMethod={}));class ManagedKafkaEventSource extends stream_1.StreamEventSource{constructor(props){super(props),this._eventSourceMappingId=void 0,this._eventSourceMappingArn=void 0;try{jsiiDeprecationWarnings.aws_cdk_lib_aws_lambda_event_sources_ManagedKafkaEventSourceProps(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,ManagedKafkaEventSource),error}this.innerProps=props}bind(target){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_lambda_IFunction(target)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.bind),error}const eventSourceMapping=target.addEventSourceMapping(`KafkaEventSource:${core_1.Names.nodeUniqueId(target.node)}${this.innerProps.topic}`,this.enrichMappingOptions({eventSourceArn:this.innerProps.clusterArn,startingPosition:this.innerProps.startingPosition,sourceAccessConfigurations:this.sourceAccessConfigurations(),kafkaTopic:this.innerProps.topic,kafkaConsumerGroupId:this.innerProps.consumerGroupId}));this._eventSourceMappingId=eventSourceMapping.eventSourceMappingId,this._eventSourceMappingArn=eventSourceMapping.eventSourceMappingArn,this.innerProps.secret!==void 0&&this.innerProps.secret.grantRead(target),target.addToRolePolicy(new iam.PolicyStatement({actions:["kafka:DescribeCluster","kafka:GetBootstrapBrokers","kafka:ListScramSecrets"],resources:[this.innerProps.clusterArn]})),target.role?.addManagedPolicy(iam.ManagedPolicy.fromAwsManagedPolicyName("service-role/AWSLambdaMSKExecutionRole"))}sourceAccessConfigurations(){const sourceAccessConfigurations=[];return this.innerProps.secret!==void 0&&sourceAccessConfigurations.push({type:lambda.SourceAccessConfigurationType.SASL_SCRAM_512_AUTH,uri:this.innerProps.secret.secretArn}),sourceAccessConfigurations.length===0?void 0:sourceAccessConfigurations}get eventSourceMappingId(){if(!this._eventSourceMappingId)throw new Error("KafkaEventSource is not yet bound to an event source mapping");return this._eventSourceMappingId}get eventSourceMappingArn(){if(!this._eventSourceMappingArn)throw new Error("KafkaEventSource is not yet bound to an event source mapping");return this._eventSourceMappingArn}}_a=JSII_RTTI_SYMBOL_1,ManagedKafkaEventSource[_a]={fqn:"aws-cdk-lib.aws_lambda_event_sources.ManagedKafkaEventSource",version:"2.87.0"},exports.ManagedKafkaEventSource=ManagedKafkaEventSource;class SelfManagedKafkaEventSource extends stream_1.StreamEventSource{constructor(props){super(props);try{jsiiDeprecationWarnings.aws_cdk_lib_aws_lambda_event_sources_SelfManagedKafkaEventSourceProps(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,SelfManagedKafkaEventSource),error}if(props.vpc){if(!props.securityGroup)throw new Error("securityGroup must be set when providing vpc");if(!props.vpcSubnets)throw new Error("vpcSubnets must be set when providing vpc")}else if(!props.secret)throw new Error("secret must be set if Kafka brokers accessed over Internet");this.innerProps=props}bind(target){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_lambda_IFunction(target)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.bind),error}if(!(target instanceof constructs_1.Construct))throw new Error("Function is not a construct. Unexpected error.");target.addEventSourceMapping(this.mappingId(target),this.enrichMappingOptions({kafkaBootstrapServers:this.innerProps.bootstrapServers,kafkaTopic:this.innerProps.topic,kafkaConsumerGroupId:this.innerProps.consumerGroupId,startingPosition:this.innerProps.startingPosition,sourceAccessConfigurations:this.sourceAccessConfigurations()})),this.innerProps.secret!==void 0&&this.innerProps.secret.grantRead(target)}mappingId(target){return`KafkaEventSource:${(0,helpers_internal_1.md5hash)(JSON.stringify(core_1.Stack.of(target).resolve(this.innerProps.bootstrapServers)))}:${this.innerProps.topic}`}sourceAccessConfigurations(){let authType;switch(this.innerProps.authenticationMethod){case AuthenticationMethod.BASIC_AUTH:authType=lambda.SourceAccessConfigurationType.BASIC_AUTH;break;case AuthenticationMethod.CLIENT_CERTIFICATE_TLS_AUTH:authType=lambda.SourceAccessConfigurationType.CLIENT_CERTIFICATE_TLS_AUTH;break;case AuthenticationMethod.SASL_SCRAM_256_AUTH:authType=lambda.SourceAccessConfigurationType.SASL_SCRAM_256_AUTH;break;case AuthenticationMethod.SASL_SCRAM_512_AUTH:default:authType=lambda.SourceAccessConfigurationType.SASL_SCRAM_512_AUTH;break}const sourceAccessConfigurations=[];return this.innerProps.secret!==void 0&&sourceAccessConfigurations.push({type:authType,uri:this.innerProps.secret.secretArn}),this.innerProps.rootCACertificate!==void 0&&sourceAccessConfigurations.push({type:lambda.SourceAccessConfigurationType.SERVER_ROOT_CA_CERTIFICATE,uri:this.innerProps.rootCACertificate.secretArn}),this.innerProps.vpcSubnets!==void 0&&this.innerProps.securityGroup!==void 0&&(sourceAccessConfigurations.push({type:lambda.SourceAccessConfigurationType.VPC_SECURITY_GROUP,uri:this.innerProps.securityGroup.securityGroupId}),this.innerProps.vpc?.selectSubnets(this.innerProps.vpcSubnets).subnetIds.forEach(id=>{sourceAccessConfigurations.push({type:lambda.SourceAccessConfigurationType.VPC_SUBNET,uri:id})})),sourceAccessConfigurations.length===0?void 0:sourceAccessConfigurations}}_b=JSII_RTTI_SYMBOL_1,SelfManagedKafkaEventSource[_b]={fqn:"aws-cdk-lib.aws_lambda_event_sources.SelfManagedKafkaEventSource",version:"2.87.0"},exports.SelfManagedKafkaEventSource=SelfManagedKafkaEventSource;
