"use strict";Object.defineProperty(exports,"__esModule",{value:!0}),exports.getTsconfigCompilerOptions=exports.extractDependencies=exports.tryGetModuleVersionFromPkg=exports.tryGetModuleVersionFromRequire=exports.exec=exports.findUpMultiple=exports.findUp=exports.callsites=void 0;const child_process_1=require("child_process"),fs=require("fs"),path=require("path");function callsites(){const _prepareStackTrace=Error.prepareStackTrace;Error.prepareStackTrace=(_,stack2)=>stack2;const stack=new Error().stack?.slice(1);return Error.prepareStackTrace=_prepareStackTrace,stack}exports.callsites=callsites;function findUp(name,directory=process.cwd()){return findUpMultiple([name],directory)[0]}exports.findUp=findUp;function findUpMultiple(names,directory=process.cwd()){const absoluteDirectory=path.resolve(directory),files=[];for(const name of names){const file=path.join(directory,name);fs.existsSync(file)&&files.push(file)}if(files.length>0)return files;const{root}=path.parse(absoluteDirectory);return absoluteDirectory===root?[]:findUpMultiple(names,path.dirname(absoluteDirectory))}exports.findUpMultiple=findUpMultiple;function exec(cmd,args,options){const proc=(0,child_process_1.spawnSync)(cmd,args,options);if(proc.error)throw proc.error;if(proc.status!==0)throw proc.stdout||proc.stderr?new Error(`[Status ${proc.status}] stdout: ${proc.stdout?.toString().trim()}


stderr: ${proc.stderr?.toString().trim()}`):new Error(`${cmd} ${args.join(" ")} ${options?.cwd?`run in directory ${options.cwd}`:""} exited with status ${proc.status}`);return proc}exports.exec=exec;function tryGetModuleVersionFromRequire(mod){try{return require(`${mod}/package.json`).version}catch{return}}exports.tryGetModuleVersionFromRequire=tryGetModuleVersionFromRequire;function tryGetModuleVersionFromPkg(mod,pkgJson,pkgPath){const dependencies={...pkgJson.dependencies??{},...pkgJson.devDependencies??{},...pkgJson.peerDependencies??{}};if(!dependencies[mod])return;const fileMatch=dependencies[mod].match(/file:(.+)/);return fileMatch&&!path.isAbsolute(fileMatch[1])?`file:${path.join(path.dirname(pkgPath),fileMatch[1])}`:dependencies[mod]}exports.tryGetModuleVersionFromPkg=tryGetModuleVersionFromPkg;function extractDependencies(pkgPath,modules){const dependencies={},pkgJson=require(pkgPath);for(const mod of modules){const version=tryGetModuleVersionFromPkg(mod,pkgJson,pkgPath)??tryGetModuleVersionFromRequire(mod);if(!version)throw new Error(`Cannot extract version for module '${mod}'. Check that it's referenced in your package.json or installed.`);dependencies[mod]=version}return dependencies}exports.extractDependencies=extractDependencies;function getTsconfigCompilerOptions(tsconfigPath){const compilerOptions=extractTsConfig(tsconfigPath),excludedCompilerOptions=["composite","charset","noEmit","tsBuildInfoFile"],options={...compilerOptions,incremental:!1,rootDir:"./",outDir:"./"};let compilerOptionsString="";return Object.keys(options).sort().forEach(key=>{if(excludedCompilerOptions.includes(key))return;const value=options[key],option="--"+key,type=typeof value;if(type==="boolean")value?compilerOptionsString+=option+" ":compilerOptionsString+=option+" false ";else if(type==="string")compilerOptionsString+=option+" "+value+" ";else if(type==="object")Array.isArray(value)&&(compilerOptionsString+=option+" "+value.join(",")+" ");else throw new Error(`Missing support for compilerOption: [${key}]: { ${type}, ${value}} 
`)}),compilerOptionsString.trim()}exports.getTsconfigCompilerOptions=getTsconfigCompilerOptions;function extractTsConfig(tsconfigPath,previousCompilerOptions){const{extends:extendedConfig,compilerOptions}=require(tsconfigPath),updatedCompilerOptions={...compilerOptions,...previousCompilerOptions??{}};return extendedConfig?extractTsConfig(path.resolve(tsconfigPath.replace(/[^\/]+$/,""),extendedConfig),updatedCompilerOptions):updatedCompilerOptions}
