"use strict";var _a;Object.defineProperty(exports,"__esModule",{value:!0}),exports.LogRetention=void 0;const jsiiDeprecationWarnings=require("../../.warnings.jsii.js"),JSII_RTTI_SYMBOL_1=Symbol.for("jsii.rtti"),path=require("path"),constructs_1=require("constructs"),log_group_1=require("./log-group"),iam=require("../../aws-iam"),s3_assets=require("../../aws-s3-assets"),cdk=require("../../core"),core_1=require("../../core"),region_info_1=require("../../region-info");class LogRetention extends constructs_1.Construct{constructor(scope,id,props){super(scope,id);try{jsiiDeprecationWarnings.aws_cdk_lib_aws_logs_LogRetentionProps(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,LogRetention),error}const provider=this.ensureSingletonLogRetentionFunction(props);props.removalPolicy===cdk.RemovalPolicy.DESTROY&&provider.grantDeleteLogGroup(props.logGroupName);const retryOptions=props.logRetentionRetryOptions,logGroupName=new cdk.CfnResource(this,"Resource",{type:"Custom::LogRetention",properties:{ServiceToken:provider.functionArn,LogGroupName:props.logGroupName,LogGroupRegion:props.logGroupRegion,SdkRetry:retryOptions?{maxRetries:retryOptions.maxRetries,base:retryOptions.base?.toMilliseconds()}:void 0,RetentionInDays:props.retention===log_group_1.RetentionDays.INFINITE?void 0:props.retention,RemovalPolicy:props.removalPolicy}}).getAtt("LogGroupName").toString();this.logGroupArn=cdk.Stack.of(this).formatArn({region:props.logGroupRegion,service:"logs",resource:"log-group",resourceName:`${logGroupName}:*`,arnFormat:core_1.ArnFormat.COLON_RESOURCE_NAME})}ensureSingletonLogRetentionFunction(props){const functionLogicalId="LogRetentionaae0aa3c5b4d4f87b02d85b201efdd8a",existing=cdk.Stack.of(this).node.tryFindChild(functionLogicalId);return existing||new LogRetentionFunction(cdk.Stack.of(this),functionLogicalId,props)}}_a=JSII_RTTI_SYMBOL_1,LogRetention[_a]={fqn:"aws-cdk-lib.aws_logs.LogRetention",version:"2.87.0"},exports.LogRetention=LogRetention;class LogRetentionFunction extends constructs_1.Construct{constructor(scope,id,props){super(scope,id),this.tags=new cdk.TagManager(cdk.TagType.KEY_VALUE,"AWS::Lambda::Function");const asset=new s3_assets.Asset(this,"Code",{path:path.join(__dirname,"log-retention-provider")}),role=props.role||new iam.Role(this,"ServiceRole",{assumedBy:new iam.ServicePrincipal("lambda.amazonaws.com"),managedPolicies:[iam.ManagedPolicy.fromAwsManagedPolicyName("service-role/AWSLambdaBasicExecutionRole")]});role.addToPrincipalPolicy(new iam.PolicyStatement({actions:["logs:PutRetentionPolicy","logs:DeleteRetentionPolicy"],resources:["*"]})),this.role=role;const resource=new cdk.CfnResource(this,"Resource",{type:"AWS::Lambda::Function",properties:{Handler:"index.handler",Runtime:cdk.Stack.of(scope).regionalFact(region_info_1.FactName.DEFAULT_CR_NODE_VERSION,"nodejs16.x"),Code:{S3Bucket:asset.s3BucketName,S3Key:asset.s3ObjectKey},Role:role.roleArn,Tags:this.tags.renderedTags}});this.functionArn=resource.getAtt("Arn"),asset.addResourceMetadata(resource,"Code"),role.node.children.forEach(child=>{cdk.CfnResource.isCfnResource(child)&&resource.addDependency(child),constructs_1.Construct.isConstruct(child)&&child.node.defaultChild&&cdk.CfnResource.isCfnResource(child.node.defaultChild)&&resource.addDependency(child.node.defaultChild)})}grantDeleteLogGroup(logGroupName){this.role.addToPrincipalPolicy(new iam.PolicyStatement({actions:["logs:DeleteLogGroup"],resources:[cdk.Stack.of(this).formatArn({service:"logs",resource:"log-group",resourceName:`${logGroupName}:*`,arnFormat:core_1.ArnFormat.COLON_RESOURCE_NAME})]}))}}
