"use strict";var _a;Object.defineProperty(exports,"__esModule",{value:!0}),exports.CfnDomain=void 0;const jsiiDeprecationWarnings=require("../../.warnings.jsii.js"),JSII_RTTI_SYMBOL_1=Symbol.for("jsii.rtti"),cdk=require("../../core"),cfn_parse=require("../../core/lib/helpers-internal");function CfnDomainPropsValidator(properties){if(!cdk.canInspect(properties))return cdk.VALIDATION_SUCCESS;const errors=new cdk.ValidationResults;return typeof properties!="object"&&errors.collect(new cdk.ValidationResult("Expected an object, but received: "+JSON.stringify(properties))),errors.collect(cdk.propertyValidator("accessPolicies",cdk.validateObject)(properties.accessPolicies)),errors.collect(cdk.propertyValidator("advancedOptions",cdk.hashValidator(cdk.validateString))(properties.advancedOptions)),errors.collect(cdk.propertyValidator("advancedSecurityOptions",CfnDomain_AdvancedSecurityOptionsInputPropertyValidator)(properties.advancedSecurityOptions)),errors.collect(cdk.propertyValidator("clusterConfig",CfnDomain_ClusterConfigPropertyValidator)(properties.clusterConfig)),errors.collect(cdk.propertyValidator("cognitoOptions",CfnDomain_CognitoOptionsPropertyValidator)(properties.cognitoOptions)),errors.collect(cdk.propertyValidator("domainEndpointOptions",CfnDomain_DomainEndpointOptionsPropertyValidator)(properties.domainEndpointOptions)),errors.collect(cdk.propertyValidator("domainName",cdk.validateString)(properties.domainName)),errors.collect(cdk.propertyValidator("ebsOptions",CfnDomain_EBSOptionsPropertyValidator)(properties.ebsOptions)),errors.collect(cdk.propertyValidator("encryptionAtRestOptions",CfnDomain_EncryptionAtRestOptionsPropertyValidator)(properties.encryptionAtRestOptions)),errors.collect(cdk.propertyValidator("engineVersion",cdk.validateString)(properties.engineVersion)),errors.collect(cdk.propertyValidator("logPublishingOptions",cdk.hashValidator(CfnDomain_LogPublishingOptionPropertyValidator))(properties.logPublishingOptions)),errors.collect(cdk.propertyValidator("nodeToNodeEncryptionOptions",CfnDomain_NodeToNodeEncryptionOptionsPropertyValidator)(properties.nodeToNodeEncryptionOptions)),errors.collect(cdk.propertyValidator("offPeakWindowOptions",CfnDomain_OffPeakWindowOptionsPropertyValidator)(properties.offPeakWindowOptions)),errors.collect(cdk.propertyValidator("snapshotOptions",CfnDomain_SnapshotOptionsPropertyValidator)(properties.snapshotOptions)),errors.collect(cdk.propertyValidator("softwareUpdateOptions",CfnDomain_SoftwareUpdateOptionsPropertyValidator)(properties.softwareUpdateOptions)),errors.collect(cdk.propertyValidator("tags",cdk.listValidator(cdk.validateCfnTag))(properties.tags)),errors.collect(cdk.propertyValidator("vpcOptions",CfnDomain_VPCOptionsPropertyValidator)(properties.vpcOptions)),errors.wrap('supplied properties not correct for "CfnDomainProps"')}function cfnDomainPropsToCloudFormation(properties){return cdk.canInspect(properties)?(CfnDomainPropsValidator(properties).assertSuccess(),{AccessPolicies:cdk.objectToCloudFormation(properties.accessPolicies),AdvancedOptions:cdk.hashMapper(cdk.stringToCloudFormation)(properties.advancedOptions),AdvancedSecurityOptions:cfnDomainAdvancedSecurityOptionsInputPropertyToCloudFormation(properties.advancedSecurityOptions),ClusterConfig:cfnDomainClusterConfigPropertyToCloudFormation(properties.clusterConfig),CognitoOptions:cfnDomainCognitoOptionsPropertyToCloudFormation(properties.cognitoOptions),DomainEndpointOptions:cfnDomainDomainEndpointOptionsPropertyToCloudFormation(properties.domainEndpointOptions),DomainName:cdk.stringToCloudFormation(properties.domainName),EBSOptions:cfnDomainEBSOptionsPropertyToCloudFormation(properties.ebsOptions),EncryptionAtRestOptions:cfnDomainEncryptionAtRestOptionsPropertyToCloudFormation(properties.encryptionAtRestOptions),EngineVersion:cdk.stringToCloudFormation(properties.engineVersion),LogPublishingOptions:cdk.hashMapper(cfnDomainLogPublishingOptionPropertyToCloudFormation)(properties.logPublishingOptions),NodeToNodeEncryptionOptions:cfnDomainNodeToNodeEncryptionOptionsPropertyToCloudFormation(properties.nodeToNodeEncryptionOptions),OffPeakWindowOptions:cfnDomainOffPeakWindowOptionsPropertyToCloudFormation(properties.offPeakWindowOptions),SnapshotOptions:cfnDomainSnapshotOptionsPropertyToCloudFormation(properties.snapshotOptions),SoftwareUpdateOptions:cfnDomainSoftwareUpdateOptionsPropertyToCloudFormation(properties.softwareUpdateOptions),Tags:cdk.listMapper(cdk.cfnTagToCloudFormation)(properties.tags),VPCOptions:cfnDomainVPCOptionsPropertyToCloudFormation(properties.vpcOptions)}):properties}function CfnDomainPropsFromCloudFormation(properties){if(properties=properties??{},typeof properties!="object")return new cfn_parse.FromCloudFormationResult(properties);const ret=new cfn_parse.FromCloudFormationPropertyObject;return ret.addPropertyResult("accessPolicies","AccessPolicies",properties.AccessPolicies!=null?cfn_parse.FromCloudFormation.getAny(properties.AccessPolicies):void 0),ret.addPropertyResult("advancedOptions","AdvancedOptions",properties.AdvancedOptions!=null?cfn_parse.FromCloudFormation.getMap(cfn_parse.FromCloudFormation.getString)(properties.AdvancedOptions):void 0),ret.addPropertyResult("advancedSecurityOptions","AdvancedSecurityOptions",properties.AdvancedSecurityOptions!=null?CfnDomainAdvancedSecurityOptionsInputPropertyFromCloudFormation(properties.AdvancedSecurityOptions):void 0),ret.addPropertyResult("clusterConfig","ClusterConfig",properties.ClusterConfig!=null?CfnDomainClusterConfigPropertyFromCloudFormation(properties.ClusterConfig):void 0),ret.addPropertyResult("cognitoOptions","CognitoOptions",properties.CognitoOptions!=null?CfnDomainCognitoOptionsPropertyFromCloudFormation(properties.CognitoOptions):void 0),ret.addPropertyResult("domainEndpointOptions","DomainEndpointOptions",properties.DomainEndpointOptions!=null?CfnDomainDomainEndpointOptionsPropertyFromCloudFormation(properties.DomainEndpointOptions):void 0),ret.addPropertyResult("domainName","DomainName",properties.DomainName!=null?cfn_parse.FromCloudFormation.getString(properties.DomainName):void 0),ret.addPropertyResult("ebsOptions","EBSOptions",properties.EBSOptions!=null?CfnDomainEBSOptionsPropertyFromCloudFormation(properties.EBSOptions):void 0),ret.addPropertyResult("encryptionAtRestOptions","EncryptionAtRestOptions",properties.EncryptionAtRestOptions!=null?CfnDomainEncryptionAtRestOptionsPropertyFromCloudFormation(properties.EncryptionAtRestOptions):void 0),ret.addPropertyResult("engineVersion","EngineVersion",properties.EngineVersion!=null?cfn_parse.FromCloudFormation.getString(properties.EngineVersion):void 0),ret.addPropertyResult("logPublishingOptions","LogPublishingOptions",properties.LogPublishingOptions!=null?cfn_parse.FromCloudFormation.getMap(CfnDomainLogPublishingOptionPropertyFromCloudFormation)(properties.LogPublishingOptions):void 0),ret.addPropertyResult("nodeToNodeEncryptionOptions","NodeToNodeEncryptionOptions",properties.NodeToNodeEncryptionOptions!=null?CfnDomainNodeToNodeEncryptionOptionsPropertyFromCloudFormation(properties.NodeToNodeEncryptionOptions):void 0),ret.addPropertyResult("offPeakWindowOptions","OffPeakWindowOptions",properties.OffPeakWindowOptions!=null?CfnDomainOffPeakWindowOptionsPropertyFromCloudFormation(properties.OffPeakWindowOptions):void 0),ret.addPropertyResult("snapshotOptions","SnapshotOptions",properties.SnapshotOptions!=null?CfnDomainSnapshotOptionsPropertyFromCloudFormation(properties.SnapshotOptions):void 0),ret.addPropertyResult("softwareUpdateOptions","SoftwareUpdateOptions",properties.SoftwareUpdateOptions!=null?CfnDomainSoftwareUpdateOptionsPropertyFromCloudFormation(properties.SoftwareUpdateOptions):void 0),ret.addPropertyResult("tags","Tags",properties.Tags!=null?cfn_parse.FromCloudFormation.getArray(cfn_parse.FromCloudFormation.getCfnTag)(properties.Tags):void 0),ret.addPropertyResult("vpcOptions","VPCOptions",properties.VPCOptions!=null?CfnDomainVPCOptionsPropertyFromCloudFormation(properties.VPCOptions):void 0),ret.addUnrecognizedPropertiesAsExtra(properties),ret}class CfnDomain extends cdk.CfnResource{static _fromCloudFormation(scope,id,resourceAttributes,options){resourceAttributes=resourceAttributes||{};const resourceProperties=options.parser.parseValue(resourceAttributes.Properties),propsResult=CfnDomainPropsFromCloudFormation(resourceProperties),ret=new CfnDomain(scope,id,propsResult.value);for(const[propKey,propVal]of Object.entries(propsResult.extraProperties))ret.addPropertyOverride(propKey,propVal);return options.parser.handleAttributes(ret,resourceAttributes,id),ret}constructor(scope,id,props={}){super(scope,id,{type:CfnDomain.CFN_RESOURCE_TYPE_NAME,properties:props});try{jsiiDeprecationWarnings.aws_cdk_lib_aws_opensearchservice_CfnDomainProps(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,CfnDomain),error}this.attrAdvancedSecurityOptionsAnonymousAuthDisableDate=cdk.Token.asString(this.getAtt("AdvancedSecurityOptions.AnonymousAuthDisableDate",cdk.ResolutionTypeHint.STRING)),this.attrArn=cdk.Token.asString(this.getAtt("Arn",cdk.ResolutionTypeHint.STRING)),this.attrDomainEndpoint=cdk.Token.asString(this.getAtt("DomainEndpoint",cdk.ResolutionTypeHint.STRING)),this.attrDomainEndpoints=this.getAtt("DomainEndpoints",cdk.ResolutionTypeHint.STRING),this.attrId=cdk.Token.asString(this.getAtt("Id",cdk.ResolutionTypeHint.STRING)),this.attrServiceSoftwareOptionsAutomatedUpdateDate=cdk.Token.asString(this.getAtt("ServiceSoftwareOptions.AutomatedUpdateDate",cdk.ResolutionTypeHint.STRING)),this.attrServiceSoftwareOptionsCancellable=this.getAtt("ServiceSoftwareOptions.Cancellable",cdk.ResolutionTypeHint.STRING),this.attrServiceSoftwareOptionsCurrentVersion=cdk.Token.asString(this.getAtt("ServiceSoftwareOptions.CurrentVersion",cdk.ResolutionTypeHint.STRING)),this.attrServiceSoftwareOptionsDescription=cdk.Token.asString(this.getAtt("ServiceSoftwareOptions.Description",cdk.ResolutionTypeHint.STRING)),this.attrServiceSoftwareOptionsNewVersion=cdk.Token.asString(this.getAtt("ServiceSoftwareOptions.NewVersion",cdk.ResolutionTypeHint.STRING)),this.attrServiceSoftwareOptionsOptionalDeployment=this.getAtt("ServiceSoftwareOptions.OptionalDeployment",cdk.ResolutionTypeHint.STRING),this.attrServiceSoftwareOptionsUpdateAvailable=this.getAtt("ServiceSoftwareOptions.UpdateAvailable",cdk.ResolutionTypeHint.STRING),this.attrServiceSoftwareOptionsUpdateStatus=cdk.Token.asString(this.getAtt("ServiceSoftwareOptions.UpdateStatus",cdk.ResolutionTypeHint.STRING)),this.accessPolicies=props.accessPolicies,this.advancedOptions=props.advancedOptions,this.advancedSecurityOptions=props.advancedSecurityOptions,this.clusterConfig=props.clusterConfig,this.cognitoOptions=props.cognitoOptions,this.domainEndpointOptions=props.domainEndpointOptions,this.domainName=props.domainName,this.ebsOptions=props.ebsOptions,this.encryptionAtRestOptions=props.encryptionAtRestOptions,this.engineVersion=props.engineVersion,this.logPublishingOptions=props.logPublishingOptions,this.nodeToNodeEncryptionOptions=props.nodeToNodeEncryptionOptions,this.offPeakWindowOptions=props.offPeakWindowOptions,this.snapshotOptions=props.snapshotOptions,this.softwareUpdateOptions=props.softwareUpdateOptions,this.tags=new cdk.TagManager(cdk.TagType.STANDARD,"AWS::OpenSearchService::Domain",props.tags,{tagPropertyName:"tags"}),this.vpcOptions=props.vpcOptions,this.node.scope&&cdk.Resource.isResource(this.node.scope)&&this.node.addValidation({validate:()=>this.cfnOptions.deletionPolicy===void 0?["'AWS::OpenSearchService::Domain' is a stateful resource type, and you must specify a Removal Policy for it. Call 'resource.applyRemovalPolicy()'."]:[]})}inspect(inspector){try{jsiiDeprecationWarnings.aws_cdk_lib_TreeInspector(inspector)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.inspect),error}inspector.addAttribute("aws:cdk:cloudformation:type",CfnDomain.CFN_RESOURCE_TYPE_NAME),inspector.addAttribute("aws:cdk:cloudformation:props",this.cfnProperties)}get cfnProperties(){return{accessPolicies:this.accessPolicies,advancedOptions:this.advancedOptions,advancedSecurityOptions:this.advancedSecurityOptions,clusterConfig:this.clusterConfig,cognitoOptions:this.cognitoOptions,domainEndpointOptions:this.domainEndpointOptions,domainName:this.domainName,ebsOptions:this.ebsOptions,encryptionAtRestOptions:this.encryptionAtRestOptions,engineVersion:this.engineVersion,logPublishingOptions:this.logPublishingOptions,nodeToNodeEncryptionOptions:this.nodeToNodeEncryptionOptions,offPeakWindowOptions:this.offPeakWindowOptions,snapshotOptions:this.snapshotOptions,softwareUpdateOptions:this.softwareUpdateOptions,tags:this.tags.renderTags(),vpcOptions:this.vpcOptions}}renderProperties(props){return cfnDomainPropsToCloudFormation(props)}}_a=JSII_RTTI_SYMBOL_1,CfnDomain[_a]={fqn:"aws-cdk-lib.aws_opensearchservice.CfnDomain",version:"2.87.0"},CfnDomain.CFN_RESOURCE_TYPE_NAME="AWS::OpenSearchService::Domain",exports.CfnDomain=CfnDomain;function CfnDomain_AdvancedSecurityOptionsInputPropertyValidator(properties){if(!cdk.canInspect(properties))return cdk.VALIDATION_SUCCESS;const errors=new cdk.ValidationResults;return typeof properties!="object"&&errors.collect(new cdk.ValidationResult("Expected an object, but received: "+JSON.stringify(properties))),errors.collect(cdk.propertyValidator("anonymousAuthDisableDate",cdk.validateString)(properties.anonymousAuthDisableDate)),errors.collect(cdk.propertyValidator("anonymousAuthEnabled",cdk.validateBoolean)(properties.anonymousAuthEnabled)),errors.collect(cdk.propertyValidator("enabled",cdk.validateBoolean)(properties.enabled)),errors.collect(cdk.propertyValidator("internalUserDatabaseEnabled",cdk.validateBoolean)(properties.internalUserDatabaseEnabled)),errors.collect(cdk.propertyValidator("masterUserOptions",CfnDomain_MasterUserOptionsPropertyValidator)(properties.masterUserOptions)),errors.collect(cdk.propertyValidator("samlOptions",CfnDomain_SAMLOptionsPropertyValidator)(properties.samlOptions)),errors.wrap('supplied properties not correct for "AdvancedSecurityOptionsInputProperty"')}function cfnDomainAdvancedSecurityOptionsInputPropertyToCloudFormation(properties){return cdk.canInspect(properties)?(CfnDomain_AdvancedSecurityOptionsInputPropertyValidator(properties).assertSuccess(),{AnonymousAuthDisableDate:cdk.stringToCloudFormation(properties.anonymousAuthDisableDate),AnonymousAuthEnabled:cdk.booleanToCloudFormation(properties.anonymousAuthEnabled),Enabled:cdk.booleanToCloudFormation(properties.enabled),InternalUserDatabaseEnabled:cdk.booleanToCloudFormation(properties.internalUserDatabaseEnabled),MasterUserOptions:cfnDomainMasterUserOptionsPropertyToCloudFormation(properties.masterUserOptions),SAMLOptions:cfnDomainSAMLOptionsPropertyToCloudFormation(properties.samlOptions)}):properties}function CfnDomainAdvancedSecurityOptionsInputPropertyFromCloudFormation(properties){if(cdk.isResolvableObject(properties))return new cfn_parse.FromCloudFormationResult(properties);if(properties=properties??{},typeof properties!="object")return new cfn_parse.FromCloudFormationResult(properties);const ret=new cfn_parse.FromCloudFormationPropertyObject;return ret.addPropertyResult("anonymousAuthDisableDate","AnonymousAuthDisableDate",properties.AnonymousAuthDisableDate!=null?cfn_parse.FromCloudFormation.getString(properties.AnonymousAuthDisableDate):void 0),ret.addPropertyResult("anonymousAuthEnabled","AnonymousAuthEnabled",properties.AnonymousAuthEnabled!=null?cfn_parse.FromCloudFormation.getBoolean(properties.AnonymousAuthEnabled):void 0),ret.addPropertyResult("enabled","Enabled",properties.Enabled!=null?cfn_parse.FromCloudFormation.getBoolean(properties.Enabled):void 0),ret.addPropertyResult("internalUserDatabaseEnabled","InternalUserDatabaseEnabled",properties.InternalUserDatabaseEnabled!=null?cfn_parse.FromCloudFormation.getBoolean(properties.InternalUserDatabaseEnabled):void 0),ret.addPropertyResult("masterUserOptions","MasterUserOptions",properties.MasterUserOptions!=null?CfnDomainMasterUserOptionsPropertyFromCloudFormation(properties.MasterUserOptions):void 0),ret.addPropertyResult("samlOptions","SAMLOptions",properties.SAMLOptions!=null?CfnDomainSAMLOptionsPropertyFromCloudFormation(properties.SAMLOptions):void 0),ret.addUnrecognizedPropertiesAsExtra(properties),ret}function CfnDomain_ClusterConfigPropertyValidator(properties){if(!cdk.canInspect(properties))return cdk.VALIDATION_SUCCESS;const errors=new cdk.ValidationResults;return typeof properties!="object"&&errors.collect(new cdk.ValidationResult("Expected an object, but received: "+JSON.stringify(properties))),errors.collect(cdk.propertyValidator("dedicatedMasterCount",cdk.validateNumber)(properties.dedicatedMasterCount)),errors.collect(cdk.propertyValidator("dedicatedMasterEnabled",cdk.validateBoolean)(properties.dedicatedMasterEnabled)),errors.collect(cdk.propertyValidator("dedicatedMasterType",cdk.validateString)(properties.dedicatedMasterType)),errors.collect(cdk.propertyValidator("instanceCount",cdk.validateNumber)(properties.instanceCount)),errors.collect(cdk.propertyValidator("instanceType",cdk.validateString)(properties.instanceType)),errors.collect(cdk.propertyValidator("multiAzWithStandbyEnabled",cdk.validateBoolean)(properties.multiAzWithStandbyEnabled)),errors.collect(cdk.propertyValidator("warmCount",cdk.validateNumber)(properties.warmCount)),errors.collect(cdk.propertyValidator("warmEnabled",cdk.validateBoolean)(properties.warmEnabled)),errors.collect(cdk.propertyValidator("warmType",cdk.validateString)(properties.warmType)),errors.collect(cdk.propertyValidator("zoneAwarenessConfig",CfnDomain_ZoneAwarenessConfigPropertyValidator)(properties.zoneAwarenessConfig)),errors.collect(cdk.propertyValidator("zoneAwarenessEnabled",cdk.validateBoolean)(properties.zoneAwarenessEnabled)),errors.wrap('supplied properties not correct for "ClusterConfigProperty"')}function cfnDomainClusterConfigPropertyToCloudFormation(properties){return cdk.canInspect(properties)?(CfnDomain_ClusterConfigPropertyValidator(properties).assertSuccess(),{DedicatedMasterCount:cdk.numberToCloudFormation(properties.dedicatedMasterCount),DedicatedMasterEnabled:cdk.booleanToCloudFormation(properties.dedicatedMasterEnabled),DedicatedMasterType:cdk.stringToCloudFormation(properties.dedicatedMasterType),InstanceCount:cdk.numberToCloudFormation(properties.instanceCount),InstanceType:cdk.stringToCloudFormation(properties.instanceType),MultiAZWithStandbyEnabled:cdk.booleanToCloudFormation(properties.multiAzWithStandbyEnabled),WarmCount:cdk.numberToCloudFormation(properties.warmCount),WarmEnabled:cdk.booleanToCloudFormation(properties.warmEnabled),WarmType:cdk.stringToCloudFormation(properties.warmType),ZoneAwarenessConfig:cfnDomainZoneAwarenessConfigPropertyToCloudFormation(properties.zoneAwarenessConfig),ZoneAwarenessEnabled:cdk.booleanToCloudFormation(properties.zoneAwarenessEnabled)}):properties}function CfnDomainClusterConfigPropertyFromCloudFormation(properties){if(cdk.isResolvableObject(properties))return new cfn_parse.FromCloudFormationResult(properties);if(properties=properties??{},typeof properties!="object")return new cfn_parse.FromCloudFormationResult(properties);const ret=new cfn_parse.FromCloudFormationPropertyObject;return ret.addPropertyResult("dedicatedMasterCount","DedicatedMasterCount",properties.DedicatedMasterCount!=null?cfn_parse.FromCloudFormation.getNumber(properties.DedicatedMasterCount):void 0),ret.addPropertyResult("dedicatedMasterEnabled","DedicatedMasterEnabled",properties.DedicatedMasterEnabled!=null?cfn_parse.FromCloudFormation.getBoolean(properties.DedicatedMasterEnabled):void 0),ret.addPropertyResult("dedicatedMasterType","DedicatedMasterType",properties.DedicatedMasterType!=null?cfn_parse.FromCloudFormation.getString(properties.DedicatedMasterType):void 0),ret.addPropertyResult("instanceCount","InstanceCount",properties.InstanceCount!=null?cfn_parse.FromCloudFormation.getNumber(properties.InstanceCount):void 0),ret.addPropertyResult("instanceType","InstanceType",properties.InstanceType!=null?cfn_parse.FromCloudFormation.getString(properties.InstanceType):void 0),ret.addPropertyResult("multiAzWithStandbyEnabled","MultiAZWithStandbyEnabled",properties.MultiAZWithStandbyEnabled!=null?cfn_parse.FromCloudFormation.getBoolean(properties.MultiAZWithStandbyEnabled):void 0),ret.addPropertyResult("warmCount","WarmCount",properties.WarmCount!=null?cfn_parse.FromCloudFormation.getNumber(properties.WarmCount):void 0),ret.addPropertyResult("warmEnabled","WarmEnabled",properties.WarmEnabled!=null?cfn_parse.FromCloudFormation.getBoolean(properties.WarmEnabled):void 0),ret.addPropertyResult("warmType","WarmType",properties.WarmType!=null?cfn_parse.FromCloudFormation.getString(properties.WarmType):void 0),ret.addPropertyResult("zoneAwarenessConfig","ZoneAwarenessConfig",properties.ZoneAwarenessConfig!=null?CfnDomainZoneAwarenessConfigPropertyFromCloudFormation(properties.ZoneAwarenessConfig):void 0),ret.addPropertyResult("zoneAwarenessEnabled","ZoneAwarenessEnabled",properties.ZoneAwarenessEnabled!=null?cfn_parse.FromCloudFormation.getBoolean(properties.ZoneAwarenessEnabled):void 0),ret.addUnrecognizedPropertiesAsExtra(properties),ret}function CfnDomain_CognitoOptionsPropertyValidator(properties){if(!cdk.canInspect(properties))return cdk.VALIDATION_SUCCESS;const errors=new cdk.ValidationResults;return typeof properties!="object"&&errors.collect(new cdk.ValidationResult("Expected an object, but received: "+JSON.stringify(properties))),errors.collect(cdk.propertyValidator("enabled",cdk.validateBoolean)(properties.enabled)),errors.collect(cdk.propertyValidator("identityPoolId",cdk.validateString)(properties.identityPoolId)),errors.collect(cdk.propertyValidator("roleArn",cdk.validateString)(properties.roleArn)),errors.collect(cdk.propertyValidator("userPoolId",cdk.validateString)(properties.userPoolId)),errors.wrap('supplied properties not correct for "CognitoOptionsProperty"')}function cfnDomainCognitoOptionsPropertyToCloudFormation(properties){return cdk.canInspect(properties)?(CfnDomain_CognitoOptionsPropertyValidator(properties).assertSuccess(),{Enabled:cdk.booleanToCloudFormation(properties.enabled),IdentityPoolId:cdk.stringToCloudFormation(properties.identityPoolId),RoleArn:cdk.stringToCloudFormation(properties.roleArn),UserPoolId:cdk.stringToCloudFormation(properties.userPoolId)}):properties}function CfnDomainCognitoOptionsPropertyFromCloudFormation(properties){if(cdk.isResolvableObject(properties))return new cfn_parse.FromCloudFormationResult(properties);if(properties=properties??{},typeof properties!="object")return new cfn_parse.FromCloudFormationResult(properties);const ret=new cfn_parse.FromCloudFormationPropertyObject;return ret.addPropertyResult("enabled","Enabled",properties.Enabled!=null?cfn_parse.FromCloudFormation.getBoolean(properties.Enabled):void 0),ret.addPropertyResult("identityPoolId","IdentityPoolId",properties.IdentityPoolId!=null?cfn_parse.FromCloudFormation.getString(properties.IdentityPoolId):void 0),ret.addPropertyResult("roleArn","RoleArn",properties.RoleArn!=null?cfn_parse.FromCloudFormation.getString(properties.RoleArn):void 0),ret.addPropertyResult("userPoolId","UserPoolId",properties.UserPoolId!=null?cfn_parse.FromCloudFormation.getString(properties.UserPoolId):void 0),ret.addUnrecognizedPropertiesAsExtra(properties),ret}function CfnDomain_DomainEndpointOptionsPropertyValidator(properties){if(!cdk.canInspect(properties))return cdk.VALIDATION_SUCCESS;const errors=new cdk.ValidationResults;return typeof properties!="object"&&errors.collect(new cdk.ValidationResult("Expected an object, but received: "+JSON.stringify(properties))),errors.collect(cdk.propertyValidator("customEndpoint",cdk.validateString)(properties.customEndpoint)),errors.collect(cdk.propertyValidator("customEndpointCertificateArn",cdk.validateString)(properties.customEndpointCertificateArn)),errors.collect(cdk.propertyValidator("customEndpointEnabled",cdk.validateBoolean)(properties.customEndpointEnabled)),errors.collect(cdk.propertyValidator("enforceHttps",cdk.validateBoolean)(properties.enforceHttps)),errors.collect(cdk.propertyValidator("tlsSecurityPolicy",cdk.validateString)(properties.tlsSecurityPolicy)),errors.wrap('supplied properties not correct for "DomainEndpointOptionsProperty"')}function cfnDomainDomainEndpointOptionsPropertyToCloudFormation(properties){return cdk.canInspect(properties)?(CfnDomain_DomainEndpointOptionsPropertyValidator(properties).assertSuccess(),{CustomEndpoint:cdk.stringToCloudFormation(properties.customEndpoint),CustomEndpointCertificateArn:cdk.stringToCloudFormation(properties.customEndpointCertificateArn),CustomEndpointEnabled:cdk.booleanToCloudFormation(properties.customEndpointEnabled),EnforceHTTPS:cdk.booleanToCloudFormation(properties.enforceHttps),TLSSecurityPolicy:cdk.stringToCloudFormation(properties.tlsSecurityPolicy)}):properties}function CfnDomainDomainEndpointOptionsPropertyFromCloudFormation(properties){if(cdk.isResolvableObject(properties))return new cfn_parse.FromCloudFormationResult(properties);if(properties=properties??{},typeof properties!="object")return new cfn_parse.FromCloudFormationResult(properties);const ret=new cfn_parse.FromCloudFormationPropertyObject;return ret.addPropertyResult("customEndpoint","CustomEndpoint",properties.CustomEndpoint!=null?cfn_parse.FromCloudFormation.getString(properties.CustomEndpoint):void 0),ret.addPropertyResult("customEndpointCertificateArn","CustomEndpointCertificateArn",properties.CustomEndpointCertificateArn!=null?cfn_parse.FromCloudFormation.getString(properties.CustomEndpointCertificateArn):void 0),ret.addPropertyResult("customEndpointEnabled","CustomEndpointEnabled",properties.CustomEndpointEnabled!=null?cfn_parse.FromCloudFormation.getBoolean(properties.CustomEndpointEnabled):void 0),ret.addPropertyResult("enforceHttps","EnforceHTTPS",properties.EnforceHTTPS!=null?cfn_parse.FromCloudFormation.getBoolean(properties.EnforceHTTPS):void 0),ret.addPropertyResult("tlsSecurityPolicy","TLSSecurityPolicy",properties.TLSSecurityPolicy!=null?cfn_parse.FromCloudFormation.getString(properties.TLSSecurityPolicy):void 0),ret.addUnrecognizedPropertiesAsExtra(properties),ret}function CfnDomain_EBSOptionsPropertyValidator(properties){if(!cdk.canInspect(properties))return cdk.VALIDATION_SUCCESS;const errors=new cdk.ValidationResults;return typeof properties!="object"&&errors.collect(new cdk.ValidationResult("Expected an object, but received: "+JSON.stringify(properties))),errors.collect(cdk.propertyValidator("ebsEnabled",cdk.validateBoolean)(properties.ebsEnabled)),errors.collect(cdk.propertyValidator("iops",cdk.validateNumber)(properties.iops)),errors.collect(cdk.propertyValidator("throughput",cdk.validateNumber)(properties.throughput)),errors.collect(cdk.propertyValidator("volumeSize",cdk.validateNumber)(properties.volumeSize)),errors.collect(cdk.propertyValidator("volumeType",cdk.validateString)(properties.volumeType)),errors.wrap('supplied properties not correct for "EBSOptionsProperty"')}function cfnDomainEBSOptionsPropertyToCloudFormation(properties){return cdk.canInspect(properties)?(CfnDomain_EBSOptionsPropertyValidator(properties).assertSuccess(),{EBSEnabled:cdk.booleanToCloudFormation(properties.ebsEnabled),Iops:cdk.numberToCloudFormation(properties.iops),Throughput:cdk.numberToCloudFormation(properties.throughput),VolumeSize:cdk.numberToCloudFormation(properties.volumeSize),VolumeType:cdk.stringToCloudFormation(properties.volumeType)}):properties}function CfnDomainEBSOptionsPropertyFromCloudFormation(properties){if(cdk.isResolvableObject(properties))return new cfn_parse.FromCloudFormationResult(properties);if(properties=properties??{},typeof properties!="object")return new cfn_parse.FromCloudFormationResult(properties);const ret=new cfn_parse.FromCloudFormationPropertyObject;return ret.addPropertyResult("ebsEnabled","EBSEnabled",properties.EBSEnabled!=null?cfn_parse.FromCloudFormation.getBoolean(properties.EBSEnabled):void 0),ret.addPropertyResult("iops","Iops",properties.Iops!=null?cfn_parse.FromCloudFormation.getNumber(properties.Iops):void 0),ret.addPropertyResult("throughput","Throughput",properties.Throughput!=null?cfn_parse.FromCloudFormation.getNumber(properties.Throughput):void 0),ret.addPropertyResult("volumeSize","VolumeSize",properties.VolumeSize!=null?cfn_parse.FromCloudFormation.getNumber(properties.VolumeSize):void 0),ret.addPropertyResult("volumeType","VolumeType",properties.VolumeType!=null?cfn_parse.FromCloudFormation.getString(properties.VolumeType):void 0),ret.addUnrecognizedPropertiesAsExtra(properties),ret}function CfnDomain_EncryptionAtRestOptionsPropertyValidator(properties){if(!cdk.canInspect(properties))return cdk.VALIDATION_SUCCESS;const errors=new cdk.ValidationResults;return typeof properties!="object"&&errors.collect(new cdk.ValidationResult("Expected an object, but received: "+JSON.stringify(properties))),errors.collect(cdk.propertyValidator("enabled",cdk.validateBoolean)(properties.enabled)),errors.collect(cdk.propertyValidator("kmsKeyId",cdk.validateString)(properties.kmsKeyId)),errors.wrap('supplied properties not correct for "EncryptionAtRestOptionsProperty"')}function cfnDomainEncryptionAtRestOptionsPropertyToCloudFormation(properties){return cdk.canInspect(properties)?(CfnDomain_EncryptionAtRestOptionsPropertyValidator(properties).assertSuccess(),{Enabled:cdk.booleanToCloudFormation(properties.enabled),KmsKeyId:cdk.stringToCloudFormation(properties.kmsKeyId)}):properties}function CfnDomainEncryptionAtRestOptionsPropertyFromCloudFormation(properties){if(cdk.isResolvableObject(properties))return new cfn_parse.FromCloudFormationResult(properties);if(properties=properties??{},typeof properties!="object")return new cfn_parse.FromCloudFormationResult(properties);const ret=new cfn_parse.FromCloudFormationPropertyObject;return ret.addPropertyResult("enabled","Enabled",properties.Enabled!=null?cfn_parse.FromCloudFormation.getBoolean(properties.Enabled):void 0),ret.addPropertyResult("kmsKeyId","KmsKeyId",properties.KmsKeyId!=null?cfn_parse.FromCloudFormation.getString(properties.KmsKeyId):void 0),ret.addUnrecognizedPropertiesAsExtra(properties),ret}function CfnDomain_IdpPropertyValidator(properties){if(!cdk.canInspect(properties))return cdk.VALIDATION_SUCCESS;const errors=new cdk.ValidationResults;return typeof properties!="object"&&errors.collect(new cdk.ValidationResult("Expected an object, but received: "+JSON.stringify(properties))),errors.collect(cdk.propertyValidator("entityId",cdk.requiredValidator)(properties.entityId)),errors.collect(cdk.propertyValidator("entityId",cdk.validateString)(properties.entityId)),errors.collect(cdk.propertyValidator("metadataContent",cdk.requiredValidator)(properties.metadataContent)),errors.collect(cdk.propertyValidator("metadataContent",cdk.validateString)(properties.metadataContent)),errors.wrap('supplied properties not correct for "IdpProperty"')}function cfnDomainIdpPropertyToCloudFormation(properties){return cdk.canInspect(properties)?(CfnDomain_IdpPropertyValidator(properties).assertSuccess(),{EntityId:cdk.stringToCloudFormation(properties.entityId),MetadataContent:cdk.stringToCloudFormation(properties.metadataContent)}):properties}function CfnDomainIdpPropertyFromCloudFormation(properties){if(cdk.isResolvableObject(properties))return new cfn_parse.FromCloudFormationResult(properties);if(properties=properties??{},typeof properties!="object")return new cfn_parse.FromCloudFormationResult(properties);const ret=new cfn_parse.FromCloudFormationPropertyObject;return ret.addPropertyResult("entityId","EntityId",cfn_parse.FromCloudFormation.getString(properties.EntityId)),ret.addPropertyResult("metadataContent","MetadataContent",cfn_parse.FromCloudFormation.getString(properties.MetadataContent)),ret.addUnrecognizedPropertiesAsExtra(properties),ret}function CfnDomain_LogPublishingOptionPropertyValidator(properties){if(!cdk.canInspect(properties))return cdk.VALIDATION_SUCCESS;const errors=new cdk.ValidationResults;return typeof properties!="object"&&errors.collect(new cdk.ValidationResult("Expected an object, but received: "+JSON.stringify(properties))),errors.collect(cdk.propertyValidator("cloudWatchLogsLogGroupArn",cdk.validateString)(properties.cloudWatchLogsLogGroupArn)),errors.collect(cdk.propertyValidator("enabled",cdk.validateBoolean)(properties.enabled)),errors.wrap('supplied properties not correct for "LogPublishingOptionProperty"')}function cfnDomainLogPublishingOptionPropertyToCloudFormation(properties){return cdk.canInspect(properties)?(CfnDomain_LogPublishingOptionPropertyValidator(properties).assertSuccess(),{CloudWatchLogsLogGroupArn:cdk.stringToCloudFormation(properties.cloudWatchLogsLogGroupArn),Enabled:cdk.booleanToCloudFormation(properties.enabled)}):properties}function CfnDomainLogPublishingOptionPropertyFromCloudFormation(properties){if(cdk.isResolvableObject(properties))return new cfn_parse.FromCloudFormationResult(properties);if(properties=properties??{},typeof properties!="object")return new cfn_parse.FromCloudFormationResult(properties);const ret=new cfn_parse.FromCloudFormationPropertyObject;return ret.addPropertyResult("cloudWatchLogsLogGroupArn","CloudWatchLogsLogGroupArn",properties.CloudWatchLogsLogGroupArn!=null?cfn_parse.FromCloudFormation.getString(properties.CloudWatchLogsLogGroupArn):void 0),ret.addPropertyResult("enabled","Enabled",properties.Enabled!=null?cfn_parse.FromCloudFormation.getBoolean(properties.Enabled):void 0),ret.addUnrecognizedPropertiesAsExtra(properties),ret}function CfnDomain_MasterUserOptionsPropertyValidator(properties){if(!cdk.canInspect(properties))return cdk.VALIDATION_SUCCESS;const errors=new cdk.ValidationResults;return typeof properties!="object"&&errors.collect(new cdk.ValidationResult("Expected an object, but received: "+JSON.stringify(properties))),errors.collect(cdk.propertyValidator("masterUserArn",cdk.validateString)(properties.masterUserArn)),errors.collect(cdk.propertyValidator("masterUserName",cdk.validateString)(properties.masterUserName)),errors.collect(cdk.propertyValidator("masterUserPassword",cdk.validateString)(properties.masterUserPassword)),errors.wrap('supplied properties not correct for "MasterUserOptionsProperty"')}function cfnDomainMasterUserOptionsPropertyToCloudFormation(properties){return cdk.canInspect(properties)?(CfnDomain_MasterUserOptionsPropertyValidator(properties).assertSuccess(),{MasterUserARN:cdk.stringToCloudFormation(properties.masterUserArn),MasterUserName:cdk.stringToCloudFormation(properties.masterUserName),MasterUserPassword:cdk.stringToCloudFormation(properties.masterUserPassword)}):properties}function CfnDomainMasterUserOptionsPropertyFromCloudFormation(properties){if(cdk.isResolvableObject(properties))return new cfn_parse.FromCloudFormationResult(properties);if(properties=properties??{},typeof properties!="object")return new cfn_parse.FromCloudFormationResult(properties);const ret=new cfn_parse.FromCloudFormationPropertyObject;return ret.addPropertyResult("masterUserArn","MasterUserARN",properties.MasterUserARN!=null?cfn_parse.FromCloudFormation.getString(properties.MasterUserARN):void 0),ret.addPropertyResult("masterUserName","MasterUserName",properties.MasterUserName!=null?cfn_parse.FromCloudFormation.getString(properties.MasterUserName):void 0),ret.addPropertyResult("masterUserPassword","MasterUserPassword",properties.MasterUserPassword!=null?cfn_parse.FromCloudFormation.getString(properties.MasterUserPassword):void 0),ret.addUnrecognizedPropertiesAsExtra(properties),ret}function CfnDomain_NodeToNodeEncryptionOptionsPropertyValidator(properties){if(!cdk.canInspect(properties))return cdk.VALIDATION_SUCCESS;const errors=new cdk.ValidationResults;return typeof properties!="object"&&errors.collect(new cdk.ValidationResult("Expected an object, but received: "+JSON.stringify(properties))),errors.collect(cdk.propertyValidator("enabled",cdk.validateBoolean)(properties.enabled)),errors.wrap('supplied properties not correct for "NodeToNodeEncryptionOptionsProperty"')}function cfnDomainNodeToNodeEncryptionOptionsPropertyToCloudFormation(properties){return cdk.canInspect(properties)?(CfnDomain_NodeToNodeEncryptionOptionsPropertyValidator(properties).assertSuccess(),{Enabled:cdk.booleanToCloudFormation(properties.enabled)}):properties}function CfnDomainNodeToNodeEncryptionOptionsPropertyFromCloudFormation(properties){if(cdk.isResolvableObject(properties))return new cfn_parse.FromCloudFormationResult(properties);if(properties=properties??{},typeof properties!="object")return new cfn_parse.FromCloudFormationResult(properties);const ret=new cfn_parse.FromCloudFormationPropertyObject;return ret.addPropertyResult("enabled","Enabled",properties.Enabled!=null?cfn_parse.FromCloudFormation.getBoolean(properties.Enabled):void 0),ret.addUnrecognizedPropertiesAsExtra(properties),ret}function CfnDomain_OffPeakWindowPropertyValidator(properties){if(!cdk.canInspect(properties))return cdk.VALIDATION_SUCCESS;const errors=new cdk.ValidationResults;return typeof properties!="object"&&errors.collect(new cdk.ValidationResult("Expected an object, but received: "+JSON.stringify(properties))),errors.collect(cdk.propertyValidator("windowStartTime",CfnDomain_WindowStartTimePropertyValidator)(properties.windowStartTime)),errors.wrap('supplied properties not correct for "OffPeakWindowProperty"')}function cfnDomainOffPeakWindowPropertyToCloudFormation(properties){return cdk.canInspect(properties)?(CfnDomain_OffPeakWindowPropertyValidator(properties).assertSuccess(),{WindowStartTime:cfnDomainWindowStartTimePropertyToCloudFormation(properties.windowStartTime)}):properties}function CfnDomainOffPeakWindowPropertyFromCloudFormation(properties){if(cdk.isResolvableObject(properties))return new cfn_parse.FromCloudFormationResult(properties);if(properties=properties??{},typeof properties!="object")return new cfn_parse.FromCloudFormationResult(properties);const ret=new cfn_parse.FromCloudFormationPropertyObject;return ret.addPropertyResult("windowStartTime","WindowStartTime",properties.WindowStartTime!=null?CfnDomainWindowStartTimePropertyFromCloudFormation(properties.WindowStartTime):void 0),ret.addUnrecognizedPropertiesAsExtra(properties),ret}function CfnDomain_OffPeakWindowOptionsPropertyValidator(properties){if(!cdk.canInspect(properties))return cdk.VALIDATION_SUCCESS;const errors=new cdk.ValidationResults;return typeof properties!="object"&&errors.collect(new cdk.ValidationResult("Expected an object, but received: "+JSON.stringify(properties))),errors.collect(cdk.propertyValidator("enabled",cdk.validateBoolean)(properties.enabled)),errors.collect(cdk.propertyValidator("offPeakWindow",CfnDomain_OffPeakWindowPropertyValidator)(properties.offPeakWindow)),errors.wrap('supplied properties not correct for "OffPeakWindowOptionsProperty"')}function cfnDomainOffPeakWindowOptionsPropertyToCloudFormation(properties){return cdk.canInspect(properties)?(CfnDomain_OffPeakWindowOptionsPropertyValidator(properties).assertSuccess(),{Enabled:cdk.booleanToCloudFormation(properties.enabled),OffPeakWindow:cfnDomainOffPeakWindowPropertyToCloudFormation(properties.offPeakWindow)}):properties}function CfnDomainOffPeakWindowOptionsPropertyFromCloudFormation(properties){if(cdk.isResolvableObject(properties))return new cfn_parse.FromCloudFormationResult(properties);if(properties=properties??{},typeof properties!="object")return new cfn_parse.FromCloudFormationResult(properties);const ret=new cfn_parse.FromCloudFormationPropertyObject;return ret.addPropertyResult("enabled","Enabled",properties.Enabled!=null?cfn_parse.FromCloudFormation.getBoolean(properties.Enabled):void 0),ret.addPropertyResult("offPeakWindow","OffPeakWindow",properties.OffPeakWindow!=null?CfnDomainOffPeakWindowPropertyFromCloudFormation(properties.OffPeakWindow):void 0),ret.addUnrecognizedPropertiesAsExtra(properties),ret}function CfnDomain_SAMLOptionsPropertyValidator(properties){if(!cdk.canInspect(properties))return cdk.VALIDATION_SUCCESS;const errors=new cdk.ValidationResults;return typeof properties!="object"&&errors.collect(new cdk.ValidationResult("Expected an object, but received: "+JSON.stringify(properties))),errors.collect(cdk.propertyValidator("enabled",cdk.validateBoolean)(properties.enabled)),errors.collect(cdk.propertyValidator("idp",CfnDomain_IdpPropertyValidator)(properties.idp)),errors.collect(cdk.propertyValidator("masterBackendRole",cdk.validateString)(properties.masterBackendRole)),errors.collect(cdk.propertyValidator("masterUserName",cdk.validateString)(properties.masterUserName)),errors.collect(cdk.propertyValidator("rolesKey",cdk.validateString)(properties.rolesKey)),errors.collect(cdk.propertyValidator("sessionTimeoutMinutes",cdk.validateNumber)(properties.sessionTimeoutMinutes)),errors.collect(cdk.propertyValidator("subjectKey",cdk.validateString)(properties.subjectKey)),errors.wrap('supplied properties not correct for "SAMLOptionsProperty"')}function cfnDomainSAMLOptionsPropertyToCloudFormation(properties){return cdk.canInspect(properties)?(CfnDomain_SAMLOptionsPropertyValidator(properties).assertSuccess(),{Enabled:cdk.booleanToCloudFormation(properties.enabled),Idp:cfnDomainIdpPropertyToCloudFormation(properties.idp),MasterBackendRole:cdk.stringToCloudFormation(properties.masterBackendRole),MasterUserName:cdk.stringToCloudFormation(properties.masterUserName),RolesKey:cdk.stringToCloudFormation(properties.rolesKey),SessionTimeoutMinutes:cdk.numberToCloudFormation(properties.sessionTimeoutMinutes),SubjectKey:cdk.stringToCloudFormation(properties.subjectKey)}):properties}function CfnDomainSAMLOptionsPropertyFromCloudFormation(properties){if(cdk.isResolvableObject(properties))return new cfn_parse.FromCloudFormationResult(properties);if(properties=properties??{},typeof properties!="object")return new cfn_parse.FromCloudFormationResult(properties);const ret=new cfn_parse.FromCloudFormationPropertyObject;return ret.addPropertyResult("enabled","Enabled",properties.Enabled!=null?cfn_parse.FromCloudFormation.getBoolean(properties.Enabled):void 0),ret.addPropertyResult("idp","Idp",properties.Idp!=null?CfnDomainIdpPropertyFromCloudFormation(properties.Idp):void 0),ret.addPropertyResult("masterBackendRole","MasterBackendRole",properties.MasterBackendRole!=null?cfn_parse.FromCloudFormation.getString(properties.MasterBackendRole):void 0),ret.addPropertyResult("masterUserName","MasterUserName",properties.MasterUserName!=null?cfn_parse.FromCloudFormation.getString(properties.MasterUserName):void 0),ret.addPropertyResult("rolesKey","RolesKey",properties.RolesKey!=null?cfn_parse.FromCloudFormation.getString(properties.RolesKey):void 0),ret.addPropertyResult("sessionTimeoutMinutes","SessionTimeoutMinutes",properties.SessionTimeoutMinutes!=null?cfn_parse.FromCloudFormation.getNumber(properties.SessionTimeoutMinutes):void 0),ret.addPropertyResult("subjectKey","SubjectKey",properties.SubjectKey!=null?cfn_parse.FromCloudFormation.getString(properties.SubjectKey):void 0),ret.addUnrecognizedPropertiesAsExtra(properties),ret}function CfnDomain_ServiceSoftwareOptionsPropertyValidator(properties){if(!cdk.canInspect(properties))return cdk.VALIDATION_SUCCESS;const errors=new cdk.ValidationResults;return typeof properties!="object"&&errors.collect(new cdk.ValidationResult("Expected an object, but received: "+JSON.stringify(properties))),errors.collect(cdk.propertyValidator("automatedUpdateDate",cdk.validateString)(properties.automatedUpdateDate)),errors.collect(cdk.propertyValidator("cancellable",cdk.validateBoolean)(properties.cancellable)),errors.collect(cdk.propertyValidator("currentVersion",cdk.validateString)(properties.currentVersion)),errors.collect(cdk.propertyValidator("description",cdk.validateString)(properties.description)),errors.collect(cdk.propertyValidator("newVersion",cdk.validateString)(properties.newVersion)),errors.collect(cdk.propertyValidator("optionalDeployment",cdk.validateBoolean)(properties.optionalDeployment)),errors.collect(cdk.propertyValidator("updateAvailable",cdk.validateBoolean)(properties.updateAvailable)),errors.collect(cdk.propertyValidator("updateStatus",cdk.validateString)(properties.updateStatus)),errors.wrap('supplied properties not correct for "ServiceSoftwareOptionsProperty"')}function cfnDomainServiceSoftwareOptionsPropertyToCloudFormation(properties){return cdk.canInspect(properties)?(CfnDomain_ServiceSoftwareOptionsPropertyValidator(properties).assertSuccess(),{AutomatedUpdateDate:cdk.stringToCloudFormation(properties.automatedUpdateDate),Cancellable:cdk.booleanToCloudFormation(properties.cancellable),CurrentVersion:cdk.stringToCloudFormation(properties.currentVersion),Description:cdk.stringToCloudFormation(properties.description),NewVersion:cdk.stringToCloudFormation(properties.newVersion),OptionalDeployment:cdk.booleanToCloudFormation(properties.optionalDeployment),UpdateAvailable:cdk.booleanToCloudFormation(properties.updateAvailable),UpdateStatus:cdk.stringToCloudFormation(properties.updateStatus)}):properties}function CfnDomainServiceSoftwareOptionsPropertyFromCloudFormation(properties){if(cdk.isResolvableObject(properties))return new cfn_parse.FromCloudFormationResult(properties);if(properties=properties??{},typeof properties!="object")return new cfn_parse.FromCloudFormationResult(properties);const ret=new cfn_parse.FromCloudFormationPropertyObject;return ret.addPropertyResult("automatedUpdateDate","AutomatedUpdateDate",properties.AutomatedUpdateDate!=null?cfn_parse.FromCloudFormation.getString(properties.AutomatedUpdateDate):void 0),ret.addPropertyResult("cancellable","Cancellable",properties.Cancellable!=null?cfn_parse.FromCloudFormation.getBoolean(properties.Cancellable):void 0),ret.addPropertyResult("currentVersion","CurrentVersion",properties.CurrentVersion!=null?cfn_parse.FromCloudFormation.getString(properties.CurrentVersion):void 0),ret.addPropertyResult("description","Description",properties.Description!=null?cfn_parse.FromCloudFormation.getString(properties.Description):void 0),ret.addPropertyResult("newVersion","NewVersion",properties.NewVersion!=null?cfn_parse.FromCloudFormation.getString(properties.NewVersion):void 0),ret.addPropertyResult("optionalDeployment","OptionalDeployment",properties.OptionalDeployment!=null?cfn_parse.FromCloudFormation.getBoolean(properties.OptionalDeployment):void 0),ret.addPropertyResult("updateAvailable","UpdateAvailable",properties.UpdateAvailable!=null?cfn_parse.FromCloudFormation.getBoolean(properties.UpdateAvailable):void 0),ret.addPropertyResult("updateStatus","UpdateStatus",properties.UpdateStatus!=null?cfn_parse.FromCloudFormation.getString(properties.UpdateStatus):void 0),ret.addUnrecognizedPropertiesAsExtra(properties),ret}function CfnDomain_SnapshotOptionsPropertyValidator(properties){if(!cdk.canInspect(properties))return cdk.VALIDATION_SUCCESS;const errors=new cdk.ValidationResults;return typeof properties!="object"&&errors.collect(new cdk.ValidationResult("Expected an object, but received: "+JSON.stringify(properties))),errors.collect(cdk.propertyValidator("automatedSnapshotStartHour",cdk.validateNumber)(properties.automatedSnapshotStartHour)),errors.wrap('supplied properties not correct for "SnapshotOptionsProperty"')}function cfnDomainSnapshotOptionsPropertyToCloudFormation(properties){return cdk.canInspect(properties)?(CfnDomain_SnapshotOptionsPropertyValidator(properties).assertSuccess(),{AutomatedSnapshotStartHour:cdk.numberToCloudFormation(properties.automatedSnapshotStartHour)}):properties}function CfnDomainSnapshotOptionsPropertyFromCloudFormation(properties){if(cdk.isResolvableObject(properties))return new cfn_parse.FromCloudFormationResult(properties);if(properties=properties??{},typeof properties!="object")return new cfn_parse.FromCloudFormationResult(properties);const ret=new cfn_parse.FromCloudFormationPropertyObject;return ret.addPropertyResult("automatedSnapshotStartHour","AutomatedSnapshotStartHour",properties.AutomatedSnapshotStartHour!=null?cfn_parse.FromCloudFormation.getNumber(properties.AutomatedSnapshotStartHour):void 0),ret.addUnrecognizedPropertiesAsExtra(properties),ret}function CfnDomain_SoftwareUpdateOptionsPropertyValidator(properties){if(!cdk.canInspect(properties))return cdk.VALIDATION_SUCCESS;const errors=new cdk.ValidationResults;return typeof properties!="object"&&errors.collect(new cdk.ValidationResult("Expected an object, but received: "+JSON.stringify(properties))),errors.collect(cdk.propertyValidator("autoSoftwareUpdateEnabled",cdk.validateBoolean)(properties.autoSoftwareUpdateEnabled)),errors.wrap('supplied properties not correct for "SoftwareUpdateOptionsProperty"')}function cfnDomainSoftwareUpdateOptionsPropertyToCloudFormation(properties){return cdk.canInspect(properties)?(CfnDomain_SoftwareUpdateOptionsPropertyValidator(properties).assertSuccess(),{AutoSoftwareUpdateEnabled:cdk.booleanToCloudFormation(properties.autoSoftwareUpdateEnabled)}):properties}function CfnDomainSoftwareUpdateOptionsPropertyFromCloudFormation(properties){if(cdk.isResolvableObject(properties))return new cfn_parse.FromCloudFormationResult(properties);if(properties=properties??{},typeof properties!="object")return new cfn_parse.FromCloudFormationResult(properties);const ret=new cfn_parse.FromCloudFormationPropertyObject;return ret.addPropertyResult("autoSoftwareUpdateEnabled","AutoSoftwareUpdateEnabled",properties.AutoSoftwareUpdateEnabled!=null?cfn_parse.FromCloudFormation.getBoolean(properties.AutoSoftwareUpdateEnabled):void 0),ret.addUnrecognizedPropertiesAsExtra(properties),ret}function CfnDomain_VPCOptionsPropertyValidator(properties){if(!cdk.canInspect(properties))return cdk.VALIDATION_SUCCESS;const errors=new cdk.ValidationResults;return typeof properties!="object"&&errors.collect(new cdk.ValidationResult("Expected an object, but received: "+JSON.stringify(properties))),errors.collect(cdk.propertyValidator("securityGroupIds",cdk.listValidator(cdk.validateString))(properties.securityGroupIds)),errors.collect(cdk.propertyValidator("subnetIds",cdk.listValidator(cdk.validateString))(properties.subnetIds)),errors.wrap('supplied properties not correct for "VPCOptionsProperty"')}function cfnDomainVPCOptionsPropertyToCloudFormation(properties){return cdk.canInspect(properties)?(CfnDomain_VPCOptionsPropertyValidator(properties).assertSuccess(),{SecurityGroupIds:cdk.listMapper(cdk.stringToCloudFormation)(properties.securityGroupIds),SubnetIds:cdk.listMapper(cdk.stringToCloudFormation)(properties.subnetIds)}):properties}function CfnDomainVPCOptionsPropertyFromCloudFormation(properties){if(cdk.isResolvableObject(properties))return new cfn_parse.FromCloudFormationResult(properties);if(properties=properties??{},typeof properties!="object")return new cfn_parse.FromCloudFormationResult(properties);const ret=new cfn_parse.FromCloudFormationPropertyObject;return ret.addPropertyResult("securityGroupIds","SecurityGroupIds",properties.SecurityGroupIds!=null?cfn_parse.FromCloudFormation.getStringArray(properties.SecurityGroupIds):void 0),ret.addPropertyResult("subnetIds","SubnetIds",properties.SubnetIds!=null?cfn_parse.FromCloudFormation.getStringArray(properties.SubnetIds):void 0),ret.addUnrecognizedPropertiesAsExtra(properties),ret}function CfnDomain_WindowStartTimePropertyValidator(properties){if(!cdk.canInspect(properties))return cdk.VALIDATION_SUCCESS;const errors=new cdk.ValidationResults;return typeof properties!="object"&&errors.collect(new cdk.ValidationResult("Expected an object, but received: "+JSON.stringify(properties))),errors.collect(cdk.propertyValidator("hours",cdk.requiredValidator)(properties.hours)),errors.collect(cdk.propertyValidator("hours",cdk.validateNumber)(properties.hours)),errors.collect(cdk.propertyValidator("minutes",cdk.requiredValidator)(properties.minutes)),errors.collect(cdk.propertyValidator("minutes",cdk.validateNumber)(properties.minutes)),errors.wrap('supplied properties not correct for "WindowStartTimeProperty"')}function cfnDomainWindowStartTimePropertyToCloudFormation(properties){return cdk.canInspect(properties)?(CfnDomain_WindowStartTimePropertyValidator(properties).assertSuccess(),{Hours:cdk.numberToCloudFormation(properties.hours),Minutes:cdk.numberToCloudFormation(properties.minutes)}):properties}function CfnDomainWindowStartTimePropertyFromCloudFormation(properties){if(cdk.isResolvableObject(properties))return new cfn_parse.FromCloudFormationResult(properties);if(properties=properties??{},typeof properties!="object")return new cfn_parse.FromCloudFormationResult(properties);const ret=new cfn_parse.FromCloudFormationPropertyObject;return ret.addPropertyResult("hours","Hours",cfn_parse.FromCloudFormation.getNumber(properties.Hours)),ret.addPropertyResult("minutes","Minutes",cfn_parse.FromCloudFormation.getNumber(properties.Minutes)),ret.addUnrecognizedPropertiesAsExtra(properties),ret}function CfnDomain_ZoneAwarenessConfigPropertyValidator(properties){if(!cdk.canInspect(properties))return cdk.VALIDATION_SUCCESS;const errors=new cdk.ValidationResults;return typeof properties!="object"&&errors.collect(new cdk.ValidationResult("Expected an object, but received: "+JSON.stringify(properties))),errors.collect(cdk.propertyValidator("availabilityZoneCount",cdk.validateNumber)(properties.availabilityZoneCount)),errors.wrap('supplied properties not correct for "ZoneAwarenessConfigProperty"')}function cfnDomainZoneAwarenessConfigPropertyToCloudFormation(properties){return cdk.canInspect(properties)?(CfnDomain_ZoneAwarenessConfigPropertyValidator(properties).assertSuccess(),{AvailabilityZoneCount:cdk.numberToCloudFormation(properties.availabilityZoneCount)}):properties}function CfnDomainZoneAwarenessConfigPropertyFromCloudFormation(properties){if(cdk.isResolvableObject(properties))return new cfn_parse.FromCloudFormationResult(properties);if(properties=properties??{},typeof properties!="object")return new cfn_parse.FromCloudFormationResult(properties);const ret=new cfn_parse.FromCloudFormationPropertyObject;return ret.addPropertyResult("availabilityZoneCount","AvailabilityZoneCount",properties.AvailabilityZoneCount!=null?cfn_parse.FromCloudFormation.getNumber(properties.AvailabilityZoneCount):void 0),ret.addUnrecognizedPropertiesAsExtra(properties),ret}
