import * as constructs from 'constructs';
import * as cdk from '../../core';
import * as cfn_parse from '../../core/lib/helpers-internal';
/**
 * Properties for defining a `CfnPipeline`
 *
 * @struct
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-osis-pipeline.html
 */
export interface CfnPipelineProps {
    /**
     * The maximum pipeline capacity, in Ingestion Compute Units (ICUs).
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-osis-pipeline.html#cfn-osis-pipeline-maxunits
     */
    readonly maxUnits: number;
    /**
     * The minimum pipeline capacity, in Ingestion Compute Units (ICUs).
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-osis-pipeline.html#cfn-osis-pipeline-minunits
     */
    readonly minUnits: number;
    /**
     * The Data Prepper pipeline configuration in YAML format.
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-osis-pipeline.html#cfn-osis-pipeline-pipelineconfigurationbody
     */
    readonly pipelineConfigurationBody: string;
    /**
     * The name of the pipeline.
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-osis-pipeline.html#cfn-osis-pipeline-pipelinename
     */
    readonly pipelineName: string;
    /**
     * Key-value pairs that represent log publishing settings.
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-osis-pipeline.html#cfn-osis-pipeline-logpublishingoptions
     */
    readonly logPublishingOptions?: CfnPipeline.LogPublishingOptionsProperty | cdk.IResolvable;
    /**
     * List of tags to add to the pipeline upon creation.
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-osis-pipeline.html#cfn-osis-pipeline-tags
     */
    readonly tags?: cdk.CfnTag[];
    /**
     * Options that specify the subnets and security groups for an OpenSearch Ingestion VPC endpoint.
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-osis-pipeline.html#cfn-osis-pipeline-vpcoptions
     */
    readonly vpcOptions?: CfnPipeline.VpcOptionsProperty | cdk.IResolvable;
}
/**
 * A CloudFormation `AWS::OSIS::Pipeline`
 *
 * The AWS::OSIS::Pipeline resource creates an Amazon OpenSearch Ingestion pipeline.
 *
 * @cloudformationResource AWS::OSIS::Pipeline
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-osis-pipeline.html
 */
export declare class CfnPipeline extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::OSIS::Pipeline";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: constructs.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnPipeline;
    /**
     * A list of the ingestion endpoints for the pipeline that you can send data to. Currently, only a single ingestion endpoint is supported for a pipeline. For example, `my-pipeline-123456789012.us-east-1.osis.amazonaws.com` .
     * @cloudformationAttribute IngestEndpointUrls
     */
    readonly attrIngestEndpointUrls: string[];
    /**
     * The Amazon Resource Name (ARN) of the pipeline.
     * @cloudformationAttribute PipelineArn
     */
    readonly attrPipelineArn: string;
    /**
     * The VPC interface endpoints that have access to the pipeline.
     * @cloudformationAttribute VpcEndpoints
     */
    readonly attrVpcEndpoints: cdk.IResolvable;
    /**
     * The maximum pipeline capacity, in Ingestion Compute Units (ICUs).
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-osis-pipeline.html#cfn-osis-pipeline-maxunits
     */
    maxUnits: number;
    /**
     * The minimum pipeline capacity, in Ingestion Compute Units (ICUs).
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-osis-pipeline.html#cfn-osis-pipeline-minunits
     */
    minUnits: number;
    /**
     * The Data Prepper pipeline configuration in YAML format.
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-osis-pipeline.html#cfn-osis-pipeline-pipelineconfigurationbody
     */
    pipelineConfigurationBody: string;
    /**
     * The name of the pipeline.
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-osis-pipeline.html#cfn-osis-pipeline-pipelinename
     */
    pipelineName: string;
    /**
     * Key-value pairs that represent log publishing settings.
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-osis-pipeline.html#cfn-osis-pipeline-logpublishingoptions
     */
    logPublishingOptions: CfnPipeline.LogPublishingOptionsProperty | cdk.IResolvable | undefined;
    /**
     * List of tags to add to the pipeline upon creation.
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-osis-pipeline.html#cfn-osis-pipeline-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * Options that specify the subnets and security groups for an OpenSearch Ingestion VPC endpoint.
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-osis-pipeline.html#cfn-osis-pipeline-vpcoptions
     */
    vpcOptions: CfnPipeline.VpcOptionsProperty | cdk.IResolvable | undefined;
    /**
     * Create a new `AWS::OSIS::Pipeline`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: constructs.Construct, id: string, props: CfnPipelineProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     */
    inspect(inspector: cdk.TreeInspector): void;
    protected get cfnProperties(): {
        [key: string]: any;
    };
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
export declare namespace CfnPipeline {
    /**
     *
     *
     * @struct
     * @stability external
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-osis-pipeline-cloudwatchlogdestination.html
     */
    interface CloudWatchLogDestinationProperty {
        /**
         * `CfnPipeline.CloudWatchLogDestinationProperty.LogGroup`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-osis-pipeline-cloudwatchlogdestination.html#cfn-osis-pipeline-cloudwatchlogdestination-loggroup
         */
        readonly logGroup?: string;
    }
}
export declare namespace CfnPipeline {
    /**
     * Container for the values required to configure logging for the pipeline. If you don't specify these values, OpenSearch Ingestion will not publish logs from your application to CloudWatch Logs.
     *
     * @struct
     * @stability external
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-osis-pipeline-logpublishingoptions.html
     */
    interface LogPublishingOptionsProperty {
        /**
         * The destination for OpenSearch Ingestion logs sent to Amazon CloudWatch Logs. This parameter is required if `IsLoggingEnabled` is set to `true` .
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-osis-pipeline-logpublishingoptions.html#cfn-osis-pipeline-logpublishingoptions-cloudwatchlogdestination
         */
        readonly cloudWatchLogDestination?: CfnPipeline.CloudWatchLogDestinationProperty | cdk.IResolvable;
        /**
         * Whether logs should be published.
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-osis-pipeline-logpublishingoptions.html#cfn-osis-pipeline-logpublishingoptions-isloggingenabled
         */
        readonly isLoggingEnabled?: boolean | cdk.IResolvable;
    }
}
export declare namespace CfnPipeline {
    /**
     * An OpenSearch Ingestion-managed VPC endpoint that will access one or more pipelines.
     *
     * @struct
     * @stability external
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-osis-pipeline-vpcendpoint.html
     */
    interface VpcEndpointProperty {
        /**
         * The unique identifier of the endpoint.
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-osis-pipeline-vpcendpoint.html#cfn-osis-pipeline-vpcendpoint-vpcendpointid
         */
        readonly vpcEndpointId?: string;
        /**
         * The ID for your VPC. AWS PrivateLink generates this value when you create a VPC.
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-osis-pipeline-vpcendpoint.html#cfn-osis-pipeline-vpcendpoint-vpcid
         */
        readonly vpcId?: string;
        /**
         * Information about the VPC, including associated subnets and security groups.
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-osis-pipeline-vpcendpoint.html#cfn-osis-pipeline-vpcendpoint-vpcoptions
         */
        readonly vpcOptions?: CfnPipeline.VpcOptionsProperty | cdk.IResolvable;
    }
}
export declare namespace CfnPipeline {
    /**
     * Options that specify the subnets and security groups for an OpenSearch Ingestion VPC endpoint.
     *
     * @struct
     * @stability external
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-osis-pipeline-vpcoptions.html
     */
    interface VpcOptionsProperty {
        /**
         * A list of security groups associated with the VPC endpoint.
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-osis-pipeline-vpcoptions.html#cfn-osis-pipeline-vpcoptions-securitygroupids
         */
        readonly securityGroupIds?: string[];
        /**
         * A list of subnet IDs associated with the VPC endpoint.
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-osis-pipeline-vpcoptions.html#cfn-osis-pipeline-vpcoptions-subnetids
         */
        readonly subnetIds?: string[];
    }
}
