"use strict";var _a,_b;Object.defineProperty(exports,"__esModule",{value:!0}),exports.InstanceType=exports.ClusterInstance=exports.ClusterInstanceType=void 0;const jsiiDeprecationWarnings=require("../../.warnings.jsii.js"),JSII_RTTI_SYMBOL_1=Symbol.for("jsii.rtti"),parameter_group_1=require("./parameter-group"),util_1=require("./private/util"),props_1=require("./props"),rds_generated_1=require("./rds.generated"),ec2=require("../../aws-ec2"),core_1=require("../../core");class ClusterInstanceType{static serverlessV2(){return new ClusterInstanceType("db.serverless",InstanceType.SERVERLESS_V2)}static provisioned(instanceType){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_ec2_InstanceType(instanceType)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.provisioned),error}return new ClusterInstanceType((instanceType??ec2.InstanceType.of(ec2.InstanceClass.T3,ec2.InstanceSize.MEDIUM)).toString(),InstanceType.PROVISIONED)}constructor(instanceType,type){this.instanceType=instanceType,this.type=type;try{jsiiDeprecationWarnings.aws_cdk_lib_aws_rds_InstanceType(type)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,ClusterInstanceType),error}}toString(){return this.instanceType}}_a=JSII_RTTI_SYMBOL_1,ClusterInstanceType[_a]={fqn:"aws-cdk-lib.aws_rds.ClusterInstanceType",version:"2.87.0"},exports.ClusterInstanceType=ClusterInstanceType;class ClusterInstance{static provisioned(id,props={}){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_rds_ProvisionedClusterInstanceProps(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.provisioned),error}return new ClusterInstance(id,{...props,instanceType:ClusterInstanceType.provisioned(props.instanceType)})}static serverlessV2(id,props={}){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_rds_ServerlessV2ClusterInstanceProps(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.serverlessV2),error}return new ClusterInstance(id,{...props,promotionTier:props.scaleWithWriter?1:2,instanceType:ClusterInstanceType.serverlessV2()})}constructor(id,props){this.id=id,this.props=props}bind(scope,cluster,props){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_rds_IDatabaseCluster(cluster),jsiiDeprecationWarnings.aws_cdk_lib_aws_rds_ClusterInstanceBindOptions(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.bind),error}return new AuroraClusterInstance(scope,this.id,{cluster,...this.props,...props})}}_b=JSII_RTTI_SYMBOL_1,ClusterInstance[_b]={fqn:"aws-cdk-lib.aws_rds.ClusterInstance",version:"2.87.0"},exports.ClusterInstance=ClusterInstance;var InstanceType;(function(InstanceType2){InstanceType2.PROVISIONED="PROVISIONED",InstanceType2.SERVERLESS_V2="SERVERLESS_V2"})(InstanceType=exports.InstanceType||(exports.InstanceType={}));class AuroraClusterInstance extends core_1.Resource{constructor(scope,id,props){if(super(scope,props.isFromLegacyInstanceProps?`${id}Wrapper`:id,{physicalName:props.instanceIdentifier}),this.tier=props.promotionTier??2,this.tier>15)throw new Error("promotionTier must be between 0-15");const isOwnedResource=core_1.Resource.isOwnedResource(props.cluster);let internetConnected,publiclyAccessible=props.publiclyAccessible;if(isOwnedResource){const ownedCluster=props.cluster;internetConnected=ownedCluster.vpc.selectSubnets(ownedCluster.vpcSubnets).internetConnectivityEstablished,publiclyAccessible=ownedCluster.vpcSubnets&&ownedCluster.vpcSubnets.subnetType===ec2.SubnetType.PUBLIC}const instanceType=props.instanceType??ClusterInstanceType.serverlessV2();this.type=instanceType.type,this.instanceSize=this.type===InstanceType.PROVISIONED?props.instanceType?.toString():void 0;const engine=props.cluster.engine,enablePerformanceInsights=props.enablePerformanceInsights||props.performanceInsightRetention!==void 0||props.performanceInsightEncryptionKey!==void 0;if(enablePerformanceInsights&&props.enablePerformanceInsights===!1)throw new Error("`enablePerformanceInsights` disabled, but `performanceInsightRetention` or `performanceInsightEncryptionKey` was set");const instanceParameterGroupConfig=(props.parameterGroup??(props.parameters?new parameter_group_1.ParameterGroup(props.cluster,"InstanceParameterGroup",{engine,parameters:props.parameters}):void 0))?.bindToInstance({}),instance=new rds_generated_1.CfnDBInstance(props.isFromLegacyInstanceProps?scope:this,props.isFromLegacyInstanceProps?id:"Resource",{engine:engine.engineType,dbClusterIdentifier:props.cluster.clusterIdentifier,promotionTier:props.isFromLegacyInstanceProps?void 0:this.tier,dbInstanceIdentifier:this.physicalName,dbInstanceClass:props.instanceType?databaseInstanceType(instanceType):void 0,publiclyAccessible,enablePerformanceInsights:enablePerformanceInsights||props.enablePerformanceInsights,performanceInsightsKmsKeyId:props.performanceInsightEncryptionKey?.keyArn,performanceInsightsRetentionPeriod:enablePerformanceInsights?props.performanceInsightRetention||props_1.PerformanceInsightRetention.DEFAULT:void 0,dbSubnetGroupName:props.isFromLegacyInstanceProps?props.subnetGroup?.subnetGroupName:void 0,dbParameterGroupName:instanceParameterGroupConfig?.parameterGroupName,monitoringInterval:props.monitoringInterval&&props.monitoringInterval.toSeconds(),monitoringRoleArn:props.monitoringRole&&props.monitoringRole.roleArn,autoMinorVersionUpgrade:props.autoMinorVersionUpgrade,allowMajorVersionUpgrade:props.allowMajorVersionUpgrade});instance.applyRemovalPolicy((0,util_1.helperRemovalPolicy)(props.removalPolicy)),internetConnected&&instance.node.addDependency(internetConnected),this.dbInstanceArn=this.getResourceArnAttribute(instance.attrDbInstanceArn,{resource:"db",service:"rds",arnFormat:core_1.ArnFormat.COLON_RESOURCE_NAME,resourceName:this.physicalName}),this.instanceIdentifier=this.getResourceNameAttribute(instance.ref),this.dbiResourceId=instance.attrDbiResourceId,this.dbInstanceEndpointAddress=instance.attrEndpointAddress}}function databaseInstanceType(instanceType){const type=instanceType.toString();return instanceType.type===InstanceType.SERVERLESS_V2?type:"db."+type}
