import * as constructs from 'constructs';
import * as cdk from '../../core';
import * as cfn_parse from '../../core/lib/helpers-internal';
/**
 * Properties for defining a `CfnApp`
 *
 * @struct
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-resiliencehub-app.html
 */
export interface CfnAppProps {
    /**
     * A JSON string that provides information about your application structure. To learn more about the `appTemplateBody` template, see the sample template provided in the *Examples* section.
     *
     * The `appTemplateBody` JSON string has the following structure:
     *
     * - *`resources`*
     *
     * The list of logical resources that needs to be included in the AWS Resilience Hub application.
     *
     * Type: Array
     *
     * > Don't add the resources that you want to exclude.
     *
     * Each `resources` array item includes the following fields:
     *
     * - *`logicalResourceId`*
     *
     * The logical identifier of the resource.
     *
     * Type: Object
     *
     * Each `logicalResourceId` object includes the following fields:
     *
     * - `identifier`
     *
     * The identifier of the resource.
     *
     * Type: String
     * - `logicalStackName`
     *
     * The name of the AWS CloudFormation stack this resource belongs to.
     *
     * Type: String
     * - `resourceGroupName`
     *
     * The name of the resource group this resource belongs to.
     *
     * Type: String
     * - `terraformSourceName`
     *
     * The name of the Terraform S3 state file this resource belongs to.
     *
     * Type: String
     * - `eksSourceName`
     *
     * The name of the Amazon Elastic Kubernetes Service cluster and namespace this resource belongs to.
     *
     * > This parameter accepts values in "eks-cluster/namespace" format.
     *
     * Type: String
     * - *`type`*
     *
     * The type of resource.
     *
     * Type: string
     * - *`name`*
     *
     * The name of the resource.
     *
     * Type: String
     * - `additionalInfo`
     *
     * Additional configuration parameters for an AWS Resilience Hub application. If you want to implement `additionalInfo` through the AWS Resilience Hub console rather than using an API call, see [Configure the application configuration parameters](https://docs.aws.amazon.com//resilience-hub/latest/userguide/app-config-param.html) .
     *
     * > Currently, this parameter accepts a key-value mapping (in a string format) of only one failover region and one associated account.
     * >
     * > Key: `"failover-regions"`
     * >
     * > Value: `"[{"region":"<REGION>", "accounts":[{"id":"<ACCOUNT_ID>"}]}]"`
     * - *`appComponents`*
     *
     * The list of Application Components (AppComponent) that this resource belongs to. If an AppComponent is not part of the AWS Resilience Hub application, it will be added.
     *
     * Type: Array
     *
     * Each `appComponents` array item includes the following fields:
     *
     * - `name`
     *
     * The name of the AppComponent.
     *
     * Type: String
     * - `type`
     *
     * The type of AppComponent. For more information about the types of AppComponent, see [Grouping resources in an AppComponent](https://docs.aws.amazon.com/resilience-hub/latest/userguide/AppComponent.grouping.html) .
     *
     * Type: String
     * - `resourceNames`
     *
     * The list of included resources that are assigned to the AppComponent.
     *
     * Type: Array of strings
     * - `additionalInfo`
     *
     * Additional configuration parameters for an AWS Resilience Hub application. If you want to implement `additionalInfo` through the AWS Resilience Hub console rather than using an API call, see [Configure the application configuration parameters](https://docs.aws.amazon.com//resilience-hub/latest/userguide/app-config-param.html) .
     *
     * > Currently, this parameter accepts a key-value mapping (in a string format) of only one failover region and one associated account.
     * >
     * > Key: `"failover-regions"`
     * >
     * > Value: `"[{"region":"<REGION>", "accounts":[{"id":"<ACCOUNT_ID>"}]}]"`
     * - *`excludedResources`*
     *
     * The list of logical resource identifiers to be excluded from the application.
     *
     * Type: Array
     *
     * > Don't add the resources that you want to include.
     *
     * Each `excludedResources` array item includes the following fields:
     *
     * - *`logicalResourceIds`*
     *
     * The logical identifier of the resource.
     *
     * Type: Object
     *
     * > You can configure only one of the following fields:
     * >
     * > - `logicalStackName`
     * > - `resourceGroupName`
     * > - `terraformSourceName`
     * > - `eksSourceName`
     *
     * Each `logicalResourceIds` object includes the following fields:
     *
     * - `identifier`
     *
     * The identifier of the resource.
     *
     * Type: String
     * - `logicalStackName`
     *
     * The name of the AWS CloudFormation stack this resource belongs to.
     *
     * Type: String
     * - `resourceGroupName`
     *
     * The name of the resource group this resource belongs to.
     *
     * Type: String
     * - `terraformSourceName`
     *
     * The name of the Terraform S3 state file this resource belongs to.
     *
     * Type: String
     * - `eksSourceName`
     *
     * The name of the Amazon Elastic Kubernetes Service cluster and namespace this resource belongs to.
     *
     * > This parameter accepts values in "eks-cluster/namespace" format.
     *
     * Type: String
     * - *`version`*
     *
     * The AWS Resilience Hub application version.
     * - `additionalInfo`
     *
     * Additional configuration parameters for an AWS Resilience Hub application. If you want to implement `additionalInfo` through the AWS Resilience Hub console rather than using an API call, see [Configure the application configuration parameters](https://docs.aws.amazon.com//resilience-hub/latest/userguide/app-config-param.html) .
     *
     * > Currently, this parameter accepts a key-value mapping (in a string format) of only one failover region and one associated account.
     * >
     * > Key: `"failover-regions"`
     * >
     * > Value: `"[{"region":"<REGION>", "accounts":[{"id":"<ACCOUNT_ID>"}]}]"`
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-resiliencehub-app.html#cfn-resiliencehub-app-apptemplatebody
     */
    readonly appTemplateBody: string;
    /**
     * The name for the application.
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-resiliencehub-app.html#cfn-resiliencehub-app-name
     */
    readonly name: string;
    /**
     * An array of ResourceMapping objects.
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-resiliencehub-app.html#cfn-resiliencehub-app-resourcemappings
     */
    readonly resourceMappings: Array<CfnApp.ResourceMappingProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * Assessment execution schedule with 'Daily' or 'Disabled' values.
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-resiliencehub-app.html#cfn-resiliencehub-app-appassessmentschedule
     */
    readonly appAssessmentSchedule?: string;
    /**
     * The optional description for an app.
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-resiliencehub-app.html#cfn-resiliencehub-app-description
     */
    readonly description?: string;
    /**
     * The Amazon Resource Name (ARN) of the resiliency policy.
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-resiliencehub-app.html#cfn-resiliencehub-app-resiliencypolicyarn
     */
    readonly resiliencyPolicyArn?: string;
    /**
     * The tags assigned to the resource. A tag is a label that you assign to an AWS resource. Each tag consists of a key/value pair.
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-resiliencehub-app.html#cfn-resiliencehub-app-tags
     */
    readonly tags?: {
        [key: string]: (string);
    };
}
/**
 * A CloudFormation `AWS::ResilienceHub::App`
 *
 * Creates an AWS Resilience Hub application. An AWS Resilience Hub application is a collection of AWS resources structured to prevent and recover AWS application disruptions. To describe a AWS Resilience Hub application, you provide an application name, resources from one or more AWS CloudFormation stacks, AWS Resource Groups , Terraform state files, AppRegistry applications, and an appropriate resiliency policy. In addition, you can also add resources that are located on Amazon Elastic Kubernetes Service ( Amazon EKS ) clusters as optional resources. For more information about the number of resources supported per application, see [Service quotas](https://docs.aws.amazon.com/general/latest/gr/resiliencehub.html#limits_resiliencehub) .
 *
 * After you create an AWS Resilience Hub application, you publish it so that you can run a resiliency assessment on it. You can then use recommendations from the assessment to improve resiliency by running another assessment, comparing results, and then iterating the process until you achieve your goals for recovery time objective (RTO) and recovery point objective (RPO).
 *
 * @cloudformationResource AWS::ResilienceHub::App
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-resiliencehub-app.html
 */
export declare class CfnApp extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::ResilienceHub::App";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: constructs.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnApp;
    /**
     * The Amazon Resource Name (ARN) of the app.
     * @cloudformationAttribute AppArn
     */
    readonly attrAppArn: string;
    /**
     * A JSON string that provides information about your application structure. To learn more about the `appTemplateBody` template, see the sample template provided in the *Examples* section.
     *
     * The `appTemplateBody` JSON string has the following structure:
     *
     * - *`resources`*
     *
     * The list of logical resources that needs to be included in the AWS Resilience Hub application.
     *
     * Type: Array
     *
     * > Don't add the resources that you want to exclude.
     *
     * Each `resources` array item includes the following fields:
     *
     * - *`logicalResourceId`*
     *
     * The logical identifier of the resource.
     *
     * Type: Object
     *
     * Each `logicalResourceId` object includes the following fields:
     *
     * - `identifier`
     *
     * The identifier of the resource.
     *
     * Type: String
     * - `logicalStackName`
     *
     * The name of the AWS CloudFormation stack this resource belongs to.
     *
     * Type: String
     * - `resourceGroupName`
     *
     * The name of the resource group this resource belongs to.
     *
     * Type: String
     * - `terraformSourceName`
     *
     * The name of the Terraform S3 state file this resource belongs to.
     *
     * Type: String
     * - `eksSourceName`
     *
     * The name of the Amazon Elastic Kubernetes Service cluster and namespace this resource belongs to.
     *
     * > This parameter accepts values in "eks-cluster/namespace" format.
     *
     * Type: String
     * - *`type`*
     *
     * The type of resource.
     *
     * Type: string
     * - *`name`*
     *
     * The name of the resource.
     *
     * Type: String
     * - `additionalInfo`
     *
     * Additional configuration parameters for an AWS Resilience Hub application. If you want to implement `additionalInfo` through the AWS Resilience Hub console rather than using an API call, see [Configure the application configuration parameters](https://docs.aws.amazon.com//resilience-hub/latest/userguide/app-config-param.html) .
     *
     * > Currently, this parameter accepts a key-value mapping (in a string format) of only one failover region and one associated account.
     * >
     * > Key: `"failover-regions"`
     * >
     * > Value: `"[{"region":"<REGION>", "accounts":[{"id":"<ACCOUNT_ID>"}]}]"`
     * - *`appComponents`*
     *
     * The list of Application Components (AppComponent) that this resource belongs to. If an AppComponent is not part of the AWS Resilience Hub application, it will be added.
     *
     * Type: Array
     *
     * Each `appComponents` array item includes the following fields:
     *
     * - `name`
     *
     * The name of the AppComponent.
     *
     * Type: String
     * - `type`
     *
     * The type of AppComponent. For more information about the types of AppComponent, see [Grouping resources in an AppComponent](https://docs.aws.amazon.com/resilience-hub/latest/userguide/AppComponent.grouping.html) .
     *
     * Type: String
     * - `resourceNames`
     *
     * The list of included resources that are assigned to the AppComponent.
     *
     * Type: Array of strings
     * - `additionalInfo`
     *
     * Additional configuration parameters for an AWS Resilience Hub application. If you want to implement `additionalInfo` through the AWS Resilience Hub console rather than using an API call, see [Configure the application configuration parameters](https://docs.aws.amazon.com//resilience-hub/latest/userguide/app-config-param.html) .
     *
     * > Currently, this parameter accepts a key-value mapping (in a string format) of only one failover region and one associated account.
     * >
     * > Key: `"failover-regions"`
     * >
     * > Value: `"[{"region":"<REGION>", "accounts":[{"id":"<ACCOUNT_ID>"}]}]"`
     * - *`excludedResources`*
     *
     * The list of logical resource identifiers to be excluded from the application.
     *
     * Type: Array
     *
     * > Don't add the resources that you want to include.
     *
     * Each `excludedResources` array item includes the following fields:
     *
     * - *`logicalResourceIds`*
     *
     * The logical identifier of the resource.
     *
     * Type: Object
     *
     * > You can configure only one of the following fields:
     * >
     * > - `logicalStackName`
     * > - `resourceGroupName`
     * > - `terraformSourceName`
     * > - `eksSourceName`
     *
     * Each `logicalResourceIds` object includes the following fields:
     *
     * - `identifier`
     *
     * The identifier of the resource.
     *
     * Type: String
     * - `logicalStackName`
     *
     * The name of the AWS CloudFormation stack this resource belongs to.
     *
     * Type: String
     * - `resourceGroupName`
     *
     * The name of the resource group this resource belongs to.
     *
     * Type: String
     * - `terraformSourceName`
     *
     * The name of the Terraform S3 state file this resource belongs to.
     *
     * Type: String
     * - `eksSourceName`
     *
     * The name of the Amazon Elastic Kubernetes Service cluster and namespace this resource belongs to.
     *
     * > This parameter accepts values in "eks-cluster/namespace" format.
     *
     * Type: String
     * - *`version`*
     *
     * The AWS Resilience Hub application version.
     * - `additionalInfo`
     *
     * Additional configuration parameters for an AWS Resilience Hub application. If you want to implement `additionalInfo` through the AWS Resilience Hub console rather than using an API call, see [Configure the application configuration parameters](https://docs.aws.amazon.com//resilience-hub/latest/userguide/app-config-param.html) .
     *
     * > Currently, this parameter accepts a key-value mapping (in a string format) of only one failover region and one associated account.
     * >
     * > Key: `"failover-regions"`
     * >
     * > Value: `"[{"region":"<REGION>", "accounts":[{"id":"<ACCOUNT_ID>"}]}]"`
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-resiliencehub-app.html#cfn-resiliencehub-app-apptemplatebody
     */
    appTemplateBody: string;
    /**
     * The name for the application.
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-resiliencehub-app.html#cfn-resiliencehub-app-name
     */
    name: string;
    /**
     * An array of ResourceMapping objects.
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-resiliencehub-app.html#cfn-resiliencehub-app-resourcemappings
     */
    resourceMappings: Array<CfnApp.ResourceMappingProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * Assessment execution schedule with 'Daily' or 'Disabled' values.
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-resiliencehub-app.html#cfn-resiliencehub-app-appassessmentschedule
     */
    appAssessmentSchedule: string | undefined;
    /**
     * The optional description for an app.
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-resiliencehub-app.html#cfn-resiliencehub-app-description
     */
    description: string | undefined;
    /**
     * The Amazon Resource Name (ARN) of the resiliency policy.
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-resiliencehub-app.html#cfn-resiliencehub-app-resiliencypolicyarn
     */
    resiliencyPolicyArn: string | undefined;
    /**
     * The tags assigned to the resource. A tag is a label that you assign to an AWS resource. Each tag consists of a key/value pair.
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-resiliencehub-app.html#cfn-resiliencehub-app-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::ResilienceHub::App`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: constructs.Construct, id: string, props: CfnAppProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     */
    inspect(inspector: cdk.TreeInspector): void;
    protected get cfnProperties(): {
        [key: string]: any;
    };
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
export declare namespace CfnApp {
    /**
     * Defines a physical resource identifier.
     *
     * @struct
     * @stability external
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resiliencehub-app-physicalresourceid.html
     */
    interface PhysicalResourceIdProperty {
        /**
         * The AWS account that owns the physical resource.
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resiliencehub-app-physicalresourceid.html#cfn-resiliencehub-app-physicalresourceid-awsaccountid
         */
        readonly awsAccountId?: string;
        /**
         * The AWS Region that the physical resource is located in.
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resiliencehub-app-physicalresourceid.html#cfn-resiliencehub-app-physicalresourceid-awsregion
         */
        readonly awsRegion?: string;
        /**
         * The identifier of the physical resource.
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resiliencehub-app-physicalresourceid.html#cfn-resiliencehub-app-physicalresourceid-identifier
         */
        readonly identifier: string;
        /**
         * Specifies the type of physical resource identifier.
         *
         * - **Arn** - The resource identifier is an Amazon Resource Name (ARN) and it can identify the following list of resources:
         *
         * - `AWS::ECS::Service`
         * - `AWS::EFS::FileSystem`
         * - `AWS::ElasticLoadBalancingV2::LoadBalancer`
         * - `AWS::Lambda::Function`
         * - `AWS::SNS::Topic`
         * - **Native** - The resource identifier is an AWS Resilience Hub -native identifier and it can identify the following list of resources:
         *
         * - `AWS::ApiGateway::RestApi`
         * - `AWS::ApiGatewayV2::Api`
         * - `AWS::AutoScaling::AutoScalingGroup`
         * - `AWS::DocDB::DBCluster`
         * - `AWS::DocDB::DBGlobalCluster`
         * - `AWS::DocDB::DBInstance`
         * - `AWS::DynamoDB::GlobalTable`
         * - `AWS::DynamoDB::Table`
         * - `AWS::EC2::EC2Fleet`
         * - `AWS::EC2::Instance`
         * - `AWS::EC2::NatGateway`
         * - `AWS::EC2::Volume`
         * - `AWS::ElasticLoadBalancing::LoadBalancer`
         * - `AWS::RDS::DBCluster`
         * - `AWS::RDS::DBInstance`
         * - `AWS::RDS::GlobalCluster`
         * - `AWS::Route53::RecordSet`
         * - `AWS::S3::Bucket`
         * - `AWS::SQS::Queue`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resiliencehub-app-physicalresourceid.html#cfn-resiliencehub-app-physicalresourceid-type
         */
        readonly type: string;
    }
}
export declare namespace CfnApp {
    /**
     * Defines a resource mapping.
     *
     * @struct
     * @stability external
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resiliencehub-app-resourcemapping.html
     */
    interface ResourceMappingProperty {
        /**
         * `CfnApp.ResourceMappingProperty.EksSourceName`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resiliencehub-app-resourcemapping.html#cfn-resiliencehub-app-resourcemapping-ekssourcename
         */
        readonly eksSourceName?: string;
        /**
         * The name of the CloudFormation stack this resource is mapped to.
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resiliencehub-app-resourcemapping.html#cfn-resiliencehub-app-resourcemapping-logicalstackname
         */
        readonly logicalStackName?: string;
        /**
         * Specifies the type of resource mapping.
         *
         * Valid Values: CfnStack | Resource | AppRegistryApp | ResourceGroup | Terraform
         *
         * - **AppRegistryApp** - The resource is mapped to another application. The name of the application is contained in the `appRegistryAppName` property.
         * - **CfnStack** - The resource is mapped to a CloudFormation stack. The name of the CloudFormation stack is contained in the `logicalStackName` property.
         * - **Resource** - The resource is mapped to another resource. The name of the resource is contained in the `resourceName` property.
         * - **ResourceGroup** - The resource is mapped to a resource group. The name of the resource group is contained in the `resourceGroupName` property.
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resiliencehub-app-resourcemapping.html#cfn-resiliencehub-app-resourcemapping-mappingtype
         */
        readonly mappingType: string;
        /**
         * The identifier of this resource.
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resiliencehub-app-resourcemapping.html#cfn-resiliencehub-app-resourcemapping-physicalresourceid
         */
        readonly physicalResourceId: CfnApp.PhysicalResourceIdProperty | cdk.IResolvable;
        /**
         * The name of the resource this resource is mapped to.
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resiliencehub-app-resourcemapping.html#cfn-resiliencehub-app-resourcemapping-resourcename
         */
        readonly resourceName?: string;
        /**
         * The short name of the Terraform source.
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resiliencehub-app-resourcemapping.html#cfn-resiliencehub-app-resourcemapping-terraformsourcename
         */
        readonly terraformSourceName?: string;
    }
}
/**
 * Properties for defining a `CfnResiliencyPolicy`
 *
 * @struct
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-resiliencehub-resiliencypolicy.html
 */
export interface CfnResiliencyPolicyProps {
    /**
     * The resiliency policy.
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-resiliencehub-resiliencypolicy.html#cfn-resiliencehub-resiliencypolicy-policy
     */
    readonly policy: {
        [key: string]: (CfnResiliencyPolicy.FailurePolicyProperty | cdk.IResolvable);
    } | cdk.IResolvable;
    /**
     * The name of the policy
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-resiliencehub-resiliencypolicy.html#cfn-resiliencehub-resiliencypolicy-policyname
     */
    readonly policyName: string;
    /**
     * The tier for this resiliency policy, ranging from the highest severity ( `MissionCritical` ) to lowest ( `NonCritical` ).
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-resiliencehub-resiliencypolicy.html#cfn-resiliencehub-resiliencypolicy-tier
     */
    readonly tier: string;
    /**
     * Specifies a high-level geographical location constraint for where your resilience policy data can be stored.
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-resiliencehub-resiliencypolicy.html#cfn-resiliencehub-resiliencypolicy-datalocationconstraint
     */
    readonly dataLocationConstraint?: string;
    /**
     * The description for the policy.
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-resiliencehub-resiliencypolicy.html#cfn-resiliencehub-resiliencypolicy-policydescription
     */
    readonly policyDescription?: string;
    /**
     * The tags assigned to the resource. A tag is a label that you assign to an AWS resource. Each tag consists of a key/value pair.
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-resiliencehub-resiliencypolicy.html#cfn-resiliencehub-resiliencypolicy-tags
     */
    readonly tags?: {
        [key: string]: (string);
    };
}
/**
 * A CloudFormation `AWS::ResilienceHub::ResiliencyPolicy`
 *
 * Defines a resiliency policy.
 *
 * @cloudformationResource AWS::ResilienceHub::ResiliencyPolicy
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-resiliencehub-resiliencypolicy.html
 */
export declare class CfnResiliencyPolicy extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::ResilienceHub::ResiliencyPolicy";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: constructs.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnResiliencyPolicy;
    /**
     * The Amazon Resource Name (ARN) of the resiliency policy.
     * @cloudformationAttribute PolicyArn
     */
    readonly attrPolicyArn: string;
    /**
     * The resiliency policy.
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-resiliencehub-resiliencypolicy.html#cfn-resiliencehub-resiliencypolicy-policy
     */
    policy: {
        [key: string]: (CfnResiliencyPolicy.FailurePolicyProperty | cdk.IResolvable);
    } | cdk.IResolvable;
    /**
     * The name of the policy
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-resiliencehub-resiliencypolicy.html#cfn-resiliencehub-resiliencypolicy-policyname
     */
    policyName: string;
    /**
     * The tier for this resiliency policy, ranging from the highest severity ( `MissionCritical` ) to lowest ( `NonCritical` ).
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-resiliencehub-resiliencypolicy.html#cfn-resiliencehub-resiliencypolicy-tier
     */
    tier: string;
    /**
     * Specifies a high-level geographical location constraint for where your resilience policy data can be stored.
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-resiliencehub-resiliencypolicy.html#cfn-resiliencehub-resiliencypolicy-datalocationconstraint
     */
    dataLocationConstraint: string | undefined;
    /**
     * The description for the policy.
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-resiliencehub-resiliencypolicy.html#cfn-resiliencehub-resiliencypolicy-policydescription
     */
    policyDescription: string | undefined;
    /**
     * The tags assigned to the resource. A tag is a label that you assign to an AWS resource. Each tag consists of a key/value pair.
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-resiliencehub-resiliencypolicy.html#cfn-resiliencehub-resiliencypolicy-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::ResilienceHub::ResiliencyPolicy`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: constructs.Construct, id: string, props: CfnResiliencyPolicyProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     */
    inspect(inspector: cdk.TreeInspector): void;
    protected get cfnProperties(): {
        [key: string]: any;
    };
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
export declare namespace CfnResiliencyPolicy {
    /**
     * Defines a failure policy.
     *
     * @struct
     * @stability external
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resiliencehub-resiliencypolicy-failurepolicy.html
     */
    interface FailurePolicyProperty {
        /**
         * The Recovery Point Objective (RPO), in seconds.
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resiliencehub-resiliencypolicy-failurepolicy.html#cfn-resiliencehub-resiliencypolicy-failurepolicy-rpoinsecs
         */
        readonly rpoInSecs: number;
        /**
         * The Recovery Time Objective (RTO), in seconds.
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resiliencehub-resiliencypolicy-failurepolicy.html#cfn-resiliencehub-resiliencypolicy-failurepolicy-rtoinsecs
         */
        readonly rtoInSecs: number;
    }
}
