"use strict";Object.defineProperty(exports,"__esModule",{value:!0}),exports.handler=void 0;const client_route_53_1=require("@aws-sdk/client-route-53"),credential_providers_1=require("@aws-sdk/credential-providers");async function handler(event){const resourceProps=event.ResourceProperties;switch(event.RequestType){case"Create":case"Update":return cfnEventHandler(resourceProps,!1);case"Delete":return cfnEventHandler(resourceProps,!0)}}exports.handler=handler;async function cfnEventHandler(props,isDeleteEvent){const{AssumeRoleArn,ParentZoneId,ParentZoneName,DelegatedZoneName,DelegatedZoneNameServers,TTL,UseRegionalStsEndpoint}=props;if(!ParentZoneId&&!ParentZoneName)throw Error("One of ParentZoneId or ParentZoneName must be specified");const timestamp=new Date().getTime(),route53=new client_route_53_1.Route53({credentials:(0,credential_providers_1.fromTemporaryCredentials)({clientConfig:{useGlobalEndpoint:!UseRegionalStsEndpoint},params:{RoleArn:AssumeRoleArn,RoleSessionName:`cross-account-zone-delegation-${timestamp}`}})}),parentZoneId=ParentZoneId??await getHostedZoneIdByName(ParentZoneName,route53);await route53.changeResourceRecordSets({HostedZoneId:parentZoneId,ChangeBatch:{Changes:[{Action:isDeleteEvent?"DELETE":"UPSERT",ResourceRecordSet:{Name:DelegatedZoneName,Type:"NS",TTL,ResourceRecords:DelegatedZoneNameServers.map(ns=>({Value:ns}))}}]}})}async function getHostedZoneIdByName(name,route53){const matchedZones=(await route53.listHostedZonesByName({DNSName:name})).HostedZones?.filter(zone=>zone.Name===`${name}.`)??[];if(matchedZones&&matchedZones.length!==1)throw Error(`Expected one hosted zone to match the given name but found ${matchedZones.length}`);return matchedZones[0].Id}
