import * as constructs from 'constructs';
import * as cdk from '../../core';
import * as cfn_parse from '../../core/lib/helpers-internal';
/**
 * Properties for defining a `CfnAutomationRule`
 *
 * @struct
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-securityhub-automationrule.html
 */
export interface CfnAutomationRuleProps {
    /**
     * One or more actions to update finding fields if a finding matches the defined criteria of the rule.
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-securityhub-automationrule.html#cfn-securityhub-automationrule-actions
     */
    readonly actions?: Array<CfnAutomationRule.AutomationRulesActionProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * A set of [AWS Security Finding Format](https://docs.aws.amazon.com/securityhub/latest/userguide/securityhub-findings-format.html) finding field attributes and corresponding expected values that Security Hub uses to filter findings. If a rule is enabled and a finding matches the conditions specified in this parameter, Security Hub applies the rule action to the finding.
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-securityhub-automationrule.html#cfn-securityhub-automationrule-criteria
     */
    readonly criteria?: CfnAutomationRule.AutomationRulesFindingFiltersProperty | cdk.IResolvable;
    /**
     * A description of the rule.
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-securityhub-automationrule.html#cfn-securityhub-automationrule-description
     */
    readonly description?: string;
    /**
     * Specifies whether a rule is the last to be applied with respect to a finding that matches the rule criteria. This is useful when a finding matches the criteria for multiple rules, and each rule has different actions. If the value of this field is set to `true` for a rule, Security Hub applies the rule action to a finding that matches the rule criteria and doesn't evaluate other rules for the finding. The default value of this field is `false` .
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-securityhub-automationrule.html#cfn-securityhub-automationrule-isterminal
     */
    readonly isTerminal?: boolean | cdk.IResolvable;
    /**
     * The name of the rule.
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-securityhub-automationrule.html#cfn-securityhub-automationrule-rulename
     */
    readonly ruleName?: string;
    /**
     * An integer ranging from 1 to 1000 that represents the order in which the rule action is applied to findings. Security Hub applies rules with lower values for this parameter first.
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-securityhub-automationrule.html#cfn-securityhub-automationrule-ruleorder
     */
    readonly ruleOrder?: number;
    /**
     * Whether the rule is active after it is created. If this parameter is equal to `ENABLED` , Security Hub applies the rule to findings and finding updates after the rule is created.
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-securityhub-automationrule.html#cfn-securityhub-automationrule-rulestatus
     */
    readonly ruleStatus?: string;
    /**
     * User-defined tags that help you label the purpose of a rule.
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-securityhub-automationrule.html#cfn-securityhub-automationrule-tags
     */
    readonly tags?: {
        [key: string]: (string);
    };
}
/**
 * A CloudFormation `AWS::SecurityHub::AutomationRule`
 *
 * The `AWS::SecurityHub::AutomationRule` resource specifies an automation rule based on input parameters. For more information, see [Automation rules](https://docs.aws.amazon.com/securityhub/latest/userguide/automation-rules.html) in the *AWS Security Hub User Guide* .
 *
 * @cloudformationResource AWS::SecurityHub::AutomationRule
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-securityhub-automationrule.html
 */
export declare class CfnAutomationRule extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::SecurityHub::AutomationRule";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: constructs.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnAutomationRule;
    /**
     * A timestamp that indicates when the rule was created.
     *
     * Uses the `date-time` format specified in [RFC 3339 section 5.6, Internet Date/Time Format](https://docs.aws.amazon.com/https://tools.ietf.org/html/rfc3339#section-5.6) . The value cannot contain spaces. For example, `2020-03-22T13:22:13.933Z` .
     * @cloudformationAttribute CreatedAt
     */
    readonly attrCreatedAt: string;
    /**
     * The principal that created the rule. For example, `arn:aws:sts::123456789012:assumed-role/Developer-Role/JaneDoe` .
     * @cloudformationAttribute CreatedBy
     */
    readonly attrCreatedBy: string;
    /**
     * The Amazon Resource Name (ARN) of the automation rule that you create. For example, `arn:aws:securityhub:us-east-1:123456789012:automation-rule/a1b2c3d4-5678-90ab-cdef-EXAMPLE11111` .
     * @cloudformationAttribute RuleArn
     */
    readonly attrRuleArn: string;
    /**
     * A timestamp that indicates when the rule was most recently updated.
     *
     * Uses the `date-time` format specified in [RFC 3339 section 5.6, Internet Date/Time Format](https://docs.aws.amazon.com/https://tools.ietf.org/html/rfc3339#section-5.6) . The value cannot contain spaces. For example, `2020-03-22T13:22:13.933Z` .
     * @cloudformationAttribute UpdatedAt
     */
    readonly attrUpdatedAt: string;
    /**
     * One or more actions to update finding fields if a finding matches the defined criteria of the rule.
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-securityhub-automationrule.html#cfn-securityhub-automationrule-actions
     */
    actions: Array<CfnAutomationRule.AutomationRulesActionProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * A set of [AWS Security Finding Format](https://docs.aws.amazon.com/securityhub/latest/userguide/securityhub-findings-format.html) finding field attributes and corresponding expected values that Security Hub uses to filter findings. If a rule is enabled and a finding matches the conditions specified in this parameter, Security Hub applies the rule action to the finding.
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-securityhub-automationrule.html#cfn-securityhub-automationrule-criteria
     */
    criteria: CfnAutomationRule.AutomationRulesFindingFiltersProperty | cdk.IResolvable | undefined;
    /**
     * A description of the rule.
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-securityhub-automationrule.html#cfn-securityhub-automationrule-description
     */
    description: string | undefined;
    /**
     * Specifies whether a rule is the last to be applied with respect to a finding that matches the rule criteria. This is useful when a finding matches the criteria for multiple rules, and each rule has different actions. If the value of this field is set to `true` for a rule, Security Hub applies the rule action to a finding that matches the rule criteria and doesn't evaluate other rules for the finding. The default value of this field is `false` .
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-securityhub-automationrule.html#cfn-securityhub-automationrule-isterminal
     */
    isTerminal: boolean | cdk.IResolvable | undefined;
    /**
     * The name of the rule.
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-securityhub-automationrule.html#cfn-securityhub-automationrule-rulename
     */
    ruleName: string | undefined;
    /**
     * An integer ranging from 1 to 1000 that represents the order in which the rule action is applied to findings. Security Hub applies rules with lower values for this parameter first.
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-securityhub-automationrule.html#cfn-securityhub-automationrule-ruleorder
     */
    ruleOrder: number | undefined;
    /**
     * Whether the rule is active after it is created. If this parameter is equal to `ENABLED` , Security Hub applies the rule to findings and finding updates after the rule is created.
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-securityhub-automationrule.html#cfn-securityhub-automationrule-rulestatus
     */
    ruleStatus: string | undefined;
    /**
     * User-defined tags that help you label the purpose of a rule.
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-securityhub-automationrule.html#cfn-securityhub-automationrule-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::SecurityHub::AutomationRule`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: constructs.Construct, id: string, props?: CfnAutomationRuleProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     */
    inspect(inspector: cdk.TreeInspector): void;
    protected get cfnProperties(): {
        [key: string]: any;
    };
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
export declare namespace CfnAutomationRule {
    /**
     * One or more actions to update finding fields if a finding matches the defined criteria of the rule.
     *
     * @struct
     * @stability external
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrule-automationrulesaction.html
     */
    interface AutomationRulesActionProperty {
        /**
         * Specifies that the automation rule action is an update to a finding field.
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrule-automationrulesaction.html#cfn-securityhub-automationrule-automationrulesaction-findingfieldsupdate
         */
        readonly findingFieldsUpdate: CfnAutomationRule.AutomationRulesFindingFieldsUpdateProperty | cdk.IResolvable;
        /**
         * Specifies that the rule action should update the `Types` finding field. The `Types` finding field classifies findings in the format of namespace/category/classifier. For more information, see [Types taxonomy for ASFF](https://docs.aws.amazon.com/securityhub/latest/userguide/securityhub-findings-format-type-taxonomy.html) in the *AWS Security Hub User Guide* .
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrule-automationrulesaction.html#cfn-securityhub-automationrule-automationrulesaction-type
         */
        readonly type: string;
    }
}
export declare namespace CfnAutomationRule {
    /**
     * Identifies the finding fields that the automation rule action updates when a finding matches the defined criteria.
     *
     * @struct
     * @stability external
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrule-automationrulesfindingfieldsupdate.html
     */
    interface AutomationRulesFindingFieldsUpdateProperty {
        /**
         * The rule action updates the `Confidence` field of a finding.
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrule-automationrulesfindingfieldsupdate.html#cfn-securityhub-automationrule-automationrulesfindingfieldsupdate-confidence
         */
        readonly confidence?: number;
        /**
         * The rule action updates the `Criticality` field of a finding.
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrule-automationrulesfindingfieldsupdate.html#cfn-securityhub-automationrule-automationrulesfindingfieldsupdate-criticality
         */
        readonly criticality?: number;
        /**
         * The rule action will update the `Note` field of a finding.
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrule-automationrulesfindingfieldsupdate.html#cfn-securityhub-automationrule-automationrulesfindingfieldsupdate-note
         */
        readonly note?: CfnAutomationRule.NoteUpdateProperty | cdk.IResolvable;
        /**
         * The rule action will update the `RelatedFindings` field of a finding.
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrule-automationrulesfindingfieldsupdate.html#cfn-securityhub-automationrule-automationrulesfindingfieldsupdate-relatedfindings
         */
        readonly relatedFindings?: Array<CfnAutomationRule.RelatedFindingProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * The rule action will update the `Severity` field of a finding.
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrule-automationrulesfindingfieldsupdate.html#cfn-securityhub-automationrule-automationrulesfindingfieldsupdate-severity
         */
        readonly severity?: CfnAutomationRule.SeverityUpdateProperty | cdk.IResolvable;
        /**
         * The rule action updates the `Types` field of a finding.
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrule-automationrulesfindingfieldsupdate.html#cfn-securityhub-automationrule-automationrulesfindingfieldsupdate-types
         */
        readonly types?: string[];
        /**
         * The rule action updates the `UserDefinedFields` field of a finding.
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrule-automationrulesfindingfieldsupdate.html#cfn-securityhub-automationrule-automationrulesfindingfieldsupdate-userdefinedfields
         */
        readonly userDefinedFields?: {
            [key: string]: (string);
        } | cdk.IResolvable;
        /**
         * The rule action updates the `VerificationState` field of a finding.
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrule-automationrulesfindingfieldsupdate.html#cfn-securityhub-automationrule-automationrulesfindingfieldsupdate-verificationstate
         */
        readonly verificationState?: string;
        /**
         * The rule action will update the `Workflow` field of a finding.
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrule-automationrulesfindingfieldsupdate.html#cfn-securityhub-automationrule-automationrulesfindingfieldsupdate-workflow
         */
        readonly workflow?: CfnAutomationRule.WorkflowUpdateProperty | cdk.IResolvable;
    }
}
export declare namespace CfnAutomationRule {
    /**
     * The criteria that determine which findings a rule applies to.
     *
     * @struct
     * @stability external
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrule-automationrulesfindingfilters.html
     */
    interface AutomationRulesFindingFiltersProperty {
        /**
         * The AWS account ID in which a finding was generated.
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrule-automationrulesfindingfilters.html#cfn-securityhub-automationrule-automationrulesfindingfilters-awsaccountid
         */
        readonly awsAccountId?: Array<CfnAutomationRule.StringFilterProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * The name of the company for the product that generated the finding. For control-based findings, the company is AWS .
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrule-automationrulesfindingfilters.html#cfn-securityhub-automationrule-automationrulesfindingfilters-companyname
         */
        readonly companyName?: Array<CfnAutomationRule.StringFilterProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * The unique identifier of a standard in which a control is enabled. This field consists of the resource portion of the Amazon Resource Name (ARN) returned for a standard in the [DescribeStandards](https://docs.aws.amazon.com/securityhub/1.0/APIReference/API_DescribeStandards.html) API response.
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrule-automationrulesfindingfilters.html#cfn-securityhub-automationrule-automationrulesfindingfilters-complianceassociatedstandardsid
         */
        readonly complianceAssociatedStandardsId?: Array<CfnAutomationRule.StringFilterProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * The security control ID for which a finding was generated. Security control IDs are the same across standards.
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrule-automationrulesfindingfilters.html#cfn-securityhub-automationrule-automationrulesfindingfilters-compliancesecuritycontrolid
         */
        readonly complianceSecurityControlId?: Array<CfnAutomationRule.StringFilterProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * The result of a security check. This field is only used for findings generated from controls.
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrule-automationrulesfindingfilters.html#cfn-securityhub-automationrule-automationrulesfindingfilters-compliancestatus
         */
        readonly complianceStatus?: Array<CfnAutomationRule.StringFilterProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * The likelihood that a finding accurately identifies the behavior or issue that it was intended to identify. `Confidence` is scored on a 0–100 basis using a ratio scale. A value of `0` means 0 percent confidence, and a value of `100` means 100 percent confidence. For example, a data exfiltration detection based on a statistical deviation of network traffic has low confidence because an actual exfiltration hasn't been verified. For more information, see [Confidence](https://docs.aws.amazon.com/securityhub/latest/userguide/asff-top-level-attributes.html#asff-confidence) in the *AWS Security Hub User Guide* .
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrule-automationrulesfindingfilters.html#cfn-securityhub-automationrule-automationrulesfindingfilters-confidence
         */
        readonly confidence?: Array<CfnAutomationRule.NumberFilterProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * A timestamp that indicates when this finding record was created.
         *
         * Uses the `date-time` format specified in [RFC 3339 section 5.6, Internet Date/Time Format](https://docs.aws.amazon.com/https://tools.ietf.org/html/rfc3339#section-5.6) . The value cannot contain spaces. For example, `2020-03-22T13:22:13.933Z` .
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrule-automationrulesfindingfilters.html#cfn-securityhub-automationrule-automationrulesfindingfilters-createdat
         */
        readonly createdAt?: Array<CfnAutomationRule.DateFilterProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * The level of importance that is assigned to the resources that are associated with a finding. `Criticality` is scored on a 0–100 basis, using a ratio scale that supports only full integers. A score of `0` means that the underlying resources have no criticality, and a score of `100` is reserved for the most critical resources. For more information, see [Criticality](https://docs.aws.amazon.com/securityhub/latest/userguide/asff-top-level-attributes.html#asff-criticality) in the *AWS Security Hub User Guide* .
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrule-automationrulesfindingfilters.html#cfn-securityhub-automationrule-automationrulesfindingfilters-criticality
         */
        readonly criticality?: Array<CfnAutomationRule.NumberFilterProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * A finding's description.
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrule-automationrulesfindingfilters.html#cfn-securityhub-automationrule-automationrulesfindingfilters-description
         */
        readonly description?: Array<CfnAutomationRule.StringFilterProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * A timestamp that indicates when the potential security issue captured by a finding was first observed by the security findings product.
         *
         * Uses the `date-time` format specified in [RFC 3339 section 5.6, Internet Date/Time Format](https://docs.aws.amazon.com/https://tools.ietf.org/html/rfc3339#section-5.6) . The value cannot contain spaces. For example, `2020-03-22T13:22:13.933Z` .
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrule-automationrulesfindingfilters.html#cfn-securityhub-automationrule-automationrulesfindingfilters-firstobservedat
         */
        readonly firstObservedAt?: Array<CfnAutomationRule.DateFilterProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * The identifier for the solution-specific component that generated a finding.
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrule-automationrulesfindingfilters.html#cfn-securityhub-automationrule-automationrulesfindingfilters-generatorid
         */
        readonly generatorId?: Array<CfnAutomationRule.StringFilterProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * The product-specific identifier for a finding.
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrule-automationrulesfindingfilters.html#cfn-securityhub-automationrule-automationrulesfindingfilters-id
         */
        readonly id?: Array<CfnAutomationRule.StringFilterProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * A timestamp that indicates when the potential security issue captured by a finding was most recently observed by the security findings product.
         *
         * Uses the `date-time` format specified in [RFC 3339 section 5.6, Internet Date/Time Format](https://docs.aws.amazon.com/https://tools.ietf.org/html/rfc3339#section-5.6) . The value cannot contain spaces. For example, `2020-03-22T13:22:13.933Z` .
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrule-automationrulesfindingfilters.html#cfn-securityhub-automationrule-automationrulesfindingfilters-lastobservedat
         */
        readonly lastObservedAt?: Array<CfnAutomationRule.DateFilterProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * The text of a user-defined note that's added to a finding.
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrule-automationrulesfindingfilters.html#cfn-securityhub-automationrule-automationrulesfindingfilters-notetext
         */
        readonly noteText?: Array<CfnAutomationRule.StringFilterProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * The timestamp of when the note was updated. Uses the date-time format specified in [RFC 3339 section 5.6, Internet Date/Time Format](https://docs.aws.amazon.com/https://www.rfc-editor.org/rfc/rfc3339#section-5.6) . The value cannot contain spaces. For example, `2020-03-22T13:22:13.933Z` .
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrule-automationrulesfindingfilters.html#cfn-securityhub-automationrule-automationrulesfindingfilters-noteupdatedat
         */
        readonly noteUpdatedAt?: Array<CfnAutomationRule.DateFilterProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * The principal that created a note.
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrule-automationrulesfindingfilters.html#cfn-securityhub-automationrule-automationrulesfindingfilters-noteupdatedby
         */
        readonly noteUpdatedBy?: Array<CfnAutomationRule.StringFilterProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * The Amazon Resource Name (ARN) for a third-party product that generated a finding in Security Hub.
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrule-automationrulesfindingfilters.html#cfn-securityhub-automationrule-automationrulesfindingfilters-productarn
         */
        readonly productArn?: Array<CfnAutomationRule.StringFilterProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * Provides the name of the product that generated the finding. For control-based findings, the product name is Security Hub.
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrule-automationrulesfindingfilters.html#cfn-securityhub-automationrule-automationrulesfindingfilters-productname
         */
        readonly productName?: Array<CfnAutomationRule.StringFilterProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * Provides the current state of a finding.
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrule-automationrulesfindingfilters.html#cfn-securityhub-automationrule-automationrulesfindingfilters-recordstate
         */
        readonly recordState?: Array<CfnAutomationRule.StringFilterProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * The product-generated identifier for a related finding.
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrule-automationrulesfindingfilters.html#cfn-securityhub-automationrule-automationrulesfindingfilters-relatedfindingsid
         */
        readonly relatedFindingsId?: Array<CfnAutomationRule.StringFilterProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * The ARN for the product that generated a related finding.
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrule-automationrulesfindingfilters.html#cfn-securityhub-automationrule-automationrulesfindingfilters-relatedfindingsproductarn
         */
        readonly relatedFindingsProductArn?: Array<CfnAutomationRule.StringFilterProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * Custom fields and values about the resource that a finding pertains to.
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrule-automationrulesfindingfilters.html#cfn-securityhub-automationrule-automationrulesfindingfilters-resourcedetailsother
         */
        readonly resourceDetailsOther?: Array<CfnAutomationRule.MapFilterProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * The identifier for the given resource type. For AWS resources that are identified by Amazon Resource Names (ARNs), this is the ARN. For AWS resources that lack ARNs, this is the identifier as defined by the AWS service that created the resource. For non- AWS resources, this is a unique identifier that is associated with the resource.
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrule-automationrulesfindingfilters.html#cfn-securityhub-automationrule-automationrulesfindingfilters-resourceid
         */
        readonly resourceId?: Array<CfnAutomationRule.StringFilterProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * The partition in which the resource that the finding pertains to is located. A partition is a group of AWS Regions . Each AWS account is scoped to one partition.
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrule-automationrulesfindingfilters.html#cfn-securityhub-automationrule-automationrulesfindingfilters-resourcepartition
         */
        readonly resourcePartition?: Array<CfnAutomationRule.StringFilterProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * The AWS Region where the resource that a finding pertains to is located.
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrule-automationrulesfindingfilters.html#cfn-securityhub-automationrule-automationrulesfindingfilters-resourceregion
         */
        readonly resourceRegion?: Array<CfnAutomationRule.StringFilterProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * A list of AWS tags associated with a resource at the time the finding was processed.
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrule-automationrulesfindingfilters.html#cfn-securityhub-automationrule-automationrulesfindingfilters-resourcetags
         */
        readonly resourceTags?: Array<CfnAutomationRule.MapFilterProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * A finding's title.
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrule-automationrulesfindingfilters.html#cfn-securityhub-automationrule-automationrulesfindingfilters-resourcetype
         */
        readonly resourceType?: Array<CfnAutomationRule.StringFilterProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * The severity value of the finding.
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrule-automationrulesfindingfilters.html#cfn-securityhub-automationrule-automationrulesfindingfilters-severitylabel
         */
        readonly severityLabel?: Array<CfnAutomationRule.StringFilterProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * Provides a URL that links to a page about the current finding in the finding product.
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrule-automationrulesfindingfilters.html#cfn-securityhub-automationrule-automationrulesfindingfilters-sourceurl
         */
        readonly sourceUrl?: Array<CfnAutomationRule.StringFilterProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * A finding's title.
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrule-automationrulesfindingfilters.html#cfn-securityhub-automationrule-automationrulesfindingfilters-title
         */
        readonly title?: Array<CfnAutomationRule.StringFilterProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * One or more finding types in the format of namespace/category/classifier that classify a finding. For a list of namespaces, classifiers, and categories, see [Types taxonomy for ASFF](https://docs.aws.amazon.com/securityhub/latest/userguide/securityhub-findings-format-type-taxonomy.html) in the *AWS Security Hub User Guide* .
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrule-automationrulesfindingfilters.html#cfn-securityhub-automationrule-automationrulesfindingfilters-type
         */
        readonly type?: Array<CfnAutomationRule.StringFilterProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * A timestamp that indicates when the finding record was most recently updated.
         *
         * Uses the `date-time` format specified in [RFC 3339 section 5.6, Internet Date/Time Format](https://docs.aws.amazon.com/https://tools.ietf.org/html/rfc3339#section-5.6) . The value cannot contain spaces. For example, `2020-03-22T13:22:13.933Z` .
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrule-automationrulesfindingfilters.html#cfn-securityhub-automationrule-automationrulesfindingfilters-updatedat
         */
        readonly updatedAt?: Array<CfnAutomationRule.DateFilterProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * A list of user-defined name and value string pairs added to a finding.
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrule-automationrulesfindingfilters.html#cfn-securityhub-automationrule-automationrulesfindingfilters-userdefinedfields
         */
        readonly userDefinedFields?: Array<CfnAutomationRule.MapFilterProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * Provides the veracity of a finding.
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrule-automationrulesfindingfilters.html#cfn-securityhub-automationrule-automationrulesfindingfilters-verificationstate
         */
        readonly verificationState?: Array<CfnAutomationRule.StringFilterProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * Provides information about the status of the investigation into a finding.
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrule-automationrulesfindingfilters.html#cfn-securityhub-automationrule-automationrulesfindingfilters-workflowstatus
         */
        readonly workflowStatus?: Array<CfnAutomationRule.StringFilterProperty | cdk.IResolvable> | cdk.IResolvable;
    }
}
export declare namespace CfnAutomationRule {
    /**
     * A date filter for querying findings.
     *
     * @struct
     * @stability external
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrule-datefilter.html
     */
    interface DateFilterProperty {
        /**
         * A date range for the date filter.
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrule-datefilter.html#cfn-securityhub-automationrule-datefilter-daterange
         */
        readonly dateRange?: CfnAutomationRule.DateRangeProperty | cdk.IResolvable;
        /**
         * A timestamp that provides the end date for the date filter.
         *
         * A correctly formatted example is `2020-05-21T20:16:34.724Z` . The value cannot contain spaces, and date and time should be separated by `T` . For more information, see [RFC 3339 section 5.6, Internet Date/Time Format](https://docs.aws.amazon.com/https://www.rfc-editor.org/rfc/rfc3339#section-5.6) .
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrule-datefilter.html#cfn-securityhub-automationrule-datefilter-end
         */
        readonly end?: string;
        /**
         * A timestamp that provides the start date for the date filter.
         *
         * A correctly formatted example is `2020-05-21T20:16:34.724Z` . The value cannot contain spaces, and date and time should be separated by `T` . For more information, see [RFC 3339 section 5.6, Internet Date/Time Format](https://docs.aws.amazon.com/https://www.rfc-editor.org/rfc/rfc3339#section-5.6) .
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrule-datefilter.html#cfn-securityhub-automationrule-datefilter-start
         */
        readonly start?: string;
    }
}
export declare namespace CfnAutomationRule {
    /**
     * A date range for the date filter.
     *
     * @struct
     * @stability external
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrule-daterange.html
     */
    interface DateRangeProperty {
        /**
         * A date range unit for the date filter.
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrule-daterange.html#cfn-securityhub-automationrule-daterange-unit
         */
        readonly unit: string;
        /**
         * A date range value for the date filter.
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrule-daterange.html#cfn-securityhub-automationrule-daterange-value
         */
        readonly value: number;
    }
}
export declare namespace CfnAutomationRule {
    /**
     * A map filter for querying findings. Each map filter provides the field to check, the value to look for, and the comparison operator.
     *
     * @struct
     * @stability external
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrule-mapfilter.html
     */
    interface MapFilterProperty {
        /**
         * The condition to apply to the key value when querying for findings with a map filter.
         *
         * To search for values that exactly match the filter value, use `EQUALS` . For example, for the `ResourceTags` field, the filter `Department EQUALS Security` matches findings that have the value `Security` for the tag `Department` .
         *
         * To search for values other than the filter value, use `NOT_EQUALS` . For example, for the `ResourceTags` field, the filter `Department NOT_EQUALS Finance` matches findings that do not have the value `Finance` for the tag `Department` .
         *
         * `EQUALS` filters on the same field are joined by `OR` . A finding matches if it matches any one of those filters.
         *
         * `NOT_EQUALS` filters on the same field are joined by `AND` . A finding matches only if it matches all of those filters.
         *
         * You cannot have both an `EQUALS` filter and a `NOT_EQUALS` filter on the same field.
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrule-mapfilter.html#cfn-securityhub-automationrule-mapfilter-comparison
         */
        readonly comparison: string;
        /**
         * The key of the map filter. For example, for `ResourceTags` , `Key` identifies the name of the tag. For `UserDefinedFields` , `Key` is the name of the field.
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrule-mapfilter.html#cfn-securityhub-automationrule-mapfilter-key
         */
        readonly key: string;
        /**
         * The value for the key in the map filter. Filter values are case sensitive. For example, one of the values for a tag called `Department` might be `Security` . If you provide `security` as the filter value, then there is no match.
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrule-mapfilter.html#cfn-securityhub-automationrule-mapfilter-value
         */
        readonly value: string;
    }
}
export declare namespace CfnAutomationRule {
    /**
     * The updated note.
     *
     * @struct
     * @stability external
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrule-noteupdate.html
     */
    interface NoteUpdateProperty {
        /**
         * The updated note text.
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrule-noteupdate.html#cfn-securityhub-automationrule-noteupdate-text
         */
        readonly text: string;
        /**
         * The principal that updated the note.
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrule-noteupdate.html#cfn-securityhub-automationrule-noteupdate-updatedby
         */
        readonly updatedBy: any | cdk.IResolvable;
    }
}
export declare namespace CfnAutomationRule {
    /**
     * A number filter for querying findings.
     *
     * @struct
     * @stability external
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrule-numberfilter.html
     */
    interface NumberFilterProperty {
        /**
         * The equal-to condition to be applied to a single field when querying for findings.
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrule-numberfilter.html#cfn-securityhub-automationrule-numberfilter-eq
         */
        readonly eq?: number;
        /**
         * The greater-than-equal condition to be applied to a single field when querying for findings.
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrule-numberfilter.html#cfn-securityhub-automationrule-numberfilter-gte
         */
        readonly gte?: number;
        /**
         * The less-than-equal condition to be applied to a single field when querying for findings.
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrule-numberfilter.html#cfn-securityhub-automationrule-numberfilter-lte
         */
        readonly lte?: number;
    }
}
export declare namespace CfnAutomationRule {
    /**
     * Provides details about a list of findings that the current finding relates to.
     *
     * @struct
     * @stability external
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrule-relatedfinding.html
     */
    interface RelatedFindingProperty {
        /**
         * The product-generated identifier for a related finding.
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrule-relatedfinding.html#cfn-securityhub-automationrule-relatedfinding-id
         */
        readonly id: any | cdk.IResolvable;
        /**
         * The Amazon Resource Name (ARN) for the product that generated a related finding.
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrule-relatedfinding.html#cfn-securityhub-automationrule-relatedfinding-productarn
         */
        readonly productArn: string;
    }
}
export declare namespace CfnAutomationRule {
    /**
     * Updates to the severity information for a finding.
     *
     * @struct
     * @stability external
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrule-severityupdate.html
     */
    interface SeverityUpdateProperty {
        /**
         * The severity value of the finding. The allowed values are the following.
         *
         * - `INFORMATIONAL` - No issue was found.
         * - `LOW` - The issue does not require action on its own.
         * - `MEDIUM` - The issue must be addressed but not urgently.
         * - `HIGH` - The issue must be addressed as a priority.
         * - `CRITICAL` - The issue must be remediated immediately to avoid it escalating.
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrule-severityupdate.html#cfn-securityhub-automationrule-severityupdate-label
         */
        readonly label?: string;
        /**
         * The normalized severity for the finding. This attribute is to be deprecated in favor of `Label` .
         *
         * If you provide `Normalized` and do not provide `Label` , `Label` is set automatically as follows.
         *
         * - 0 - `INFORMATIONAL`
         * - 1–39 - `LOW`
         * - 40–69 - `MEDIUM`
         * - 70–89 - `HIGH`
         * - 90–100 - `CRITICAL`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrule-severityupdate.html#cfn-securityhub-automationrule-severityupdate-normalized
         */
        readonly normalized?: number;
        /**
         * The native severity as defined by the AWS service or integrated partner product that generated the finding.
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrule-severityupdate.html#cfn-securityhub-automationrule-severityupdate-product
         */
        readonly product?: number;
    }
}
export declare namespace CfnAutomationRule {
    /**
     * A string filter for querying findings.
     *
     * @struct
     * @stability external
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrule-stringfilter.html
     */
    interface StringFilterProperty {
        /**
         * The condition to apply to a string value when querying for findings. To search for values that contain the filter criteria value, use one of the following comparison operators:
         *
         * - To search for values that exactly match the filter value, use `EQUALS` .
         *
         * For example, the filter `ResourceType EQUALS AwsEc2SecurityGroup` only matches findings that have a resource type of `AwsEc2SecurityGroup` .
         * - To search for values that start with the filter value, use `PREFIX` .
         *
         * For example, the filter `ResourceType PREFIX AwsIam` matches findings that have a resource type that starts with `AwsIam` . Findings with a resource type of `AwsIamPolicy` , `AwsIamRole` , or `AwsIamUser` would all match.
         *
         * `EQUALS` and `PREFIX` filters on the same field are joined by `OR` . A finding matches if it matches any one of those filters.
         *
         * To search for values that do not contain the filter criteria value, use one of the following comparison operators:
         *
         * - To search for values that do not exactly match the filter value, use `NOT_EQUALS` .
         *
         * For example, the filter `ResourceType NOT_EQUALS AwsIamPolicy` matches findings that have a resource type other than `AwsIamPolicy` .
         * - To search for values that do not start with the filter value, use `PREFIX_NOT_EQUALS` .
         *
         * For example, the filter `ResourceType PREFIX_NOT_EQUALS AwsIam` matches findings that have a resource type that does not start with `AwsIam` . Findings with a resource type of `AwsIamPolicy` , `AwsIamRole` , or `AwsIamUser` would all be excluded from the results.
         *
         * `NOT_EQUALS` and `PREFIX_NOT_EQUALS` filters on the same field are joined by `AND` . A finding matches only if it matches all of those filters.
         *
         * For filters on the same field, you cannot provide both an `EQUALS` filter and a `NOT_EQUALS` or `PREFIX_NOT_EQUALS` filter. Combining filters in this way always returns an error, even if the provided filter values would return valid results.
         *
         * You can combine `PREFIX` filters with `NOT_EQUALS` or `PREFIX_NOT_EQUALS` filters for the same field. Security Hub first processes the `PREFIX` filters, then the `NOT_EQUALS` or `PREFIX_NOT_EQUALS` filters.
         *
         * For example, for the following filter, Security Hub first identifies findings that have resource types that start with either `AwsIAM` or `AwsEc2` . It then excludes findings that have a resource type of `AwsIamPolicy` and findings that have a resource type of `AwsEc2NetworkInterface` .
         *
         * - `ResourceType PREFIX AwsIam`
         * - `ResourceType PREFIX AwsEc2`
         * - `ResourceType NOT_EQUALS AwsIamPolicy`
         * - `ResourceType NOT_EQUALS AwsEc2NetworkInterface`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrule-stringfilter.html#cfn-securityhub-automationrule-stringfilter-comparison
         */
        readonly comparison: string;
        /**
         * The string filter value. Filter values are case sensitive. For example, the product name for control-based findings is `Security Hub` . If you provide `security hub` as the filter text, then there is no match.
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrule-stringfilter.html#cfn-securityhub-automationrule-stringfilter-value
         */
        readonly value: string;
    }
}
export declare namespace CfnAutomationRule {
    /**
     * Used to update information about the investigation into the finding.
     *
     * @struct
     * @stability external
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrule-workflowupdate.html
     */
    interface WorkflowUpdateProperty {
        /**
         * The status of the investigation into the finding. The workflow status is specific to an individual finding. It does not affect the generation of new findings. For example, setting the workflow status to `SUPPRESSED` or `RESOLVED` does not prevent a new finding for the same issue.
         *
         * The allowed values are the following.
         *
         * - `NEW` - The initial state of a finding, before it is reviewed.
         *
         * Security Hub also resets `WorkFlowStatus` from `NOTIFIED` or `RESOLVED` to `NEW` in the following cases:
         *
         * - The record state changes from `ARCHIVED` to `ACTIVE` .
         * - The compliance status changes from `PASSED` to either `WARNING` , `FAILED` , or `NOT_AVAILABLE` .
         * - `NOTIFIED` - Indicates that you notified the resource owner about the security issue. Used when the initial reviewer is not the resource owner, and needs intervention from the resource owner.
         * - `RESOLVED` - The finding was reviewed and remediated and is now considered resolved.
         * - `SUPPRESSED` - Indicates that you reviewed the finding and do not believe that any action is needed. The finding is no longer updated.
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-automationrule-workflowupdate.html#cfn-securityhub-automationrule-workflowupdate-status
         */
        readonly status: string;
    }
}
/**
 * Properties for defining a `CfnHub`
 *
 * @struct
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-securityhub-hub.html
 */
export interface CfnHubProps {
    /**
     * Whether to automatically enable new controls when they are added to standards that are enabled.
     *
     * By default, this is set to `true` , and new controls are enabled automatically. To not automatically enable new controls, set this to `false` .
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-securityhub-hub.html#cfn-securityhub-hub-autoenablecontrols
     */
    readonly autoEnableControls?: boolean | cdk.IResolvable;
    /**
     * Specifies whether an account has consolidated control findings turned on or off. If the value for this field is set to `SECURITY_CONTROL` , Security Hub generates a single finding for a control check even when the check applies to multiple enabled standards.
     *
     * If the value for this field is set to `STANDARD_CONTROL` , Security Hub generates separate findings for a control check when the check applies to multiple enabled standards.
     *
     * The value for this field in a member account matches the value in the administrator account. For accounts that aren't part of an organization, the default value of this field is `SECURITY_CONTROL` if you enabled Security Hub on or after February 23, 2023.
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-securityhub-hub.html#cfn-securityhub-hub-controlfindinggenerator
     */
    readonly controlFindingGenerator?: string;
    /**
     * Whether to enable the security standards that Security Hub has designated as automatically enabled. If you don't provide a value for `EnableDefaultStandards` , it is set to `true` , and the designated standards are automatically enabled in each AWS Region where you enable Security Hub . If you don't want to enable the designated standards, set `EnableDefaultStandards` to `false` .
     *
     * Currently, the automatically enabled standards are the Center for Internet Security (CIS) AWS Foundations Benchmark v1.2.0 and AWS Foundational Security Best Practices (FSBP).
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-securityhub-hub.html#cfn-securityhub-hub-enabledefaultstandards
     */
    readonly enableDefaultStandards?: boolean | cdk.IResolvable;
    /**
     * An array of key-value pairs to apply to this resource.
     *
     * For more information, see [Tag](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html) .
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-securityhub-hub.html#cfn-securityhub-hub-tags
     */
    readonly tags?: any;
}
/**
 * A CloudFormation `AWS::SecurityHub::Hub`
 *
 * The `AWS::SecurityHub::Hub` resource specifies the enablement of the AWS Security Hub service in your AWS account . The service is enabled in the current AWS Region or the specified Region. You create a separate `Hub` resource in each Region in which you want to enable Security Hub .
 *
 * When you use this resource to enable Security Hub , default security standards are enabled. To disable default standards, set the `EnableDefaultStandards` property to `false` . You can use the [`AWS::SecurityHub::Standard`](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-securityhub-standard.html) resource to enable additional standards.
 *
 * When you use this resource to enable Security Hub , new controls are automatically enabled for your enabled standards. To disable automatic enablement of new controls, set the `AutoEnableControls` property to `false` .
 *
 * You must create an `AWS::SecurityHub::Hub` resource for an account before you can create other types of Security Hub resources for the account through AWS CloudFormation . Use a [DependsOn attribute](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-attribute-dependson.html) , such as `"DependsOn": "Hub"` , to ensure that you've created an `AWS::SecurityHub::Hub` resource before creating other Security Hub resources for an account.
 *
 * @cloudformationResource AWS::SecurityHub::Hub
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-securityhub-hub.html
 */
export declare class CfnHub extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::SecurityHub::Hub";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: constructs.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnHub;
    /**
     * Whether to automatically enable new controls when they are added to standards that are enabled.
     *
     * By default, this is set to `true` , and new controls are enabled automatically. To not automatically enable new controls, set this to `false` .
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-securityhub-hub.html#cfn-securityhub-hub-autoenablecontrols
     */
    autoEnableControls: boolean | cdk.IResolvable | undefined;
    /**
     * Specifies whether an account has consolidated control findings turned on or off. If the value for this field is set to `SECURITY_CONTROL` , Security Hub generates a single finding for a control check even when the check applies to multiple enabled standards.
     *
     * If the value for this field is set to `STANDARD_CONTROL` , Security Hub generates separate findings for a control check when the check applies to multiple enabled standards.
     *
     * The value for this field in a member account matches the value in the administrator account. For accounts that aren't part of an organization, the default value of this field is `SECURITY_CONTROL` if you enabled Security Hub on or after February 23, 2023.
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-securityhub-hub.html#cfn-securityhub-hub-controlfindinggenerator
     */
    controlFindingGenerator: string | undefined;
    /**
     * Whether to enable the security standards that Security Hub has designated as automatically enabled. If you don't provide a value for `EnableDefaultStandards` , it is set to `true` , and the designated standards are automatically enabled in each AWS Region where you enable Security Hub . If you don't want to enable the designated standards, set `EnableDefaultStandards` to `false` .
     *
     * Currently, the automatically enabled standards are the Center for Internet Security (CIS) AWS Foundations Benchmark v1.2.0 and AWS Foundational Security Best Practices (FSBP).
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-securityhub-hub.html#cfn-securityhub-hub-enabledefaultstandards
     */
    enableDefaultStandards: boolean | cdk.IResolvable | undefined;
    /**
     * An array of key-value pairs to apply to this resource.
     *
     * For more information, see [Tag](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html) .
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-securityhub-hub.html#cfn-securityhub-hub-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::SecurityHub::Hub`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: constructs.Construct, id: string, props?: CfnHubProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     */
    inspect(inspector: cdk.TreeInspector): void;
    protected get cfnProperties(): {
        [key: string]: any;
    };
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `CfnStandard`
 *
 * @struct
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-securityhub-standard.html
 */
export interface CfnStandardProps {
    /**
     * The ARN of the standard that you want to enable. To view a list of available Security Hub standards and their ARNs, use the [`DescribeStandards`](https://docs.aws.amazon.com/securityhub/1.0/APIReference/API_DescribeStandards.html) API operation.
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-securityhub-standard.html#cfn-securityhub-standard-standardsarn
     */
    readonly standardsArn: string;
    /**
     * Specifies which controls are to be disabled in a standard.
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-securityhub-standard.html#cfn-securityhub-standard-disabledstandardscontrols
     */
    readonly disabledStandardsControls?: Array<CfnStandard.StandardsControlProperty | cdk.IResolvable> | cdk.IResolvable;
}
/**
 * A CloudFormation `AWS::SecurityHub::Standard`
 *
 * The `AWS::SecurityHub::Standard` resource specifies the enablement of a security standard. The standard is identified by the `StandardsArn` property. To view a list of Security Hub standards and their Amazon Resource Names (ARNs), use the [`DescribeStandards`](https://docs.aws.amazon.com/securityhub/1.0/APIReference/API_DescribeStandards.html) API operation.
 *
 * You must create a separate `AWS::SecurityHub::Standard` resource for each standard that you want to enable.
 *
 * For more information about Security Hub standards, see [Security Hub standards reference](https://docs.aws.amazon.com/securityhub/latest/userguide/standards-reference.html) in the *AWS Security Hub User Guide* .
 *
 * @cloudformationResource AWS::SecurityHub::Standard
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-securityhub-standard.html
 */
export declare class CfnStandard extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::SecurityHub::Standard";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: constructs.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnStandard;
    /**
     * The ARN of a resource that represents your subscription to a supported standard.
     * @cloudformationAttribute StandardsSubscriptionArn
     */
    readonly attrStandardsSubscriptionArn: string;
    /**
     * The ARN of the standard that you want to enable. To view a list of available Security Hub standards and their ARNs, use the [`DescribeStandards`](https://docs.aws.amazon.com/securityhub/1.0/APIReference/API_DescribeStandards.html) API operation.
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-securityhub-standard.html#cfn-securityhub-standard-standardsarn
     */
    standardsArn: string;
    /**
     * Specifies which controls are to be disabled in a standard.
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-securityhub-standard.html#cfn-securityhub-standard-disabledstandardscontrols
     */
    disabledStandardsControls: Array<CfnStandard.StandardsControlProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * Create a new `AWS::SecurityHub::Standard`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: constructs.Construct, id: string, props: CfnStandardProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     */
    inspect(inspector: cdk.TreeInspector): void;
    protected get cfnProperties(): {
        [key: string]: any;
    };
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
export declare namespace CfnStandard {
    /**
     * Provides details about an individual security control. For a list of Security Hub controls, see [Security Hub controls reference](https://docs.aws.amazon.com/securityhub/latest/userguide/securityhub-controls-reference.html) in the *AWS Security Hub User Guide* .
     *
     * @struct
     * @stability external
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-standard-standardscontrol.html
     */
    interface StandardsControlProperty {
        /**
         * A user-defined reason for changing a control's enablement status in a specified standard. If you are disabling a control, then this property is required.
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-standard-standardscontrol.html#cfn-securityhub-standard-standardscontrol-reason
         */
        readonly reason?: string;
        /**
         * The Amazon Resource Name (ARN) of the control.
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securityhub-standard-standardscontrol.html#cfn-securityhub-standard-standardscontrol-standardscontrolarn
         */
        readonly standardsControlArn: string;
    }
}
