"use strict";var _a;Object.defineProperty(exports,"__esModule",{value:!0}),exports.Portfolio=void 0;const jsiiDeprecationWarnings=require("../../.warnings.jsii.js"),JSII_RTTI_SYMBOL_1=Symbol.for("jsii.rtti"),association_manager_1=require("./private/association-manager"),util_1=require("./private/util"),validation_1=require("./private/validation"),servicecatalog_generated_1=require("./servicecatalog.generated"),iam=require("../../aws-iam"),cdk=require("../../core");class PortfolioBase extends cdk.Resource{constructor(){super(...arguments),this.associatedPrincipals=new Set,this.assetBuckets=new Set,this.sharedAccounts=[]}giveAccessToRole(role){this.associatePrincipal(role.roleArn,role.node.addr)}giveAccessToUser(user){this.associatePrincipal(user.userArn,user.node.addr)}giveAccessToGroup(group){this.associatePrincipal(group.groupArn,group.node.addr)}addProduct(product){if(product.assetBuckets)for(const bucket of product.assetBuckets)this.assetBuckets.add(bucket);association_manager_1.AssociationManager.associateProductWithPortfolio(this,product,void 0)}shareWithAccount(accountId,options={}){const hashId=this.generateUniqueHash(accountId);this.sharedAccounts.push(accountId),new servicecatalog_generated_1.CfnPortfolioShare(this,`PortfolioShare${hashId}`,{portfolioId:this.portfolioId,accountId,shareTagOptions:options.shareTagOptions,acceptLanguage:options.messageLanguage})}associateTagOptions(tagOptions){association_manager_1.AssociationManager.associateTagOptions(this,this.portfolioId,tagOptions)}constrainTagUpdates(product,options={}){association_manager_1.AssociationManager.constrainTagUpdates(this,product,options)}notifyOnStackEvents(product,topic,options={}){association_manager_1.AssociationManager.notifyOnStackEvents(this,product,topic,options)}constrainCloudFormationParameters(product,options){association_manager_1.AssociationManager.constrainCloudFormationParameters(this,product,options)}setLaunchRole(product,launchRole,options={}){association_manager_1.AssociationManager.setLaunchRole(this,product,launchRole,options)}setLocalLaunchRoleName(product,launchRoleName,options={}){const launchRole=new iam.Role(this,`LaunchRole${launchRoleName}`,{roleName:launchRoleName,assumedBy:new iam.ServicePrincipal("servicecatalog.amazonaws.com")});return association_manager_1.AssociationManager.setLocalLaunchRoleName(this,product,launchRole.roleName,options),launchRole}setLocalLaunchRole(product,launchRole,options={}){validation_1.InputValidator.validateRoleNameSetForLocalLaunchRole(launchRole),association_manager_1.AssociationManager.setLocalLaunchRoleName(this,product,launchRole.roleName,options)}deployWithStackSets(product,options){association_manager_1.AssociationManager.deployWithStackSets(this,product,options)}associatePrincipal(principalArn,principalId){if(!this.associatedPrincipals.has(principalArn)){const hashId=this.generateUniqueHash(principalId);new servicecatalog_generated_1.CfnPortfolioPrincipalAssociation(this,`PortolioPrincipalAssociation${hashId}`,{portfolioId:this.portfolioId,principalArn,principalType:"IAM"}),this.associatedPrincipals.add(principalArn)}}addBucketPermissionsToSharedAccounts(){if(this.sharedAccounts.length>0)for(const bucket of this.assetBuckets)bucket.grantRead(new iam.CompositePrincipal(...this.sharedAccounts.map(account=>new iam.AccountPrincipal(account))))}}class Portfolio extends PortfolioBase{static fromPortfolioArn(scope,id,portfolioArn){const portfolioId=cdk.Stack.of(scope).splitArn(portfolioArn,cdk.ArnFormat.SLASH_RESOURCE_NAME).resourceName;if(!portfolioId)throw new Error("Missing required Portfolio ID from Portfolio ARN: "+portfolioArn);class Import extends PortfolioBase{constructor(){super(...arguments),this.portfolioArn=portfolioArn,this.portfolioId=portfolioId}generateUniqueHash(value){return(0,util_1.hashValues)(this.portfolioArn,value)}}return new Import(scope,id,{environmentFromArn:portfolioArn})}constructor(scope,id,props){super(scope,id);try{jsiiDeprecationWarnings.aws_cdk_lib_aws_servicecatalog_PortfolioProps(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,Portfolio),error}this.validatePortfolioProps(props),this.portfolio=new servicecatalog_generated_1.CfnPortfolio(this,"Resource",{displayName:props.displayName,providerName:props.providerName,description:props.description,acceptLanguage:props.messageLanguage}),this.portfolioId=this.portfolio.ref,this.portfolioArn=cdk.Stack.of(this).formatArn({service:"catalog",resource:"portfolio",resourceName:this.portfolioId}),props.tagOptions!==void 0&&this.associateTagOptions(props.tagOptions);const portfolioNodeId=this.node.id;cdk.Aspects.of(this).add({visit(c){c.node.id===portfolioNodeId&&c.addBucketPermissionsToSharedAccounts()}})}generateUniqueHash(value){return(0,util_1.hashValues)(cdk.Names.nodeUniqueId(this.portfolio.node),value)}validatePortfolioProps(props){validation_1.InputValidator.validateLength(this.node.path,"portfolio display name",1,100,props.displayName),validation_1.InputValidator.validateLength(this.node.path,"portfolio provider name",1,50,props.providerName),validation_1.InputValidator.validateLength(this.node.path,"portfolio description",0,2e3,props.description)}}_a=JSII_RTTI_SYMBOL_1,Portfolio[_a]={fqn:"aws-cdk-lib.aws_servicecatalog.Portfolio",version:"2.87.0"},exports.Portfolio=Portfolio;
