import { IBucket } from '../../../aws-s3';
import * as cdk from '../../../core';
/**
 * Deployment environment for an AWS Service Catalog product stack.
 *
 * Interoperates with the StackSynthesizer of the parent stack.
 */
export declare class ProductStackSynthesizer extends cdk.StackSynthesizer {
    private readonly assetBucket?;
    private bucketDeployment?;
    constructor(assetBucket?: IBucket);
    addFileAsset(asset: cdk.FileAssetSource): cdk.FileAssetLocation;
    private physicalNameOfBucket;
    addDockerImageAsset(_asset: cdk.DockerImageAssetSource): cdk.DockerImageAssetLocation;
    synthesize(session: cdk.ISynthesisSession): void;
}
