"use strict";Object.defineProperty(exports,"__esModule",{value:!0}),exports.InputValidator=void 0;const cdk=require("../../../core");class InputValidator{static validateLength(resourceName,inputName,minLength,maxLength,inputString){if(!cdk.Token.isUnresolved(inputString)&&inputString!==void 0&&(inputString.length<minLength||inputString.length>maxLength))throw new Error(`Invalid ${inputName} for resource ${resourceName}, must have length between ${minLength} and ${maxLength}, got: '${this.truncateString(inputString,100)}'`)}static validateRegex(resourceName,inputName,regexp,inputString){if(!cdk.Token.isUnresolved(inputString)&&inputString!==void 0&&!regexp.test(inputString))throw new Error(`Invalid ${inputName} for resource ${resourceName}, must match regex pattern ${regexp}, got: '${this.truncateString(inputString,100)}'`)}static validateUrl(resourceName,inputName,inputString){this.validateRegex(resourceName,inputName,/^https?:\/\/.*/,inputString)}static validateEmail(resourceName,inputName,inputString){this.validateRegex(resourceName,inputName,/^[\w\d.%+\-]+@[a-z\d.\-]+\.[a-z]{2,4}$/i,inputString)}static validateRoleNameSetForLocalLaunchRole(role){if(role.node.defaultChild&&cdk.Token.isUnresolved(role.node.defaultChild.roleName))throw new Error(`Role ${role.node.id} used for Local Launch Role must have roleName explicitly set`)}static truncateString(string,maxLength){return string.length>maxLength?string.substring(0,maxLength)+"[truncated]":string}}exports.InputValidator=InputValidator;
