"use strict";var _a;Object.defineProperty(exports,"__esModule",{value:!0}),exports.SqsSubscription=void 0;const jsiiDeprecationWarnings=require("../../.warnings.jsii.js"),JSII_RTTI_SYMBOL_1=Symbol.for("jsii.rtti"),constructs_1=require("constructs"),iam=require("../../aws-iam"),sns=require("../../aws-sns"),core_1=require("../../core"),cxapi=require("../../cx-api");class SqsSubscription{constructor(queue,props={}){this.queue=queue,this.props=props;try{jsiiDeprecationWarnings.aws_cdk_lib_aws_sqs_IQueue(queue),jsiiDeprecationWarnings.aws_cdk_lib_aws_sns_subscriptions_SqsSubscriptionProps(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,SqsSubscription),error}}bind(topic){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_sns_ITopic(topic)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.bind),error}if(!(this.queue instanceof constructs_1.Construct))throw new Error("The supplied Queue object must be an instance of Construct");const snsServicePrincipal=new iam.ServicePrincipal("sns.amazonaws.com"),queuePolicyDependable=this.queue.addToResourcePolicy(new iam.PolicyStatement({resources:[this.queue.queueArn],actions:["sqs:SendMessage"],principals:[snsServicePrincipal],conditions:{ArnEquals:{"aws:SourceArn":topic.topicArn}}})).policyDependable;return this.queue.encryptionMasterKey&&this.queue.encryptionMasterKey.addToResourcePolicy(new iam.PolicyStatement({resources:["*"],actions:["kms:Decrypt","kms:GenerateDataKey"],principals:[snsServicePrincipal],conditions:core_1.FeatureFlags.of(topic).isEnabled(cxapi.SNS_SUBSCRIPTIONS_SQS_DECRYPTION_POLICY)?{ArnEquals:{"aws:SourceArn":topic.topicArn}}:void 0})),topic instanceof sns.Topic&&topic.stack!==this.queue.stack&&this.queue.stack.addDependency(topic.stack),{subscriberScope:this.queue,subscriberId:core_1.Names.nodeUniqueId(topic.node),endpoint:this.queue.queueArn,protocol:sns.SubscriptionProtocol.SQS,rawMessageDelivery:this.props.rawMessageDelivery,filterPolicy:this.props.filterPolicy,filterPolicyWithMessageBody:this.props.filterPolicyWithMessageBody,region:this.regionFromArn(topic),deadLetterQueue:this.props.deadLetterQueue,subscriptionDependency:queuePolicyDependable}}regionFromArn(topic){return topic instanceof sns.Topic?topic.stack!==this.queue.stack&&!core_1.Token.isUnresolved(topic.env.region)&&topic.env.region!==this.queue.env.region?topic.env.region:void 0:core_1.Stack.of(topic).splitArn(topic.topicArn,core_1.ArnFormat.SLASH_RESOURCE_NAME).region}}_a=JSII_RTTI_SYMBOL_1,SqsSubscription[_a]={fqn:"aws-cdk-lib.aws_sns_subscriptions.SqsSubscription",version:"2.87.0"},exports.SqsSubscription=SqsSubscription;
