"use strict";var _a;Object.defineProperty(exports,"__esModule",{value:!0}),exports.Queue=exports.FifoThroughputLimit=exports.DeduplicationScope=exports.QueueEncryption=void 0;const jsiiDeprecationWarnings=require("../../.warnings.jsii.js"),JSII_RTTI_SYMBOL_1=Symbol.for("jsii.rtti"),queue_base_1=require("./queue-base"),sqs_generated_1=require("./sqs.generated"),validate_props_1=require("./validate-props"),iam=require("../../aws-iam"),kms=require("../../aws-kms"),core_1=require("../../core");var QueueEncryption;(function(QueueEncryption2){QueueEncryption2.UNENCRYPTED="NONE",QueueEncryption2.KMS_MANAGED="KMS_MANAGED",QueueEncryption2.KMS="KMS",QueueEncryption2.SQS_MANAGED="SQS_MANAGED"})(QueueEncryption=exports.QueueEncryption||(exports.QueueEncryption={}));var DeduplicationScope;(function(DeduplicationScope2){DeduplicationScope2.MESSAGE_GROUP="messageGroup",DeduplicationScope2.QUEUE="queue"})(DeduplicationScope=exports.DeduplicationScope||(exports.DeduplicationScope={}));var FifoThroughputLimit;(function(FifoThroughputLimit2){FifoThroughputLimit2.PER_QUEUE="perQueue",FifoThroughputLimit2.PER_MESSAGE_GROUP_ID="perMessageGroupId"})(FifoThroughputLimit=exports.FifoThroughputLimit||(exports.FifoThroughputLimit={}));class Queue extends queue_base_1.QueueBase{static fromQueueArn(scope,id,queueArn){return Queue.fromQueueAttributes(scope,id,{queueArn})}static fromQueueAttributes(scope,id,attrs){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_sqs_QueueAttributes(attrs)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.fromQueueAttributes),error}const stack=core_1.Stack.of(scope),parsedArn=stack.splitArn(attrs.queueArn,core_1.ArnFormat.NO_RESOURCE_NAME),queueName=attrs.queueName||parsedArn.resource,queueUrl=attrs.queueUrl||`https://sqs.${parsedArn.region}.${stack.urlSuffix}/${parsedArn.account}/${queueName}`;class Import extends queue_base_1.QueueBase{constructor(){super(...arguments),this.queueArn=attrs.queueArn,this.queueUrl=queueUrl,this.queueName=queueName,this.encryptionMasterKey=attrs.keyArn?kms.Key.fromKeyArn(this,"Key",attrs.keyArn):void 0,this.fifo=this.determineFifo(),this.autoCreatePolicy=!1}determineFifo(){if(core_1.Token.isUnresolved(this.queueArn))return attrs.fifo||!1;if(typeof attrs.fifo<"u"){if(attrs.fifo&&!queueName.endsWith(".fifo"))throw new Error("FIFO queue names must end in '.fifo'");if(!attrs.fifo&&queueName.endsWith(".fifo"))throw new Error("Non-FIFO queue name may not end in '.fifo'")}return!!queueName.endsWith(".fifo")}}return new Import(scope,id)}constructor(scope,id,props={}){super(scope,id,{physicalName:props.queueName}),this.autoCreatePolicy=!0;try{jsiiDeprecationWarnings.aws_cdk_lib_aws_sqs_QueueProps(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,Queue),error}(0,validate_props_1.validateProps)(props);const redrivePolicy=props.deadLetterQueue?{deadLetterTargetArn:props.deadLetterQueue.queue.queueArn,maxReceiveCount:props.deadLetterQueue.maxReceiveCount}:void 0,{encryptionMasterKey,encryptionProps}=_determineEncryptionProps.call(this),fifoProps=this.determineFifoProps(props);this.fifo=fifoProps.fifoQueue||!1;const queue=new sqs_generated_1.CfnQueue(this,"Resource",{queueName:this.physicalName,...fifoProps,...encryptionProps,redrivePolicy,delaySeconds:props.deliveryDelay&&props.deliveryDelay.toSeconds(),maximumMessageSize:props.maxMessageSizeBytes,messageRetentionPeriod:props.retentionPeriod&&props.retentionPeriod.toSeconds(),receiveMessageWaitTimeSeconds:props.receiveMessageWaitTime&&props.receiveMessageWaitTime.toSeconds(),visibilityTimeout:props.visibilityTimeout&&props.visibilityTimeout.toSeconds()});queue.applyRemovalPolicy(props.removalPolicy??core_1.RemovalPolicy.DESTROY),this.queueArn=this.getResourceArnAttribute(queue.attrArn,{service:"sqs",resource:this.physicalName}),this.queueName=this.getResourceNameAttribute(queue.attrQueueName),this.encryptionMasterKey=encryptionMasterKey,this.queueUrl=queue.ref,this.deadLetterQueue=props.deadLetterQueue;function _determineEncryptionProps(){let encryption=props.encryption;if(encryption===QueueEncryption.SQS_MANAGED&&props.encryptionMasterKey)throw new Error("'encryptionMasterKey' is not supported if encryption type 'SQS_MANAGED' is used");if(encryption!==QueueEncryption.KMS&&props.encryptionMasterKey&&(encryption=QueueEncryption.KMS),!encryption)return{encryptionProps:{}};if(encryption===QueueEncryption.UNENCRYPTED)return{encryptionProps:{sqsManagedSseEnabled:!1}};if(encryption===QueueEncryption.KMS_MANAGED)return{encryptionProps:{kmsMasterKeyId:"alias/aws/sqs",kmsDataKeyReusePeriodSeconds:props.dataKeyReuse&&props.dataKeyReuse.toSeconds()}};if(encryption===QueueEncryption.KMS){const masterKey=props.encryptionMasterKey||new kms.Key(this,"Key",{description:`Created by ${this.node.path}`});return{encryptionMasterKey:masterKey,encryptionProps:{kmsMasterKeyId:masterKey.keyArn,kmsDataKeyReusePeriodSeconds:props.dataKeyReuse&&props.dataKeyReuse.toSeconds()}}}if(encryption===QueueEncryption.SQS_MANAGED)return{encryptionProps:{sqsManagedSseEnabled:!0}};throw new Error(`Unexpected 'encryptionType': ${encryption}`)}props.enforceSSL&&this.enforceSSLStatement()}determineFifoProps(props){let fifoQueue=props.fifo;const queueName=props.queueName;if(typeof fifoQueue>"u"&&queueName&&!core_1.Token.isUnresolved(queueName)&&queueName.endsWith(".fifo")&&(fifoQueue=!0),typeof fifoQueue>"u"&&props.contentBasedDeduplication&&(fifoQueue=!0),typeof fifoQueue>"u"&&props.deduplicationScope&&(fifoQueue=!0),typeof fifoQueue>"u"&&props.fifoThroughputLimit&&(fifoQueue=!0),typeof queueName=="string"){if(fifoQueue&&!queueName.endsWith(".fifo"))throw new Error("FIFO queue names must end in '.fifo'");if(!fifoQueue&&queueName.endsWith(".fifo"))throw new Error("Non-FIFO queue name may not end in '.fifo'")}if(props.contentBasedDeduplication&&!fifoQueue)throw new Error("Content-based deduplication can only be defined for FIFO queues");if(props.deduplicationScope&&!fifoQueue)throw new Error("Deduplication scope can only be defined for FIFO queues");if(props.fifoThroughputLimit&&!fifoQueue)throw new Error("FIFO throughput limit can only be defined for FIFO queues");return{contentBasedDeduplication:props.contentBasedDeduplication,deduplicationScope:props.deduplicationScope,fifoThroughputLimit:props.fifoThroughputLimit,fifoQueue}}enforceSSLStatement(){const statement=new iam.PolicyStatement({actions:["sqs:*"],conditions:{Bool:{"aws:SecureTransport":"false"}},effect:iam.Effect.DENY,resources:[this.queueArn],principals:[new iam.AnyPrincipal]});this.addToResourcePolicy(statement)}}_a=JSII_RTTI_SYMBOL_1,Queue[_a]={fqn:"aws-cdk-lib.aws_sqs.Queue",version:"2.87.0"},exports.Queue=Queue;
