"use strict";var _a;Object.defineProperty(exports,"__esModule",{value:!0}),exports.EncryptionOption=exports.AthenaStartQueryExecution=void 0;const jsiiDeprecationWarnings=require("../../../.warnings.jsii.js"),JSII_RTTI_SYMBOL_1=Symbol.for("jsii.rtti"),iam=require("../../../aws-iam"),sfn=require("../../../aws-stepfunctions"),cdk=require("../../../core"),task_utils_1=require("../private/task-utils");class AthenaStartQueryExecution extends sfn.TaskStateBase{constructor(scope,id,props){super(scope,id,props),this.props=props;try{jsiiDeprecationWarnings.aws_cdk_lib_aws_stepfunctions_tasks_AthenaStartQueryExecutionProps(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,AthenaStartQueryExecution),error}this.integrationPattern=props.integrationPattern??sfn.IntegrationPattern.REQUEST_RESPONSE,(0,task_utils_1.validatePatternSupported)(this.integrationPattern,AthenaStartQueryExecution.SUPPORTED_INTEGRATION_PATTERNS),this.taskPolicies=this.createPolicyStatements()}createPolicyStatements(){const policyStatements=[new iam.PolicyStatement({resources:[cdk.Stack.of(this).formatArn({service:"athena",resource:"datacatalog",resourceName:this.props.queryExecutionContext?.catalogName??"AwsDataCatalog"}),cdk.Stack.of(this).formatArn({service:"athena",resource:"workgroup",resourceName:this.props.workGroup??"primary"})],actions:["athena:getDataCatalog","athena:startQueryExecution","athena:getQueryExecution"]})];return policyStatements.push(new iam.PolicyStatement({actions:["s3:CreateBucket","s3:ListBucket","s3:GetBucketLocation","s3:GetObject"],resources:["*"]})),policyStatements.push(new iam.PolicyStatement({actions:["s3:AbortMultipartUpload","s3:ListBucketMultipartUploads","s3:ListMultipartUploadParts","s3:PutObject"],resources:[this.props.resultConfiguration?.outputLocation?.bucketName?cdk.Stack.of(this).formatArn({region:"",account:"",service:"s3",resource:this.props.resultConfiguration?.outputLocation?.bucketName,resourceName:`${this.props.resultConfiguration?.outputLocation?.objectKey}/*`}):"*"]})),policyStatements.push(new iam.PolicyStatement({actions:["lakeformation:GetDataAccess"],resources:["*"]})),policyStatements.push(new iam.PolicyStatement({actions:["glue:BatchCreatePartition","glue:BatchDeletePartition","glue:BatchDeleteTable","glue:BatchGetPartition","glue:CreateDatabase","glue:CreatePartition","glue:CreateTable","glue:DeleteDatabase","glue:DeletePartition","glue:DeleteTable","glue:GetDatabase","glue:GetDatabases","glue:GetPartition","glue:GetPartitions","glue:GetTable","glue:GetTables","glue:UpdateDatabase","glue:UpdatePartition","glue:UpdateTable"],resources:[cdk.Stack.of(this).formatArn({service:"glue",resource:"catalog"}),cdk.Stack.of(this).formatArn({service:"glue",resource:"database",resourceName:this.props.queryExecutionContext?.databaseName??"default"}),cdk.Stack.of(this).formatArn({service:"glue",resource:"table",resourceName:(this.props.queryExecutionContext?.databaseName??"default")+"/*"}),cdk.Stack.of(this).formatArn({service:"glue",resource:"userDefinedFunction",resourceName:(this.props.queryExecutionContext?.databaseName??"default")+"/*"})]})),policyStatements}renderEncryption(){return this.props.resultConfiguration?.encryptionConfiguration!==void 0?{EncryptionOption:this.props.resultConfiguration.encryptionConfiguration.encryptionOption,KmsKey:this.props.resultConfiguration.encryptionConfiguration.encryptionKey}:void 0}_renderTask(){return{Resource:(0,task_utils_1.integrationResourceArn)("athena","startQueryExecution",this.integrationPattern),Parameters:sfn.FieldUtils.renderObject({QueryString:this.props.queryString,ClientRequestToken:this.props.clientRequestToken,QueryExecutionContext:this.props.queryExecutionContext?.catalogName||this.props.queryExecutionContext?.databaseName?{Catalog:this.props.queryExecutionContext?.catalogName,Database:this.props.queryExecutionContext?.databaseName}:void 0,ResultConfiguration:{EncryptionConfiguration:this.renderEncryption(),OutputLocation:this.props.resultConfiguration?.outputLocation?`s3://${this.props.resultConfiguration.outputLocation.bucketName}/${this.props.resultConfiguration.outputLocation.objectKey}/`:void 0},WorkGroup:this.props?.workGroup})}}}_a=JSII_RTTI_SYMBOL_1,AthenaStartQueryExecution[_a]={fqn:"aws-cdk-lib.aws_stepfunctions_tasks.AthenaStartQueryExecution",version:"2.87.0"},AthenaStartQueryExecution.SUPPORTED_INTEGRATION_PATTERNS=[sfn.IntegrationPattern.REQUEST_RESPONSE,sfn.IntegrationPattern.RUN_JOB],exports.AthenaStartQueryExecution=AthenaStartQueryExecution;var EncryptionOption;(function(EncryptionOption2){EncryptionOption2.S3_MANAGED="SSE_S3",EncryptionOption2.KMS="SSE_KMS",EncryptionOption2.CLIENT_SIDE_KMS="CSE_KMS"})(EncryptionOption=exports.EncryptionOption||(exports.EncryptionOption={}));
