"use strict";var _a;Object.defineProperty(exports,"__esModule",{value:!0}),exports.SageMakerCreateModel=void 0;const jsiiDeprecationWarnings=require("../../../.warnings.jsii.js"),JSII_RTTI_SYMBOL_1=Symbol.for("jsii.rtti"),ec2=require("../../../aws-ec2"),iam=require("../../../aws-iam"),sfn=require("../../../aws-stepfunctions"),cdk=require("../../../core"),task_utils_1=require("../private/task-utils");class SageMakerCreateModel extends sfn.TaskStateBase{constructor(scope,id,props){super(scope,id,props),this.props=props,this.connections=new ec2.Connections,this.securityGroups=[];try{jsiiDeprecationWarnings.aws_cdk_lib_aws_stepfunctions_tasks_SageMakerCreateModelProps(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,SageMakerCreateModel),error}this.integrationPattern=props.integrationPattern||sfn.IntegrationPattern.REQUEST_RESPONSE,(0,task_utils_1.validatePatternSupported)(this.integrationPattern,SageMakerCreateModel.SUPPORTED_INTEGRATION_PATTERNS),props.vpc&&(this.vpc=props.vpc,this.subnets=props.subnetSelection?this.vpc.selectSubnets(props.subnetSelection).subnetIds:this.vpc.selectSubnets().subnetIds),this.role=this.props.role||this.createSagemakerRole(),this.grantPrincipal=this.role,this.taskPolicies=this.makePolicyStatements()}addSecurityGroup(securityGroup){try{jsiiDeprecationWarnings.aws_cdk_lib_aws_ec2_ISecurityGroup(securityGroup)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.addSecurityGroup),error}this.securityGroups.push(securityGroup)}_renderTask(){return{Resource:(0,task_utils_1.integrationResourceArn)("sagemaker","createModel",this.integrationPattern),Parameters:sfn.FieldUtils.renderObject(this.renderParameters())}}renderParameters(){return{EnableNetworkIsolation:this.props.enableNetworkIsolation,ExecutionRoleArn:this.role.roleArn,ModelName:this.props.modelName,Tags:this.props.tags?.value,PrimaryContainer:this.props.primaryContainer.bind(this).parameters,Containers:this.props.containers?.map(container=>container.bind(this)),...this.renderVpcConfig()}}makePolicyStatements(){const stack=cdk.Stack.of(this);return[new iam.PolicyStatement({actions:["sagemaker:CreateModel"],resources:[stack.formatArn({service:"sagemaker",resource:"model",resourceName:sfn.JsonPath.isEncodedJsonPath(this.props.modelName)?"*":`${this.props.modelName.toLowerCase()}*`})]}),new iam.PolicyStatement({actions:["sagemaker:ListTags"],resources:["*"]}),new iam.PolicyStatement({actions:["iam:PassRole"],resources:[this.role.roleArn],conditions:{StringEquals:{"iam:PassedToService":"sagemaker.amazonaws.com"}}})]}createSagemakerRole(){const role=new iam.Role(this,"SagemakerRole",{assumedBy:new iam.ServicePrincipal("sagemaker.amazonaws.com"),inlinePolicies:{CreateModel:new iam.PolicyDocument({statements:[new iam.PolicyStatement({actions:["cloudwatch:PutMetricData","logs:CreateLogStream","logs:CreateLogGroup","logs:PutLogEvents","logs:DescribeLogStreams","ecr:GetAuthorizationToken"],resources:["*"]})]})}});return this.props.vpc&&role.addToPrincipalPolicy(new iam.PolicyStatement({actions:["ec2:CreateNetworkInterface","ec2:CreateNetworkInterfacePermission","ec2:DeleteNetworkInterface","ec2:DeleteNetworkInterfacePermission","ec2:DescribeNetworkInterfaces","ec2:DescribeVpcs","ec2:DescribeDhcpOptions","ec2:DescribeSubnets","ec2:DescribeSecurityGroups"],resources:["*"]})),role}renderVpcConfig(){return this.vpc&&this.securityGroup===void 0&&(this.securityGroup=new ec2.SecurityGroup(this,"ModelSecurityGroup",{vpc:this.vpc}),this.connections.addSecurityGroup(this.securityGroup),this.securityGroups.push(this.securityGroup)),this.vpc?{VpcConfig:{SecurityGroupIds:cdk.Lazy.list({produce:()=>this.securityGroups.map(sg=>sg.securityGroupId)}),Subnets:this.subnets}}:{}}}_a=JSII_RTTI_SYMBOL_1,SageMakerCreateModel[_a]={fqn:"aws-cdk-lib.aws_stepfunctions_tasks.SageMakerCreateModel",version:"2.87.0"},SageMakerCreateModel.SUPPORTED_INTEGRATION_PATTERNS=[sfn.IntegrationPattern.REQUEST_RESPONSE],exports.SageMakerCreateModel=SageMakerCreateModel;
