"use strict";var _a;Object.defineProperty(exports,"__esModule",{value:!0}),exports.SageMakerCreateTransformJob=void 0;const jsiiDeprecationWarnings=require("../../../.warnings.jsii.js"),JSII_RTTI_SYMBOL_1=Symbol.for("jsii.rtti"),base_types_1=require("./base-types"),utils_1=require("./private/utils"),ec2=require("../../../aws-ec2"),iam=require("../../../aws-iam"),sfn=require("../../../aws-stepfunctions"),core_1=require("../../../core"),task_utils_1=require("../private/task-utils");class SageMakerCreateTransformJob extends sfn.TaskStateBase{constructor(scope,id,props){super(scope,id,props),this.props=props;try{jsiiDeprecationWarnings.aws_cdk_lib_aws_stepfunctions_tasks_SageMakerCreateTransformJobProps(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,SageMakerCreateTransformJob),error}this.integrationPattern=props.integrationPattern||sfn.IntegrationPattern.REQUEST_RESPONSE,(0,task_utils_1.validatePatternSupported)(this.integrationPattern,SageMakerCreateTransformJob.SUPPORTED_INTEGRATION_PATTERNS),props.role&&(this._role=props.role),this.transformInput=props.transformInput.transformDataSource.s3DataSource.s3DataType?props.transformInput:Object.assign({},props.transformInput,{transformDataSource:{s3DataSource:{...props.transformInput.transformDataSource.s3DataSource,s3DataType:base_types_1.S3DataType.S3_PREFIX}}}),this.transformResources=props.transformResources||{instanceCount:1,instanceType:ec2.InstanceType.of(ec2.InstanceClass.M4,ec2.InstanceSize.XLARGE)},this.taskPolicies=this.makePolicyStatements()}_renderTask(){return{Resource:(0,task_utils_1.integrationResourceArn)("sagemaker","createTransformJob",this.integrationPattern),Parameters:sfn.FieldUtils.renderObject(this.renderParameters())}}get role(){if(this._role===void 0)throw new Error("role not available yet--use the object in a Task first");return this._role}renderParameters(){return{...this.props.batchStrategy?{BatchStrategy:this.props.batchStrategy}:{},...(0,utils_1.renderEnvironment)(this.props.environment),...this.props.maxConcurrentTransforms?{MaxConcurrentTransforms:this.props.maxConcurrentTransforms}:{},...this.props.maxPayload?{MaxPayloadInMB:this.props.maxPayload.toMebibytes()}:{},...this.props.modelClientOptions?this.renderModelClientOptions(this.props.modelClientOptions):{},ModelName:this.props.modelName,...(0,utils_1.renderTags)(this.props.tags),...this.renderTransformInput(this.transformInput),TransformJobName:this.props.transformJobName,...this.renderTransformOutput(this.props.transformOutput),...this.renderTransformResources(this.transformResources)}}renderModelClientOptions(options){const retries=options.invocationsMaxRetries;if(!core_1.Token.isUnresolved(retries)&&retries&&(retries<0||retries>3))throw new Error(`invocationsMaxRetries should be between 0 and 3. Received: ${retries}.`);const timeout=options.invocationsTimeout?.toSeconds();if(!core_1.Token.isUnresolved(timeout)&&timeout&&(timeout<1||timeout>3600))throw new Error(`invocationsTimeout should be between 1 and 3600 seconds. Received: ${timeout}.`);return{ModelClientConfig:{InvocationsMaxRetries:retries??0,InvocationsTimeoutInSeconds:timeout??60}}}renderTransformInput(input){return{TransformInput:{...input.compressionType?{CompressionType:input.compressionType}:{},...input.contentType?{ContentType:input.contentType}:{},DataSource:{S3DataSource:{S3Uri:input.transformDataSource.s3DataSource.s3Uri,S3DataType:input.transformDataSource.s3DataSource.s3DataType}},...input.splitType?{SplitType:input.splitType}:{}}}}renderTransformOutput(output){return{TransformOutput:{S3OutputPath:output.s3OutputPath,...output.encryptionKey?{KmsKeyId:output.encryptionKey.keyArn}:{},...output.accept?{Accept:output.accept}:{},...output.assembleWith?{AssembleWith:output.assembleWith}:{}}}}renderTransformResources(resources){return{TransformResources:{InstanceCount:resources.instanceCount,InstanceType:sfn.JsonPath.isEncodedJsonPath(resources.instanceType.toString())?resources.instanceType.toString():`ml.${resources.instanceType}`,...resources.volumeEncryptionKey?{VolumeKmsKeyId:resources.volumeEncryptionKey.keyArn}:{}}}}makePolicyStatements(){const stack=core_1.Stack.of(this);this._role===void 0&&(this._role=new iam.Role(this,"SagemakerTransformRole",{assumedBy:new iam.ServicePrincipal("sagemaker.amazonaws.com"),managedPolicies:[iam.ManagedPolicy.fromAwsManagedPolicyName("AmazonSageMakerFullAccess")]}));const policyStatements=[new iam.PolicyStatement({actions:["sagemaker:CreateTransformJob","sagemaker:DescribeTransformJob","sagemaker:StopTransformJob"],resources:[stack.formatArn({service:"sagemaker",resource:"transform-job",resourceName:"*"})]}),new iam.PolicyStatement({actions:["sagemaker:ListTags"],resources:["*"]}),new iam.PolicyStatement({actions:["iam:PassRole"],resources:[this.role.roleArn],conditions:{StringEquals:{"iam:PassedToService":"sagemaker.amazonaws.com"}}})];return this.integrationPattern===sfn.IntegrationPattern.RUN_JOB&&policyStatements.push(new iam.PolicyStatement({actions:["events:PutTargets","events:PutRule","events:DescribeRule"],resources:[stack.formatArn({service:"events",resource:"rule",resourceName:"StepFunctionsGetEventsForSageMakerTransformJobsRule"})]})),policyStatements}}_a=JSII_RTTI_SYMBOL_1,SageMakerCreateTransformJob[_a]={fqn:"aws-cdk-lib.aws_stepfunctions_tasks.SageMakerCreateTransformJob",version:"2.87.0"},SageMakerCreateTransformJob.SUPPORTED_INTEGRATION_PATTERNS=[sfn.IntegrationPattern.REQUEST_RESPONSE,sfn.IntegrationPattern.RUN_JOB],exports.SageMakerCreateTransformJob=SageMakerCreateTransformJob;
