"use strict";var _a,_b,_c;Object.defineProperty(exports,"__esModule",{value:!0}),exports.DockerVolumeConsistency=exports.DockerImage=exports.BundlingDockerImage=exports.BundlingFileAccess=exports.BundlingOutput=exports.DockerBuildSecret=void 0;const jsiiDeprecationWarnings=require("../../.warnings.jsii.js"),JSII_RTTI_SYMBOL_1=Symbol.for("jsii.rtti"),child_process_1=require("child_process"),crypto=require("crypto"),path_1=require("path"),fs_1=require("./fs"),asset_staging_1=require("./private/asset-staging"),jsii_deprecated_1=require("./private/jsii-deprecated");class DockerBuildSecret{static fromSrc(src){return`src=${src}`}}_a=JSII_RTTI_SYMBOL_1,DockerBuildSecret[_a]={fqn:"aws-cdk-lib.DockerBuildSecret",version:"2.87.0"},exports.DockerBuildSecret=DockerBuildSecret;var BundlingOutput;(function(BundlingOutput2){BundlingOutput2.ARCHIVED="archived",BundlingOutput2.NOT_ARCHIVED="not-archived",BundlingOutput2.AUTO_DISCOVER="auto-discover"})(BundlingOutput=exports.BundlingOutput||(exports.BundlingOutput={}));var BundlingFileAccess;(function(BundlingFileAccess2){BundlingFileAccess2.VOLUME_COPY="VOLUME_COPY",BundlingFileAccess2.BIND_MOUNT="BIND_MOUNT"})(BundlingFileAccess=exports.BundlingFileAccess||(exports.BundlingFileAccess={}));class BundlingDockerImage{static fromRegistry(image){return new DockerImage(image)}static fromAsset(path,options={}){return DockerImage.fromBuild(path,options)}constructor(image,_imageHash){this.image=image,this._imageHash=_imageHash}toJSON(){return this._imageHash??this.image}run(options={}){const volumes=options.volumes||[],environment=options.environment||{},entrypoint=options.entrypoint?.[0]||null,command=[...options.entrypoint?.[1]?[...options.entrypoint.slice(1)]:[],...options.command?[...options.command]:[]],dockerArgs=["run","--rm",...options.securityOpt?["--security-opt",options.securityOpt]:[],...options.network?["--network",options.network]:[],...options.user?["-u",options.user]:[],...options.volumesFrom?flatten(options.volumesFrom.map(v=>["--volumes-from",v])):[],...flatten(volumes.map(v=>["-v",`${v.hostPath}:${v.containerPath}:${isSeLinux()?"z,":""}${v.consistency??DockerVolumeConsistency.DELEGATED}`])),...flatten(Object.entries(environment).map(([k,v])=>["--env",`${k}=${v}`])),...options.workingDirectory?["-w",options.workingDirectory]:[],...entrypoint?["--entrypoint",entrypoint]:[],this.image,...command];(0,asset_staging_1.dockerExec)(dockerArgs)}cp(imagePath,outputPath){const{stdout}=(0,asset_staging_1.dockerExec)(["create",this.image],{}),match=stdout.toString().match(/([0-9a-f]{16,})/);if(!match)throw new Error("Failed to extract container ID from Docker create output");const containerId=match[1],containerPath=`${containerId}:${imagePath}`,destPath=outputPath??fs_1.FileSystem.mkdtemp("cdk-docker-cp-");try{return(0,asset_staging_1.dockerExec)(["cp",containerPath,destPath]),destPath}catch(err){throw new Error(`Failed to copy files from ${containerPath} to ${destPath}: ${err}`)}finally{(0,asset_staging_1.dockerExec)(["rm","-v",containerId])}}}_b=JSII_RTTI_SYMBOL_1,BundlingDockerImage[_b]={fqn:"aws-cdk-lib.BundlingDockerImage",version:"2.87.0"},exports.BundlingDockerImage=BundlingDockerImage;class DockerImage extends BundlingDockerImage{static fromBuild(path,options={}){try{jsiiDeprecationWarnings.aws_cdk_lib_DockerBuildOptions(options)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.fromBuild),error}const buildArgs=options.buildArgs||{};if(options.file&&(0,path_1.isAbsolute)(options.file))throw new Error(`"file" must be relative to the docker build directory. Got ${options.file}`);const input=JSON.stringify({path,...options}),tag=`cdk-${crypto.createHash("sha256").update(input).digest("hex")}`,dockerArgs=["build","-t",tag,...options.file?["-f",(0,path_1.join)(path,options.file)]:[],...options.platform?["--platform",options.platform]:[],...options.targetStage?["--target",options.targetStage]:[],...flatten(Object.entries(buildArgs).map(([k,v])=>["--build-arg",`${k}=${v}`])),path];(0,asset_staging_1.dockerExec)(dockerArgs);const hash=fs_1.FileSystem.fingerprint(path,{extraHash:JSON.stringify(options)});return new DockerImage(tag,hash)}static fromRegistry(image){return new DockerImage(image)}constructor(image,_imageHash){const deprecated=(0,jsii_deprecated_1.quiet)();super(image,_imageHash),(0,jsii_deprecated_1.reset)(deprecated),this.image=image}toJSON(){const deprecated=(0,jsii_deprecated_1.quiet)(),json=super.toJSON();return(0,jsii_deprecated_1.reset)(deprecated),json}run(options={}){try{jsiiDeprecationWarnings.aws_cdk_lib_DockerRunOptions(options)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.run),error}const deprecated=(0,jsii_deprecated_1.quiet)(),result=super.run(options);return(0,jsii_deprecated_1.reset)(deprecated),result}cp(imagePath,outputPath){const deprecated=(0,jsii_deprecated_1.quiet)(),result=super.cp(imagePath,outputPath);return(0,jsii_deprecated_1.reset)(deprecated),result}}_c=JSII_RTTI_SYMBOL_1,DockerImage[_c]={fqn:"aws-cdk-lib.DockerImage",version:"2.87.0"},exports.DockerImage=DockerImage;var DockerVolumeConsistency;(function(DockerVolumeConsistency2){DockerVolumeConsistency2.CONSISTENT="consistent",DockerVolumeConsistency2.DELEGATED="delegated",DockerVolumeConsistency2.CACHED="cached"})(DockerVolumeConsistency=exports.DockerVolumeConsistency||(exports.DockerVolumeConsistency={}));function flatten(x){return Array.prototype.concat([],...x)}function isSeLinux(){if(process.platform!="linux")return!1;const prog="selinuxenabled",proc=(0,child_process_1.spawnSync)(prog,[],{stdio:["pipe",process.stderr,"inherit"]});return proc.error?!1:proc.status==0}
