"use strict";Object.defineProperty(exports,"__esModule",{value:!0}),exports.ExportWriter=void 0;const path=require("path"),constructs_1=require("constructs"),export_reader_provider_1=require("./export-reader-provider"),types_1=require("./types"),cfn_dynamic_reference_1=require("../../cfn-dynamic-reference"),custom_resource_1=require("../../custom-resource"),lazy_1=require("../../lazy"),uniqueid_1=require("../../private/uniqueid"),stack_1=require("../../stack"),token_1=require("../../token"),custom_resource_provider_1=require("../custom-resource-provider");class CRProvider extends custom_resource_provider_1.CustomResourceProvider{static getOrCreateProvider(scope,uniqueid,props){const id=`${uniqueid}CustomResourceProvider`,stack=stack_1.Stack.of(scope);return stack.node.tryFindChild(id)??new CRProvider(stack,id,props)}constructor(scope,id,props){super(scope,id,props),this.resourceArns=new Set,this.addToRolePolicy({Effect:"Allow",Resource:lazy_1.Lazy.list({produce:()=>Array.from(this.resourceArns)}),Action:["ssm:DeleteParameters","ssm:ListTagsForResource","ssm:GetParameters","ssm:PutParameter"]})}addResourceArn(arn){this.resourceArns.add(arn)}}class ExportWriter extends constructs_1.Construct{static getOrCreate(scope,uniqueId,props){const stack=stack_1.Stack.of(scope),existing=stack.node.tryFindChild(uniqueId);return existing||new ExportWriter(stack,uniqueId,{region:props.region})}constructor(scope,id,props){super(scope,id),this._references={};const stack=stack_1.Stack.of(this),region=props.region??stack.region,resourceType="Custom::CrossRegionExportWriter";this.provider=CRProvider.getOrCreateProvider(this,resourceType,{codeDirectory:path.join(__dirname,"cross-region-ssm-writer-handler"),runtime:custom_resource_provider_1.CustomResourceProviderRuntime.NODEJS_18_X}),this.addRegionToPolicy(region);const properties={region,exports:lazy_1.Lazy.any({produce:()=>this._references})};new custom_resource_1.CustomResource(this,"Resource",{resourceType,serviceToken:this.provider.serviceToken,properties:{WriterProps:properties}})}exportValue(exportName,reference,importStack){const stack=stack_1.Stack.of(this),parameterName=`/${types_1.SSM_EXPORT_PATH_PREFIX}${exportName}`,ref=new cfn_dynamic_reference_1.CfnDynamicReference(cfn_dynamic_reference_1.CfnDynamicReferenceService.SSM,parameterName);return this._references[parameterName]=stack.resolve(reference.toString()),this.addToExportReader(parameterName,ref,importStack)}addRegionToPolicy(region){token_1.Token.isUnresolved(region)||this.provider.addResourceArn(stack_1.Stack.of(this).formatArn({service:"ssm",resource:"parameter",region,resourceName:`${types_1.SSM_EXPORT_PATH_PREFIX}*`}))}addToExportReader(exportName,exportValueRef,importStack){const readerConstructName=(0,uniqueid_1.makeUniqueId)(["ExportsReader"]),exportReader=export_reader_provider_1.ExportReader.getOrCreate(importStack.nestedStackParent??importStack,readerConstructName);return this.addRegionToPolicy(importStack.region),exportReader.importValue(exportName,exportValueRef)}}exports.ExportWriter=ExportWriter;
