"use strict";var _a;Object.defineProperty(exports,"__esModule",{value:!0}),exports.CustomResourceProvider=exports.CustomResourceProviderRuntime=exports.builtInCustomResourceProviderNodeRuntime=exports.INLINE_CUSTOM_RESOURCE_CONTEXT=void 0;const jsiiDeprecationWarnings=require("../../../.warnings.jsii.js"),JSII_RTTI_SYMBOL_1=Symbol.for("jsii.rtti"),path=require("path"),constructs_1=require("constructs"),fs=require("fs-extra"),cxapi=require("../../../cx-api"),region_info_1=require("../../../region-info"),asset_staging_1=require("../asset-staging"),assets_1=require("../assets"),cfn_resource_1=require("../cfn-resource"),duration_1=require("../duration"),fs_1=require("../fs"),helpers_internal_1=require("../helpers-internal"),lazy_1=require("../lazy"),size_1=require("../size"),stack_1=require("../stack"),token_1=require("../token"),ENTRYPOINT_FILENAME="__entrypoint__",ENTRYPOINT_NODEJS_SOURCE=path.join(__dirname,"nodejs-entrypoint.js");exports.INLINE_CUSTOM_RESOURCE_CONTEXT="@aws-cdk/core:inlineCustomResourceIfPossible";function builtInCustomResourceProviderNodeRuntime(scope){const runtimeName=stack_1.Stack.of(scope).regionalFact(region_info_1.FactName.DEFAULT_CR_NODE_VERSION,"nodejs16.x");return Object.values(CustomResourceProviderRuntime).find(value=>value===runtimeName)??CustomResourceProviderRuntime.NODEJS_16_X}exports.builtInCustomResourceProviderNodeRuntime=builtInCustomResourceProviderNodeRuntime;var CustomResourceProviderRuntime;(function(CustomResourceProviderRuntime2){CustomResourceProviderRuntime2.NODEJS_12_X="nodejs12.x",CustomResourceProviderRuntime2.NODEJS_12="deprecated_nodejs12.x",CustomResourceProviderRuntime2.NODEJS_14_X="nodejs14.x",CustomResourceProviderRuntime2.NODEJS_16_X="nodejs16.x",CustomResourceProviderRuntime2.NODEJS_18_X="nodejs18.x"})(CustomResourceProviderRuntime=exports.CustomResourceProviderRuntime||(exports.CustomResourceProviderRuntime={}));class CustomResourceProvider extends constructs_1.Construct{static getOrCreate(scope,uniqueid,props){try{jsiiDeprecationWarnings.aws_cdk_lib_CustomResourceProviderProps(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.getOrCreate),error}return this.getOrCreateProvider(scope,uniqueid,props).serviceToken}static getOrCreateProvider(scope,uniqueid,props){try{jsiiDeprecationWarnings.aws_cdk_lib_CustomResourceProviderProps(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.getOrCreateProvider),error}const id=`${uniqueid}CustomResourceProvider`,stack=stack_1.Stack.of(scope);return stack.node.tryFindChild(id)??new CustomResourceProvider(stack,id,props)}get codeHash(){if(!this._codeHash)throw new Error("This custom resource uses inlineCode: true and does not have a codeHash");return this._codeHash}constructor(scope,id,props){super(scope,id);try{jsiiDeprecationWarnings.aws_cdk_lib_CustomResourceProviderProps(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,CustomResourceProvider),error}const stack=stack_1.Stack.of(scope);if(!fs.existsSync(path.join(props.codeDirectory,"index.js")))throw new Error(`cannot find ${props.codeDirectory}/index.js`);const{code,codeHandler,metadata}=this.createCodePropAndMetadata(props,stack);if(props.policyStatements)for(const statement of props.policyStatements)this.addToRolePolicy(statement);const config=(0,helpers_internal_1.getPrecreatedRoleConfig)(this,`${this.node.path}/Role`),assumeRolePolicyDoc=[{Action:"sts:AssumeRole",Effect:"Allow",Principal:{Service:"lambda.amazonaws.com"}}],managedPolicyArn="arn:${AWS::Partition}:iam::aws:policy/service-role/AWSLambdaBasicExecutionRole";this.roleArn="",config.enabled&&(this.node.addValidation({validate:()=>(helpers_internal_1.PolicySynthesizer.getOrCreate(this).addRole(`${this.node.path}/Role`,{missing:!config.precreatedRoleName,roleName:config.precreatedRoleName??id+"Role",managedPolicies:[{managedPolicyArn}],policyStatements:this.policyStatements??[],assumeRolePolicy:assumeRolePolicyDoc}),[])}),this.roleArn=stack_1.Stack.of(this).formatArn({region:"",service:"iam",resource:"role",resourceName:config.precreatedRoleName})),config.preventSynthesis||(this._role=new cfn_resource_1.CfnResource(this,"Role",{type:"AWS::IAM::Role",properties:{AssumeRolePolicyDocument:{Version:"2012-10-17",Statement:assumeRolePolicyDoc},ManagedPolicyArns:[{"Fn::Sub":managedPolicyArn}],Policies:lazy_1.Lazy.any({produce:()=>this.renderPolicies()})}}),this.roleArn=token_1.Token.asString(this._role.getAtt("Arn")));const timeout=props.timeout??duration_1.Duration.minutes(15),memory=props.memorySize??size_1.Size.mebibytes(128),handler=new cfn_resource_1.CfnResource(this,"Handler",{type:"AWS::Lambda::Function",properties:{Code:code,Timeout:timeout.toSeconds(),MemorySize:memory.toMebibytes(),Handler:codeHandler,Role:this.roleArn,Runtime:customResourceProviderRuntimeToString(props.runtime),Environment:this.renderEnvironmentVariables(props.environment),Description:props.description??void 0}});this._role&&handler.addDependency(this._role),metadata&&Object.entries(metadata).forEach(([k,v])=>handler.addMetadata(k,v)),this.serviceToken=token_1.Token.asString(handler.getAtt("Arn"))}createCodePropAndMetadata(props,stack){let codeHandler="index.handler";if(!this.node.tryGetContext(exports.INLINE_CUSTOM_RESOURCE_CONTEXT)){const stagingDirectory=fs_1.FileSystem.mkdtemp("cdk-custom-resource");fs.copySync(props.codeDirectory,stagingDirectory,{filter:(src,_dest)=>!src.endsWith(".ts")}),(props.useCfnResponseWrapper??!0)&&(fs.copyFileSync(ENTRYPOINT_NODEJS_SOURCE,path.join(stagingDirectory,`${ENTRYPOINT_FILENAME}.js`)),codeHandler=`${ENTRYPOINT_FILENAME}.handler`);const staging=new asset_staging_1.AssetStaging(this,"Staging",{sourcePath:stagingDirectory}),assetFileName=staging.relativeStagedPath(stack),asset=stack.synthesizer.addFileAsset({fileName:assetFileName,sourceHash:staging.assetHash,packaging:assets_1.FileAssetPackaging.ZIP_DIRECTORY});return this._codeHash=staging.assetHash,{code:{S3Bucket:asset.bucketName,S3Key:asset.objectKey},codeHandler,metadata:this.node.tryGetContext(cxapi.ASSET_RESOURCE_METADATA_ENABLED_CONTEXT)?{[cxapi.ASSET_RESOURCE_METADATA_PATH_KEY]:assetFileName,[cxapi.ASSET_RESOURCE_METADATA_PROPERTY_KEY]:"Code"}:void 0}}return{code:{ZipFile:fs.readFileSync(path.join(props.codeDirectory,"index.js"),"utf-8")},codeHandler}}addToRolePolicy(statement){this.policyStatements||(this.policyStatements=[]),this.policyStatements.push(statement)}renderPolicies(){return this.policyStatements?[{PolicyName:"Inline",PolicyDocument:{Version:"2012-10-17",Statement:this.policyStatements}}]:void 0}renderEnvironmentVariables(env){if(!env||Object.keys(env).length===0)return;env={...env},env.AWS_STS_REGIONAL_ENDPOINTS="regional";const variables={},keys=Object.keys(env).sort();for(const key of keys)variables[key]=env[key];return{Variables:variables}}}_a=JSII_RTTI_SYMBOL_1,CustomResourceProvider[_a]={fqn:"aws-cdk-lib.CustomResourceProvider",version:"2.87.0"},exports.CustomResourceProvider=CustomResourceProvider;function customResourceProviderRuntimeToString(x){switch(x){case CustomResourceProviderRuntime.NODEJS_12:case CustomResourceProviderRuntime.NODEJS_12_X:return"nodejs12.x";case CustomResourceProviderRuntime.NODEJS_14_X:return"nodejs14.x";case CustomResourceProviderRuntime.NODEJS_16_X:return"nodejs16.x";case CustomResourceProviderRuntime.NODEJS_18_X:return"nodejs18.x"}}
