"use strict";Object.defineProperty(exports,"__esModule",{value:!0}),exports.obtainDependencies=exports.removeDependency=exports.addDependency=void 0;const cfn_resource_1=require("./cfn-resource"),stack_1=require("./stack"),stage_1=require("./stage"),util_1=require("./util");function addDependency(source,target,reason){operateOnDependency(DependencyOperation.ADD,source,target,reason)}exports.addDependency=addDependency;function removeDependency(source,target){operateOnDependency(DependencyOperation.REMOVE,source,target)}exports.removeDependency=removeDependency;var DependencyOperation;(function(DependencyOperation2){DependencyOperation2[DependencyOperation2.ADD=0]="ADD",DependencyOperation2[DependencyOperation2.REMOVE=1]="REMOVE"})(DependencyOperation||(DependencyOperation={}));function operateOnDependency(operation,source,target,description){if(source===target)return;const sourceStack=stack_1.Stack.of(source),targetStack=stack_1.Stack.of(target),sourceStage=stage_1.Stage.of(sourceStack),targetStage=stage_1.Stage.of(targetStack);if(sourceStage!==targetStage)throw new Error(`You cannot have a dependency from '${source.node.path}' (in ${describeStage(sourceStage)}) to '${target.node.path}' (in ${describeStage(targetStage)}): dependency cannot cross stage boundaries`);const sourcePath=(0,util_1.pathToTopLevelStack)(sourceStack),targetPath=(0,util_1.pathToTopLevelStack)(targetStack),commonStack=(0,util_1.findLastCommonElement)(sourcePath,targetPath);if(!commonStack){const topLevelSource=sourcePath[0],topLevelTarget=targetPath[0],reason={source,target,description};switch(operation){case DependencyOperation.ADD:{topLevelSource._addAssemblyDependency(topLevelTarget,reason);break}case DependencyOperation.REMOVE:{topLevelSource._removeAssemblyDependency(topLevelTarget,reason);break}default:throw new Error(`Unsupported dependency operation: ${operation}`)}return}if(commonStack===source)return;if(commonStack===target)throw new Error(`Nested stack '${sourceStack.node.path}' cannot depend on a parent stack '${targetStack.node.path}'`);const sourceResource=resourceInCommonStackFor(source,commonStack),targetResource=resourceInCommonStackFor(target,commonStack);switch(operation){case DependencyOperation.ADD:{sourceResource._addResourceDependency(targetResource);break}case DependencyOperation.REMOVE:{sourceResource._removeResourceDependency(targetResource);break}default:throw new Error(`Unsupported dependency operation: ${operation}`)}}function obtainDependencies(source){let dependencies=[];return source instanceof cfn_resource_1.CfnResource&&(dependencies=source.obtainResourceDependencies()),(0,util_1.pathToTopLevelStack)(stack_1.Stack.of(source)).forEach(stack=>{dependencies=[...dependencies,...stack._obtainAssemblyDependencies({source})]}),dependencies}exports.obtainDependencies=obtainDependencies;function resourceInCommonStackFor(element,commonStack){const resource=stack_1.Stack.isStack(element)?element.nestedStackResource:element;if(!resource)throw new Error(`Unexpected value for resource when looking at ${element}!`);const resourceStack=stack_1.Stack.of(resource);return commonStack===resourceStack?resource:resourceInCommonStackFor(resourceStack,commonStack)}function describeStage(assembly){return assembly?assembly.parentStage?`Stage '${assembly.node.path}'`:"the App":"an unrooted construct tree"}
