"use strict";Object.defineProperty(exports,"__esModule",{value:!0}),exports.isNameOfCloudFormationIntrinsic=exports.minimalCloudFormationJoin=exports.CLOUDFORMATION_TOKEN_RESOLVER=exports.CloudFormationLang=void 0;const cfn_utils_provider_1=require("./cfn-utils-provider"),resolve_1=require("./resolve"),yaml_cfn=require("./yaml-cfn"),lazy_1=require("../lazy"),resolvable_1=require("../resolvable"),stack_1=require("../stack"),token_1=require("../token"),type_hints_1=require("../type-hints");class CloudFormationLang{static toJSON(obj,space){return lazy_1.Lazy.uncachedString({produce:ctx=>tokenAwareStringify(obj,space??0,ctx)})}static toYAML(obj){return lazy_1.Lazy.uncachedString({produce:()=>yaml_cfn.serialize(obj)})}static concat(left,right){if(left===void 0&&right===void 0)return"";const parts=new Array;return left!==void 0&&parts.push(left),right!==void 0&&parts.push(right),parts.length===1?parts[0]:parts.length===2&&isConcatable(parts[0])&&isConcatable(parts[1])?`${parts[0]}${parts[1]}`:fnJoinConcat(parts)}}exports.CloudFormationLang=CloudFormationLang;function fnJoinConcat(parts){return{"Fn::Join":["",minimalCloudFormationJoin("",parts)]}}function tokenAwareStringify(root,space,ctx){let indent=0;const ret=new Array;switch(recurse(ctx.resolve(root,{allowIntrinsicKeys:!0})),ret.length){case 0:return;case 1:return renderSegment(ret[0]);default:return fnJoinConcat(ret.map(renderSegment))}function recurse(obj){if(obj!==void 0){if(token_1.Token.isUnresolved(obj))throw new Error("This shouldn't happen anymore");if(Array.isArray(obj))return renderCollection("[","]",obj,recurse);if(typeof obj=="object"&&obj!=null&&!(obj instanceof Date)){if(isIntrinsic(obj)&&(0,resolve_1.resolvedTypeHint)(obj)){renderIntrinsic(obj);return}return renderCollection("{","}",definedEntries(obj),([key,value])=>{key.startsWith(resolve_1.INTRINSIC_KEY_PREFIX)&&([key,value]=value),recurse(key),pushLiteral(prettyPunctuation(":")),recurse(value)})}pushLiteral(JSON.stringify(obj))}}function renderCollection(pre,post,xs,each){pushLiteral(pre),indent+=space;let atLeastOne=!1;for(const[comma,item]of sepIter(xs))comma&&pushLiteral(","),pushLineBreak(),each(item),atLeastOne=!0;indent-=space,atLeastOne&&pushLineBreak(),pushLiteral(post)}function renderIntrinsic(intrinsic){switch((0,resolve_1.resolvedTypeHint)(intrinsic)){case type_hints_1.ResolutionTypeHint.STRING:pushLiteral('"'),pushIntrinsic(deepQuoteStringLiterals(intrinsic)),pushLiteral('"');return;case type_hints_1.ResolutionTypeHint.STRING_LIST:const stack=stack_1.Stack.of(ctx.scope),stringifyResponse=stringifyCache.obtain(stack,JSON.stringify(intrinsic),()=>cfn_utils_provider_1.CfnUtils.stringify(stack,`CdkJsonStringify${stringifyCounter++}`,intrinsic));pushIntrinsic(stringifyResponse);return;case type_hints_1.ResolutionTypeHint.NUMBER:pushIntrinsic(intrinsic);return}throw new Error(`Unexpected type hint: ${(0,resolve_1.resolvedTypeHint)(intrinsic)}`)}function pushLiteral(lit){let last=ret[ret.length-1];last?.type!=="literal"&&(last={type:"literal",parts:[]},ret.push(last)),last.parts.push(lit)}function pushIntrinsic(intrinsic){ret.push({type:"intrinsic",intrinsic})}function pushLineBreak(){space>0&&pushLiteral(`
${" ".repeat(indent)}`)}function prettyPunctuation(punc){return space>0?`${punc} `:punc}}function renderSegment(s){switch(s.type){case"literal":return s.parts.join("");case"intrinsic":return s.intrinsic}}const CLOUDFORMATION_CONCAT={join(left,right){return CloudFormationLang.concat(left,right)}};exports.CLOUDFORMATION_TOKEN_RESOLVER=new resolvable_1.DefaultTokenResolver(CLOUDFORMATION_CONCAT);function minimalCloudFormationJoin(delimiter,values){let i=0;for(;i<values.length;){const el=values[i];isSplicableFnJoinIntrinsic(el)?values.splice(i,1,...el["Fn::Join"][1]):i>0&&isConcatable(values[i-1])&&isConcatable(values[i])?(values[i-1]=`${values[i-1]}${delimiter}${values[i]}`,values.splice(i,1)):i+=1}return values;function isSplicableFnJoinIntrinsic(obj){if(!isIntrinsic(obj)||Object.keys(obj)[0]!=="Fn::Join")return!1;const[delim,list]=obj["Fn::Join"];return!(delim!==delimiter||token_1.Token.isUnresolved(list)||!Array.isArray(list))}}exports.minimalCloudFormationJoin=minimalCloudFormationJoin;function isConcatable(obj){return["string","number"].includes(typeof obj)&&!token_1.Token.isUnresolved(obj)}function isIntrinsic(x){if(Array.isArray(x)||x===null||typeof x!="object")return!1;const keys=Object.keys(x);return keys.length!==1?!1:keys[0]==="Ref"||isNameOfCloudFormationIntrinsic(keys[0])}function isNameOfCloudFormationIntrinsic(name){return name.startsWith("Fn::")?name!=="Fn::GetArtifactAtt"&&name!=="Fn::GetParam":!1}exports.isNameOfCloudFormationIntrinsic=isNameOfCloudFormationIntrinsic;function*sepIter(xs){let comma=!1;for(const item of xs)yield[comma,item],comma=!0}function*definedEntries(xs){for(const[key,value]of Object.entries(xs))value!==void 0&&(yield[key,value])}function deepQuoteStringLiterals(x){if(Array.isArray(x))return x.map(deepQuoteStringLiterals);if(typeof x=="object"&&x!=null){const ret={};for(const[key,value]of Object.entries(x))ret[deepQuoteStringLiterals(key)]=deepQuoteStringLiterals(value);return ret}return typeof x=="string"?quoteString(x):x}function quoteString(s){return s=JSON.stringify(s),s.substring(1,s.length-1)}let stringifyCounter=1;class ScopedCache{constructor(){this.cache=new WeakMap}obtain(object,key,init){let kvMap=this.cache.get(object);kvMap||(kvMap=new Map,this.cache.set(object,kvMap));let ret=kvMap.get(key);return ret===void 0&&(ret=init(),kvMap.set(key,ret)),ret}}const stringifyCache=new ScopedCache;
