"use strict";Object.defineProperty(exports,"__esModule",{value:!0}),exports.LogicalIDs=void 0;class LogicalIDs{constructor(){this.renames={},this.reverse={}}addRename(oldId,newId){if(oldId in this.renames)throw new Error(`A rename has already been registered for '${oldId}'`);this.renames[oldId]=newId}applyRename(oldId){let newId=oldId;if(oldId in this.renames&&(newId=this.renames[oldId]),newId in this.reverse&&this.reverse[newId]!==oldId)throw new Error(`Two objects have been assigned the same Logical ID: '${this.reverse[newId]}' and '${oldId}' are now both named '${newId}'.`);return this.reverse[newId]=oldId,validateLogicalId(newId),newId}assertAllRenamesApplied(){const keys=new Set;if(Object.keys(this.renames).forEach(keys.add.bind(keys)),Object.keys(this.reverse).map(newId=>{keys.delete(this.reverse[newId])}),keys.size!==0){const unusedRenames=Array.from(keys.values());throw new Error(`The following Logical IDs were attempted to be renamed, but not found: ${unusedRenames.join(", ")}`)}}}exports.LogicalIDs=LogicalIDs;const VALID_LOGICALID_REGEX=/^[A-Za-z][A-Za-z0-9]{1,254}$/;function validateLogicalId(logicalId){if(!VALID_LOGICALID_REGEX.test(logicalId))throw new Error(`Logical ID must adhere to the regular expression: ${VALID_LOGICALID_REGEX.toString()}, got '${logicalId}'`)}
