"use strict";Object.defineProperty(exports,"__esModule",{value:!0}),exports.addCustomSynthesis=exports.synthesize=void 0;const fs=require("fs"),path=require("path"),metadata_resource_1=require("./metadata-resource"),prepare_app_1=require("./prepare-app"),tree_metadata_1=require("./tree-metadata"),cxapi=require("../../../cx-api"),annotations_1=require("../annotations"),app_1=require("../app"),aspect_1=require("../aspect"),fs_1=require("../fs"),stack_1=require("../stack"),stage_1=require("../stage"),construct_tree_1=require("../validation/private/construct-tree"),report_1=require("../validation/private/report"),POLICY_VALIDATION_FILE_PATH="policy-validation-report.json",VALIDATION_REPORT_JSON_CONTEXT="@aws-cdk/core:validationReportJson";function synthesize(root,options={}){injectTreeMetadata(root),synthNestedAssemblies(root,options),invokeAspects(root),injectMetadataResources(root),(0,prepare_app_1.prepareApp)(root),options.skipValidation||validateTree(root);const builder=stage_1.Stage.isStage(root)?root._assemblyBuilder:new cxapi.CloudAssemblyBuilder(options.outdir);synthesizeTree(root,builder,options.validateOnSynthesis);const assembly=builder.buildAssembly();return invokeValidationPlugins(root,builder.outdir,assembly),assembly}exports.synthesize=synthesize;function getAssemblies(root,rootAssembly){const assemblies=new Map;return assemblies.set(root.artifactId,rootAssembly),visitAssemblies(root,"pre",construct=>{const stage=construct;stage.parentStage&&assemblies.has(stage.parentStage.artifactId)&&assemblies.set(stage.artifactId,assemblies.get(stage.parentStage.artifactId).getNestedAssembly(stage.artifactId))}),assemblies}function invokeValidationPlugins(root,outdir,assembly){if(!app_1.App.isApp(root))return;let hash;const assemblies=getAssemblies(root,assembly),templatePathsByPlugin=new Map;visitAssemblies(root,"post",construct=>{if(stage_1.Stage.isStage(construct))for(const plugin of construct.policyValidationBeta1){templatePathsByPlugin.has(plugin)||templatePathsByPlugin.set(plugin,[]);let assemblyToUse=assemblies.get(construct.artifactId);if(!assemblyToUse)throw new Error(`Validation failed, cannot find cloud assembly for stage ${construct.stageName}`);templatePathsByPlugin.get(plugin).push(...assemblyToUse.stacksRecursively.map(stack=>stack.templateFullPath))}});const reports=[];templatePathsByPlugin.size>0&&console.log(`Performing Policy Validations
`),templatePathsByPlugin.size>0&&(hash=fs_1.FileSystem.fingerprint(outdir));for(const[plugin,paths]of templatePathsByPlugin.entries()){try{const report=plugin.validate({templatePaths:paths});reports.push({...report,pluginName:plugin.name})}catch(e){reports.push({success:!1,pluginName:plugin.name,pluginVersion:plugin.version,violations:[],metadata:{error:`Validation plugin '${plugin.name}' failed: ${e.message}`}})}if(fs_1.FileSystem.fingerprint(outdir)!==hash)throw new Error(`Illegal operation: validation plugin '${plugin.name}' modified the cloud assembly`)}if(reports.length>0){const tree=new construct_tree_1.ConstructTree(root),formatter=new report_1.PolicyValidationReportFormatter(tree),formatJson=root.node.tryGetContext(VALIDATION_REPORT_JSON_CONTEXT)??!1,output=formatJson?formatter.formatJson(reports):formatter.formatPrettyPrinted(reports),reportFile=path.join(assembly.directory,POLICY_VALIDATION_FILE_PATH);if(formatJson?fs.writeFileSync(reportFile,JSON.stringify(output,void 0,2)):console.error(output),reports.some(r=>!r.success)){const message=formatJson?`Validation failed. See the validation report in '${reportFile}' for details`:"Validation failed. See the validation report above for details";console.log(message),process.exitCode=1}else console.log("Policy Validation Successful!")}}const CUSTOM_SYNTHESIS_SYM=Symbol.for("@aws-cdk/core:customSynthesis");function addCustomSynthesis(construct,synthesis){Object.defineProperty(construct,CUSTOM_SYNTHESIS_SYM,{value:synthesis,enumerable:!1})}exports.addCustomSynthesis=addCustomSynthesis;function getCustomSynthesis(construct){return construct[CUSTOM_SYNTHESIS_SYM]}function synthNestedAssemblies(root,options){for(const child of root.node.children)stage_1.Stage.isStage(child)?child.synth(options):synthNestedAssemblies(child,options)}function invokeAspects(root){const invokedByPath={};let nestedAspectWarning=!1;recurse(root,[]);function recurse(construct,inheritedAspects){const node=construct.node,aspects=aspect_1.Aspects.of(construct),allAspectsHere=[...inheritedAspects??[],...aspects.all],nodeAspectsCount=aspects.all.length;for(const aspect of allAspectsHere){let invoked=invokedByPath[node.path];invoked||(invoked=invokedByPath[node.path]=[]),!invoked.includes(aspect)&&(aspect.visit(construct),!nestedAspectWarning&&nodeAspectsCount!==aspects.all.length&&(annotations_1.Annotations.of(construct).addWarning("We detected an Aspect was added via another Aspect, and will not be applied"),nestedAspectWarning=!0),invoked.push(aspect))}for(const child of construct.node.children)stage_1.Stage.isStage(child)||recurse(child,allAspectsHere)}}function injectMetadataResources(root){visit(root,"post",construct=>{if(!stack_1.Stack.isStack(construct)||!construct._versionReportingEnabled)return;const CDKMetadata="CDKMetadata";construct.node.tryFindChild(CDKMetadata)||new metadata_resource_1.MetadataResource(construct,CDKMetadata)})}function injectTreeMetadata(root){visit(root,"post",construct=>{if(!app_1.App.isApp(construct)||!construct._treeMetadata)return;const CDKTreeMetadata="Tree";construct.node.tryFindChild(CDKTreeMetadata)||new tree_metadata_1.TreeMetadata(construct)})}function synthesizeTree(root,builder,validateOnSynth=!1){visit(root,"post",construct=>{const session={outdir:builder.outdir,assembly:builder,validateOnSynth};stack_1.Stack.isStack(construct)?construct.synthesizer.synthesize(session):construct instanceof tree_metadata_1.TreeMetadata?construct._synthesizeTree(session):getCustomSynthesis(construct)?.onSynthesize(session)})}function validateTree(root){const errors=new Array;if(visit(root,"pre",construct=>{for(const message of construct.node.validate())errors.push({message,source:construct})}),errors.length>0){const errorList=errors.map(e=>`[${e.source.node.path}] ${e.message}`).join(`
  `);throw new Error(`Validation failed with the following errors:
  ${errorList}`)}}function visitAssemblies(root,order,cb){order==="pre"&&cb(root);for(const child of root.node.children)stage_1.Stage.isStage(child)&&visitAssemblies(child,order,cb);order==="post"&&cb(root)}function visit(root,order,cb){order==="pre"&&cb(root);for(const child of root.node.children)stage_1.Stage.isStage(child)||visit(child,order,cb);order==="post"&&cb(root)}
