"use strict";Object.defineProperty(exports,"__esModule",{value:!0}),exports.TreeMetadata=void 0;const fs=require("fs"),path=require("path"),constructs_1=require("constructs"),runtime_info_1=require("./runtime-info"),cloud_assembly_schema_1=require("../../../cloud-assembly-schema"),annotations_1=require("../annotations"),stack_1=require("../stack"),tree_1=require("../tree"),FILE_PATH="tree.json";class TreeMetadata extends constructs_1.Construct{constructor(scope){super(scope,"Tree")}_synthesizeTree(session){const lookup={},visit=construct=>{const childrenMap=construct.node.children.map(c=>{try{return visit(c)}catch(e){annotations_1.Annotations.of(this).addWarning(`Failed to render tree metadata for node [${c.node.id}]. Reason: ${e}`);return}}).filter(child=>child!==void 0).reduce((map,child)=>Object.assign(map,{[child.id]:child}),{}),parent=construct.node.scope,node={id:construct.node.id||"App",path:construct.node.path,parent:parent&&parent.node.path?{id:parent.node.id,path:parent.node.path,constructInfo:(0,runtime_info_1.constructInfoFromConstruct)(parent)}:void 0,children:Object.keys(childrenMap).length===0?void 0:childrenMap,attributes:this.synthAttributes(construct),constructInfo:(0,runtime_info_1.constructInfoFromConstruct)(construct)};return lookup[node.path]=node,node},tree={version:"tree-0.1",tree:visit(this.node.root)};this._tree=lookup;const builder=session.assembly;fs.writeFileSync(path.join(builder.outdir,FILE_PATH),JSON.stringify(tree,(key,value)=>{if(key!=="parent")return value},2),{encoding:"utf-8"}),builder.addArtifact("Tree",{type:cloud_assembly_schema_1.ArtifactType.CDK_TREE,properties:{file:FILE_PATH}})}getNodeWithParents(node){if(!this._tree)throw new Error(`attempting to get node branch for ${node.path}, but the tree has not been created yet!`);let tree=node;return node.parent&&(tree={...node,parent:this.getNodeWithParents(this._tree[node.parent.path])}),tree}renderTreeWithChildren(node,child){return node.parent?this.renderTreeWithChildren(node.parent,node):child?{...node,children:{[child.id]:child}}:node}_getNodeBranch(constructPath){if(!this._tree)throw new Error(`attempting to get node branch for ${constructPath}, but the tree has not been created yet!`);const tree=this._tree[constructPath],treeWithParents=this.getNodeWithParents(tree);return this.renderTreeWithChildren(treeWithParents)}synthAttributes(construct){function canInspect(inspectable){return inspectable.inspect!==void 0}const inspector=new tree_1.TreeInspector;if(canInspect(construct))return construct.inspect(inspector),stack_1.Stack.of(construct).resolve(inspector.attributes)}}exports.TreeMetadata=TreeMetadata;
