"use strict";var _a;Object.defineProperty(exports,"__esModule",{value:!0}),exports.Resource=void 0;const jsiiDeprecationWarnings=require("../../.warnings.jsii.js"),JSII_RTTI_SYMBOL_1=Symbol.for("jsii.rtti"),arn_1=require("./arn"),cfn_resource_1=require("./cfn-resource"),lazy_1=require("./lazy"),physical_name_generator_1=require("./private/physical-name-generator"),reference_1=require("./reference"),stack_1=require("./stack"),token_1=require("./token"),constructs_1=require("constructs"),RESOURCE_SYMBOL=Symbol.for("@aws-cdk/core.Resource");class Resource extends constructs_1.Construct{static isResource(construct){return construct!==null&&typeof construct=="object"&&RESOURCE_SYMBOL in construct}static isOwnedResource(construct){return construct.node.defaultChild?cfn_resource_1.CfnResource.isCfnResource(construct.node.defaultChild):!1}constructor(scope,id,props={}){super(scope,id);try{jsiiDeprecationWarnings.aws_cdk_lib_ResourceProps(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,Resource),error}if((props.account!==void 0||props.region!==void 0)&&props.environmentFromArn!==void 0)throw new Error(`Supply at most one of 'account'/'region' (${props.account}/${props.region}) and 'environmentFromArn' (${props.environmentFromArn})`);Object.defineProperty(this,RESOURCE_SYMBOL,{value:!0}),this.stack=stack_1.Stack.of(this);const parsedArn=props.environmentFromArn?this.stack.splitArn(props.environmentFromArn,arn_1.ArnFormat.NO_RESOURCE_NAME):void 0;this.env={account:props.account??parsedArn?.account??this.stack.account,region:props.region??parsedArn?.region??this.stack.region};let physicalName=props.physicalName;props.physicalName&&(0,physical_name_generator_1.isGeneratedWhenNeededMarker)(props.physicalName)?(this._physicalName=void 0,this._allowCrossEnvironment=!0,physicalName=lazy_1.Lazy.string({produce:()=>this._physicalName})):props.physicalName&&!token_1.Token.isUnresolved(props.physicalName)?(this._physicalName=props.physicalName,this._allowCrossEnvironment=!0):(this._physicalName=props.physicalName,this._allowCrossEnvironment=!1),physicalName===void 0&&(physicalName=token_1.Token.asString(void 0)),this.physicalName=physicalName}_enableCrossEnvironment(){if(!this._allowCrossEnvironment)throw new Error(`Cannot use resource '${this.node.path}' in a cross-environment fashion, the resource's physical name must be explicit set or use \`PhysicalName.GENERATE_IF_NEEDED\``);this._physicalName||(this._physicalName=this.generatePhysicalName())}applyRemovalPolicy(policy){try{jsiiDeprecationWarnings.aws_cdk_lib_RemovalPolicy(policy)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.applyRemovalPolicy),error}const child=this.node.defaultChild;if(!child||!cfn_resource_1.CfnResource.isCfnResource(child))throw new Error("Cannot apply RemovalPolicy: no child or not a CfnResource. Apply the removal policy on the CfnResource directly.");child.applyRemovalPolicy(policy)}generatePhysicalName(){return(0,physical_name_generator_1.generatePhysicalName)(this)}getResourceNameAttribute(nameAttr){return mimicReference(nameAttr,{produce:context=>{const consumingStack=stack_1.Stack.of(context.scope);return this.stack.account!==consumingStack.account||this.stack.region!==consumingStack.region&&!consumingStack._crossRegionReferences?(this._enableCrossEnvironment(),this.physicalName):nameAttr}})}getResourceArnAttribute(arnAttr,arnComponents){try{jsiiDeprecationWarnings.aws_cdk_lib_ArnComponents(arnComponents)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.getResourceArnAttribute),error}return mimicReference(arnAttr,{produce:context=>{const consumingStack=stack_1.Stack.of(context.scope);return this.stack.account!==consumingStack.account||this.stack.region!==consumingStack.region&&!consumingStack._crossRegionReferences?(this._enableCrossEnvironment(),this.stack.formatArn(arnComponents)):arnAttr}})}}_a=JSII_RTTI_SYMBOL_1,Resource[_a]={fqn:"aws-cdk-lib.Resource",version:"2.87.0"},exports.Resource=Resource;function mimicReference(refSource,producer){const reference=token_1.Tokenization.reverse(refSource,{failConcat:!1});return reference_1.Reference.isReference(reference)?token_1.Token.asString(new class extends reference_1.Reference{resolve(context){return producer.produce(context)}}(reference,reference.target,reference.displayName)):lazy_1.Lazy.uncachedString(producer)}
