"use strict";var _a;Object.defineProperty(exports,"__esModule",{value:!0}),exports.DefaultStackSynthesizer=exports.BOOTSTRAP_QUALIFIER_CONTEXT=void 0;const jsiiDeprecationWarnings=require("../../../.warnings.jsii.js"),JSII_RTTI_SYMBOL_1=Symbol.for("jsii.rtti"),_shared_1=require("./_shared"),asset_manifest_builder_1=require("./asset-manifest-builder"),stack_synthesizer_1=require("./stack-synthesizer"),cxapi=require("../../../cx-api"),string_specializer_1=require("../helpers-internal/string-specializer"),token_1=require("../token");exports.BOOTSTRAP_QUALIFIER_CONTEXT="@aws-cdk/core:bootstrapQualifier";const MIN_BOOTSTRAP_STACK_VERSION=6,MIN_LOOKUP_ROLE_BOOTSTRAP_STACK_VERSION=8;class DefaultStackSynthesizer extends stack_synthesizer_1.StackSynthesizer{constructor(props={}){super(),this.props=props,this.assetManifest=new asset_manifest_builder_1.AssetManifestBuilder;try{jsiiDeprecationWarnings.aws_cdk_lib_DefaultStackSynthesizerProps(props)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,DefaultStackSynthesizer),error}this.useLookupRoleForStackOperations=props.useLookupRoleForStackOperations??!0;for(const key in props)props.hasOwnProperty(key)&&validateNoToken(key);function validateNoToken(key){const prop=props[key];if(typeof prop=="string"&&token_1.Token.isUnresolved(prop))throw new Error(`DefaultStackSynthesizer property '${key}' cannot contain tokens; only the following placeholder strings are allowed: `+["${Qualifier}",cxapi.EnvironmentPlaceholders.CURRENT_REGION,cxapi.EnvironmentPlaceholders.CURRENT_ACCOUNT,cxapi.EnvironmentPlaceholders.CURRENT_PARTITION].join(", "))}}reusableBind(stack){try{jsiiDeprecationWarnings.aws_cdk_lib_Stack(stack)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.reusableBind),error}const copy=Object.create(this);return copy.bind(stack),copy}get bootstrapQualifier(){return this.qualifier}get lookupRole(){return this.lookupRoleArn}bind(stack){try{jsiiDeprecationWarnings.aws_cdk_lib_Stack(stack)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.bind),error}super.bind(stack);const qualifier=this.props.qualifier??stack.node.tryGetContext(exports.BOOTSTRAP_QUALIFIER_CONTEXT)??DefaultStackSynthesizer.DEFAULT_QUALIFIER;this.qualifier=qualifier;const spec=new string_specializer_1.StringSpecializer(stack,qualifier);this.bucketName=spec.specialize(this.props.fileAssetsBucketName??DefaultStackSynthesizer.DEFAULT_FILE_ASSETS_BUCKET_NAME),this.repositoryName=spec.specialize(this.props.imageAssetsRepositoryName??DefaultStackSynthesizer.DEFAULT_IMAGE_ASSETS_REPOSITORY_NAME),this._deployRoleArn=spec.specialize(this.props.deployRoleArn??DefaultStackSynthesizer.DEFAULT_DEPLOY_ROLE_ARN),this._cloudFormationExecutionRoleArn=spec.specialize(this.props.cloudFormationExecutionRole??DefaultStackSynthesizer.DEFAULT_CLOUDFORMATION_ROLE_ARN),this.fileAssetPublishingRoleArn=spec.specialize(this.props.fileAssetPublishingRoleArn??DefaultStackSynthesizer.DEFAULT_FILE_ASSET_PUBLISHING_ROLE_ARN),this.imageAssetPublishingRoleArn=spec.specialize(this.props.imageAssetPublishingRoleArn??DefaultStackSynthesizer.DEFAULT_IMAGE_ASSET_PUBLISHING_ROLE_ARN),this.lookupRoleArn=spec.specialize(this.props.lookupRoleArn??DefaultStackSynthesizer.DEFAULT_LOOKUP_ROLE_ARN),this.bucketPrefix=spec.specialize(this.props.bucketPrefix??DefaultStackSynthesizer.DEFAULT_FILE_ASSET_PREFIX),this.dockerTagPrefix=spec.specialize(this.props.dockerTagPrefix??DefaultStackSynthesizer.DEFAULT_DOCKER_ASSET_PREFIX),this.bootstrapStackVersionSsmParameter=spec.qualifierOnly(this.props.bootstrapStackVersionSsmParameter??DefaultStackSynthesizer.DEFAULT_BOOTSTRAP_STACK_VERSION_SSM_PARAMETER)}addFileAsset(asset){try{jsiiDeprecationWarnings.aws_cdk_lib_FileAssetSource(asset)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.addFileAsset),error}(0,_shared_1.assertBound)(this.bucketName);const location=this.assetManifest.defaultAddFileAsset(this.boundStack,asset,{bucketName:this.bucketName,bucketPrefix:this.bucketPrefix,role:this.fileAssetPublishingRoleArn?{assumeRoleArn:this.fileAssetPublishingRoleArn,assumeRoleExternalId:this.props.fileAssetPublishingExternalId}:void 0});return this.cloudFormationLocationFromFileAsset(location)}addDockerImageAsset(asset){try{jsiiDeprecationWarnings.aws_cdk_lib_DockerImageAssetSource(asset)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.addDockerImageAsset),error}(0,_shared_1.assertBound)(this.repositoryName);const location=this.assetManifest.defaultAddDockerImageAsset(this.boundStack,asset,{repositoryName:this.repositoryName,dockerTagPrefix:this.dockerTagPrefix,role:this.imageAssetPublishingRoleArn?{assumeRoleArn:this.imageAssetPublishingRoleArn,assumeRoleExternalId:this.props.imageAssetPublishingExternalId}:void 0});return this.cloudFormationLocationFromDockerImageAsset(location)}synthesizeStackTemplate(stack,session){try{jsiiDeprecationWarnings.aws_cdk_lib_Stack(stack),jsiiDeprecationWarnings.aws_cdk_lib_ISynthesisSession(session)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.synthesizeStackTemplate),error}stack._synthesizeTemplate(session,this.lookupRoleArn)}get stack(){try{jsiiDeprecationWarnings.print("aws-cdk-lib.DefaultStackSynthesizer#stack","Use `boundStack` instead.")}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,jsiiDeprecationWarnings.getPropertyDescriptor(this,"stack").get),error}return this.boundStack}synthesize(session){try{jsiiDeprecationWarnings.aws_cdk_lib_ISynthesisSession(session)}catch(error){throw process.env.JSII_DEBUG!=="1"&&error.name==="DeprecationError"&&Error.captureStackTrace(error,this.synthesize),error}(0,_shared_1.assertBound)(this.qualifier),(this.props.generateBootstrapVersionRule??!0)&&this.addBootstrapVersionRule(MIN_BOOTSTRAP_STACK_VERSION,this.bootstrapStackVersionSsmParameter);const templateAssetSource=this.synthesizeTemplate(session,this.lookupRoleArn),templateAsset=this.addFileAsset(templateAssetSource),assetManifestId=this.assetManifest.emitManifest(this.boundStack,session,{requiresBootstrapStackVersion:MIN_BOOTSTRAP_STACK_VERSION,bootstrapStackVersionSsmParameter:this.bootstrapStackVersionSsmParameter});this.emitArtifact(session,{assumeRoleExternalId:this.props.deployRoleExternalId,assumeRoleArn:this._deployRoleArn,cloudFormationExecutionRoleArn:this._cloudFormationExecutionRoleArn,stackTemplateAssetObjectUrl:templateAsset.s3ObjectUrlWithPlaceholders,requiresBootstrapStackVersion:MIN_BOOTSTRAP_STACK_VERSION,bootstrapStackVersionSsmParameter:this.bootstrapStackVersionSsmParameter,additionalDependencies:[assetManifestId],lookupRole:this.useLookupRoleForStackOperations&&this.lookupRoleArn?{arn:this.lookupRoleArn,assumeRoleExternalId:this.props.lookupRoleExternalId,requiresBootstrapStackVersion:MIN_LOOKUP_ROLE_BOOTSTRAP_STACK_VERSION,bootstrapStackVersionSsmParameter:this.bootstrapStackVersionSsmParameter}:void 0})}get deployRoleArn(){if(!this._deployRoleArn)throw new Error("deployRoleArn getter can only be called after the synthesizer has been bound to a Stack");return this._deployRoleArn}get cloudFormationExecutionRoleArn(){if(!this._cloudFormationExecutionRoleArn)throw new Error("cloudFormationExecutionRoleArn getter can only be called after the synthesizer has been bound to a Stack");return this._cloudFormationExecutionRoleArn}}_a=JSII_RTTI_SYMBOL_1,DefaultStackSynthesizer[_a]={fqn:"aws-cdk-lib.DefaultStackSynthesizer",version:"2.87.0"},DefaultStackSynthesizer.DEFAULT_QUALIFIER="hnb659fds",DefaultStackSynthesizer.DEFAULT_CLOUDFORMATION_ROLE_ARN="arn:${AWS::Partition}:iam::${AWS::AccountId}:role/cdk-${Qualifier}-cfn-exec-role-${AWS::AccountId}-${AWS::Region}",DefaultStackSynthesizer.DEFAULT_DEPLOY_ROLE_ARN="arn:${AWS::Partition}:iam::${AWS::AccountId}:role/cdk-${Qualifier}-deploy-role-${AWS::AccountId}-${AWS::Region}",DefaultStackSynthesizer.DEFAULT_FILE_ASSET_PUBLISHING_ROLE_ARN="arn:${AWS::Partition}:iam::${AWS::AccountId}:role/cdk-${Qualifier}-file-publishing-role-${AWS::AccountId}-${AWS::Region}",DefaultStackSynthesizer.DEFAULT_IMAGE_ASSET_PUBLISHING_ROLE_ARN="arn:${AWS::Partition}:iam::${AWS::AccountId}:role/cdk-${Qualifier}-image-publishing-role-${AWS::AccountId}-${AWS::Region}",DefaultStackSynthesizer.DEFAULT_LOOKUP_ROLE_ARN="arn:${AWS::Partition}:iam::${AWS::AccountId}:role/cdk-${Qualifier}-lookup-role-${AWS::AccountId}-${AWS::Region}",DefaultStackSynthesizer.DEFAULT_IMAGE_ASSETS_REPOSITORY_NAME="cdk-${Qualifier}-container-assets-${AWS::AccountId}-${AWS::Region}",DefaultStackSynthesizer.DEFAULT_FILE_ASSETS_BUCKET_NAME="cdk-${Qualifier}-assets-${AWS::AccountId}-${AWS::Region}",DefaultStackSynthesizer.DEFAULT_FILE_ASSET_KEY_ARN_EXPORT_NAME="CdkBootstrap-${Qualifier}-FileAssetKeyArn",DefaultStackSynthesizer.DEFAULT_FILE_ASSET_PREFIX="",DefaultStackSynthesizer.DEFAULT_DOCKER_ASSET_PREFIX="",DefaultStackSynthesizer.DEFAULT_BOOTSTRAP_STACK_VERSION_SSM_PARAMETER="/cdk-bootstrap/${Qualifier}/version",exports.DefaultStackSynthesizer=DefaultStackSynthesizer;
