"use strict";Object.defineProperty(exports,"__esModule",{value:!0}),exports.handler=exports.forceSdkInstallation=void 0;const child_process_1=require("child_process"),fs=require("fs"),path_1=require("path"),shared_1=require("../shared");let latestSdkInstalled=!1;function forceSdkInstallation(){latestSdkInstalled=!1}exports.forceSdkInstallation=forceSdkInstallation;function installLatestSdk(){console.log("Installing latest AWS SDK v2"),(0,child_process_1.execSync)("HOME=/tmp npm install aws-sdk@2 --production --no-package-lock --no-save --prefix /tmp"),latestSdkInstalled=!0}const patchedServices=[];function patchSdk(awsSdk){const apiLoader=awsSdk.apiLoader;return patchedServices.forEach(({serviceName,apiVersions})=>{const lowerServiceName=serviceName.toLowerCase();awsSdk.Service.hasService(lowerServiceName)?awsSdk.Service.addVersions(awsSdk[serviceName],apiVersions):(apiLoader.services[lowerServiceName]={},awsSdk[serviceName]=awsSdk.Service.defineService(lowerServiceName,apiVersions)),apiVersions.forEach(apiVersion=>{Object.defineProperty(apiLoader.services[lowerServiceName],apiVersion,{get:function(){const modelFilePrefix=`aws-sdk-patch/${lowerServiceName}-${apiVersion}`,model=JSON.parse(fs.readFileSync((0,path_1.join)(__dirname,`${modelFilePrefix}.service.json`),"utf-8"));return model.paginators=JSON.parse(fs.readFileSync((0,path_1.join)(__dirname,`${modelFilePrefix}.paginators.json`),"utf-8")).pagination,model},enumerable:!0,configurable:!0})})}),awsSdk}async function handler(event,context){try{let AWS;if(!latestSdkInstalled&&event.ResourceProperties.InstallLatestAwsSdk==="true")try{installLatestSdk(),AWS=require("/tmp/node_modules/aws-sdk")}catch(e){console.log(`Failed to install latest AWS SDK v2: ${e}`),AWS=require("aws-sdk")}else latestSdkInstalled?AWS=require("/tmp/node_modules/aws-sdk"):AWS=require("aws-sdk");try{AWS=patchSdk(AWS)}catch(e){console.log(`Failed to patch AWS SDK: ${e}. Proceeding with the installed copy.`)}console.log(JSON.stringify({...event,ResponseURL:"..."})),console.log("AWS SDK VERSION: "+AWS.VERSION),event.ResourceProperties.Create=(0,shared_1.decodeCall)(event.ResourceProperties.Create),event.ResourceProperties.Update=(0,shared_1.decodeCall)(event.ResourceProperties.Update),event.ResourceProperties.Delete=(0,shared_1.decodeCall)(event.ResourceProperties.Delete);let physicalResourceId;switch(event.RequestType){case"Create":physicalResourceId=event.ResourceProperties.Create?.physicalResourceId?.id??event.ResourceProperties.Update?.physicalResourceId?.id??event.ResourceProperties.Delete?.physicalResourceId?.id??event.LogicalResourceId;break;case"Update":case"Delete":physicalResourceId=event.ResourceProperties[event.RequestType]?.physicalResourceId?.id??event.PhysicalResourceId;break}let flatData={},data={};const call=event.ResourceProperties[event.RequestType];if(call){let credentials;if(call.assumedRoleArn){const timestamp=new Date().getTime(),params={RoleArn:call.assumedRoleArn,RoleSessionName:`${timestamp}-${physicalResourceId}`.substring(0,64)};credentials=new AWS.ChainableTemporaryCredentials({params,stsConfig:{stsRegionalEndpoints:"regional"}})}if(!Object.prototype.hasOwnProperty.call(AWS,call.service))throw Error(`Service ${call.service} does not exist in AWS SDK version ${AWS.VERSION}.`);const awsService=new AWS[call.service]({apiVersion:call.apiVersion,credentials,region:call.region});try{const response=await awsService[call.action](call.parameters&&(0,shared_1.decodeSpecialValues)(call.parameters,physicalResourceId)).promise();flatData={apiVersion:awsService.config.apiVersion,region:awsService.config.region,...(0,shared_1.flatten)(response)};let outputPaths;call.outputPath?outputPaths=[call.outputPath]:call.outputPaths&&(outputPaths=call.outputPaths),outputPaths?data=(0,shared_1.filterKeys)(flatData,(0,shared_1.startsWithOneOf)(outputPaths)):data=flatData}catch(e){if(!call.ignoreErrorCodesMatching||!new RegExp(call.ignoreErrorCodesMatching).test(e.code))throw e}call.physicalResourceId?.responsePath&&(physicalResourceId=flatData[call.physicalResourceId.responsePath])}await(0,shared_1.respond)(event,"SUCCESS","OK",physicalResourceId,data)}catch(e){console.log(e),await(0,shared_1.respond)(event,"FAILED",e.message||"Internal Error",context.logStreamName,{})}}exports.handler=handler;
