"use strict";Object.defineProperty(exports,"__esModule",{value:!0}),exports.handler=exports.forceSdkInstallation=void 0;const child_process_1=require("child_process"),get_v3_client_package_name_1=require("./v2-to-v3/get-v3-client-package-name"),shared_1=require("../shared");let installedSdk={};function forceSdkInstallation(){installedSdk={}}exports.forceSdkInstallation=forceSdkInstallation;function installLatestSdk(packageName){console.log("Installing latest AWS SDK v3"),(0,child_process_1.execSync)(`HOME=/tmp npm install ${packageName} --omit=dev --no-package-lock --no-save --prefix /tmp`),installedSdk={...installedSdk,[packageName]:!0}}async function loadAwsSdk(packageName,installLatestAwsSdk){let awsSdk;try{!installedSdk[packageName]&&installLatestAwsSdk==="true"?(installLatestSdk(packageName),awsSdk=await Promise.resolve(`${`/tmp/node_modules/${packageName}`}`).then(s=>require(s)).catch(async e=>(console.log(`Failed to install latest AWS SDK v3: ${e}`),Promise.resolve(`${packageName}`).then(s=>require(s))))):installedSdk[packageName]?awsSdk=await Promise.resolve(`${`/tmp/node_modules/${packageName}`}`).then(s=>require(s)):awsSdk=await Promise.resolve(`${packageName}`).then(s=>require(s))}catch{throw Error(`Package ${packageName} does not exist.`)}return awsSdk}async function handler(event,context){try{event.ResourceProperties.Create=(0,shared_1.decodeCall)(event.ResourceProperties.Create),event.ResourceProperties.Update=(0,shared_1.decodeCall)(event.ResourceProperties.Update),event.ResourceProperties.Delete=(0,shared_1.decodeCall)(event.ResourceProperties.Delete);let data={},physicalResourceId;switch(event.RequestType){case"Create":physicalResourceId=event.ResourceProperties.Create?.physicalResourceId?.id??event.ResourceProperties.Update?.physicalResourceId?.id??event.ResourceProperties.Delete?.physicalResourceId?.id??event.LogicalResourceId;break;case"Update":case"Delete":physicalResourceId=event.ResourceProperties[event.RequestType]?.physicalResourceId?.id??event.PhysicalResourceId;break}const call=event.ResourceProperties[event.RequestType];if(call){const packageName=call.service.startsWith("@aws-sdk/")?call.service:(0,get_v3_client_package_name_1.getV3ClientPackageName)(call.service);let awsSdk=loadAwsSdk(packageName,event.ResourceProperties.InstallLatestAwsSdk);console.log(JSON.stringify({...event,ResponseURL:"..."}));let credentials;if(call.assumedRoleArn){const timestamp=new Date().getTime(),params={RoleArn:call.assumedRoleArn,RoleSessionName:`${timestamp}-${physicalResourceId}`.substring(0,64)},{fromTemporaryCredentials}=await Promise.resolve("@aws-sdk/credential-providers").then(s=>require(s));credentials=fromTemporaryCredentials({params})}awsSdk=await awsSdk;const[_clientName,ServiceClient]=Object.entries(awsSdk).find(([name])=>name.endsWith("Client")&&name!=="__Client"),client=new ServiceClient({apiVersion:call.apiVersion,credentials,region:call.region}),commandName=call.action.endsWith("Command")?call.action:`${call.action}Command`,Command=Object.entries(awsSdk).find(([name])=>name.toLowerCase()===commandName.toLowerCase())?.[1];let flatData={};try{const response=await client.send(new Command((call.parameters&&(0,shared_1.decodeSpecialValues)(call.parameters,physicalResourceId))??{}));flatData={apiVersion:client.config.apiVersion,region:await client.config.region().catch(()=>{}),...(0,shared_1.flatten)(response)};let outputPaths;call.outputPath?outputPaths=[call.outputPath]:call.outputPaths&&(outputPaths=call.outputPaths),outputPaths?data=(0,shared_1.filterKeys)(flatData,(0,shared_1.startsWithOneOf)(outputPaths)):data=flatData}catch(e){if(!call.ignoreErrorCodesMatching||!new RegExp(call.ignoreErrorCodesMatching).test(e.code))throw e}call.physicalResourceId?.responsePath&&(physicalResourceId=flatData[call.physicalResourceId.responsePath])}await(0,shared_1.respond)(event,"SUCCESS","OK",physicalResourceId,data)}catch(e){console.log(e),await(0,shared_1.respond)(event,"FAILED",e.message||"Internal Error",context.logStreamName,{})}}exports.handler=handler;
