"use strict";Object.defineProperty(exports,"__esModule",{value:!0}),exports.DestinationPattern=exports.DestinationIdentifier=exports.DockerImageManifestEntry=exports.FileManifestEntry=exports.AssetManifestReader=void 0;const fs=require("fs"),path=require("path"),cloud_assembly_schema_1=require("../../../cloud-assembly-schema");class AssetManifestReader{static fromFile(fileName){try{const obj=cloud_assembly_schema_1.Manifest.loadAssetManifest(fileName);return new AssetManifestReader(path.dirname(fileName),obj)}catch(e){throw new Error(`Cannot read asset manifest '${fileName}': ${e.message}`)}}static fromPath(filePath){let st;try{st=fs.statSync(filePath)}catch(e){throw new Error(`Cannot read asset manifest at '${filePath}': ${e.message}`)}return st.isDirectory()?AssetManifestReader.fromFile(path.join(filePath,AssetManifestReader.DEFAULT_FILENAME)):AssetManifestReader.fromFile(filePath)}constructor(directory,manifest){this.manifest=manifest,this.directory=directory}select(selection){if(selection===void 0)return this;const ret={version:this.manifest.version,dockerImages:{},files:{}};for(const assetType of ASSET_TYPES)for(const[assetId,asset]of Object.entries(this.manifest[assetType]||{})){const filteredDestinations=filterDict(asset.destinations,(_,destId)=>selection.some(sel=>sel.matches(new DestinationIdentifier(assetId,destId))));Object.keys(filteredDestinations).length>0&&(ret[assetType][assetId]={...asset,destinations:filteredDestinations})}return new AssetManifestReader(this.directory,ret)}list(){return[...describeAssets("file",this.manifest.files||{}),...describeAssets("docker-image",this.manifest.dockerImages||{})];function describeAssets(type,assets){const ret=new Array;for(const[assetId,asset]of Object.entries(assets||{})){ret.push(`${assetId} ${type} ${JSON.stringify(asset.source)}`);const destStrings=Object.entries(asset.destinations).map(([destId,dest])=>` ${assetId}:${destId} ${JSON.stringify(dest)}`);ret.push(...prefixTreeChars(destStrings,"  "))}return ret}}get entries(){return[...makeEntries(this.manifest.files||{},FileManifestEntry),...makeEntries(this.manifest.dockerImages||{},DockerImageManifestEntry)];function makeEntries(assets,ctor){const ret=new Array;for(const[assetId,asset]of Object.entries(assets))for(const[destId,destination]of Object.entries(asset.destinations))ret.push(new ctor(new DestinationIdentifier(assetId,destId),asset.source,destination));return ret}}}AssetManifestReader.DEFAULT_FILENAME="assets.json",exports.AssetManifestReader=AssetManifestReader;const ASSET_TYPES=["files","dockerImages"];class FileManifestEntry{constructor(id,source,destination){this.id=id,this.source=source,this.destination=destination,this.type="file",this.genericSource=source}}exports.FileManifestEntry=FileManifestEntry;class DockerImageManifestEntry{constructor(id,source,destination){this.id=id,this.source=source,this.destination=destination,this.type="docker-image",this.genericSource=source}}exports.DockerImageManifestEntry=DockerImageManifestEntry;class DestinationIdentifier{constructor(assetId,destinationId){this.assetId=assetId,this.destinationId=destinationId}toString(){return this.destinationId?`${this.assetId}:${this.destinationId}`:this.assetId}}exports.DestinationIdentifier=DestinationIdentifier;function filterDict(xs,pred){const ret={};for(const[key,value]of Object.entries(xs))pred(value,key)&&(ret[key]=value);return ret}class DestinationPattern{static parse(s){if(!s)throw new Error("Empty string is not a valid destination identifier");const parts=s.split(":").map(x=>x!=="*"?x:void 0);if(parts.length===1)return new DestinationPattern(parts[0]);if(parts.length===2)return new DestinationPattern(parts[0]||void 0,parts[1]||void 0);throw new Error(`Asset identifier must contain at most 2 ':'-separated parts, got '${s}'`)}constructor(assetId,destinationId){this.assetId=assetId,this.destinationId=destinationId}matches(id){return(this.assetId===void 0||this.assetId===id.assetId)&&(this.destinationId===void 0||this.destinationId===id.destinationId)}toString(){return`${this.assetId??"*"}:${this.destinationId??"*"}`}}exports.DestinationPattern=DestinationPattern;function prefixTreeChars(xs,prefix=""){const ret=new Array;for(let i=0;i<xs.length;i++){const boxChar=i===xs.length-1?"\u2514":"\u251C";ret.push(`${prefix}${boxChar}${xs[i]}`)}return ret}
