# How to contribute

First off, thank you for considering contributing to `backtracking_llm`! Your
help is greatly appreciated. Whether you're reporting a bug, suggesting a new
feature, or writing code, this document will guide you through the process.

## Code of Conduct

This project and everyone participating in it is governed by a
[Code of Conduct](CODE_OF_CONDUCT.md). By participating, you are expect to
uphold to this code.

## How Can I Contribute?

### Reporting Bugs

If you find a bug, please open an issue on the
[GitHub repository](https://github.com/matee8/backtracking_llm/issues).

A great bug report includes:
- A clear and descriptive title.
- A step-by-step description of how to reproduce the bug.
- The version of `backtracking-llm` you are using.
- Any relevant code snippets, error messages, or logs.

### Suggesting Enhancements

If you have an idea for a new feature or an improvement to an existing one,
please open an issue to start a discussion. This allows us to align on the
design before any code is written.

## Coding Conventions

-   Code Style: We follow the [PEP 8](https://www.python.org/dev/peps/pep-0008/)
    style guide.
-   Docstrings: All public modules, classes, and functions should have
    Google-style docstrings.
-   Testing: We strive for 100% test coverage. Please ensure any new code is
    accompanied by corresponding unit tests in the `tests/` directory.

Thank you again for your contribution!
