# forgeNN## Table of Contents

- [Installation](#installation)
- [Overview](#overview)
- [Quick Start](#quick-start)
- [Educational Examples](#educational-examples)
- [Architecture](#architecture)
- [Performance](#performance)
- [Complete Example](#complete-example)
- [Links](#links)
- [Contributing](#contributing)
- [Acknowledgments](#acknowledgments)

## Installationtch Neural Network Framework with Educational Purposes*

[![Python 3.8+](https://img.shields.io/badge/python-3.8+-blue.svg)](https://www.python.org/downloads/)
[![NumPy](https://img.shields.io/badge/powered_by-NumPy-blue.svg)](https://numpy.org/)
[![PyPI version](https://img.shields.io/pypi/v/forgeNN.svg)](https://pypi.org/project/forgeNN/)
[![Downloads](https://img.shields.io/pypi/dm/forgeNN.svg)](https://pypi.org/project/forgeNN/)
[![License](https://img.shields.io/pypi/l/forgeNN.svg)](https://pypi.org/project/forgeNN/)

## � Table of Contents

- [📦 Installation](#-installation)
- [🚀 Overview](#-overview)
- [🔥 Quick Start](#-quick-start)
- [🎓 Educational Examples](#-educational-examples)
- [🏗️ Architecture](#️-architecture)
- [⚡ Performance](#-performance)
- [📈 Complete Example](#-complete-example)
- [🔗 Links](#-links)
- [🤝 Contributing](#-contributing)
- [🌟 Acknowledgments](#-acknowledgments)

## �📦 Installation

```bash
pip install forgeNN
```

## Overview

**forgeNN** is a modern neural network framework that is developed by a solo developer learning about ML. Features vectorized operations for high-speed training.

### Key Features

- **Vectorized Operations**: NumPy-powered batch processing (100x+ speedup)
- **Dynamic Computation Graphs**: Automatic differentiation with gradient tracking
- **Complete Neural Networks**: From simple neurons to complex architectures
- **Production Loss Functions**: Cross-entropy, MSE with numerical stability

## Quick Start

### Installation

```bash
pip install forgeNN
```

### High-Performance Training

```python
import forgeNN
from sklearn.datasets import make_classification

# Generate dataset
X, y = make_classification(n_samples=1000, n_features=20, n_classes=3)

# Create vectorized model  
model = forgeNN.VectorizedMLP(20, [64, 32], 3)
optimizer = forgeNN.VectorizedOptimizer(model.parameters(), lr=0.01)

# Fast batch training
for epoch in range(10):
    # Convert to tensors
    x_batch = forgeNN.Tensor(X)
    
    # Forward pass
    logits = model(x_batch)
    loss = forgeNN.cross_entropy_loss(logits, y)
    
    # Backward pass
    optimizer.zero_grad()
    loss.backward()
    optimizer.step()
    
    acc = forgeNN.accuracy(logits, y)
    print(f"Epoch {epoch}: Loss = {loss.data:.4f}, Acc = {acc*100:.1f}%")
```

## Educational Examples

### Legacy Examples

```python
# For learning automatic differentiation
from forgeNN.legacy import Value, MLP

x = Value(2.0)
y = x**2 + 3*x + 1
y.backward()
print(f"dy/dx = {x.grad}")  # 7.0

# Simple neural network
model = MLP(2, [4, 1])
output = model([Value(1.0), Value(2.0)])
```

## Architecture

- **Main API**: `forgeNN.Tensor`, `forgeNN.VectorizedMLP` (production use)
- **Legacy API**: `forgeNN.legacy.*` (educational purposes)
- **Functions**: Complete activation and loss function library
- **Examples**: `example.py` - Complete MNIST classification demo

## Performance

| Implementation | Speed | MNIST Accuracy |
|---------------|-------|----------------|
| Vectorized | 38,000+ samples/sec | 93%+ in <2s |

**Highlights**:
- **100x+ speedup** over scalar implementations
- **Production-ready** performance with educational clarity
- **Memory efficient** vectorized operations

## Complete Example

See `example.py` for a full MNIST classification demo achieving professional results.

## Links

- **PyPI Package**: https://pypi.org/project/forgeNN/
- **Documentation**: See guides in this repository
- **Issues**: GitHub Issues for bug reports and feature requests

## Contributing

I am not currently accepting contributions, but I'm always open to suggestions and feedback!

## Acknowledgments

- Inspired by educational automatic differentiation tutorials
- Built for both learning and production use
- Optimized with modern NumPy practices
- **Available on PyPI**: `pip install forgeNN`

---

*Made with care for the ML community. Happy learning and building!*
