from .return_class import AbstractApiClass


class LlmExecutionPreview(AbstractApiClass):
    """
        Preview of executing queries using LLM.

        Args:
            client (ApiClient): An authenticated API Client instance
            error (str): The error message if the preview failed.
            sql (str): Preview of SQL query generated by LLM.
    """

    def __init__(self, client, error=None, sql=None):
        super().__init__(client, None)
        self.error = error
        self.sql = sql
        self.deprecated_keys = {}

    def __repr__(self):
        repr_dict = {f'error': repr(self.error), f'sql': repr(self.sql)}
        class_name = "LlmExecutionPreview"
        repr_str = ',\n  '.join([f'{key}={value}' for key, value in repr_dict.items(
        ) if getattr(self, key, None) is not None and key not in self.deprecated_keys])
        return f"{class_name}({repr_str})"

    def to_dict(self):
        """
        Get a dict representation of the parameters in this class

        Returns:
            dict: The dict value representation of the class parameters
        """
        resp = {'error': self.error, 'sql': self.sql}
        return {key: value for key, value in resp.items() if value is not None and key not in self.deprecated_keys}
