from .return_class import AbstractApiClass


class LlmGeneratedCode(AbstractApiClass):
    """
        Code generated by LLM.

        Args:
            client (ApiClient): An authenticated API Client instance
            sql (str): SQL query generated by LLM.
    """

    def __init__(self, client, sql=None):
        super().__init__(client, None)
        self.sql = sql
        self.deprecated_keys = {}

    def __repr__(self):
        repr_dict = {f'sql': repr(self.sql)}
        class_name = "LlmGeneratedCode"
        repr_str = ',\n  '.join([f'{key}={value}' for key, value in repr_dict.items(
        ) if getattr(self, key, None) is not None and key not in self.deprecated_keys])
        return f"{class_name}({repr_str})"

    def to_dict(self):
        """
        Get a dict representation of the parameters in this class

        Returns:
            dict: The dict value representation of the class parameters
        """
        resp = {'sql': self.sql}
        return {key: value for key, value in resp.items() if value is not None and key not in self.deprecated_keys}
