# Ai-eBash!

[![Python Version](https://img.shields.io/badge/python-3.11+-blue.svg)](https://www.python.org/downloads/)
[![License: MIT](https://img.shields.io/badge/License-MIT-yellow.svg)](https://opensource.org/licenses/MIT)
[![PyPI Version](https://img.shields.io/pypi/v/ai-ebash.svg)](https://pypi.org/project/ai-ebash/)
[![GitHub Stars](https://img.shields.io/github/stars/Vivatist/ai-ebash.svg)](https://github.com/Vivatist/ai-ebash/stargazers)

> **Интеграция искусственного интеллекта в ваш терминал.** Задавайте вопросы ***ChatGPT***, ***Deep Seek***, ***Grok*** и многим другим большим языковым моделям (LLM). Выполняйте предложенные нейросетью скрипты и команды прямо из командной строки. Идеально подходит для новичков в администрировании Linux и Windows.

🌍 **Available in:** [English](../../README.md) | [Русский](README_ru.md)

![pgram response1](/docs/img/ru_main_img.gif)

## Содержание

- [Ai-eBash!](#ai-ebash)
  - [Содержание](#содержание)
  - [Описание](#описание)
    - [Возможности](#возможности)
    - [Быстрый старт](#быстрый-старт)
  - [Подключение к нейросетям](#подключение-к-нейросетям)
    - [Получение токена (API\_KEY) и подключение к предустановленной нейросети](#получение-токена-api_key-и-подключение-к-предустановленной-нейросети)
    - [Добавление новой нейросети](#добавление-новой-нейросети)
      - [Пример подключения](#пример-подключения)
  - [Примеры](#примеры)
    - [Быстрый запрос](#быстрый-запрос)
    - [Режим диалога и запуск кода](#режим-диалога-и-запуск-кода)
  - [Безопасность](#безопасность)
  - [Установка](#установка)
    - [Ubuntu/Debian (pipx)](#ubuntudebian-pipx)
    - [Ubuntu/DEbian (DEB пакет)](#ubuntudebian-deb-пакет)
    - [Windows (Экспериментально)](#windows-экспериментально)
  - [Удаление](#удаление)
    - [Если установлен с помощью pipx](#если-установлен-с-помощью-pipx)
    - [Если установлен DEB пакет](#если-установлен-deb-пакет)
    - [Если установлен в Windows:](#если-установлен-в-windows)
  - [Конфигурация](#конфигурация)
    - [Первоначальная настройка](#первоначальная-настройка)
    - [Поддерживаемые провайдеры ИИ](#поддерживаемые-провайдеры-ии)
    - [Файл конфигурации](#файл-конфигурации)
    - [Сброс настроек](#сброс-настроек)
    - [Лучшие практики](#лучшие-практики)
  - [Содействие](#содействие)
    - [Области для содействия](#области-для-содействия)
    - [Настройка среды разработки](#настройка-среды-разработки)
    - [Правила содействия](#правила-содействия)
  - [Лицензия](#лицензия)
  - [Контакты](#контакты)

## Описание

### Возможности

- **Быстрые запросы к ИИ** — Получайте ответы от больших языковых моделей ИИ через командную строку
- **Отсутствие интерфейса** — Общайтесь с выбранным ИИ в естественной форме и на любом языке `ai как утановить русский шрифт?`
- **Интерактивный режим диалога** — Общайтесь с ИИ в режиме диалога с сохранением контекста беседы
- **Выполнение кода** — Выполняйте в консоли предложенные ИИ скрипты и команды
- **Дружелюбный интерфейс** — Форматированный вывод с подсветкой синтаксиса - все как во время привычной работы с нейросетями.
- **Множество провайдеров ИИ** — Поддержка OpenAI, OpenRouter, DeepSeek, Anthropic и других распространенных провайдеров ИИ.
- **Поддержка нескольких языков** — Сейчас доступны En и Ru. Вы можете [(помочь с переводом)](#содействие) на другие языки.

### Быстрый старт

Установите Ai-eBash одним из удобных для вас [способов](#установка). 

Запустите программу `ai кто ты?`. Через пару секунд нейросеть ответит:

![pgram response1](/docs/img/ru_img1.png)

Попробуйте что нибудь посложнее:

![pgram response1](/docs/img/ru_img3.png)

При первом запуске программа использует нейросеть от Microsoft - **DeepSeek-R1-Lite-Preview** с публичным токеном. Это не самый лучший выбор, так как из-за множества запросов может появляться сообщение о превышении квоты, но для тестового запуска сойдет. 

**Для полноценной работы необходимо [получить](#получение-токена-api_key-и-подключение-к-предустановленной-нейросети) личный токен и добавить его в настройки выбранной нейросети в [настройках](#установка) программы.**

> [!NOTE]
> Ai-eBash может работать с любой нейросетью поддерживающей подключение по API. На сегодняшний день это практически все большие языковые модели (LLM) представленные на рынке. [Как подключить новую нейросеть](#добавление-новой-нейросети).

## Подключение к нейросетям
В Ai-eBash уже предустановлено несколько популярных моделей, таких как **DeepSeek**, **Grok 4 Fast**, **Qwen3 Coder**, однако политика провайдеров не позволяет полноценно работать без авторизации. Вам необходимо получить личный токен (или по другому - API_KEY) на сайте провайдера.

### Получение токена (API_KEY) и подключение к предустановленной нейросети
Рекомендую пользоваться провайдером [OpenRouter](https://openrouter.ai/models?max_price=0) - легкая регистрация и десятки самых популярных нейросетей в бесплатном доступе по одному токену.

- Зарегистрируйтесь на [сайте](https://openrouter.ai/)
- Получите токен нажав **[Create API key](https://openrouter.ai/settings/keys)**. Cохраните его, OpenRouter покажет вам его только один раз!
- Добавьте токен в Ai-eBash в [настройках](#конфигурация) выбранной нейросети
- Сделайте эту нейросеть текущей

**Готово! Теперь в консоли вам будет отвечать выбранная нейросеть. Таким же образом можете подключить любую другую модель с данного сайта.**

> [!NOTE]
> Один токен OpenRouter дествителен для **всех** моделей и нейросетей представленных данным провайдером

Примерно такая же процедура нужна для получения токена у других провайдеров, хотя я не уверен для чего это может понадобится при наличии **OpenRouter**.

### Добавление новой нейросети
Для добавления в Ai-eBash **новой** нейросети, в том числе локальной или от крупных провайдеров  достаточно ввести в [настройках](#конфигурация) Ai-Ebash:
 - API_KEY (личный токен)
 - API_URL (ссылка для подключения)
 - model (название модели)

Эти данные можно выяснить на сайте провайдера представляющего доступ к конкретной нейросети в разделе *API*. 

#### Пример подключения
На примере подключения к бесплатной нейросети ***Meta: Llama 3.1*** представленной на сайте [OpenRouter](https://openrouter.ai/models?max_price=0) среди десятков других бесплатных моделей.

Открываем страницу данной нейросети, ищем раздел [API](https://openrouter.ai/meta-llama/llama-3.1-405b-instruct:free/api). 

Среди кодов с примерами подключения ищем информацию похожую на: 

 - **API_URL** - в случае с OpenRouter этот параметр будет называться ***base_url***
 - **model** - так и называется ***model***

Как получить **API_KEY** [описано](#получение-токена-api_key-и-подключение-к-предустановленной-нейросети) выше

Вбиваем значения этих параметров (***без кавычек***) в настройки Ai-eBash, и назначаем эту нейросеть текущей. Теперь на наши вопросы будет отвечать ***Meta: Llama 3.1*** 


## Примеры

### Быстрый запрос

```bash
# Simple question
ai скрипт для обновления ядра
```

### Режим диалога и запуск кода

Чтобы начать диалог используйте ключ `-d` или просто введите `ai` и нажмите `Enter`
В режиме диалога Ai-eBash сохраняет контекст беседы на протяжении всего диалога. 

```bash
ai -d какая версия питона установлена?
```

```bash
ai # Enter
```

> [!NOTE]
> В случае, когда **в режиме диалога** в ответе присутствуют блоки кода - они нумеруются. Для запуска кода просто введите номер блока в консоль.

![dialog mode](/docs/img/ru_img4.gif)

## Безопасность

> [!WARNING]
> Никогда не выполняйте предложенный нейросетью код если не уверены в том что он делает!

## Установка

### Ubuntu/Debian (pipx)

**Рекомендуемый способ установки**

1. **Установите pipx** (если еще не установлен):
   ```bash
   sudo apt update
   sudo apt install pipx python3-venv -y
   pipx ensurepath
   ```

2. **Перезапустите терминал**

3. **Установите AI-eBash**:
   ```bash
   pipx install ai-ebash
   ```

> **Примечание:** Если pipx не работает, вы можете установить через pip:
> ```bash
> pip install ai-ebash
> ```

### Ubuntu/DEbian (DEB пакет)

1. **Скачайте актуальный DEB пакет с [GitHub](https://github.com/Vivatist/ai-ebash/releases/latest)**:
   ```bash
   wget -qO ai-ebash.deb $(wget -qO- https://api.github.com/repos/Vivatist/ai-ebash/releases/latest \
     | grep "browser_download_url.*\.deb" | cut -d '"' -f 4)
   ```

2. **Установите пакет**:
   ```bash
   sudo dpkg -i ./ai-ebash.deb
   sudo apt-get install -f -y
   ```

3. **Перезапустите терминал**


### Windows (Экспериментально)

1. **Установите Python 3.11+** (если еще не установлен)

2. **Установите AI-eBash**:
   ```cmd
   pip install ai-ebash
   ```

3. **Перезапустите терминал**


## Удаление

### Если установлен с помощью pipx
```bash
pipx uninstall ai-ebash
```

### Если установлен DEB пакет
```bash
sudo apt remove ai-ebash
# Or for complete deletion, including configuration files:
sudo apt purge ai-ebash
```

or you can also use dpkg.:

```bash
sudo dpkg -r ai-ebash
# Or for complete deletion, including configuration files:
sudo dpkg -P ai-ebash
```

### Если установлен в Windows:
```bash
pip uninstall ai-ebash
```

## Конфигурация

### Первоначальная настройка

Запустите режим настройки для настройки провайдера ИИ:

```bash
ai -s
```

### Поддерживаемые провайдеры ИИ

- **OpenAI** (GPT-3.5, GPT-4)
- **Anthropic** (Claude)
- **OpenRouter** (Множество моделей)
- **Локальные модели** (Ollama, LM Studio)

И многие другие поддерживающие подключение по API

### Файл конфигурации

Настройки хранятся в:
- **Linux:** `~/.config/ai-ebash/config.yaml`
- **Windows:** `%APPDATA%\ai-ebash\config.yaml`

### Сброс настроек

Чтобы вернуться к настройкам по умолчанию, вручную удалите файл конфигурации или выполните команды:
```bash
# Для Linux
rm ~/.config/ai-ebash/config.yaml
```
```bash
# Для Windows
rm %APPDATA%\ai-ebash\config.yaml
```
### Лучшие практики

1. **Проверяйте код перед выполнением**
   ```bash
   # Всегда проверяйте что предлагает ИИ
   ai Удалить все файлы из /tmp  # Не выполняйте это слепо!
   ```

2. **Используйте безопасные команды**
   ```bash
   # Предпочитайте эти вместо деструктивных операций
   ai Показать использование диска
   ai Показать запущенные процессы
   ```

## Содействие

Буду рад помощи! 

### Области для содействия

- 🌍 **Локализация** - Поддержка новых языков ([образец](https://github.com/Vivatist/ai-ebash/blob/main/src/aiebash/locales/template_locale.json)) в том числе для [README.md](https://github.com/Vivatist/ai-ebash/blob/main/README.md)
- 🤖 **Провайдеры ИИ** - Интеграция новых провайдеров ИИ
- 🎨 **UI/UX** - Улучшение интерфейса менеджера конфигурации (да, он не идеален)
- 🔧 **Инструменты** - Создание дополнительных утилит
- 💡 **Идеи** - Буду рад любым идеям по улучшению и развитию Ai-eBash. [Присоединиться к обсуждению](https://github.com/Vivatist/ai-ebash/discussions/10#discussion-8924293)

Вот как начать:

### Настройка среды разработки

1. **Форкните репозиторий**
2. **Клонируйте ваш форк**:
   ```bash
   git clone https://github.com/your-username/ai-ebash.git
   cd ai-ebash
   ```

3. **Настройте среду разработки**:
   ```bash
   python -m venv venv
   source venv/bin/activate  # На Windows: venv\Scripts\activate
   pip install -r requirements.txt
   pip install -e .
   ```

### Правила содействия

- 📝 **Стиль кода**: Следуйте PEP 8
- 🧪 **Тестирование**: Добавляйте тесты для новых функций
- 📚 **Документация**: Обновляйте README для новых функций
- 🔄 **Pull Requests**: Используйте понятные сообщения коммитов

## Лицензия

Этот проект лицензирован под MIT License.

## Контакты

- **Автор**: Andrey Bochkarev
- **GitHub Issues**: [🐛 Сообщить об ошибках](https://github.com/Vivatist/ai-ebash/issues)
- **Обсуждения**: [💬 Присоединиться](https://github.com/Vivatist/ai-ebash/discussions)

---

<div align="center">

**Создано с ❤️ для Linux сообщества**

[⭐ Поставьте звезду на GitHub](https://github.com/Vivatist/ai-ebash)
</div>