import * as autoscaling from '@aws-cdk/aws-autoscaling';
import * as kms from '@aws-cdk/aws-kms';
import * as lambda from '@aws-cdk/aws-lambda';
import { Construct } from '@aws-cdk/core';
/**
 * Use a Lambda Function as a hook target.
 *
 * Internally creates a Topic to make the connection.
 *
 * @stability stable
 */
export declare class FunctionHook implements autoscaling.ILifecycleHookTarget {
    private readonly fn;
    private readonly encryptionKey?;
    /**
     * @param fn Function to invoke in response to a lifecycle event.
     * @param encryptionKey If provided, this key is used to encrypt the contents of the SNS topic.
     * @stability stable
     */
    constructor(fn: lambda.IFunction, encryptionKey?: kms.IKey | undefined);
    /**
     * Called when this object is used as the target of a lifecycle hook.
     *
     * @stability stable
     */
    bind(scope: Construct, lifecycleHook: autoscaling.ILifecycleHook): autoscaling.LifecycleHookTargetConfig;
}
