"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.FunctionHook = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const sns = require("@aws-cdk/aws-sns");
const subs = require("@aws-cdk/aws-sns-subscriptions");
const topic_hook_1 = require("./topic-hook");
/**
 * Use a Lambda Function as a hook target.
 *
 * Internally creates a Topic to make the connection.
 *
 * @stability stable
 */
class FunctionHook {
    /**
     * @param fn Function to invoke in response to a lifecycle event.
     * @param encryptionKey If provided, this key is used to encrypt the contents of the SNS topic.
     * @stability stable
     */
    constructor(fn, encryptionKey) {
        this.fn = fn;
        this.encryptionKey = encryptionKey;
    }
    /**
     * Called when this object is used as the target of a lifecycle hook.
     *
     * @stability stable
     */
    bind(scope, lifecycleHook) {
        var _b;
        const topic = new sns.Topic(scope, 'Topic', {
            masterKey: this.encryptionKey,
        });
        // Per: https://docs.aws.amazon.com/sns/latest/dg/sns-key-management.html#sns-what-permissions-for-sse
        // Topic's grantPublish() is in a base class that does not know there is a kms key, and so does not
        // grant appropriate permissions to the kms key. We do that here to ensure the correct permissions
        // are in place.
        (_b = this.encryptionKey) === null || _b === void 0 ? void 0 : _b.grant(lifecycleHook.role, 'kms:Decrypt', 'kms:GenerateDataKey');
        topic.addSubscription(new subs.LambdaSubscription(this.fn));
        return new topic_hook_1.TopicHook(topic).bind(scope, lifecycleHook);
    }
}
exports.FunctionHook = FunctionHook;
_a = JSII_RTTI_SYMBOL_1;
FunctionHook[_a] = { fqn: "@aws-cdk/aws-autoscaling-hooktargets.FunctionHook", version: "1.94.0" };
//# sourceMappingURL=data:application/json;base64,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