import * as autoscaling from '@aws-cdk/aws-autoscaling';
import * as sqs from '@aws-cdk/aws-sqs';
import { Construct } from '@aws-cdk/core';
/**
 * Use an SQS queue as a hook target.
 *
 * @stability stable
 */
export declare class QueueHook implements autoscaling.ILifecycleHookTarget {
    private readonly queue;
    /**
     * @stability stable
     */
    constructor(queue: sqs.IQueue);
    /**
     * Called when this object is used as the target of a lifecycle hook.
     *
     * @stability stable
     */
    bind(_scope: Construct, lifecycleHook: autoscaling.ILifecycleHook): autoscaling.LifecycleHookTargetConfig;
}
