"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.QueueHook = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 * Use an SQS queue as a hook target.
 *
 * @stability stable
 */
class QueueHook {
    /**
     * @stability stable
     */
    constructor(queue) {
        this.queue = queue;
    }
    /**
     * Called when this object is used as the target of a lifecycle hook.
     *
     * @stability stable
     */
    bind(_scope, lifecycleHook) {
        this.queue.grantSendMessages(lifecycleHook.role);
        return { notificationTargetArn: this.queue.queueArn };
    }
}
exports.QueueHook = QueueHook;
_a = JSII_RTTI_SYMBOL_1;
QueueHook[_a] = { fqn: "@aws-cdk/aws-autoscaling-hooktargets.QueueHook", version: "1.94.0" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoicXVldWUtaG9vay5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbInF1ZXVlLWhvb2sudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7Ozs7Ozs7OztBQU9BLE1BQWEsU0FBUzs7OztJQUNwQixZQUE2QixLQUFpQjtRQUFqQixVQUFLLEdBQUwsS0FBSyxDQUFZO0lBQzlDLENBQUM7Ozs7OztJQUVNLElBQUksQ0FBQyxNQUFpQixFQUFFLGFBQXlDO1FBQ3RFLElBQUksQ0FBQyxLQUFLLENBQUMsaUJBQWlCLENBQUMsYUFBYSxDQUFDLElBQUksQ0FBQyxDQUFDO1FBQ2pELE9BQU8sRUFBRSxxQkFBcUIsRUFBRSxJQUFJLENBQUMsS0FBSyxDQUFDLFFBQVEsRUFBRSxDQUFDO0lBQ3hELENBQUM7O0FBUEgsOEJBUUMiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgKiBhcyBhdXRvc2NhbGluZyBmcm9tICdAYXdzLWNkay9hd3MtYXV0b3NjYWxpbmcnO1xuaW1wb3J0ICogYXMgc3FzIGZyb20gJ0Bhd3MtY2RrL2F3cy1zcXMnO1xuaW1wb3J0IHsgQ29uc3RydWN0IH0gZnJvbSAnQGF3cy1jZGsvY29yZSc7XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG5leHBvcnQgY2xhc3MgUXVldWVIb29rIGltcGxlbWVudHMgYXV0b3NjYWxpbmcuSUxpZmVjeWNsZUhvb2tUYXJnZXQge1xuICBjb25zdHJ1Y3Rvcihwcml2YXRlIHJlYWRvbmx5IHF1ZXVlOiBzcXMuSVF1ZXVlKSB7XG4gIH1cblxuICBwdWJsaWMgYmluZChfc2NvcGU6IENvbnN0cnVjdCwgbGlmZWN5Y2xlSG9vazogYXV0b3NjYWxpbmcuSUxpZmVjeWNsZUhvb2spOiBhdXRvc2NhbGluZy5MaWZlY3ljbGVIb29rVGFyZ2V0Q29uZmlnIHtcbiAgICB0aGlzLnF1ZXVlLmdyYW50U2VuZE1lc3NhZ2VzKGxpZmVjeWNsZUhvb2sucm9sZSk7XG4gICAgcmV0dXJuIHsgbm90aWZpY2F0aW9uVGFyZ2V0QXJuOiB0aGlzLnF1ZXVlLnF1ZXVlQXJuIH07XG4gIH1cbn1cbiJdfQ==