import * as autoscaling from '@aws-cdk/aws-autoscaling';
import * as sns from '@aws-cdk/aws-sns';
import { Construct } from '@aws-cdk/core';
/**
 * Use an SNS topic as a hook target.
 *
 * @stability stable
 */
export declare class TopicHook implements autoscaling.ILifecycleHookTarget {
    private readonly topic;
    /**
     * @stability stable
     */
    constructor(topic: sns.ITopic);
    /**
     * Called when this object is used as the target of a lifecycle hook.
     *
     * @stability stable
     */
    bind(_scope: Construct, lifecycleHook: autoscaling.ILifecycleHook): autoscaling.LifecycleHookTargetConfig;
}
