"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.TopicHook = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 * Use an SNS topic as a hook target.
 *
 * @stability stable
 */
class TopicHook {
    /**
     * @stability stable
     */
    constructor(topic) {
        this.topic = topic;
    }
    /**
     * Called when this object is used as the target of a lifecycle hook.
     *
     * @stability stable
     */
    bind(_scope, lifecycleHook) {
        this.topic.grantPublish(lifecycleHook.role);
        return { notificationTargetArn: this.topic.topicArn };
    }
}
exports.TopicHook = TopicHook;
_a = JSII_RTTI_SYMBOL_1;
TopicHook[_a] = { fqn: "@aws-cdk/aws-autoscaling-hooktargets.TopicHook", version: "1.94.0" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoidG9waWMtaG9vay5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbInRvcGljLWhvb2sudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7Ozs7Ozs7OztBQU9BLE1BQWEsU0FBUzs7OztJQUNwQixZQUE2QixLQUFpQjtRQUFqQixVQUFLLEdBQUwsS0FBSyxDQUFZO0lBQzlDLENBQUM7Ozs7OztJQUVNLElBQUksQ0FBQyxNQUFpQixFQUFFLGFBQXlDO1FBQ3RFLElBQUksQ0FBQyxLQUFLLENBQUMsWUFBWSxDQUFDLGFBQWEsQ0FBQyxJQUFJLENBQUMsQ0FBQztRQUM1QyxPQUFPLEVBQUUscUJBQXFCLEVBQUUsSUFBSSxDQUFDLEtBQUssQ0FBQyxRQUFRLEVBQUUsQ0FBQztJQUN4RCxDQUFDOztBQVBILDhCQVFDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0ICogYXMgYXV0b3NjYWxpbmcgZnJvbSAnQGF3cy1jZGsvYXdzLWF1dG9zY2FsaW5nJztcbmltcG9ydCAqIGFzIHNucyBmcm9tICdAYXdzLWNkay9hd3Mtc25zJztcbmltcG9ydCB7IENvbnN0cnVjdCB9IGZyb20gJ0Bhd3MtY2RrL2NvcmUnO1xuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuZXhwb3J0IGNsYXNzIFRvcGljSG9vayBpbXBsZW1lbnRzIGF1dG9zY2FsaW5nLklMaWZlY3ljbGVIb29rVGFyZ2V0IHtcbiAgY29uc3RydWN0b3IocHJpdmF0ZSByZWFkb25seSB0b3BpYzogc25zLklUb3BpYykge1xuICB9XG5cbiAgcHVibGljIGJpbmQoX3Njb3BlOiBDb25zdHJ1Y3QsIGxpZmVjeWNsZUhvb2s6IGF1dG9zY2FsaW5nLklMaWZlY3ljbGVIb29rKTogYXV0b3NjYWxpbmcuTGlmZWN5Y2xlSG9va1RhcmdldENvbmZpZyB7XG4gICAgdGhpcy50b3BpYy5ncmFudFB1Ymxpc2gobGlmZWN5Y2xlSG9vay5yb2xlKTtcbiAgICByZXR1cm4geyBub3RpZmljYXRpb25UYXJnZXRBcm46IHRoaXMudG9waWMudG9waWNBcm4gfTtcbiAgfVxufVxuIl19