# Himpunan

Sebuah library Python untuk operasi himpunan (Set Operations) yang diimplementasikan menggunakan magic methods Python.

## ✨ Fitur
- Membuat, menambah, dan mengurangi anggota himpunan
- Irisan `/`
- Gabungan `+`
- Selisih `-`
- Selisih Simetris `*`
- Komplemen (`komplement()`)
- Himpunan Kuasa (`abs()`)
- Produk Kartesius (`**`)
- Subset, Superset, dan Ekuivalen (`<=`, `>=`, `//`)

## 📦 Instalasi
```bash
pip install afl2-himpunan==0.1.2
```

## Contoh
```
from afl2_himpunan import Himpunan

S = Himpunan(1,2,3,4,5,6,7,8,9)
h1 = Himpunan(1, 2, 3)
h2 = Himpunan(3, 4, 5)

print(len(h1))  # Output: 3
print(3 in h1)  # Output: True
print(h1 == h2)  # Output: False

h1 += 4  # Menambah elemen 4 ke h1
print(h1)  # Output: Himpunan([1, 2, 3, 4])

h3 = h1 / h2  # Irisan
print(h3)  # Output: Himpunan([3, 4])

h4 = h1 + h2  # Gabungan
print(h4)  # Output: Himpunan([1, 2, 3, 4, 5])

h5 = h1 - h2  # Selisih
print(h5)  # Output: Himpunan([1, 2])

h6 = h1.Komplemen(S)  # Komplemen
print(h6)  # Output: Himpunan([5, 6, 7, 8, 9])

print(abs(h1))  # Output: 16
```