# json-schema-to-class [![Build Status](https://travis-ci.com/FebruaryBreeze/json-schema-to-class.svg?branch=master)](https://travis-ci.com/FebruaryBreeze/json-schema-to-class) [![codecov](https://codecov.io/gh/FebruaryBreeze/json-schema-to-class/branch/master/graph/badge.svg)](https://codecov.io/gh/FebruaryBreeze/json-schema-to-class) [![PyPI version](https://badge.fury.io/py/json-schema-to-class.svg)](https://pypi.org/project/json-schema-to-class/)

Convert JSON Schema into Python Class

## Installation

Need Python 3.6+.

```bash
pip install json-schema-to-class
```

## Usage

For example, convert [tests/test.schema.json](./tests/test.schema.json) into Python class:

```bash
json-schema-to-class tests/test.schema.json -o tests/schema_build.py
```

Get `tests/schema_build.py` as follow:

```python
from typing import List


class LrMode:
    def __init__(self, values=None):
        self.enum = ['step', 'cos']
        self.value = values if values is None else 'cos'


class LrSchedulerConfig:
    class WarmUp:
        def __init__(self, values: dict = None):
            self.start: float = values.get("start", 0.0)
            self.steps: int = values.get("steps", 0)

    def __init__(self, values: dict = None):
        self.lr_mode = LrMode(values=values.get("lr_mode"))
        self.base_lr: float = values.get("base_lr", None)
        self.target_lr: float = values.get("target_lr", 0.0002)
        self.decay_factor: float = values.get("decay_factor", 0.1)
        self.milestones: List[float] = values.get("milestones", [0.3, 0.6, 0.9])
        self.lr_decay: float = values.get("lr_decay", 0.98)
        self.warm_up = self.WarmUp(values=values.get("warm_up", {}))


class LrSchedulerConfigs:
    def __init__(self, values: list = None):
        self.items: List[LrSchedulerConfig] = [
            LrSchedulerConfig(values=value) for value in (values or [])
        ]
```
